<?php

namespace App\Filament\User\Resources\CategoriaResource\Pages;

use App\Filament\User\Resources\CategoriaResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;
use Filament\Actions\Action;


class EditCategoria extends EditRecord
{
    protected static string $resource = CategoriaResource::class;
    
    // botao salvar
    protected function getSaveFormAction(): Action
    {
        return parent::getSaveFormAction()
            ->label('Salvar Categoria')
            ->icon('heroicon-o-check')
            ->color('success');
    }
    // botao cancelar
    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }
    // redireciona para a pagina de listagem
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
    // mensagem de sucesso
    protected function getUpdatedNotificationTitle(): ?string
    {
        return 'Categoria atualizada!';
    }
    // mensagem de sucesso
    protected function getUpdatedNotificationDescription(): ?string
    {
        return 'As informações da categoria foram atualizadas com sucesso.';
    }
    // icone de sucesso
    protected function getUpdatedNotificationIcon(): ?string
    {
        return 'heroicon-o-check-circle';
    }
    // cor de sucesso
    protected function getUpdatedNotificationColor(): ?string
    {
        return 'success';
    }
    // acao de visualizar
    protected function getUpdatedNotificationActions(): ?array
    {
        return [
            Actions\ViewAction::make()
                ->label('Visualizar Categoria'),
        ];
    }
    // mensagem de sucesso
    protected function getSavedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Categoria atualizada!')
            ->body('As informações da categoria foram atualizadas com sucesso')
            ->duration(5000);
    }
}
