<?php

namespace App\Filament\User\Resources\CategoriaResource\Pages;

use App\Filament\User\Resources\CategoriaResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions\Action;
use Filament\Notifications\Notification;


class CreateCategoria extends CreateRecord
{
    protected static string $resource = CategoriaResource::class;

    // titulo
    public function getTitle(): string
    {
        return 'Nova Categoria';
    }

    // botao criar categoria
    protected function getCreateFormAction(): Action
    {
        return parent::getCreateFormAction()
            ->label('Criar Categoria')
            ->icon('heroicon-o-plus-circle')
            ->color('primary');
    }

    // botao criar e criar outro
    protected function getCreateAnotherFormAction(): Action
    {
        return parent::getCreateAnotherFormAction()
            ->label('Criar e criar outro')
            ->icon('heroicon-o-plus')
            ->color('primary');
    }

    // botao cancelar
    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }

    // redireciona para a pagina de listagem
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Categoria criada!')
            ->body('A nova categoria foi cadastrada com sucesso')
            ->duration(5000);
    }

    
}
