<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once '../config/database.php';

// Função para log
function debug_log($message) {
    error_log(print_r($message, true));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    debug_log("Recebendo pagamento - POST data:");
    debug_log($_POST);

    $installment_id = filter_input(INPUT_POST, 'installment_id', FILTER_SANITIZE_NUMBER_INT);
    $payment_date = filter_input(INPUT_POST, 'payment_date', FILTER_SANITIZE_STRING);

    if (!$installment_id || !$payment_date) {
        debug_log("ID da parcela ou data de pagamento inválidos");
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'ID da parcela ou data de pagamento inválidos']);
        exit;
    }

    // Validar a data de pagamento
    $payment_timestamp = strtotime($payment_date);
    if (!$payment_timestamp || $payment_timestamp > time()) {
        debug_log("Data de pagamento inválida ou futura");
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Data de pagamento inválida ou futura']);
        exit;
    }

    try {
        $pdo->beginTransaction();

        // Verificar se a parcela existe e não está paga
        $stmt = $pdo->prepare("
            SELECT i.id, i.status, i.due_date, m.user_id
            FROM installments i
            JOIN movements m ON i.movement_id = m.id
            WHERE i.id = ? 
            AND i.status != 'paid'
            AND m.user_id = ?
        ");
        $stmt->execute([$installment_id, $_SESSION['user_id']]);
        $installment = $stmt->fetch();

        if (!$installment) {
            debug_log("Parcela não encontrada ou já está paga");
            throw new Exception('Parcela não encontrada ou já está paga');
        }

        // Atualizar o status da parcela para pago
        $stmt = $pdo->prepare("
            UPDATE installments 
            SET status = 'paid', 
                payment_date = ? 
            WHERE id = ?
        ");
        
        debug_log("Atualizando parcela {$installment_id} para paga com data {$payment_date}");
        $success = $stmt->execute([$payment_date, $installment_id]);

        if (!$success) {
            debug_log("Erro ao atualizar parcela:");
            debug_log($stmt->errorInfo());
            throw new Exception('Erro ao processar pagamento');
        }

        $pdo->commit();
        debug_log("Pagamento processado com sucesso");
        
        header('Content-Type: application/json');
        echo json_encode(['success' => true]);
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        debug_log("Erro na transação: " . $e->getMessage());
        
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        exit;
    }
}

header('Content-Type: application/json');
echo json_encode(['success' => false, 'message' => 'Método não permitido']);
exit;
