<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

// Buscar todos os clientes do usuário atual
$stmt = $pdo->prepare("SELECT * FROM clients WHERE user_id = ? ORDER BY name");
$stmt->execute([$_SESSION['user_id']]);
$clients = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes - Sistema Financeiro</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    <?php include '../includes/navbar.php'; ?>

    <div id="content" class="py-4 px-4">
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Clientes</h2>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addClientModal">
                    <i class="fas fa-plus me-2"></i>Novo Cliente
                </button>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Email</th>
                                    <th>Telefone</th>
                                    <th>Mensalidade</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($clients as $client): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($client['name']); ?></td>
                                    <td><?php echo htmlspecialchars($client['email']); ?></td>
                                    <td class="phone-number"><?php echo htmlspecialchars($client['phone']); ?></td>
                                    <td>R$ <?php echo number_format($client['monthly_fee'], 2, ',', '.'); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-info edit-client" data-id="<?php echo $client['id']; ?>">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger delete-client" data-id="<?php echo $client['id']; ?>">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Adicionar Cliente -->
    <div class="modal fade" id="addClientModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Novo Cliente</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="save.php" method="POST">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="name" class="form-label">Nome</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email">
                        </div>
                        <div class="mb-3">
                            <label for="phone" class="form-label">Telefone</label>
                            <input type="tel" class="form-control phone-mask" id="phone" name="phone">
                        </div>
                        <div class="mb-3">
                            <label for="monthly_fee" class="form-label">Mensalidade</label>
                            <input type="text" class="form-control money-mask" id="monthly_fee" name="monthly_fee" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Salvar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script>
        $(document).ready(function() {
            // Máscara para telefone
            $('.phone-mask').mask('(00) 00000-0000');
            $('.money-mask').mask('#.##0,00', {reverse: true});

            // Aplicar máscara nos números de telefone existentes na tabela
            $('.phone-number').each(function() {
                var phone = $(this).text();
                if (phone) {
                    // Remove todos os caracteres não numéricos
                    phone = phone.replace(/\D/g, '');
                    // Aplica a máscara
                    if (phone.length === 11) {
                        phone = phone.replace(/^(\d{2})(\d{5})(\d{4})$/, '($1) $2-$3');
                        $(this).text(phone);
                    }
                }
            });

            // Editar cliente
            $('.edit-client').click(function() {
                const id = $(this).data('id');
                window.location.href = 'edit.php?id=' + id;
            });

            // Excluir cliente
            $('.delete-client').click(function() {
                if (confirm('Tem certeza que deseja excluir este cliente?')) {
                    const id = $(this).data('id');
                    window.location.href = 'delete.php?id=' + id;
                }
            });
        });
    </script>
</body>
</html>
