<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body" style="padding-bottom: 80px;">
                <div class="col-md-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_create')): ?>
                    <a href="<?php echo e(route('frontbox.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        PDV
                    </a>
                    <?php endif; ?>
                </div>
                <hr>
                <?php echo Form::open()->fill(request()->all())->get(); ?>

                <div class="row">
                    <div class="col-md-3">
                        <?php echo Form::select('cliente_id', 'Cliente')->attrs(['class' => 'select2']); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::date('start_date', 'Data inicial'); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::date('end_date', 'Data final'); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::select('estado', 'Estado', [
                            '' => 'Todos',
                            'novo' => 'Novo',
                            'aprovado' => 'Aprovado',
                            'cancelado' => 'Cancelado',
                            'rejeitado' => 'Rejeitado'
                        ]); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::select('tem_devolucao', 'Devoluções', [
                            '' => 'Todos',
                            '1' => 'Com devoluções'
                        ]); ?>

                    </div>
                    <div class="col-md-3 text-left ">
                        <br>
                        <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                        <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('frontbox.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                    </div>
                </div>
                <?php echo Form::close(); ?>


                <div class="row mt-3 g-2 justify-content-center" style="margin-bottom: 10px;">
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #6c2eb7; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ <?php echo e(number_format($somaValores, 2, ',', '.')); ?></h5>
                                <small>Soma Valores</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #d32f2f; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ <?php echo e(number_format($somaCancelamentos, 2, ',', '.')); ?></h5>
                                <small>Soma Cancelamentos</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #ff9800; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ <?php echo e(number_format($somaRejeitados, 2, ',', '.')); ?></h5>
                                <small>Soma Rejeitados</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #1976d2; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ <?php echo e(number_format($somaDescontos, 2, ',', '.')); ?></h5>
                                <small>Soma Descontos</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #388e3c; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ <?php echo e(number_format($somaTrocos, 2, ',', '.')); ?></h5>
                                <small>Soma Trocos</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #222; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ <?php echo e(number_format($somaRecebimentos, 2, ',', '.')); ?></h5>
                                <small>Soma Recebimentos</small>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($contigencia != null): ?>
                <div class="row">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="text-danger">Contigência ativada</h4>
                                <p class="text-danger">Tipo: <strong><?php echo e($contigencia->tipo); ?></strong></p>
                                <p class="text-danger">Data de início: <strong><?php echo e(__data_pt($contigencia->created_at)); ?></strong></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="col-lg-12 mt-4">
                    <div class="table-responsive" style="min-height: 400px;">
                        <table class="table table-striped table-centered mb-0 w-100">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>CPF/CNPJ</th>
                                    <th>Valor</th>
                                    <th>Desconto</th>
                                    <th>Valor Recebido</th>
                                    <th>Estado</th>
                                    <th>Devolução</th>
                                    <th>Número NFCe</th>
                                    <th>Data</th>
                                    <th>Lista de preço</th>
                                    <th>Usuário</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->numero_sequencial); ?></td>
                                    <td><span class="d-inline-block text-truncate" style="max-width: 220px;"><?php echo e($item->cliente ? $item->cliente->razao_social : ($item->cliente_nome != "" ? $item->cliente_nome : "--")); ?></span></td>
                                    <td><span class="d-inline-block text-truncate" style="max-width: 140px;"><?php echo e($item->cliente ? $item->cliente->cpf_cnpj : ($item->cliente_cpf_cnpj != "" ? $item->cliente_cpf_cnpj : "--")); ?></span></td>
                                    <td><?php echo e(__moeda($item->itens->sum('sub_total'))); ?></td>
                                    <td><?php echo e(__moeda($item->desconto)); ?></td>
                                    <td><?php echo e(__moeda($item->fatura->sum('valor'))); ?></td>
                                    <td width="110">
                                        <?php if($item->estado == 'aprovado'): ?>
                                        <span class="btn btn-success text-white btn-sm py-0 px-1">aprovado</span>
                                        <?php elseif($item->estado == 'cancelado'): ?>
                                        <span class="btn btn-danger text-white btn-sm py-0 px-1">cancelado</span>
                                        <?php elseif($item->estado == 'rejeitado'): ?>
                                        <span class="btn btn-warning text-white btn-sm py-0 px-1">rejeitado</span>
                                        <?php else: ?>
                                        <span class="btn btn-info text-white btn-sm py-0 px-1">novo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td width="90">
                                        <?php if($item->tem_devolucao == 1): ?>
                                        <span class="btn btn-warning text-white btn-sm py-0 px-1">
                                            <i class="ri-refresh-line"></i> Sim
                                        </span>
                                        <?php else: ?>
                                        <span class="text-muted">Não</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->estado == 'aprovado' ? $item->numero : '--'); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d/m/Y H:i')); ?></td>
                                    <td><?php echo e($item->lista ? $item->listaPreco->nome : '--'); ?></td>
                                    <td><?php echo e($item->user ? $item->user->name : '--'); ?></td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-outline-secondary btn-sm dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                Ações
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm small">
                                                <li>
                                                    <a class="dropdown-item text-primary" href="<?php echo e(route('frontbox.imprimir-nao-fiscal', [$item->id])); ?>" target="_blank">
                                                        <i class="ri-printer-line me-1"></i> Imprimir Não Fiscal
                                                    </a>
                                                </li>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_delete')): ?>
                                                <li>
                                                    <form action="<?php echo e(route('frontbox.destroy', $item->id)); ?>" method="POST" id="form-<?php echo e($item->id); ?>" style="display:inline;">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="button" class="dropdown-item text-danger btn-delete">
                                                            <i class="ri-delete-bin-line me-1"></i> Cancelar
                                                        </button>
                                                    </form>
                                                </li>
                                                <?php endif; ?>
                                                <?php if($item->estado != 'aprovado'): ?>
                                                <li>
                                                    <a class="dropdown-item text-info" href="<?php echo e(route('frontbox.show', $item->id)); ?>">
                                                        <i class="ri-eye-line me-1"></i> Detalhes
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item text-dark" href="<?php echo e(route('nfce.xml-temp', $item->id)); ?>" target="_blank">
                                                        <i class="ri-file-line me-1"></i> XML Temporário
                                                    </a>
                                                </li>
                                                <?php endif; ?>
                                                <?php if($item->estado == 'aprovado'): ?>
                                                <li>
                                                    <a class="dropdown-item text-success" href="<?php echo e(route('nfce.imprimir', [$item->id])); ?>" target="_blank">
                                                        <i class="ri-printer-line me-1"></i> Imprimir NFCe
                                                    </a>
                                                </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="12" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <br>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<style>
    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
    }

    .dropdown-menu {
        position: absolute !important;
        z-index: 1050;
        max-height: 300px;
        overflow-y: auto;
    }

    .table-responsive {
        min-height: 600px;
    }

    .card-body {
        padding-bottom: 80px;
    }
    
    /* Estilos para botões de estado */
    .btn-sm.py-0.px-1 {
        font-size: 0.75rem;
        display: inline-block;
        min-width: 80px;
        text-align: center;
        margin: 0 auto;
        border-radius: 3px;
        font-weight: 500;
    }

    /* Reduzir espaçamento entre os cards */
    .row.g-2 > [class^='col-'] {
        margin-bottom: 8px;
    }
    .row.g-2 {
        gap: 8px 0;
    }

    .card-destaque {
        box-shadow: 0 2px 8px rgba(0,0,0,0.08), 0 0px 0px rgba(0,0,0,0.01);
        border: 1.5px solid #e0e0e0;
        border-radius: 10px;
        transition: box-shadow 0.2s;
        background: #fff;
        color: #222;
    }
    .card-destaque:hover {
        box-shadow: 0 4px 16px rgba(0,0,0,0.13);
        border-color: #bdbdbd;
    }
    .card-destaque h4, .card-destaque h6 { color: inherit; }
    .card-recebimentos {
        background: #43a047 !important;
        border-color: #388e3c !important;
        color: #fff !important;
    }
    .card-recebimentos i { color: #fff !important; }
    .card-descontos {
        background: #1976d2 !important;
        border-color: #1565c0 !important;
        color: #fff !important;
    }
    .card-descontos i { color: #fff !important; }
    .card-trocos {
        background: #fbc02d !important;
        border-color: #f9a825 !important;
        color: #fff !important;
    }
    .card-trocos i { color: #fff !important; }
    .card-cancelamentos {
        background: #c62828 !important;
        border-color: #b71c1c !important;
        color: #fff !important;
    }
    .card-cancelamentos i { color: #fff !important; }
    .card-valores {
        background: #6a1b9a !important;
        border-color: #45277a !important;
        color: #fff !important;
    }
    .card-valores i { color: #fff !important; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/nfce_transmitir.js"></script>
<script>
    document.querySelectorAll('.dropdown').forEach(function (dropdown) {
        const button = dropdown.querySelector('.dropdown-toggle');
        button.addEventListener('click', function () {
            const rect = dropdown.getBoundingClientRect();
            const isNearBottom = window.innerHeight - rect.bottom < 150;
            if (isNearBottom) {
                dropdown.classList.add('dropup');
            } else {
                dropdown.classList.remove('dropup');
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Lista de Vendas PDV'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/front_box/index.blade.php ENDPATH**/ ?>