@extends('layouts.app', ['title' => 'Configuração eNPS'])

@section('css')
<style>
    .form-switch .form-check-input {
        width: 3em;
        height: 1.5em;
        margin-top: 0.1em;
    }
    
    .config-card {
        border-radius: 10px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
        transition: all 0.3s;
    }
    
    .config-card:hover {
        box-shadow: 0 8px 15px rgba(0,0,0,0.1);
    }
    
    .form-section {
        border-left: 4px solid #0d6efd;
        padding-left: 15px;
        margin-bottom: 25px;
    }
</style>
@endsection

@section('content')
<div class="container my-4">
    <div class="row">
        <div class="col-12">
            <div class="card config-card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Configuração da Pesquisa eNPS</h5>
                    <div>
                        <a href="{{ route('nps.admin') }}" class="btn btn-sm btn-outline-secondary">
                            <i class="ri-bar-chart-line"></i> Ver Painel eNPS
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form method="post" action="{{ route('nps.configuracao.salvar') }}" class="needs-validation" novalidate>
                        @csrf
                        
                        <!-- Status da Pesquisa -->
                        <div class="form-section">
                            <h6 class="mb-3">Status da Pesquisa</h6>
                            <div class="mb-3 form-check form-switch">
                                <input type="checkbox" class="form-check-input" id="ativo" name="ativo" value="1" @if($configuracao->ativo) checked @endif>
                                <label class="form-check-label" for="ativo">Ativar pesquisa eNPS</label>
                                <div class="form-text">Quando ativa, a pesquisa será exibida para os usuários de acordo com as configurações abaixo.</div>
                            </div>
                        </div>
                        
                        <!-- Configurações de Período -->
                        <div class="form-section">
                            <h6 class="mb-3">Configurações de Período</h6>
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label for="data_inicio" class="form-label">Data de Início</label>
                                    <input type="date" class="form-control @error('data_inicio') is-invalid @enderror" id="data_inicio" name="data_inicio" value="{{ $configuracao->data_inicio ? $configuracao->data_inicio->format('Y-m-d') : '' }}">
                                    <div class="form-text">A pesquisa só será exibida a partir desta data.</div>
                                    @error('data_inicio')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label for="data_fim" class="form-label">Data de Término (opcional)</label>
                                    <input type="date" class="form-control @error('data_fim') is-invalid @enderror" id="data_fim" name="data_fim" value="{{ $configuracao->data_fim ? $configuracao->data_fim->format('Y-m-d') : '' }}">
                                    <div class="form-text">Deixe em branco para manter a pesquisa ativa indefinidamente.</div>
                                    @error('data_fim')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label for="dia_mes" class="form-label">Dia do Mês para Exibição</label>
                                    <input type="number" class="form-control @error('dia_mes') is-invalid @enderror" id="dia_mes" name="dia_mes" min="1" max="31" value="{{ $configuracao->dia_mes }}" required>
                                    <div class="form-text">A pesquisa será exibida todos os dias até ser respondida ou ignorada. No próximo mês, aparecerá novamente a partir deste dia configurado.</div>
                                    @error('dia_mes')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <!-- Personalização da Pesquisa -->
                        <div class="form-section">
                            <h6 class="mb-3">Personalização</h6>
                            <div class="mb-3">
                                <label for="titulo" class="form-label">Título da Pesquisa</label>
                                <input type="text" class="form-control @error('titulo') is-invalid @enderror" id="titulo" name="titulo" value="{{ $configuracao->titulo }}" required>
                                @error('titulo')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="descricao" class="form-label">Descrição ou Mensagem (opcional)</label>
                                <textarea class="form-control @error('descricao') is-invalid @enderror" id="descricao" name="descricao" rows="3">{{ $configuracao->descricao }}</textarea>
                                <div class="form-text">Texto adicional para explicar o propósito da pesquisa aos usuários.</div>
                                @error('descricao')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="ri-save-line"></i> Salvar Configurações
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Card de Informações -->
            <div class="card config-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Informações sobre a Pesquisa eNPS</h5>
                </div>
                <div class="card-body">
                    <h6>O que é a Pesquisa eNPS?</h6>
                    <p>eNPS (Employee Net Promoter Score) é uma métrica utilizada para medir o nível de satisfação e lealdade dos usuários com o sistema. A pesquisa pergunta em uma escala de 0 a 10 o quanto o usuário recomendaria o sistema.</p>
                    
                    <h6>Como funciona?</h6>
                    <p>De acordo com a resposta na escala de 0 a 10, os usuários são classificados em:</p>
                    <ul>
                        <li><span class="badge bg-danger">Detratores (0-6)</span>: Usuários insatisfeitos que podem prejudicar sua marca através de feedback negativo.</li>
                        <li><span class="badge bg-warning text-dark">Neutros (7-8)</span>: Usuários satisfeitos, mas sem entusiasmo, vulneráveis a ofertas competitivas.</li>
                        <li><span class="badge bg-success">Promotores (9-10)</span>: Usuários leais que continuarão usando e recomendando o sistema para outros.</li>
                    </ul>
                    
                    <h6>Comportamento da Pesquisa</h6>
                    <ul>
                        <li>A pesquisa será exibida apenas <strong>uma vez por dia</strong> para cada usuário, no seu primeiro acesso ou quando fizer login novamente.</li>
                        <li>A pesquisa <strong>não será exibida</strong> para usuários SuperAdmin.</li>
                        <li>Quando um usuário comum acessa o sistema, a pesquisa será exibida todos os dias (uma vez por dia) até que ele responda ou escolha ignorá-la.</li>
                        <li>Depois que o usuário responder ou ignorar, a pesquisa só será mostrada novamente no próximo mês, a partir do dia configurado.</li>
                        <li>O campo "Dia do Mês para Exibição" define a partir de qual dia do mês a pesquisa será exibida novamente para usuários que já responderam ou ignoraram no mês anterior.</li>
                        <li>Se configurado com datas de início e término, a pesquisa só será exibida dentro deste período, respeitando as demais regras.</li>
                    </ul>
                    
                    <h6>Cálculo do Score NPS</h6>
                    <p>O score NPS é calculado subtraindo a porcentagem de Detratores da porcentagem de Promotores:</p>
                    <div class="alert alert-info">
                        <strong>NPS = % de Promotores - % de Detratores</strong>
                    </div>
                    <p>O resultado varia de -100 (se todos forem Detratores) a +100 (se todos forem Promotores).</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Validação do formulário
        const form = document.querySelector('.needs-validation');
        
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            
            form.classList.add('was-validated');
        });
        
        // Validação da data de término
        const dataInicio = document.getElementById('data_inicio');
        const dataFim = document.getElementById('data_fim');
        
        dataFim.addEventListener('change', function() {
            if (dataInicio.value && dataFim.value) {
                if (new Date(dataFim.value) < new Date(dataInicio.value)) {
                    dataFim.setCustomValidity('A data de término deve ser posterior à data de início');
                } else {
                    dataFim.setCustomValidity('');
                }
            } else {
                dataFim.setCustomValidity('');
            }
        });
        
        dataInicio.addEventListener('change', function() {
            if (dataInicio.value && dataFim.value) {
                if (new Date(dataFim.value) < new Date(dataInicio.value)) {
                    dataFim.setCustomValidity('A data de término deve ser posterior à data de início');
                } else {
                    dataFim.setCustomValidity('');
                }
            } else {
                dataFim.setCustomValidity('');
            }
        });
    });
</script>
@endsection 