<div id="cpf_nota" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="standard-modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header py-2">
                <h4 class="modal-title" id="standard-modalLabel">CPF na Nota?</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body py-2">
                <div class="row g-1">
                    <div class="col-md-12">
                        {!! Form::tel('cliente_cpf_cnpj', 'CPF/CNPJ')->attrs(['class' => 'cpf_cnpj', 'style' => 'padding: 0.25rem 0.5rem; height: calc(1.75rem + 2px);']) !!}
                    </div>
                    <div class="col-md-12 mt-2">
                        {!! Form::text('cliente_nome', 'Nome (opcional)')->attrs(['style' => 'padding: 0.25rem 0.5rem; height: calc(1.75rem + 2px);']) !!}
                    </div>
                </div>
            </div>
            <div class="modal-footer py-1">
                <button type="button" id="btn_fiscal_emitir" class="btn btn-primary py-1">Emitir</button>
            </div>
        </div>
    </div>
</div>

<!-- Script com verificação de jQuery -->
<script>
// Primeiro, verifica se já existe uma função de diagnóstico global
window.NGBPDiagnostico = window.NGBPDiagnostico || {
    scriptCarregado: false,
    jqueryDisponivel: false,
    versao: '3.0',
    timestamp: new Date().toISOString()
};

// Função para inicializar o script quando jQuery estiver disponível
function inicializarEmissaoCupomFiscal() {
    // Verifica se jQuery está disponível
    if (typeof jQuery === 'undefined') {
        console.error('jQuery não disponível - Esperando carregamento');
        // Tentar novamente em 500ms
        setTimeout(inicializarEmissaoCupomFiscal, 500);
        return;
    }
    
    // jQuery está disponível!
    window.NGBPDiagnostico.jqueryDisponivel = true;
    console.log('%c INICIALIZANDO EMISSOR CUPOM FISCAL v3.0 ' + new Date().toISOString(), 
               'background: #4CAF50; color: white; padding: 5px; border-radius: 3px;');
    
    // Use uma função auto-executável para não poluir o escopo global
    (function($) {
        // Confirmação de que estamos usando jQuery válido
        console.log('jQuery disponível - versão:', $.fn.jquery);
        
        // Verificar se o botão existe
        var $botaoEmitir = $('#btn_fiscal_emitir');
        if ($botaoEmitir.length === 0) {
            console.warn('Botão de emissão não encontrado no DOM');
            
            // Verificar periodicamente se o botão aparece
            var verificadorBotao = setInterval(function() {
                $botaoEmitir = $('#btn_fiscal_emitir');
                if ($botaoEmitir.length > 0) {
                    console.log('Botão de emissão encontrado no DOM após verificação periódica');
                    clearInterval(verificadorBotao);
                    configurarBotaoEmissao($botaoEmitir);
                }
            }, 1000);
            
            return;
        } else {
            console.log('Botão de emissão encontrado no DOM');
            configurarBotaoEmissao($botaoEmitir);
        }
        
        // Função para configurar o botão de emissão
        function configurarBotaoEmissao($botao) {
            // Adicionar estilo para confirmar que o script está ativo
            $botao.css('position', 'relative')
                 .attr('data-emissor-ativo', 'sim')
                 .attr('data-versao', '3.0');
            
            // Adicionar CSS inline para maior garantia
            var estiloBotao = document.createElement('style');
            estiloBotao.textContent = '#btn_fiscal_emitir[data-emissor-ativo="sim"] { border-bottom: 2px solid #4CAF50 !important; }';
            document.head.appendChild(estiloBotao);
            
            // Remover handlers existentes e adicionar o novo
            $botao.off('click');
            
            // Adicionar o manipulador de eventos
            $botao.on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                console.log('%c BOTÃO EMITIR CLICADO! ' + new Date().toISOString(), 
                          'background: #FF5722; color: white; padding: 5px; border-radius: 3px;');
                
                // Verificar se o swal está disponível
                if (typeof swal === 'undefined') {
                    console.error('Função swal não disponível, usando alert como fallback');
                    alert('Iniciando emissão do cupom fiscal...');
                } else {
                    swal({
                        title: "Processando...",
                        text: "Iniciando emissão do cupom fiscal",
                        icon: "info",
                        buttons: false,
                        closeOnClickOutside: false,
                        closeOnEsc: false
                    });
                }
                
                emitirCupomFiscal();
            });
            
            // Marcar que o script foi carregado com sucesso
            window.NGBPDiagnostico.scriptCarregado = true;
            console.log('Botão de emissão configurado com sucesso');
        }
        
        // Função principal para emitir o cupom fiscal
        function emitirCupomFiscal() {
            try {
                // Capturar dados do modal
                var cpfCnpj = $('#cpf_nota input[name="cliente_cpf_cnpj"]').val() || '';
                var clienteNome = $('#cpf_nota input[name="cliente_nome"]').val() || '';
                
                console.log('Dados do cliente:', { cpfCnpj, clienteNome });
                
                // Identificar qual PDV está sendo usado - simplificado para apenas PDV 1
                var isPDV1 = true;
                console.log('Usando PDV 1');
                
                // Fechar o modal
                try {
                    $('#cpf_nota').modal('hide');
                } catch (e) {
                    console.error('Erro ao fechar modal via jQuery:', e);
                    try {
                        var modalEl = document.getElementById('cpf_nota');
                        if (modalEl) {
                            if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                                var bsModal = bootstrap.Modal.getInstance(modalEl);
                                if (bsModal) bsModal.hide();
                            } else {
                                $(modalEl).hide();
                                $('.modal-backdrop').remove();
                            }
                        }
                    } catch (e2) {
                        console.error('Erro ao fechar modal via alternativas:', e2);
                    }
                }
                
                // Capturar dados de pagamento
                var pagamentos = obterDadosPagamento();
                console.log('Dados de pagamento:', pagamentos);
                
                // Verificar modo de venda (nova ou atualização)
                var vendaIdElement = $('#venda_id').length > 0 ? $('#venda_id') : $('input[name="venda_id"]');
                var vendaId = vendaIdElement.length > 0 ? vendaIdElement.val() : null;
                
                // Só considerar atualização se tivermos um ID válido
                var isUpdate = vendaId && vendaId !== '' && vendaId !== 'undefined' && vendaId !== undefined;
                
                console.log('Modo:', isUpdate ? 'Atualização' : 'Nova venda', 'ID:', vendaId);
                
                // Preparar dados do formulário
                var formData = prepararDadosFormulario(cpfCnpj, clienteNome, pagamentos);
                
                // Garantir que temos o path_url
                var pathUrl = obterPathUrl();
                
                // URL da API
                var apiUrl = pathUrl + (isUpdate 
                    ? 'api/frenteCaixa/update/' + vendaId 
                    : 'api/frenteCaixa/store');
                
                console.log('Enviando requisição para:', apiUrl);
                
                // Enviar requisição AJAX
                $.ajax({
                    url: apiUrl,
                    type: 'POST',
                    data: formData,
                    timeout: 30000,
                    beforeSend: function() {
                        // Log detalhado dos dados que estão sendo enviados
                        console.log('%c DADOS ENVIADOS PARA API:', 'background: #FF9800; color: white; padding: 5px; border-radius: 3px;');
                        console.log('URL:', apiUrl);
                        
                        // Mostrar valores importantes para diagnóstico
                        console.log('Total:', formData.total);
                        console.log('Desconto:', formData.desconto);
                        console.log('Total Produtos:', formData.total_produtos);
                        console.log('Pagamentos:', formData['valor_fatura[]']);
                        
                        // Log completo dos dados
                        console.log('Dados completos:', formData);
                    },
                    success: function(venda) {
                        console.log('Venda processada com sucesso:', venda);
                        enviarRequisicaoNFCe(venda, pathUrl);
                    },
                    error: function(xhr, status, error) {
                        console.error('Erro ao processar venda:', { xhr, status, error });
                        
                        // Se falhou porque tentou atualizar com ID inválido, tentar criar nova venda
                        if (isUpdate && (xhr.status === 404 || xhr.status === 405)) {
                            console.warn('Falha ao atualizar venda. Tentando criar uma nova venda...');
                            
                            // Ajustar para nova venda
                            var novaUrl = pathUrl + 'api/frenteCaixa/store';
                            console.log('Tentando nova URL:', novaUrl);
                            
                            $.ajax({
                                url: novaUrl,
                                type: 'POST',
                                data: formData,
                                timeout: 30000,
                                success: function(venda) {
                                    console.log('Nova venda criada com sucesso após falha na atualização:', venda);
                                    enviarRequisicaoNFCe(venda, pathUrl);
                                },
                                error: function(xhr2, status2, error2) {
                                    console.error('Erro ao criar nova venda após falha na atualização:', 
                                                 { xhr: xhr2, status: status2, error: error2 });
                                    mostrarErro('Falha ao processar venda', 
                                               'Não foi possível criar ou atualizar a venda. ' + 
                                               obterMensagemErro(xhr2, status2, error2));
                                }
                            });
                        } else {
                            mostrarErro('Falha ao processar venda', obterMensagemErro(xhr, status, error));
                        }
                    }
                });
            } catch (error) {
                console.error('Erro global ao processar venda:', error);
                mostrarErro('Erro', 'Falha ao processar venda: ' + error.message);
            }
        }
        
        // Função para obter dados de pagamento da tabela
        function obterDadosPagamento() {
            var pagamentos = [];
            var temFatura = false;
            
            // Primeiro, verificar se já existem pagamentos globais registrados
            if (typeof window.pagamentosRegistradosPDV !== 'undefined' && 
                window.pagamentosRegistradosPDV && 
                window.pagamentosRegistradosPDV.length > 0) {
                console.log('Usando pagamentos já registrados globalmente:', window.pagamentosRegistradosPDV);
                return window.pagamentosRegistradosPDV;
            }
            
            // Verificar se temos pagamentos em memória (possivelmente do processamento do PDV)
            if (typeof window.pagamentos !== 'undefined' && window.pagamentos && window.pagamentos.length > 0) {
                console.log('Usando pagamentos da memória:', window.pagamentos);
                return window.pagamentos;
            }
            
            // Seletores para diferentes versões do PDV
            var seletoresTabelas = [
                '.table-payment tbody tr', 
                '.fatura tr.dynamic-form',
                '.pagamentos-table tr',
                '.pagamentos tbody tr',
                '#tabela-pagamentos tr',
                'table.table-dynamic tbody tr'
            ];
            
            // Percorrer os seletores
            $.each(seletoresTabelas, function(i, seletor) {
                $(seletor).each(function() {
                    temFatura = true;
                    try {
                        // Capturar dados da linha
                        var tipo, valor, dataVencimento;
                        
                        // PDV1 - versão padrão
                        if ($(this).find('.tipo_pagamento').length) {
                            tipo = $(this).find('.tipo_pagamento').val() || $(this).find('select[name="tipo_pagamento_row[]"]').val();
                            valor = $(this).find('.valor_integral_row').val();
                            dataVencimento = $(this).find('.data_vencimento').val();
                        }
                        // PDV1 - versão alternativa
                        else if ($(this).find('.payment_type').length) {
                            tipo = $(this).find('.payment_type').val();
                            valor = $(this).find('.payment_value').val();
                        }
                        // Tentar encontrar por atributos
                        else {
                            $(this).find('select, input').each(function() {
                                var name = $(this).attr('name') || '';
                                if (name.includes('tipo_pagamento')) {
                                    tipo = $(this).val();
                                } else if (name.includes('valor')) {
                                    valor = $(this).val();
                                } else if (name.includes('data') || $(this).attr('type') === 'date') {
                                    dataVencimento = $(this).val();
                                }
                            });
                        }
                        
                        if (tipo && valor) {
                            // Converter valor para formato numérico
                            var valorNumerico = converterParaNumero(valor);
                            
                            if (!isNaN(valorNumerico)) {
                                pagamentos.push({
                                    tipo: tipo,
                                    valor: valorNumerico,
                                    dataVencimento: dataVencimento || null
                                });
                            }
                        }
                    } catch (err) {
                        console.error('Erro ao processar linha de pagamento:', err);
                    }
                });
            });
            
            // Se não encontrarmos pagamentos, tentar métodos alternativos
            if (pagamentos.length === 0) {
                pagamentos = obterDadosPagamentoAlternativo();
            }
            
            // Se ainda não tivermos pagamentos e estamos na tela de PDV, tentar capturar o valor total
            if (pagamentos.length === 0) {
                var valorTotal = obterValorTotal();
                if (valorTotal > 0) {
                    console.log('Usando valor total como pagamento em dinheiro:', valorTotal);
                    pagamentos.push({
                        tipo: '01', // 01 = Dinheiro
                        valor: valorTotal,
                        dataVencimento: null
                    });
                } else {
                    // Último recurso: tentar capturar qualquer número que pareça ser um valor total
                    var valorEncontrado = capturarValorDeTela();
                    if (valorEncontrado > 0) {
                        console.log('Usando valor encontrado na tela como pagamento em dinheiro:', valorEncontrado);
                        pagamentos.push({
                            tipo: '01', // 01 = Dinheiro
                            valor: valorEncontrado,
                            dataVencimento: null
                        });
                    }
                }
            }
            
            // Se ainda não temos pagamentos, criar um pagamento padrão
            if (pagamentos.length === 0) {
                console.warn('Nenhum pagamento encontrado - criando pagamento padrão');
                pagamentos.push({
                    tipo: '01', // 01 = Dinheiro
                    valor: 0.01, // Valor mínimo
                    dataVencimento: null
                });
            }
            
            // Armazenar para acesso posterior
            window.pagamentosRegistradosPDV = pagamentos;
            
            return pagamentos;
        }
        
        // Função para capturar qualquer valor numérico visível na tela
        function capturarValorDeTela() {
            var valorEncontrado = 0;
            
            // Procurar por elementos que contenham textos como "Total", "Valor", etc.
            var elementosComValor = $('*:contains("Total"), *:contains("total"), *:contains("Valor"), *:contains("valor"), *:contains("R$")');
            
            elementosComValor.each(function() {
                var texto = $(this).text();
                if (texto.match(/R\$|\d+,\d+|\d+\.\d+/)) {
                    var valor = converterParaNumero(texto);
                    if (valor > valorEncontrado) {
                        valorEncontrado = valor;
                    }
                }
            });
            
            return valorEncontrado;
        }
        
        // Função para obter valor total da venda
        function obterValorTotal() {
            var valorTotal = 0;
            var possiveisElementos = [
                '.total-venda-modal', '#total-venda', '.lbl-total', '#valor_total',
                '.total_venda', '#inp-valor_total', '.resumo-total', '#resumo-total'
            ];
            
            for (var i = 0; i < possiveisElementos.length; i++) {
                var el = $(possiveisElementos[i]);
                if (el.length) {
                    var textoValor = el.text() || el.val() || '0';
                    valorTotal = converterParaNumero(textoValor);
                    if (valorTotal > 0) break;
                }
            }
            
            return valorTotal;
        }
        
        // Função para obter dados de pagamento por métodos alternativos
        function obterDadosPagamentoAlternativo() {
            var pagamentos = [];
            
            // PDV1: Verificar campos específicos
            if ($('#inp-tipo_pagamento').length) {
                var tipo = $('#inp-tipo_pagamento').val();
                var valor = $('#inp-valor_total').val() || $('#valor_total').text();
                
                if (tipo && valor) {
                    var valorNumerico = converterParaNumero(valor);
                    if (!isNaN(valorNumerico)) {
                        pagamentos.push({
                            tipo: tipo,
                            valor: valorNumerico,
                            dataVencimento: null
                        });
                    }
                }
            }
            
            // PDV2: Verificar atributos data
            if ($('[data-pdv-total]').length) {
                var valorTotal = $('[data-pdv-total]').data('pdv-total');
                if (valorTotal) {
                    pagamentos.push({
                        tipo: '01', // Dinheiro
                        valor: parseFloat(valorTotal),
                        dataVencimento: null
                    });
                }
            }
            
            return pagamentos;
        }
        
        // Função para converter string para número
        function converterParaNumero(valor) {
            if (!valor) return 0;
            
            // Se já for um número
            if (typeof valor === 'number') return valor;
            
            // Se for string
            if (typeof valor === 'string') {
                // Remover caracteres não numéricos, exceto . e ,
                valor = valor.replace(/[^\d.,]/g, '');
                
                // Formato brasileiro (1.234,56)
                if (valor.includes(',')) {
                    return parseFloat(valor.replace(/\./g, '').replace(',', '.'));
                } 
                // Formato americano (1,234.56)
                else if (valor.includes('.')) {
                    return parseFloat(valor);
                }
                // Apenas números
                else {
                    return parseFloat(valor);
                }
            }
            
            return 0;
        }
        
        // Função para preparar os dados do formulário
        function prepararDadosFormulario(cpfCnpj, clienteNome, pagamentos) {
            console.log('Preparando dados do formulário...');
            var formData = {};
            var formularioEncontrado = false;
            
            // Tentar serializar diferentes formulários
            var possiveisFormularios = [
                '#form-pdv',
                '#form-pdv-update',
                '#form-frente-caixa',
                'form:first'
            ];
            
            // Tentar cada formulário
            for (var i = 0; i < possiveisFormularios.length; i++) {
                var $form = $(possiveisFormularios[i]);
                if ($form.length) {
                    try {
                        console.log('Tentando serializar formulário:', possiveisFormularios[i]);
                        // Verificar se o método serializeFormJSON está disponível
                        if (typeof $form.serializeFormJSON === 'function') {
                            formData = $form.serializeFormJSON();
                            formularioEncontrado = true;
                            console.log('Formulário serializado com sucesso via serializeFormJSON');
                            break;
                        } 
                        // Tentar usar serializeArray como alternativa
                        else if (typeof $form.serializeArray === 'function') {
                            var dadosArray = $form.serializeArray();
                            $.each(dadosArray, function(i, field) {
                                formData[field.name] = field.value;
                            });
                            formularioEncontrado = true;
                            console.log('Formulário serializado com sucesso via serializeArray');
                            break;
                        }
                        // Último recurso: usar serialize padrão
                        else if (typeof $form.serialize === 'function') {
                            // Converter string de formulário em objeto
                            var serializedStr = $form.serialize();
                            var pairs = serializedStr.split('&');
                            for (var j = 0; j < pairs.length; j++) {
                                var pair = pairs[j].split('=');
                                formData[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1] || '');
                            }
                            formularioEncontrado = true;
                            console.log('Formulário serializado com sucesso via serialize');
                            break;
                        }
                    } catch (err) {
                        console.error('Erro ao serializar formulário:', err);
                    }
                }
            }
            
            // Se nenhum formulário foi encontrado, capturar inputs manualmente
            if (!formularioEncontrado) {
                console.log('Nenhum formulário encontrado. Capturando inputs manualmente...');
                $('input[name], select[name], textarea[name]').each(function() {
                    var name = $(this).attr('name');
                    if (name && name !== 'cliente_cpf_cnpj' && name !== 'cliente_nome') {
                        formData[name] = $(this).val();
                    }
                });
            }
            
            // NOVA LÓGICA: Capturar valores de desconto e total de forma mais robusta
            var valorTotal = 0;
            var valorProdutos = 0;
            var valorDesconto = 0;
            var valorAcrescimo = 0;
            
            // 1. Tentar obter valores de variáveis globais primeiro
            if (typeof window.DESCONTO !== 'undefined') {
                valorDesconto = parseFloat(window.DESCONTO) || 0;
                console.log('Desconto capturado da variável global:', valorDesconto);
            }
            
            if (typeof window.VALORACRESCIMO !== 'undefined') {
                valorAcrescimo = parseFloat(window.VALORACRESCIMO) || 0;
                console.log('Acréscimo capturado da variável global:', valorAcrescimo);
            }
            
            // 2. Tentar obter valores de elementos na página
            var elementosValorTotal = [
                '#total-venda', '.total-venda', '#valor_total', '.valor_total',
                '#inp-valor_total', '.inp-valor_total', '#total_venda', '.total_venda'
            ];
            
            var elementosValorDesconto = [
                '#desconto', '.desconto', '#valor_desconto', '.valor_desconto',
                '#inp-desconto', '.inp-desconto', '#desconto_venda', '.desconto_venda'
            ];
            
            // Buscar valor total
            for (var i = 0; i < elementosValorTotal.length; i++) {
                var elemento = $(elementosValorTotal[i]);
                if (elemento.length) {
                    var valor = elemento.val() || elemento.text();
                    valorTotal = converterParaNumero(valor);
                    if (valorTotal > 0) {
                        console.log('Valor total encontrado:', valorTotal);
                        break;
                    }
                }
            }
            
            // Se ainda não temos o desconto das variáveis globais, buscar nos elementos
            if (valorDesconto === 0) {
                for (var i = 0; i < elementosValorDesconto.length; i++) {
                    var elemento = $(elementosValorDesconto[i]);
                    if (elemento.length) {
                        var valor = elemento.val() || elemento.text();
                        valorDesconto = converterParaNumero(valor);
                        if (valorDesconto > 0) {
                            console.log('Valor desconto encontrado:', valorDesconto);
                            break;
                        }
                    }
                }
            }
            
            // CORREÇÃO: Calcular valor dos produtos corretamente
            // O valor dos produtos é o valor total ANTES do desconto
            if (valorTotal > 0) {
                // Se o valor total já é o valor com desconto
                if (typeof getValorTotal === 'function') {
                    // Usar a função global se disponível
                    var valorTotalGlobal = getValorTotal();
                    if (valorTotalGlobal > 0) {
                        valorTotal = valorTotalGlobal;
                        console.log('Valor total obtido via getValorTotal():', valorTotal);
                    }
                }
                
                // O valor dos produtos é o valor antes do desconto
                valorProdutos = valorTotal + valorDesconto;
                console.log('Valor dos produtos calculado (valor total + desconto):', valorProdutos);
                
                // Validação adicional
                if (valorProdutos < valorTotal) {
                    console.warn('AVISO: Valor dos produtos calculado é menor que o valor total!');
                    // Neste caso, assumir que o valor total é o valor dos produtos
                    valorProdutos = valorTotal;
                }
            }
            
            // Adicionar dados essenciais ao formData
            formData.empresa_id = $('#empresa_id').val() || $('input[name="empresa_id"]').val() || '';
            formData.usuario_id = $('#usuario_id').val() || $('input[name="usuario_id"]').val() || '';
            formData.cliente_cpf_cnpj = cpfCnpj;
            formData.cliente_nome = clienteNome;
            formData.tipo_documento = 'fiscal';
            formData.emitir_nfce = true;
            
            // Log detalhado dos valores antes de adicionar ao formData
            console.log('Resumo dos valores calculados:', {
                valorTotal: valorTotal,
                valorProdutos: valorProdutos,
                valorDesconto: valorDesconto,
                valorAcrescimo: valorAcrescimo,
                diferencaCalculada: valorProdutos - valorTotal
            });
            
            // CORREÇÃO: Garantir que o valor total seja o valor após o desconto
            if (valorTotal > 0) {
                // O total deve ser o valor após o desconto
                formData.total = valorTotal.toFixed(2);
                console.log('Total adicionado ao formData (valor após desconto):', formData.total);
            }
            
            if (valorProdutos > 0) {
                // O total_produtos deve ser o valor antes do desconto
                formData.total_produtos = valorProdutos.toFixed(2);
                console.log('Valor produtos adicionado ao formData (valor antes do desconto):', formData.total_produtos);
                
                // IMPORTANTE: Garantir que o valor total da NFCe seja o valor após o desconto
                formData.total_nfce = valorTotal.toFixed(2);
                console.log('Valor total NFCe adicionado ao formData (valor após desconto):', formData.total_nfce);
            }
            
            if (valorDesconto > 0) {
                formData.desconto = valorDesconto.toFixed(2);
                console.log('Desconto adicionado ao formData:', formData.desconto);
            }
            
            if (valorAcrescimo > 0) {
                formData.acrescimo = valorAcrescimo.toFixed(2);
                console.log('Acréscimo adicionado ao formData:', formData.acrescimo);
            }
            
            // NOVA IMPLEMENTAÇÃO: Garantir que o desconto seja incluído na fatura
            formData.fatura = {
                total_nfce: valorTotal.toFixed(2),  // Valor após desconto
                valor_produtos: valorProdutos.toFixed(2), // Valor antes do desconto
                desconto: valorDesconto.toFixed(2),
                acrescimo: valorAcrescimo.toFixed(2)
            };
            
            // Adicionar dados de pagamentos
            if (pagamentos && pagamentos.length > 0) {
                console.log('Adicionando dados de', pagamentos.length, 'pagamentos');
                
                // Remover arrays anteriores para evitar duplicação
                delete formData['tipo_pagamento[]'];
                delete formData['valor_fatura[]'];
                delete formData['data_vencimento[]'];
                
                // Inicializar arrays
                formData['tipo_pagamento[]'] = [];
                formData['valor_fatura[]'] = [];
                formData['data_vencimento[]'] = [];
                
                // CORREÇÃO: Garantir que o valor total dos pagamentos seja igual ao valor total após desconto
                var totalPagamentos = 0;
                
                // Preencher arrays com dados de pagamento
                for (var i = 0; i < pagamentos.length; i++) {
                    formData['tipo_pagamento[]'].push(pagamentos[i].tipo);
                    
                    // Ajustar o valor do pagamento para corresponder ao valor com desconto
                    var valorPagamento = pagamentos[i].valor;
                    if (i === 0 && pagamentos.length === 1) {
                        // Se só tem um pagamento, garantir que seja igual ao valor total com desconto
                        valorPagamento = valorTotal;
                    }
                    
                    formData['valor_fatura[]'].push(valorPagamento);
                    totalPagamentos += parseFloat(valorPagamento);
                    
                    // Data de vencimento (hoje se não especificada)
                    var dataVenc = pagamentos[i].dataVencimento;
                    if (!dataVenc) {
                        var hoje = new Date();
                        dataVenc = hoje.getFullYear() + '-' + 
                              ('0' + (hoje.getMonth() + 1)).slice(-2) + '-' + 
                              ('0' + hoje.getDate()).slice(-2);
                    }
                    formData['data_vencimento[]'].push(dataVenc);
                }
                
                // Definir tipo_pagamento principal como o primeiro pagamento
                if (pagamentos.length > 0) {
                    formData.tipo_pagamento = pagamentos[0].tipo;
                }
                
                // Log de verificação dos valores
                console.log('Verificação final dos valores:', {
                    valorTotal: valorTotal,
                    totalPagamentos: totalPagamentos,
                    diferenca: Math.abs(valorTotal - totalPagamentos),
                    valorProdutos: valorProdutos,
                    valorDesconto: valorDesconto
                });
            }
            
            console.log('Dados do formulário preparados com sucesso:', formData);
            return formData;
        }
        
        // Função para obter o path_url
        function obterPathUrl() {
            if (typeof path_url !== 'undefined' && path_url) {
                return path_url;
            }
            
            // Verificar se existe nos dados da página
            var pathFromMeta = $('meta[name="base-url"]').attr('content');
            if (pathFromMeta) {
                console.log('Usando path_url de meta tag:', pathFromMeta);
                window.path_url = pathFromMeta;
                return pathFromMeta.endsWith('/') ? pathFromMeta : pathFromMeta + '/';
            }
            
            // Verificar em variáveis globais comuns
            if (typeof baseUrl !== 'undefined') {
                console.log('Usando baseUrl global:', baseUrl);
                window.path_url = baseUrl;
                return baseUrl.endsWith('/') ? baseUrl : baseUrl + '/';
            }
            
            // Definir baseado na localização atual
            var baseUrl = window.location.origin + '/';
            if (window.location.pathname.includes('/public/')) {
                baseUrl += 'public/';
            }
            
            console.log('Path_url não encontrado, usando URL base calculada:', baseUrl);
            window.path_url = baseUrl;
            return baseUrl;
        }
        
        // Função para enviar requisição de emissão de NFCe
        function enviarRequisicaoNFCe(venda, pathUrl) {
            // Verificar se temos uma venda válida
            if (!venda || !venda.id) {
                mostrarErro('Erro de Validação', 'ID de venda inválido. Não é possível emitir o cupom fiscal.');
                console.error('Tentativa de emitir NFCe com ID de venda inválido:', venda);
                return;
            }
            
            // Atualizar mensagem de progresso
            if (typeof swal !== 'undefined') {
                swal({
                    title: "Emitindo NFCe...",
                    text: "Aguarde enquanto o cupom fiscal é emitido",
                    icon: "info",
                    buttons: false,
                    closeOnClickOutside: false,
                    closeOnEsc: false
                });
            }
            
            // Configurar URL da API
            var nfceUrl = pathUrl + "api/nfce_painel/emitir";
            console.log('Enviando requisição para emissão de NFCe:', nfceUrl, 'ID da venda:', venda.id);
            
            // Enviar requisição
            $.ajax({
                url: nfceUrl,
                type: 'POST',
                data: { id: venda.id },
                timeout: 60000,
                success: function(result) {
                    console.log('NFCe emitida com sucesso:', result);
                    
                    if (typeof swal !== 'undefined') {
                        swal({
                            title: "Sucesso!",
                            text: "NFCe emitida - Recibo: " + (result.recibo || 'Emitido'),
                            icon: "success",
                        }).then(function() {
                            finalizarProcesso(venda.id, pathUrl);
                        });
                    } else {
                        alert("NFCe emitida com sucesso!");
                        finalizarProcesso(venda.id, pathUrl);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro ao emitir NFCe:', { xhr, status, error });
                    
                    // Modificação: Em vez de apenas mostrar erro, finalizar a venda mesmo assim
                    // e informar ao usuário que ele pode emitir depois
                    if (typeof swal !== 'undefined') {
                        swal({
                            title: "Venda concluída com ressalvas",
                            text: "A venda foi processada, estoque baixado e financeiro lançado, mas houve um erro ao emitir a NFCe: \n\n" + 
                                  obterMensagemErro(xhr, status, error) + 
                                  "\n\nVocê poderá emitir o cupom fiscal posteriormente através da tela de frontbox.",
                            icon: "warning",
                        }).then(function() {
                            // Continuar com o processo de finalização mesmo após o erro na NFCe
                            finalizarProcessoSemImpressao(venda.id, pathUrl);
                        });
                    } else {
                        alert("Venda concluída, mas houve um erro ao emitir a NFCe. Você poderá emitir o cupom fiscal posteriormente através da tela de frontbox.");
                        finalizarProcessoSemImpressao(venda.id, pathUrl);
                    }
                }
            });
        }
        
        // Nova função para finalizar o processo sem abrir impressão em caso de erro na NFCe
        function finalizarProcessoSemImpressao(vendaId, pathUrl) {
            // Redirecionar para a página de nova venda no PDV
            var urlRedirect = pathUrl + 'frontbox/create';
            console.log('Redirecionando para nova venda:', urlRedirect);
            window.location.href = urlRedirect;
        }
        
        // Função para finalizar o processo
        function finalizarProcesso(vendaId, pathUrl) {
            // Abrir impressão
            var urlImpressao = pathUrl + 'nfce/imprimir/' + vendaId;
            console.log('Abrindo impressão:', urlImpressao);
            window.open(urlImpressao, "_blank");
            
            // Redirecionar para a página de nova venda no PDV
            setTimeout(function() {
                var urlRedirect = pathUrl + 'frontbox/create';
                console.log('Redirecionando para nova venda:', urlRedirect);
                window.location.href = urlRedirect;
            }, 500);
        }
        
        // Função para obter mensagem de erro
        function obterMensagemErro(xhr, status, error) {
            var errorMsg = "Erro desconhecido";
            
            try {
                if (xhr.responseJSON) {
                    errorMsg = typeof xhr.responseJSON === 'string' 
                        ? xhr.responseJSON 
                        : JSON.stringify(xhr.responseJSON);
                } else if (xhr.responseText) {
                    errorMsg = xhr.responseText;
                } else if (error) {
                    errorMsg = error.toString();
                } else if (status) {
                    errorMsg = status;
                }
            } catch (e) {
                console.error('Erro ao processar mensagem de erro:', e);
            }
            
            return errorMsg;
        }
        
        // Função para mostrar erro
        function mostrarErro(titulo, mensagem) {
            if (typeof swal !== 'undefined') {
                swal({
                    title: titulo,
                    text: mensagem,
                    icon: "error"
                });
            } else {
                alert(titulo + ": " + mensagem);
            }
        }
    })(jQuery); // Passamos jQuery como parâmetro para evitar conflitos
}

// Inicialize o script - verificará jQuery e aguardará se necessário
inicializarEmissaoCupomFiscal();

// Script de emergência independente em JavaScript puro
(function() {
    // Aguardar 5 segundos para verificar se o script principal funcionou
    setTimeout(function() {
        // Verificar se o script principal não foi inicializado
        if (!window.NGBPDiagnostico || !window.NGBPDiagnostico.scriptCarregado) {
            console.error('%c ALERTA: SCRIPT EMISSOR FISCAL NÃO INICIALIZADO ', 
                         'background: #f44336; color: white; padding: 5px;');
            
            // Tentar configurar em JavaScript puro
            var botaoEmitir = document.getElementById('btn_fiscal_emitir');
            if (botaoEmitir) {
                console.log('Script de emergência: botão encontrado');
                
                // Adicionar borda vermelha para indicar modo de emergência
                botaoEmitir.style.borderBottom = '3px solid #f44336';
                
                // Adicionar manipulador de eventos
                botaoEmitir.onclick = function(e) {
                    if (e) {
                        if (e.preventDefault) e.preventDefault();
                        if (e.stopPropagation) e.stopPropagation();
                    }
                    
                    console.log('Botão clicado via script de emergência');
                    alert('O script principal não foi carregado. Emissão em modo de emergência.');
                    
                    // Capturar dados básicos
                    var cpfInput = document.querySelector('#cpf_nota input[name="cliente_cpf_cnpj"]');
                    var nomeInput = document.querySelector('#cpf_nota input[name="cliente_nome"]');
                    
                    var cpf = cpfInput ? cpfInput.value : '';
                    var nome = nomeInput ? nomeInput.value : '';
                    
                    alert('Cliente: ' + nome + '\nCPF/CNPJ: ' + cpf + '\n\nPor favor, recarregue a página e tente novamente.');
                    
                    // Fechar modal
                    var modal = document.getElementById('cpf_nota');
                    if (modal) {
                        modal.style.display = 'none';
                        
                        // Remover backdrop se existir
                        var backdrops = document.querySelectorAll('.modal-backdrop');
                        for (var i = 0; i < backdrops.length; i++) {
                            backdrops[i].parentNode.removeChild(backdrops[i]);
                        }
                    }
                    
                    return false;
                };
            } else {
                console.error('Script de emergência: botão não encontrado');
            }
        } else {
            console.log('Script de diagnóstico: o script principal já está carregado');
        }
    }, 5000);
})();
</script>
