@extends('layouts.app', ['title' => 'Detalhes da Venda'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <h4>Detalhes da Venda</h4>
                <div style="text-align: right; margin-top: -35px;">
                    <a href="{{ route('frontbox.index') }}" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
                <hr class="mt-3">

                <a class="btn btn-dark mb-2" title="Imprimir" target="_blank" href="{{ route('frontbox.imprimir-nao-fiscal', [$data->id]) }}">
                    Imprimir
                    <i class="ri-printer-line"></i>
                </a>
                
                @if($data->estado == 'aprovado' && $data->tem_devolucao == 0)
                <a class="btn btn-danger mb-2 ms-2" title="Devolução" href="{{ route('devolucao_venda.devolucao', ['nfce', $data->id]) }}">
                    Devolução
                    <i class="ri-arrow-go-back-line"></i>
                </a>
                
                <a class="btn btn-warning mb-2 ms-2" title="Troca" href="{{ route('devolucao_venda.troca', ['nfce', $data->id]) }}">
                    Troca
                    <i class="ri-swap-line"></i>
                </a>
                @endif
                
                <div class="">
                    <h4>Cliente: <strong style="color: steelblue">{{ $data->cliente_id ? $data->cliente->razao_social : 'Consumidor Final'}}</strong></h4>

                    @if($data->user)
                    <h5>Usuário: <strong class="text-">{{ $data->user->name}}</strong></h5>
                    @endif
                </div>
                <hr>
                <div class="col-lg-12 mt-4">
                    <div class="table-responsive-sm">
                        <h5>Produtos:</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Item</th>
                                        <th>Qtd</th>
                                        <th>Valor</th>
                                        <th>Subtotal</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $subTotal = 0;
                                    @endphp
                                    @forelse ($data->itens as $i)
                                        <tr>
                                            <td>
                                                {{$i->produto ? $i->produto->nome : 'Não encontrado'}}
                                                @if($i->produtoVariacao)
                                                    <br><small class="text-white">{{ $i->produtoVariacao->descricao }}</small>
                                                @endif
                                            </td>
                                            <td>
                                                {{$i->quantidade}}
                                                @if(isset($i->quantidade_restante))
                                                <small class="d-block">({{ $i->quantidade_restante }} disponível)</small>
                                                @endif
                                            </td>
                                            <td>R$ {{ number_format($i->valor_unitario, 2, ',', '.') }}</td>
                                            <td>R$ {{ number_format($i->sub_total, 2, ',', '.') }}</td>
                                            <td>
                                                <span class="{{ $i->classe_status ?? 'text-success' }}">
                                                    {{ $i->status_devolucao ?? 'Normal' }}
                                                </span>
                                                
                                                @if(isset($i->substituto))
                                                <div class="mt-1">
                                                    <small>Substituído por: {{ $i->substituto->produto->nome }} ({{ $i->substituto->quantidade }})</small>
                                                </div>
                                                @endif
                                            </td>
                                        </tr>
                                        @php
                                            $subTotal += $i->sub_total;
                                        @endphp
                                    @empty
                                        <tr>
                                            <td colspan="5" align="center">Nenhum registro!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <h5 class="mt-2">TOTAL: {{ __moeda($subTotal) }} </h5>
                        @if(isset($data->desconto) && $data->desconto > 0)
                            <h6 class="mt-2 text-danger">Desconto: -{{ __moeda($data->desconto) }}</h6>
                        @endif
                    </div>
                    <div class="mt-5 col-md-6 col-12">
                        <h5>Forma de Pagamento:</h5>
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Pagamento</th>
                                    <th>Data Vencimento</th>
                                    <th>Valor</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data->fatura as $item)
                                <tr>
                                    <td>{{ $item->getTipoPagamento($item->tipo_pagamento) }}</td>
                                    <td>{{ __data_pt($item->data_vencimento, 0) }}</td>
                                    <td>{{ __moeda($item->valor) }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                </div>
                
                @if(isset($devolucoes) && count($devolucoes) > 0)
                <div class="col-lg-12 mt-5">
                    <h5>Histórico de Devoluções/Trocas:</h5>
                    <div class="table-responsive">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Data</th>
                                    <th>Valor Total</th>
                                    <th>Tipo</th>
                                    <th>Forma de Pagamento</th>
                                    <th>Observação</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($devolucoes as $devolucao)
                                <tr>
                                    <td>{{ __data_pt($devolucao->data_devolucao) }}</td>
                                    <td>{{ __moeda($devolucao->valor_total) }}</td>
                                    <td>
                                        @if(stripos($devolucao->observacao, 'troca') !== false)
                                        <span class="badge bg-warning">Troca</span>
                                        @else
                                        <span class="badge bg-danger">Devolução</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($devolucao->tipo_pagamento == '00')
                                        Vale Crédito
                                        @else
                                        {{ \App\Models\Nfce::tiposPagamento()[$devolucao->tipo_pagamento] ?? $devolucao->tipo_pagamento }}
                                        @endif
                                    </td>
                                    <td>{{ $devolucao->observacao }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
