@extends('layouts.app', ['title' => 'Financeiro Planos'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12 text-right">
                        <a href="{{ route('financeiro-plano.historico-recebimentos') }}" class="btn btn-success me-2">
                            <i class="ri-history-line"></i> Histórico de Recebimentos
                        </a>
                        <a href="{{ route('gerenciar-planos.sync-financeiro') }}" class="btn btn-primary">
                            <i class="ri-refresh-line"></i> Sincronizar dados de Revenda
                        </a>
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->get()
                    !!}

                    <div class="row mt-3">
                        <div class="col-md-3">
                            {!!Form::select('empresa', 'Pesquisar por empresa')
                            ->options($empresa ? [$empresa->id => $empresa->info] : [])
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::select('revenda', 'Pesquisar por revenda')
                            ->options($revenda ? [$revenda->id => $revenda->nome] : [])
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('start_date', 'Data cadastro inicial')
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('end_date', 'Data cadastro final')
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::select('status_pagamento', 'Status de pagamento', ['' => 'Selecione'] + \App\Models\FinanceiroPlano::statusDePagamentos())
                            ->attrs(['class' => 'form-select'])
                            !!}
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-2">
                            {!!Form::date('pagamento_start_date', 'Data pagamento inicial')
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('pagamento_end_date', 'Data pagamento final')
                            !!}
                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="{{ route('financeiro-plano.index') }}"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Empresa</th>
                                    <th>Revenda</th>
                                    <th>Plano</th>
                                    <th>Valor</th>
                                    <th>Valor Repasse</th>
                                    <th>Tipo de pagamento</th>
                                    <th>Data de cadastro</th>
                                    <th>Data último pagamento</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($data as $item)
                                <tr>

                                    <td>{{ $item->empresa->info }}</td>
                                    <td>{{ $item->revenda ? $item->revenda->nome : '-' }}</td>
                                    <td>{{ $item->plano->nome }}</td>
                                    <td>{{ __moeda($item->valor) }}</td>
                                    <td>{{ $item->valor_repasse ? __moeda($item->valor_repasse) : '-' }}</td>
                                    <td>
                                        {{ $item->tipo_pagamento }}
                                    </td>

                                    <td>{{ __data_pt($item->created_at, 1) }}</td>
                                    <td>
                                        @if($item->recebimentos->count() > 0)
                                            {{ __data_pt($item->recebimentos->sortByDesc('data_pagamento')->first()->data_pagamento, 0) }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->status_pagamento == 'pendente')
                                            <span class="badge bg-warning">{{ strtoupper($item->status_pagamento) }}</span>
                                        @elseif($item->status_pagamento == 'recebido')
                                            <span class="badge bg-success">{{ strtoupper($item->status_pagamento) }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ strtoupper($item->status_pagamento) }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex">
                                            @if($item->status_pagamento == 'pendente')
                                            <a href="{{ route('financeiro-plano.receber', $item->id) }}" class="btn btn-success btn-sm me-1" title="Receber Pagamento">
                                                <i class="ri-money-dollar-circle-line"></i>
                                            </a>
                                            @endif

                                            <form action="{{ route('financeiro-plano.destroy', $item->id) }}" method="post" id="form-{{$item->id}}">
                                                @method('delete')
                                                @csrf
                                                <button type="button" class="btn btn-delete btn-sm btn-danger me-1">
                                                    <i class="ri-delete-bin-line"></i>
                                                </button>

                                                <a class="btn btn-warning btn-sm" href="{{ route('financeiro-plano.edit', [$item->id]) }}">
                                                    <i class="ri-pencil-fill"></i>
                                                </a>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                        <h5>Soma recebido: <strong class="text-success">R$ {{ __moeda($somaRecebido) }}</strong></h5>
                    </div>
                    <div class="col-md-3">
                        <h5>Soma pendente: <strong class="text-warning">R$ {{ __moeda($somaPendente) }}</strong></h5>
                    </div>
                    <div class="col-md-3">
                        <h5>Soma cancelado: <strong class="text-danger">R$ {{ __moeda($somaCancelado) }}</strong></h5>
                    </div>
                    <div class="col-md-3">
                        <h5>Soma repasse: <strong class="text-primary">R$ {{ __moeda($somaRepasse) }}</strong></h5>
                    </div>
                </div>
                {!! $data->appends(request()->all())->links() !!}

            </div>
        </div>
    </div>
</div>

@endsection

