<!DOCTYPE html>
<html>
<head>
	<style type="text/css">
		.footer {
			position: fixed;
			bottom: 0px;
			padding: 0;
		}
		.footer small{
			color:grey; 
			font-size: 10px;
			text-align: left;
			margin-top: 100px !important;
		}
		body{
			width: 260px;
			margin-left: -40px;
			margin-top: -40px;
			font-family: Arial, sans-serif;
		}
		.mt-20{
			margin-top: -20px;
		}
		.mt-10{
			margin-top: -10px;
		}
		.mt-25{
			margin-top: -25px;
		}
		table th{
			font-size: 10px;
			text-align: left;
		}

		table td{
			font-size: 11px;
		}

		strong{
			color: #3B4CA7;
		}
		.section-header {
			text-align: left;
			font-size: 10px;
			font-weight: bold;
			border-top: 1px solid #000;
			padding-top: 5px;
			margin-top: 8px;
			margin-bottom: 5px;
			text-transform: uppercase;
		}
		.value-positive {
			color: #2980b9;
		}
		.value-negative {
			color: #e74c3c;
		}
		.value-neutral {
			color: #3B4CA7;
		}
		.value-warning {
			color: #ff7700;
		}
		.small-note {
			font-size: 7px;
			display: block;
			color: #777;
		}
		.company-header {
			text-align: center;
			margin-bottom: 10px;
		}
		.company-header h4 {
			margin: 0;
			padding: 0;
		}
		.report-title {
			text-align: center; 
			font-size: 12px;
			font-weight: bold;
			margin-bottom: 8px;
			text-transform: uppercase;
		}
		.item-row {
			margin-bottom: 3px;
		}
		.summary-table {
			width: 100%;
			border-collapse: collapse;
		}
		.summary-table td {
			padding: 2px 0;
		}
		.divider {
			border-top: 1px solid #ddd;
			margin: 5px 0;
		}
		.signature-area {
			margin-top: 15px;
			text-align: center;
			font-size: 9px;
		}
	</style>
</head>
<body>
	@php
	// Inicialização de variáveis para evitar erros
	$pagar = $pagar ?? collect();
	$receber = $receber ?? collect();
	$valorRecebidoTotal = $valorRecebidoTotal ?? 0;
	$somaSuprimento = $somaSuprimento ?? 0;
	$somaSangria = $somaSangria ?? 0;
	$totalCrediario = $totalCrediario ?? 0;
	$totalBoleto = $totalBoleto ?? 0;
	$totalCreditoLoja = $totalCreditoLoja ?? 0;
	$totalVendasCanceladas = $totalVendasCanceladas ?? 0;
	@endphp
	
	<div class="company-header">
		<h4 class="report-title">Relatório de Caixa</h4>
		<h5 style="margin: 0; padding: 0;">{{ $empresa->nome_fantasia }}</h5>
		<h6 style="margin: 0; padding: 0; font-size: 9px;">{{ __setMask($empresa->cpf_cnpj) }}</h6>
	</div>
	
	<table class="summary-table">
		<tr>
			<td style="width: 50%">
				<span style="font-size: 9px;">Vendas Brutas:</span><br>
				<strong class="value-positive">R$ {{ __moeda($totalVendas) }}</strong>
			</td>
			<td style="width: 50%">
				<span style="font-size: 9px;">Valor de Abertura:</span><br>
				<strong class="value-neutral">R$ {{ __moeda($item->valor_abertura) }}</strong>
			</td>
		</tr>
		<tr>
			<td>
				<span style="font-size: 9px;">Abertura:</span><br>
				<strong style="font-size: 9px;">{{ __data_pt($item->created_at) }}</strong>
			</td>
			<td>
				<span style="font-size: 9px;">Fechamento:</span><br>
				<strong style="font-size: 9px;">{{ __data_pt($item->updated_at) }}</strong>
			</td>
		</tr>
	</table>

	<div class="section-header">Pagamentos por Tipo</div>
	<table class="summary-table">
		<tbody>
			@php 
			$totalAVista = 0;
			$totalAPrazo = 0;
			@endphp
			
			@foreach($somaTiposPagamento as $key => $tp)
			@if($tp > 0)
			@php
			$aPrazo = in_array($key, ['05', '06', '15', '16']);
			if ($aPrazo) {
				$totalAPrazo += $tp;
			} else {
				$totalAVista += $tp;
			}
			@endphp
			<tr>
				<td style="width: 65%">
					<span style="font-size: 9px;">
						{{App\Models\Nfce::getTipoPagamento($key)}}
						@if($aPrazo)<small style="font-style: italic; color: #960;">(Futuro)</small>@endif
					</span>
				</td>
				<td style="width: 35%">
					<strong style="font-size: 9px; @if($aPrazo) color: #960; @else color: #090; @endif">
						R$ {{ __moeda($tp) }}
					</strong>
				</td>
			</tr>
			@endif
			@endforeach
			
			<!-- Totais à vista e a prazo -->
			<tr style="border-top: 1px solid #ccc;">
				<td style="width: 65%">
					<span style="font-size: 9px;"><strong>Total à Vista:</strong></span>
				</td>
				<td style="width: 35%">
					<strong style="font-size: 9px; color: #090;">R$ {{ __moeda($totalAVista) }}</strong>
				</td>
			</tr>
			<tr>
				<td style="width: 65%">
					<span style="font-size: 9px;"><strong>Total a Prazo:</strong></span>
				</td>
				<td style="width: 35%">
					<strong style="font-size: 9px; color: #960;">R$ {{ __moeda($totalAPrazo) }}</strong>
				</td>
			</tr>
			<tr style="border-top: 1px solid #000;">
				<td style="width: 65%">
					<span style="font-size: 9px;"><strong>Total Geral:</strong></span>
				</td>
				<td style="width: 35%">
					<strong style="font-size: 9px;">R$ {{ __moeda($totalAVista + $totalAPrazo) }}</strong>
				</td>
			</tr>
		</tbody>
	</table>

	<!-- Resumo Financeiro -->
	<div class="section-header">Resumo Financeiro</div>
	<table class="summary-table">
		<tr>
			<td style="width: 65%; padding: 3px 0;">
				<span style="font-size: 9px;"><strong>Vendas Brutas Total:</strong></span>
			</td>
			<td style="width: 35%; padding: 3px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($totalVendas) }}</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 65%; padding: 3px 0;">
				<span style="font-size: 9px;"><strong>Valor Efetivo no Caixa:</strong></span>
			</td>
			<td style="width: 35%; padding: 3px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($item->valor_abertura + $totalVendasEfetivas + ($valorRecebidoTotal ?? 0) + $somaSuprimento - $somaSangria - $pagar->sum('valor_integral')) }}</strong>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="padding: 5px 0;"></td>
		</tr>
	</table>

	<div class="section-header">Vendas</div>
	<table class="data-table" style="width: 100%;">
		@foreach($data as $i)
		@php
		$faturas = [];
		if($i->tipo != 'OS') {
			$faturas = $i->fatura ?? \App\Models\FaturaNfce::where('nfce_id', $i->id)->get();
		}
		$temPagamentoMultiplo = (!empty($faturas) && count($faturas) > 1);
		$valor = $i->tipo != 'OS' ? $i->total : $i->valor;
		
		// Calcular valores à vista e a prazo
		$valorAVista = 0;
		$valorAPrazo = 0;
		$pagamentosAgrupados = [];
		
		if ($temPagamentoMultiplo) {
			foreach ($faturas as $f) {
				$tipo = \App\Models\Nfce::getTipoPagamento($f->tipo_pagamento);
				$aPrazo = in_array($f->tipo_pagamento, ['05', '06', '15', '16']);
				
				if (!isset($pagamentosAgrupados[$tipo])) {
					$pagamentosAgrupados[$tipo] = [
						'a_prazo' => $aPrazo,
						'valor' => 0,
						'tipo_pagamento' => $f->tipo_pagamento
					];
				}
				
				$pagamentosAgrupados[$tipo]['valor'] += $f->valor;
				
				if ($aPrazo) {
					$valorAPrazo += $f->valor;
				} else {
					$valorAVista += $f->valor;
				}
			}
		} else {
			// Para pagamento único
			if ($i->tipo != 'OS') {
				// Para NFCe e NFe
				if ($i->tipo_pagamento) {
					$tipo = \App\Models\Nfce::getTipoPagamento($i->tipo_pagamento);
					$aPrazo = in_array($i->tipo_pagamento, ['05', '06', '15', '16']);
					
					$pagamentosAgrupados[$tipo] = [
						'a_prazo' => $aPrazo,
						'valor' => $valor,
						'tipo_pagamento' => $i->tipo_pagamento
					];
					
					if ($aPrazo) {
						$valorAPrazo = $valor;
					} else {
						$valorAVista = $valor;
					}
				}
			} else {
				// Para OS
				if ($i->forma_pagamento) {
					$tipo = \App\Models\Nfce::getTipoPagamento($i->forma_pagamento);
					$aPrazo = in_array($i->forma_pagamento, ['05', '06', '15', '16']);
					
					$pagamentosAgrupados[$tipo] = [
						'a_prazo' => $aPrazo,
						'valor' => $valor,
						'tipo_pagamento' => $i->forma_pagamento
					];
					
					if ($aPrazo) {
						$valorAPrazo = $valor;
					} else {
						$valorAVista = $valor;
					}
				}
			}
		}
		@endphp
		
		<tr>
			<td colspan="2" style="border-top: 1px dashed #ccc; padding-top: 5px;">
				<div style="margin: 0; padding: 0; font-size: 9px;">
					<strong>{{ $i->tipo }}</strong> | 
					<strong>ID:</strong> {{ $i->id }} |
					<strong>Status:</strong> {{ $i->estado }}
				</div>
				
				<div style="margin: 0; padding: 0; font-size: 9px;">
					<strong>Data:</strong> {{ __data_pt($i->created_at) }}
				</div>
				
				<div style="margin: 0; padding: 0; font-size: 9px; margin-bottom: 3px;">
					<strong>Cliente:</strong> {{ $i->cliente->razao_social ?? 'NÃO IDENTIFICADO' }}
				</div>
				
				<div style="font-size: 9px; margin-bottom: 3px;">
					<strong>Formas de Pagamento:</strong>
					@foreach($pagamentosAgrupados as $tipo => $info)
						<div style="margin: 1px 0;">
							<span style="background-color: {{ $info['a_prazo'] ? '#ffd' : '#dfd' }}; padding: 1px 3px; font-size: 8px;">{{ $tipo }}</span>
							<strong style="font-size: 8px;">R$ {{ __moeda($info['valor']) }}</strong>
							@if($info['a_prazo'])
								<span style="font-size: 7px; font-style: italic;">(Futuro)</span>
							@endif
						</div>
					@endforeach
				</div>
				
				<div style="display: flex; justify-content: space-between; width: 100%; font-size: 9px; margin-bottom: 2px;">
					<div>
						<strong>À Vista:</strong> 
						<span style="color: #090;">R$ {{ __moeda($valorAVista) }}</span>
					</div>
					<div>
						<strong>A Prazo:</strong> 
						<span style="color: #960;">R$ {{ __moeda($valorAPrazo) }}</span>
					</div>
				</div>
				
				<div style="text-align: right; font-size: 10px; margin-top: 2px; border-top: 1px dotted #ddd; padding-top: 2px;">
					<strong>Total:</strong> 
					<strong>R$ {{ __moeda($valor) }}</strong>
				</div>
			</td>
		</tr>
		@endforeach
	</table>

	<div class="section-header">Contas Recebidas</div>
	<table class="summary-table">
		<thead>
			<tr>
				<th style="width: 40%">
					<span style="font-size: 9px;">CLIENTE</span>
				</th>
				<th style="width: 30%">
					<span style="font-size: 9px;">PAGAMENTO</span>
				</th>
				<th style="width: 30%">
					<span style="font-size: 9px;">VALOR</span>
				</th>
			</tr>
		</thead>
		<tbody>
			@php 
				$contasRecebidas = 0; 
				$totalContasRecebidas = 0; 
				$valorRecebidoTotal = 0; 
			@endphp
			
			@foreach($contas as $conta)
				@if($conta->tipo == 'Conta Recebida')
					@php 
						$contasRecebidas++; 
						$totalContasRecebidas += $conta->valor_integral;
						$valorRecebido = ($conta->valor_recebido && $conta->valor_recebido > 0) ? $conta->valor_recebido : $conta->valor_integral;
						$valorRecebidoTotal += $valorRecebido;
					@endphp
					<tr>
						<td style="border-bottom: 1px dotted #ddd;">
							<span style="font-size: 9px;">{{ $conta->cliente->razao_social ?? 'NÃO IDENTIFICADO' }}</span>
							<br>
							<span style="font-size: 8px;">{{ __data_pt($conta->created_at) }}</span>
						</td>
						<td style="border-bottom: 1px dotted #ddd;">
							<span style="font-size: 9px;">
								@if($conta->tipo_pagamento)
									{{ \App\Models\ContaReceber::tiposPagamento()[$conta->tipo_pagamento] ?? 'Não identificado' }}
								@else
									Não informado
								@endif
							</span>
							<br>
							<span style="font-size: 8px;">
								{{ ($conta->valor_recebido > 0 && $conta->valor_recebido < $conta->valor_integral) ? 'Parcial' : 'Integral' }}
							</span>
						</td>
						<td style="border-bottom: 1px dotted #ddd;">
							<span style="font-size: 9px;">
								R$ @if($conta->valor_recebido > 0 && $conta->valor_recebido < $conta->valor_integral)
									{{ __moeda($conta->valor_recebido) }}
								@else
									{{ __moeda($conta->valor_integral) }}
								@endif
							</span>
							<br>
							<span style="font-size: 8px;">
								Total: R$ {{ __moeda($conta->valor_integral) }}
							</span>
						</td>
					</tr>
				@endif
			@endforeach
			
			@if($contasRecebidas == 0)
				<tr>
					<td colspan="3" style="text-align: center;">
						<span style="font-size: 9px;">Nenhuma conta recebida</span>
					</td>
				</tr>
			@endif
		</tbody>
	</table>
	
	@if($contasRecebidas > 0)
		<div style="display: flex; justify-content: space-between; font-size: 9px; margin-top: 5px;">
			<span>Total Integral: R$ {{ __moeda($totalContasRecebidas) }}</span>
			<span>Total Recebido: R$ {{ __moeda($valorRecebidoTotal) }}</span>
		</div>
	@endif

	<div class="section-header">Suprimentos</div>
	<table class="summary-table">
		<tbody>
			@if(sizeof($suprimentos) > 0)
			@foreach($suprimentos as $s)
			@php
			$somaSuprimento += $s->valor;
			@endphp 
			<tr>
				<td style="width: 65%">
					<span style="font-size: 9px;">{{ __data_pt($s->created_at) }}</span>
				</td>
				<td style="width: 35%">
					<strong style="font-size: 9px;">R$ {{ __moeda($s->valor) }}</strong>
				</td>
			</tr>
			@endforeach
			@else
			<tr>
				<td style="width: 65%">
					<span style="font-size: 9px;">--</span>
				</td>
				<td style="width: 35%">
					<span style="font-size: 9px;">R$ {{ __moeda(0) }}</span>
				</td>
			</tr>
			@endif
		</tbody>
	</table>

	<div class="section-header">Sangrias</div>
	<table class="summary-table">
		<tbody>
			@if(sizeof($sangrias) > 0)
			@foreach($sangrias as $s)
			@php
			$somaSangria += $s->valor;
			@endphp
			<tr>
				<td style="width: 65%">
					<span style="font-size: 9px;">{{ __data_pt($s->created_at) }}</span>
				</td>
				<td style="width: 35%">
					<strong style="font-size: 9px;">R$ {{ __moeda($s->valor) }}</strong>
				</td>
			</tr>
			@endforeach
			@else
			<tr>
				<td style="width: 65%">
					<span style="font-size: 9px;">--</span>
				</td>
				<td style="width: 35%">
					<span style="font-size: 9px;">R$ {{ __moeda(0) }}</span>
				</td>
			</tr>
			@endif
		</tbody>
	</table>

	<div class="section-header">Resumo Geral</div>
	<table class="summary-table">
		<tbody>
			<tr>
				<td style="width: 60%">
					<span style="font-size: 10px; font-weight: bold;">Vendas Brutas:</span>
					<span class="small-note">(Total de todas as vendas)</span>
				</td>
				<td style="width: 40%; text-align: right;">
					<strong class="value-positive" style="font-size: 10px;">R$ {{ __moeda($totalVendas) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 10px; font-weight: bold;">Vendas Recebidas:</span>
					<span class="small-note">(Dinheiro, Cartão, PIX, etc.)</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-positive" style="font-size: 10px;">R$ {{ __moeda($totalVendasEfetivas) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 10px; font-weight: bold;">Vendas Pendentes:</span>
					<span class="small-note">(Crediário, Boleto, Crédito Loja)</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-warning" style="font-size: 10px;">R$ {{ __moeda($totalCrediario + $totalBoleto + $totalCreditoLoja) }}</strong>
				</td>
			</tr>
			<tr style="border-top: 1px solid #ddd; margin-top: 5px;">
				<td>
					<span style="font-size: 10px; font-weight: bold;">Saldo Final em Caixa:</span>
					<span class="small-note">(Abertura + Vendas + Recebimentos + Suprimentos - Sangrias - Contas Pagas)</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-positive" style="font-size: 10px;">R$ {{ __moeda($item->valor_abertura + $totalVendasEfetivas + ($valorRecebidoTotal ?? 0) + $somaSuprimento - $somaSangria - $pagar->sum('valor_integral')) }}</strong>
				</td>
			</tr>
		</tbody>
	</table>
	
	<div class="section-header">Detalhamento Financeiro</div>
	<table class="summary-table">
		<tbody>
			<tr>
				<td style="width: 60%">
					<span style="font-size: 9px;">Valor de Abertura:</span>
					<span class="small-note">(Saldo inicial do caixa)</span>
				</td>
				<td style="width: 40%; text-align: right;">
					<strong class="value-neutral" style="font-size: 9px;">R$ {{ __moeda($item->valor_abertura) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Vendas Brutas:</span>
					<span class="small-note">(Total de todas as vendas)</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-positive" style="font-size: 9px;">R$ {{ __moeda($totalVendas) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Vendas à Vista:</span>
					<span class="small-note">(Dinheiro, Cartão, PIX, etc.)</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px; color: #090;">R$ {{ __moeda($totalVendas - $totalCrediario - $totalBoleto - $totalCreditoLoja) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Vendas a Prazo:</span>
					<span class="small-note">(Crediário, Boleto, Crédito Loja)</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px; color: #960;">R$ {{ __moeda($totalCrediario + $totalBoleto + $totalCreditoLoja) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Contas Recebidas:</span>
					<span class="small-note">(Valor efetivo recebido)</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-positive" style="font-size: 9px;">R$ {{ __moeda($valorRecebidoTotal ?? 0) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Valor Total de Contas:</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-neutral" style="font-size: 9px;">R$ {{ __moeda($receber->sum('valor_integral')) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Suprimentos:</span>
					<span class="small-note">(Entradas de dinheiro no caixa)</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-positive" style="font-size: 9px;">R$ {{ __moeda($somaSuprimento) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Sangrias:</span>
					<span class="small-note">(Saídas de dinheiro do caixa)</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-negative" style="font-size: 9px;">R$ {{ __moeda($somaSangria) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;">Contas Pagas:</span>
				</td>
				<td style="text-align: right;">
					<strong class="value-negative" style="font-size: 9px;">R$ {{ __moeda($pagar->sum('valor_integral')) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Devoluções em Dinheiro:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Devoluções em Cartão:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Devoluções em Crédito Loja:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['credito']) }}</strong>
				</td>
			</tr>
		</tbody>
	</table>
	
	<div class="section-header">Cálculo do Saldo Final</div>
	<table class="summary-table">
		<tbody>
			<tr>
				<td style="width: 60%">
					<span style="font-size: 9px;"><i>➡</i> Valor Abertura:</span>
				</td>
				<td style="width: 40%; text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($item->valor_abertura) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>+</i> Vendas à Vista:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px; color: #090;">R$ {{ __moeda($totalVendasEfetivas) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>+</i> Contas Recebidas:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($valorRecebidoTotal ?? 0) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>+</i> Suprimentos:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($somaSuprimento) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Sangrias:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($somaSangria) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Contas Pagas:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($pagar->sum('valor_integral')) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Devoluções em Dinheiro:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Devoluções em Cartão:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</strong>
				</td>
			</tr>
			<tr>
				<td>
					<span style="font-size: 9px;"><i>-</i> Devoluções em Crédito Loja:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['credito']) }}</strong>
				</td>
			</tr>
			<tr style="border-top: 1px solid #000;">
				<td>
					<span style="font-size: 9px; font-weight: bold;"><i>=</i> Saldo Final:</span>
				</td>
				<td style="text-align: right;">
					<strong style="font-size: 9px;">R$ {{ __moeda($item->valor_abertura + $totalVendasEfetivas + ($valorRecebidoTotal ?? 0) + $somaSuprimento - $somaSangria - $pagar->sum('valor_integral') - $devolucoesPorTipo['dinheiro']) }}</strong>
				</td>
			</tr>
		</tbody>
	</table>

	<div class="section-header">Movimentações de Trocas</div>
	<table class="summary-table">
		<tbody>
			@php 
			$somaDevolucoesDinheiro = 0; 
			$somaTrocasDiferenca = 0; 
			@endphp
			
			@forelse ($devolucoes->where('is_troca', true) as $troca)
				@php
				// Calcular o valor da troca (valor devolvido - diferença)
				$valorTrocado = $troca->valor_total - $troca->valor_diferenca;
				
				// Se for troca com diferença em dinheiro ou PIX, adicionar ao total
				if (($troca->tipo_pagamento == '01' || $troca->tipo_pagamento == '17') && $troca->valor_diferenca != 0) {
					if ($troca->valor_diferenca > 0) {
						// Se diferença é positiva, cliente recebeu: sai do caixa
						$somaDevolucoesDinheiro += $troca->valor_diferenca;
					} else {
						// Se diferença é negativa, cliente pagou: entra no caixa
						$somaTrocasDiferenca += abs($troca->valor_diferenca);
					}
				}
				@endphp
				<tr>
					<td colspan="2" style="border-top: 1px dashed #ccc; padding-top: 4px;">
						<div style="font-size: 9px; margin-bottom: 2px;">
							<strong>ID:</strong> {{ $troca->id }} | 
							<strong>Cliente:</strong> {{ $troca->cliente ? $troca->cliente->razao_social : 'NÃO IDENTIFICADO' }}
						</div>
						<div style="font-size: 9px; margin-bottom: 2px;">
							<strong>Data:</strong> {{ __data_pt($troca->data_devolucao) }} | 
							<strong>Pagamento:</strong> {{ App\Models\Nfce::getTipoPagamento($troca->tipo_pagamento) }}
						</div>
						<div style="display: flex; justify-content: space-between; width: 100%; font-size: 9px; margin-bottom: 2px;">
							<div>
								<strong>Valor Devolvido:</strong> 
								<span>R$ {{ __moeda($troca->valor_total) }}</span>
							</div>
							<div>
								<strong>Valor Trocado:</strong> 
								<span>R$ {{ __moeda($valorTrocado) }}</span>
							</div>
						</div>
						@if($troca->valor_diferenca != 0)
							<div style="text-align: right; font-size: 9px; margin-top: 2px; border-top: 1px dotted #ddd; padding-top: 2px;">
								<strong>Diferença:</strong> 
								<strong style="{{ $troca->valor_diferenca > 0 ? 'color: #d00;' : 'color: #090;' }}">
									R$ {{ __moeda(abs($troca->valor_diferenca)) }}
									@if($troca->valor_diferenca > 0)
										<small>(Cliente recebeu)</small>
									@else
										<small>(Cliente pagou)</small>
									@endif
								</strong>
							</div>
						@endif
					</td>
				</tr>
			@empty
				<tr>
					<td colspan="2" style="text-align: center; font-size: 9px; padding: 5px 0;">
						Nenhuma troca registrada neste caixa.
					</td>
				</tr>
			@endforelse
			
			@if($devolucoes->where('is_troca', true)->count() > 0)
				<tr>
					<td style="width: 65%; border-top: 1px solid #000; padding-top: 3px;">
						<span style="font-size: 9px;"><strong>Total de Saídas:</strong></span>
					</td>
					<td style="width: 35%; border-top: 1px solid #000; padding-top: 3px;">
						<strong style="font-size: 9px; color: #d00;">R$ {{ __moeda($somaDevolucoesDinheiro) }}</strong>
					</td>
				</tr>
				<tr>
					<td style="width: 65%;">
						<span style="font-size: 9px;"><strong>Total de Entradas:</strong></span>
					</td>
					<td style="width: 35%;">
						<strong style="font-size: 9px; color: #090;">R$ {{ __moeda($somaTrocasDiferenca) }}</strong>
					</td>
				</tr>
			@endif
		</tbody>
	</table>

	<div class="section-header">Movimentações de Devoluções</div>
	<table class="summary-table">
		<tbody>
			@php $totalDevolucoesSimples = 0; @endphp
			@forelse ($devolucoes->where('is_troca', false) as $devolucao)
				@php $totalDevolucoesSimples += $devolucao->valor_total; @endphp
				<tr>
					<td colspan="2" style="border-top: 1px dashed #ccc; padding-top: 4px;">
						<div style="font-size: 9px; margin-bottom: 2px;">
							<strong>ID:</strong> {{ $devolucao->id }} | 
							<strong>Tipo:</strong> {{ strtoupper($devolucao->tipo_venda) }}
						</div>
						<div style="font-size: 9px; margin-bottom: 2px;">
							<strong>Cliente:</strong> {{ $devolucao->cliente ? $devolucao->cliente->razao_social : 'NÃO IDENTIFICADO' }}
						</div>
						<div style="font-size: 9px; margin-bottom: 2px;">
							<strong>Data:</strong> {{ __data_pt($devolucao->data_devolucao) }} | 
							<strong>Pagamento:</strong> {{ App\Models\Nfce::getTipoPagamento($devolucao->tipo_pagamento) }}
						</div>
						<div style="text-align: right; font-size: 10px; margin-top: 2px; border-top: 1px dotted #ddd; padding-top: 2px;">
							<strong>Total:</strong> 
							<strong>R$ {{ __moeda($devolucao->valor_total) }}</strong>
						</div>
					</td>
				</tr>
			@empty
				<tr>
					<td colspan="2" style="text-align: center; font-size: 9px; padding: 5px 0;">
						Nenhuma devolução registrada neste caixa.
					</td>
				</tr>
			@endforelse
			
			@if($devolucoes->where('is_troca', false)->count() > 0)
				<tr>
					<td style="width: 65%; border-top: 1px solid #000; padding-top: 3px;">
						<span style="font-size: 9px;"><strong>Total de Devoluções:</strong></span>
					</td>
					<td style="width: 35%; border-top: 1px solid #000; padding-top: 3px;">
						<strong style="font-size: 9px;">R$ {{ __moeda($totalDevolucoesSimples) }}</strong>
					</td>
				</tr>
			@endif
		</tbody>
	</table>

	<div class="section-header">Contas Recebidas</div>
	<table class="summary-table">
		<thead>
			<tr>
				<th style="width: 40%">
					<span style="font-size: 9px;">CLIENTE</span>
				</th>
				<th style="width: 30%">
					<span style="font-size: 9px;">PAGAMENTO</span>
				</th>
				<th style="width: 30%">
					<span style="font-size: 9px;">VALOR</span>
				</th>
			</tr>
		</thead>
		<tbody>
			@php 
				$contasRecebidas = 0; 
				$totalContasRecebidas = 0; 
				$valorRecebidoTotal = 0; 
			@endphp
			
			@foreach($contas as $conta)
				@if($conta->tipo == 'Conta Recebida')
					@php 
						$contasRecebidas++; 
						$totalContasRecebidas += $conta->valor_integral;
						$valorRecebido = ($conta->valor_recebido && $conta->valor_recebido > 0) ? $conta->valor_recebido : $conta->valor_integral;
						$valorRecebidoTotal += $valorRecebido;
					@endphp
					<tr>
						<td style="border-bottom: 1px dotted #ddd;">
							<span style="font-size: 9px;">{{ $conta->cliente->razao_social ?? 'NÃO IDENTIFICADO' }}</span>
							<br>
							<span style="font-size: 8px;">{{ __data_pt($conta->created_at) }}</span>
						</td>
						<td style="border-bottom: 1px dotted #ddd;">
							<span style="font-size: 9px;">
								@if($conta->tipo_pagamento)
									{{ \App\Models\ContaReceber::tiposPagamento()[$conta->tipo_pagamento] ?? 'Não identificado' }}
								@else
									Não informado
								@endif
							</span>
							<br>
							<span style="font-size: 8px;">
								{{ ($conta->valor_recebido > 0 && $conta->valor_recebido < $conta->valor_integral) ? 'Parcial' : 'Integral' }}
							</span>
						</td>
						<td style="border-bottom: 1px dotted #ddd;">
							<span style="font-size: 9px;">
								R$ @if($conta->valor_recebido > 0 && $conta->valor_recebido < $conta->valor_integral)
									{{ __moeda($conta->valor_recebido) }}
								@else
									{{ __moeda($conta->valor_integral) }}
								@endif
							</span>
							<br>
							<span style="font-size: 8px;">
								Total: R$ {{ __moeda($conta->valor_integral) }}
							</span>
						</td>
					</tr>
				@endif
			@endforeach
			
			@if($contasRecebidas == 0)
				<tr>
					<td colspan="3" style="text-align: center;">
						<span style="font-size: 9px;">Nenhuma conta recebida</span>
					</td>
				</tr>
			@endif
		</tbody>
	</table>
	
	@if($contasRecebidas > 0)
		<div style="display: flex; justify-content: space-between; font-size: 9px; margin-top: 5px;">
			<span>Total Integral: R$ {{ __moeda($totalContasRecebidas) }}</span>
			<span>Total Recebido: R$ {{ __moeda($valorRecebidoTotal) }}</span>
		</div>
	@endif

	<div class="section-header">Devoluções</div>
	<table class="summary-table">
		<tr>
			<td style="width: 65%; padding: 3px 0;">
				<span style="font-size: 9px;"><strong>Dinheiro:</strong></span>
			</td>
			<td style="width: 35%; padding: 3px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 65%; padding: 3px 0;">
				<span style="font-size: 9px;"><strong>Cartão:</strong></span>
			</td>
			<td style="width: 35%; padding: 3px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 65%; padding: 3px 0;">
				<span style="font-size: 9px;"><strong>Crédito Loja:</strong></span>
			</td>
			<td style="width: 35%; padding: 3px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['credito']) }}</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 65%; padding: 3px 0;">
				<span style="font-size: 9px;"><strong>PIX:</strong></span>
			</td>
			<td style="width: 35%; padding: 3px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($devolucoesPorTipo['pix']) }}</strong>
			</td>
		</tr>
		<tr style="border-top: 1px solid #000;">
			<td style="width: 65%; padding: 3px 0;">
				<span style="font-size: 9px;"><strong>Total Devoluções:</strong></span>
			</td>
			<td style="width: 35%; padding: 3px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($totalDevolucoes) }}</strong>
			</td>
		</tr>
	</table>

	<div class="section-header">Saldo Final em Caixa</div>
	<table class="summary-table">
		<tr>
			<td style="width: 65%; padding: 4px 0;">
				<span style="font-size: 9px;"><strong>Valor em Caixa:</strong></span>
			</td>
			<td style="width: 35%; padding: 4px 0;">
				<strong style="font-size: 9px;">R$ {{ __moeda($item->valor_abertura + $totalVendasEfetivas + ($valorRecebidoTotal ?? 0) + $somaSuprimento - $somaSangria - $pagar->sum('valor_integral') - $devolucoesPorTipo['dinheiro'] - $devolucoesPorTipo['pix']) }}</strong>
			</td>
		</tr>
	</table>

	<div class="signature-area">
		<div style="margin-bottom: 5px; padding-top: 10px; border-top: 1px solid #000;">
			{{$usuario->name}}
		</div>
		<div>
			{{ date('d/m/Y H:i') }}
		</div>
	</div>
</body>
</html>
