var DESCONTO = 0;
var VALORACRESCIMO = 0;
var PERCENTUALMAXDESCONTO = false;
var CONFIRMAITENS = false

// Funções beepErro e beepSucesso para evitar erro caso não estejam definidas
if (typeof beepErro !== 'function') {
    function beepErro() {}
}
if (typeof beepSucesso !== 'function') {
    function beepSucesso() {}
}

// Aguardar o jQuery estar disponível
if (typeof jQuery !== 'undefined') {
    $(function () {
        // validaButtonSave()
        $("#lista_id").val('')
        
        // Validar botão de formas de pagamento na inicialização
        validaButtonFormasPagamento();
    });
} else {
    console.error('jQuery não está disponível no pre_venda.js');
}

if (typeof jQuery !== 'undefined') {
    $("#inp-tipo_pagamento").change(() => {
        validaButtonSave()
    })

    $("#inp-produto_id").select2({
    minimumInputLength: 2,
    language: "pt-BR",
    placeholder: "Digite para buscar o produto",
    width: "100%",
    theme: "bootstrap4",
    ajax: {
        cache: true,
        url: path_url + "api/produtos",
        dataType: "json",
        data: function (params) {
            let empresa_id = $('#empresa_id').val()
            console.clear();
            var query = {
                pesquisa: params.term,
                lista_id: $('#lista_id').val(),
                empresa_id: empresa_id,
                usuario_id: $('#usuario_id').val(),
            };
            return query;
        },
        processResults: function (response) {
            var results = [];
            let compra = 0
            if($('#is_compra') && $('#is_compra').val() == 1){
                compra = 1
            }

            $.each(response, function (i, v) {
                var o = {};
                o.id = v.id;
                if(v.codigo_variacao){
                    o.codigo_variacao = v.codigo_variacao
                }

                o.text = v.nome

                if(parseFloat(v.valor_unitario) > 0){
                    o.text += ' R$ ' + convertFloatToMoeda(v.valor_unitario);
                }

                if(v.codigo_barras){
                    o.text += ' [' + v.codigo_barras  + ']';
                }
                o.value = v.id;
                // console.log(o)
                results.push(o);
            });
            return {
                results: results,
            };
        },
    },
});

function validaButtonSave() {
    $('#salvar_pre_venda').attr("disabled", 1)
    $('#btn_formas_pagamento').attr("disabled", 1)

    var tipo = $('#inp-tipo_pagamento').val()
    var tipo_row = $('#inp-tipo_pagamento_row').val()

    if (tipo != null) {

        if (tipo != '01') {
            $('#salvar_pre_venda').removeAttr("disabled")
        }
        else {
            $('#salvar_pre_venda').removeAttr("disabled")
        }
    }
    
    // Habilitar botão de formas de pagamento se houver itens
    if ($('.table-itens tbody tr').length > 0) {
        $('#btn_formas_pagamento').removeAttr("disabled")
    }
}

// Função para validar botão de formas de pagamento
function validaButtonFormasPagamento() {
    if ($('.table-itens tbody tr').length > 0) {
        $('#btn_formas_pagamento').removeAttr("disabled")
    } else {
        $('#btn_formas_pagamento').attr("disabled", 1)
    }
}

function finalizar(id) {
    $('#finalizar_pre_venda').modal('show')
    $.get(path_url + 'api/pre-venda/finalizar/' + id)
    .done((res) => {
        $('#finalizar_pre_venda .modal-body').html(res)
        setTimeout(() => {
            calcTotalFatura()
            CONFIRMAITENS = $('#confirma-itens').val()
            validaItens()
        }, 200)
    })
    .fail((e) => {
        console.log(e)
    })
}

function validaItens(){
    if(CONFIRMAITENS == 1){
        $('.btn-sbm').attr('disabled', 1)
        $('.mensagem-itens').html('* Confirme todos os itens para finalizar')
    }
    setTimeout(() => {
        $('.btn-sbm').removeAttr('disabled')

        $('.line_status').each(function () {
            if($(this).val() == 0){
                $('.btn-sbm').attr('disabled', 1)
            }
        })
    }, 20)

    // setTimeout(() => {
    //     $('#inp-codigo_barras').focus()
    // }, 500)
}


$('body').on('blur', '.valor_parcela', function () {
    calcTotalFatura()
})

// $(document).on("click", ".btn-delete-linha", function () {
//     $(this).closest("tr").remove();
//     swal("Sucesso", "Parcela removida!", "success");
//     calcTotalFatura()
// });

function calcTotalFatura() {
    var total = 0
    $(".valor_parcela").each(function () {
        total += convertMoedaToFloat($(this).val())
    })
    setTimeout(() => {
        total_fatura = total
        $('.total_parcelas').html("R$ " + convertFloatToMoeda(total))
    }, 100)
}

$(document).off("keyup", "#codBarras");
$(document).on("keyup", "#codBarras", function (e) {
    if (e.key === 'Enter' || e.keyCode === 13) {
        let barcode = $(this).val().trim();
        if(barcode) {
            processarCodigoBarrasPreVenda(barcode);
        }
    }
});

$(document).on("blur", "#inp-codigo_barras", function (e) {

    encontraItemCodigoBarras($(this).val())
})

function encontraItemCodigoBarras(codigo){
    $('.line_codigo_barras').each(function () {
        if($(this).val() == codigo){
            $status = $(this).prev()
            $btn = $(this).next()
            $status.val(1)
            $btn.addClass('disabled')
            $nome = $(this).closest("tr").find('.produto_nome')
            $nome.addClass('text-success')
            
        }
    })
    setTimeout(() => {
        $('#inp-codigo_barras').val('')
        validaItens()
    }, 50)
}

$(document).on("click", ".confirma-item", function () {
    $codigoBarra = $(this).prev()
    $status = $(this).prev().prev()
    $id = $(this).prev().prev().prev()
    $status.val(1)
    $(this).addClass('disabled')
    $nome = $(this).closest("tr").find('.produto_nome')
    $nome.addClass('text-success')
    validaItens()
})

$(document).on("click", ".btn-add-tr", function () {
    var $table = $(this)
    .closest(".row")
    .prev()
    .find(".table-dynamic");
    var hasEmpty = false;
    $table.find("input, select").each(function () {
        if (($(this).val() == "" || $(this).val() == null) && $(this).attr("type") != "hidden" && $(this).attr("type") != "file" && !$(this).hasClass("ignore")) {
            hasEmpty = true;
        }
    });
    if (hasEmpty) {
        Swal.fire(
            "Atenção",
            "Preencha todos os campos antes de adicionar novos.",
            "warning"
            );
        return;
    }
    var $tr = $table.find(".dynamic-form").first();
    $tr.find("select.select2").select2("destroy");
    var $clone = $tr.clone();
    $clone.show();
    $clone.find("input,select").val("");
    $table.append($clone);
    setTimeout(function () {
        $("tbody select.select2").select2({
            language: "pt-BR",
            width: "100%",
            theme: "bootstrap4"
        });
    }, 100);


})

$(document).on("click", '#gerar_nfe', function () {
    let fatura = getFaturas()
    gerarNFe(fatura)
})

$(document).on("click", '#gerar_nfce', function () {
    let fatura = getFaturas()
    gerarNFCe(fatura)
})

$(document).on("click", '.finalizar_pre_venda', function () {
    let fatura = getFaturas()
    gerarVenda(fatura)
})

function getFaturas() {
    let data = []
    $('.tipo_pagamento').each(function () {
        let tipo = $(this).val()
        let vencimento = $(this).closest('td').next().find('input').val()
        let valor = $(this).closest('td').next().next().find('input').val()
        let js = {
            tipo: tipo,
            vencimento: vencimento,
            valor: valor,
        }
        data.push(js)
    })
    return data
}

function gerarNFe(fatura) {

    $.post(path_url + "api/nfe/gerarNfe", {
        pre_venda_id: $('#pre_venda_id').val(),
        conta_receber: $('#inp-gerar_conta_receber').val(),
        fatura: fatura,
        empresa_id: $('#empresa_id').val(),
        usuario_id: $('#usuario_id').val()
    })
    .done((success) => {
        transmitir(success)
    })
    .fail((err) => {
        console.log(err)
    })
}

function gerarNFCe(fatura) {
    $.post(path_url + "api/nfce/gerarNfce", {
        pre_venda_id: $('#pre_venda_id').val(),
        conta_receber: $('#inp-gerar_conta_receber').val(),
        fatura: fatura,
        empresa_id: $('#empresa_id').val(),
        usuario_id: $('#usuario_id').val()
    })
    .done((success) => {
        transmitirNfce(success)
    })
    .fail((err) => {
        console.log(err)
    })
}

function gerarVenda(fatura) {

    $.post(path_url + "api/nfce/gerarVenda", {
        pre_venda_id: $('#pre_venda_id').val(),
        conta_receber: $('#inp-gerar_conta_receber').val(),
        fatura: fatura,
        empresa_id: $('#empresa_id').val(),
    })
    .done((success) => {
        Swal.fire({
            title: "Sucesso",
            text: "Venda finalizada com sucesso, deseja imprimir o comprovante?",
            icon: "success",
            buttons: true,
            buttons: ["Não", "Sim"],
            dangerMode: true,
        }).then((isConfirm) => {
            if (isConfirm) {
                window.open(path_url + 'frontbox/imprimir-nao-fiscal/' + success, "_blank")
                location.reload()
            } else {
                location.reload()
            }
        });
    })
    .fail((err) => {
        console.log(err)
        Swal.fire("Erro", err.responseJSON, "error")
    })
}

function transmitir(id) {
    console.clear()
    $.post(path_url + "api/nfe_painel/emitir", {
        id: id,
    })
    .done((success) => {
        Swal.fire("Sucesso", "NFe emitida " + success.recibo + " - chave: [" + success.chave + "]", "success")
        .then(() => {
            window.open(path_url + 'nfe/imprimir/' + id, "_blank")
            setTimeout(() => {
                location.reload()
            }, 100)
        })
    })
    .fail((err) => {
        try {
            if (err.responseJSON.error) {
                let o = err.responseJSON.error.protNFe.infProt
                Swal.fire("Algo deu errado", o.cStat + " - " + o.xMotivo, "error")
                .then(() => {
                    location.reload()
                })
            } else {
                Swal.fire("Algo deu errado", err[0], "error")
            }
        } catch {
            try {
                Swal.fire("Algo deu errado", err.responseJSON, "error")
                .then(() => {
                    location.reload()
                })
            } catch {
                Swal.fire("Algo deu errado", err.responseJSON[0], "error")
                .then(() => {
                    location.reload()
                })
            }
        }

    })
}

function transmitirNfce(id) {
    console.clear()
    $.post(path_url + "api/nfce_painel/emitir", {
        id: id,
    })
    .done((success) => {
        Swal.fire("Sucesso", "NFCe emitida " + success.recibo + " - chave: [" + success.chave + "]", "success")
        .then(() => {
            window.open(path_url + 'nfce/imprimir/' + id, "_blank")
            setTimeout(() => {
                location.reload()
            }, 100)
        })
    })
    .fail((err) => {
        console.log(err)

        Swal.fire("Algo deu errado", err.responseJSON, "error")

    })
}


// --- INÍCIO: Lógica de busca igual ao PDV ---

function processarCodigoBarrasPreVenda(barcode) {
    // Se o código começar com 2 e for de balança, pode implementar lógica similar se necessário
    // Aqui, vamos direto para buscarPorCodigoBarrasPreVenda
    buscarPorCodigoBarrasPreVenda(barcode);
}

function buscarPorCodigoBarrasPreVenda(barcode) {
    $('#codBarras').val('');
    $('#codBarras').focus();
    let loadingToast = toastr.info(
        '<i class="ri-loader-4-line fa-spin"></i> Buscando produto...',
        '',
        {
            timeOut: 0,
            extendedTimeOut: 0,
            closeButton: false,
            progressBar: true,
            positionClass: "toast-top-right"
        }
    );
    $.get(path_url + "api/produtos/findByBarcode", {
        barcode: barcode,
        empresa_id: $('#empresa_id').val(),
        lista_id: $('#lista_id').val(),
        usuario_id: $('#usuario_id').val()
    })
    .done((data) => {
        toastr.clear(loadingToast);
        if (data.id) {
            let qtd = 1;
            adicionarProdutoDiretamentePreVenda(data, qtd);
            toastr.success(
                data.nome,
                '',
                {
                    timeOut: 3000,
                    positionClass: "toast-top-right",
                    progressBar: true,
                    closeButton: false
                }
            );
        } else {
            beepErro && beepErro();
            toastr.error('Produto não encontrado', '', {
                timeOut: 3000,
                positionClass: "toast-top-right"
            });
            buscarPorReferenciaPreVenda(barcode);
        }
    })
    .fail((error) => {
        toastr.clear(loadingToast);
        console.error(error);
        beepErro && beepErro();
        toastr.error('Erro ao buscar produto', '', {
            timeOut: 3000,
            positionClass: "toast-top-right"
        });
        buscarPorReferenciaPreVenda(barcode);
    });
}

function adicionarProdutoDiretamentePreVenda(produto, qtd) {
    if (produto && produto.valor_unitario) {
        let valorUnitario = parseFloat(produto.valor_unitario);
        let quantidade = parseFloat(qtd);
        let subTotal = parseFloat((quantidade * valorUnitario).toFixed(2));
        let dataRequest = {
            qtd: quantidade,
            value_unit: valorUnitario,
            sub_total: subTotal,
            product_id: produto.id,
            variacao_id: produto.codigo_variacao || null,
            local_id: $('#local_id').val(),
            lista_id: $('#lista_id').val(),
            usuario_id: $('#usuario_id').val(),
        };
        $.get(path_url + "api/frenteCaixa/linhaProdutoVenda", dataRequest)
        .done((e) => {
            if (e === false) {
                beepErro && beepErro();
                Swal.fire("Atenção", "Produto com estoque insuficiente!", "warning");
            } else {
                let novaLinha = $(e);
                $(".table-itens tbody").append(novaLinha);
                novaLinha.css('background-color', '#d4edda');
                setTimeout(() => {
                    novaLinha.css('transition', 'background-color 1s ease');
                    novaLinha.css('background-color', '');
                }, 100);
                beepSucesso && beepSucesso();
                
                // Debug da nova linha adicionada
                console.log('Nova linha adicionada:', novaLinha.html());
                
                // Aguardar um pouco para garantir que o DOM foi atualizado
                setTimeout(() => {
                    calcSubTotal(); // Recalcula os subtotais primeiro
                    calcTotal(); // Depois calcula o total
                    debugTabelaPreVenda(); // Debug para verificar se tudo está correto
                }, 100);
                
                limparCamposProdutoPreVenda(); // Limpa os campos após adicionar
                
                // Notifica o usuário sobre o controle de estoque
                if (produto.gerenciar_estoque) {
                    toastr.info(`Produto "${produto.nome}" adicionado à pré-venda. Estoque debitado automaticamente.`, '', {
                        timeOut: 3000,
                        positionClass: "toast-top-right",
                        progressBar: true,
                        closeButton: false
                    });
                }
            }
            setTimeout(() => {
                $('#codBarras').focus();
            }, 100);
        })
        .fail((e) => {
            console.log(e);
            beepErro && beepErro();
            Swal.fire("Atenção", e.responseJSON || "Erro ao adicionar produto", "warning");
        });
    } else {
        beepErro && beepErro();
        Swal.fire("Erro", "Produto não encontrado ou sem preço definido", "error");
    }
}

function buscarPorReferenciaPreVenda(barcode) {
    $.get(path_url + "api/produtos/findByReferencia", {
        referencia: barcode,
        empresa_id: $('#empresa_id').val(),
        lista_id: $('#lista_id').val(),
        usuario_id: $('#usuario_id').val()
    })
    .done((data) => {
        if (data.id) {
            let qtd = 1;
            adicionarProdutoDiretamentePreVenda(data, qtd);
            toastr.success(data.nome, '', {
                timeOut: 3000,
                positionClass: "toast-top-right",
                progressBar: true,
                closeButton: false
            });
        } else {
            toastr.error('Produto não encontrado', '', {
                timeOut: 3000,
                positionClass: "toast-top-right"
            });
        }
    })
    .fail((error) => {
        console.error(error);
        toastr.error('Erro ao buscar produto', '', {
            timeOut: 3000,
            positionClass: "toast-top-right"
        });
    });
}

// Evento Enter no campo de busca
$(document).off("keyup", "#codBarras");
$(document).on("keyup", "#codBarras", function (e) {
    if (e.key === 'Enter' || e.keyCode === 13) {
        let barcode = $(this).val().trim();
        if(barcode) {
            processarCodigoBarrasPreVenda(barcode);
        }
    }
});

// Evento clique no botão Adicionar
// Função original removida - agora usa a validação melhorada abaixo

function adicionarLinhaItemPreVenda(produto) {
    // Usar a função que faz o controle de estoque corretamente
    var qtd = $('#inp-quantidade').val() || '1,00';
    adicionarProdutoDiretamentePreVenda(produto, qtd);
}

// Após adicionar produto, limpar campos auxiliares
function limparCamposProdutoPreVenda() {
    $('#inp-valor_unitario').val('');
    $('#inp-quantidade').val('');
    $('#inp-subtotal').val('');
    $('#inp-total').val('');
    $('#codBarras').val('').trigger('change'); // Limpa select2/autocomplete
    $('#inp-produto_id').val('').trigger('change'); // Limpa campo hidden se existir
}

// --- FIM: Lógica de busca igual ao PDV ---

// Validação melhorada para pré-venda - verifica se há produto selecionado no Select2
$(document).on("click", ".btn-add-item", function () {
    // Verifica se há produto selecionado no Select2
    var selected = $('#codBarras').select2('data')[0];
    var barcode = $('#codBarras').val().trim();
    
    // Validação detalhada dos campos obrigatórios
    let camposFaltando = [];
    
    // Verifica se há produto selecionado
    if (!selected || !selected.id) {
        if (!barcode || barcode.length === 0) {
            camposFaltando.push("Produto");
            $("#codBarras").addClass('is-invalid');
            $("#produto-error").show();
        }
    } else {
        $("#codBarras").removeClass('is-invalid');
        $("#produto-error").hide();
    }
    
    // Verifica quantidade
    let qtd = $("#inp-quantidade").val();
    qtd = convertMoedaToFloat(qtd);
    if (!qtd || qtd <= 0) {
        camposFaltando.push("Quantidade");
        $("#inp-quantidade").addClass('is-invalid');
        $("#quantidade-error").show();
    } else {
        $("#inp-quantidade").removeClass('is-invalid');
        $("#quantidade-error").hide();
    }
    
    // Verifica valor unitário
    let value_unit = $("#inp-valor_unitario").val();
    value_unit = convertMoedaToFloat(value_unit);
    if (!value_unit || value_unit <= 0) {
        camposFaltando.push("Valor Unitário");
        $("#inp-valor_unitario").addClass('is-invalid');
        $("#valor-error").show();
    } else {
        $("#inp-valor_unitario").removeClass('is-invalid');
        $("#valor-error").hide();
    }
    
    // Se há campos faltando, mostra a mensagem
    if (camposFaltando.length > 0) {
        let mensagem = "Os seguintes campos são obrigatórios:\n\n";
        camposFaltando.forEach(function(campo, index) {
            mensagem += "• " + campo + "\n";
        });
        mensagem += "\nPor favor, preencha todos os campos para continuar.";
        
        Swal.fire({
            title: "Campos Obrigatórios",
            text: mensagem,
            icon: "warning",
            confirmButtonText: "Entendi",
            confirmButtonColor: "#3085d6"
        });
        
        // Remove as classes de erro após 3 segundos
        setTimeout(() => {
            $("#inp-quantidade, #inp-valor_unitario, #codBarras").removeClass('is-invalid');
            $("#quantidade-error, #valor-error, #produto-error").hide();
        }, 3000);
        
        return;
    }
    
    // Se chegou até aqui, todos os campos estão preenchidos
    // Usa a lógica original da pré-venda
    if (selected && selected.id) {
        // Buscar dados completos do produto selecionado
        $.get(path_url + "api/produtos/find", {
            produto_id: selected.id,
            usuario_id: $('#usuario_id').val(),
            empresa_id: $('#empresa_id').val(),
            lista_id: $('#lista_id').val()
        })
        .done(function(produto) {
            if (produto && produto.id) {
                adicionarLinhaItemPreVenda(produto);
                
                // Validar botão de formas de pagamento
                validaButtonFormasPagamento();
                
                // Feedback visual de sucesso
                Swal.fire({
                    title: "Sucesso!",
                    text: "Item adicionado com sucesso!",
                    icon: "success",
                    timer: 1500,
                    showConfirmButton: false
                });
            } else {
                Swal.fire('Atenção', 'Produto não encontrado!', 'warning');
            }
        });
    } else if (barcode && barcode.length > 0 && /^\d+$/.test(barcode)) {
        // Buscar por código de barras
        $.get(path_url + "api/produtos/findByBarcode", {
            barcode: barcode,
            empresa_id: $('#empresa_id').val(),
            lista_id: $('#lista_id').val(),
            usuario_id: $('#usuario_id').val()
        })
        .done(function(produto) {
            if (produto && produto.id) {
                adicionarLinhaItemPreVenda(produto);
                
                // Validar botão de formas de pagamento
                validaButtonFormasPagamento();
                
                // Feedback visual de sucesso
                Swal.fire({
                    title: "Sucesso!",
                    text: "Item adicionado com sucesso!",
                    icon: "success",
                    timer: 1500,
                    showConfirmButton: false
                });
            } else {
                Swal.fire('Atenção', 'Produto não encontrado pelo código de barras!', 'warning');
            }
        });
    }
});

function validaCaixa() {
    let abertura = $('#abertura').val()
    if (!abertura) {
        $('#modal-abrir_caixa').modal('show')
        return
    }
}


$("body").on("click", "#btn-incrementa", function () {
    let inp = $(this).closest('div.input-group-append').prev()[0]
    if (inp.value) {
        let v = convertMoedaToFloat(inp.value)
        v += 1
        inp.value = convertFloatToMoeda(v)
        calcSubTotal()
    }
})

$("body").on("click", "#btn-subtrai", function () {
    let inp = $(this).closest('.input-group').find('input')[0]
    if (inp.value) {
        let v = convertMoedaToFloat(inp.value)
        v -= 1
        inp.value = convertFloatToMoeda(v)

        calcSubTotal()
    }
})

// Eventos para recalcular quando quantidade ou valor unitário mudam
$(document).on('input', '.qtd, .qtd_row, input[name="quantidade[]"]', function() {
    console.log('Quantidade alterada, recalculando...');
    calcSubTotal();
});

$(document).on('input', '.value-unit, input[name="valor_unitario[]"]', function() {
    console.log('Valor unitário alterado, recalculando...');
    calcSubTotal();
});

// Evento para quando o campo de quantidade na área de busca muda
$(document).on('input', '#inp-quantidade', function() {
    let qtd = convertMoedaToFloat($(this).val());
    let valor = convertMoedaToFloat($('#inp-valor_unitario').val());
    let subtotal = qtd * valor;
    $('#inp-subtotal').val(convertFloatToMoeda(subtotal));
    console.log('Subtotal da área de busca atualizado:', convertFloatToMoeda(subtotal));
});

// Evento para quando o valor unitário na área de busca muda
$(document).on('input', '#inp-valor_unitario', function() {
    let qtd = convertMoedaToFloat($('#inp-quantidade').val());
    let valor = convertMoedaToFloat($(this).val());
    let subtotal = qtd * valor;
    $('#inp-subtotal').val(convertFloatToMoeda(subtotal));
    console.log('Subtotal da área de busca atualizado:', convertFloatToMoeda(subtotal));
});

// Função de debug para verificar a estrutura da tabela
function debugTabelaPreVenda() {
    // console.log('=== DEBUG TABELA PRÉ-VENDA ===');
    // console.log('Número de linhas:', $('.line-product').length);
    
    $('.line-product').each(function(index) {
        // console.log(`--- Linha ${index + 1} ---`);
        // console.log('HTML da linha:', $(this).html());
        
        let qtd = $(this).find('.qtd, .qtd_row, input[name="quantidade[]"]');
        let value = $(this).find('.value-unit, input[name="valor_unitario[]"]');
        let sub = $(this).find('.subtotal-item, input[name="subtotal_item[]"]');
        
        // console.log('Elementos encontrados:', {
        //     qtd: qtd.length > 0 ? qtd.val() : 'NÃO ENCONTRADO',
        //     value: value.length > 0 ? value.val() : 'NÃO ENCONTRADO',
        //     sub: sub.length > 0 ? sub.val() : 'NÃO ENCONTRADO'
        // });
    });
    
    console.log('=== FIM DEBUG ===');
}

// Chamar debug quando a página carregar
$(document).ready(function() {
    setTimeout(function() {
        debugTabelaPreVenda();
    }, 1000);
    
    // Interceptar o clique no botão Cancelar da pré-venda
    $(document).on('click', 'a[href*="pre-venda.index"]', function(e) {
        e.preventDefault();
        
        // Verificar se há itens na tabela
        let numeroItens = $('.line-product').length;
        
        if (numeroItens > 0) {
            // Há itens, mostrar confirmação
            Swal.fire({
                title: "Cancelar Pré-Venda?",
                text: `Existem ${numeroItens} item(s) na pré-venda. Deseja realmente cancelar? O estoque será restaurado automaticamente.`,
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Sim, cancelar!",
                cancelButtonText: "Não, continuar editando"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Mostrar loading
                    Swal.fire({
                        title: "Restaurando estoque...",
                        text: "Aguarde enquanto restauramos o estoque dos produtos.",
                        icon: "info",
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        showConfirmButton: false
                    });
                    
                    // Usuário confirmou, restaurar estoque e cancelar
                    restaurarEstoqueTodosItensPreVenda().then(() => {
                        // Após restaurar o estoque, mostrar sucesso e redirecionar
                        Swal.fire({
                            title: "Pré-Venda Cancelada!",
                            text: "O estoque foi restaurado com sucesso.",
                            icon: "success",
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = $(e.target).attr('href');
                        });
                    }).catch((error) => {
                        console.error('Erro ao restaurar estoque:', error);
                        // Mesmo com erro, mostrar mensagem e redirecionar
                        Swal.fire({
                            title: "Atenção",
                            text: "A pré-venda foi cancelada, mas houve um erro ao restaurar o estoque. Verifique o estoque manualmente.",
                            icon: "warning",
                            confirmButtonText: "OK"
                        }).then(() => {
                            window.location.href = $(e.target).attr('href');
                        });
                    });
                }
            });
        } else {
            // Não há itens, cancelar diretamente
            window.location.href = $(this).attr('href');
        }
    });
});



$(".btn-delete-prevenda").on("click", function (e) {
    e.preventDefault();
    var form = $(this).parents("form").attr("id");
    swal({      
        title: "Você está certo?",
        text: "Uma vez excluida, esta pré-venda não poderá ser restaurada!",
        icon: "warning",
        closeOnClickOutside: false,
        closeOnEsc: false,
        buttons: true,
        buttons: ["Voltar", "Excluir"],
        dangerMode: true,
    }).then((isConfirm) => {
        if (isConfirm) {
            document.getElementById(form).submit();
        } else {
            swal("", "A pré-venda não foi excluida!", "info");
        }
    });
});

// Função de exclusão melhorada com controle de estoque
$(document).on('click', '.btn-delete-row', function (e) {
    e.preventDefault();
    e.stopPropagation();
    
    let linha = $(this).closest('tr');
    let produtoNome = linha.find('td:eq(1)').text().trim();
    let produto_id = linha.find('.produto_row').val();
    let quantidade = linha.find('.qtd, .qtd_row, input[name="quantidade[]"]').val();
    quantidade = parseFloat(quantidade);
    if (isNaN(quantidade) || quantidade <= 0) quantidade = 1;
    let variacao_id = linha.find('input[name="variacao_id[]"]').val();
    let local_id = $('#local_id').val();
    
    Swal.fire({
        title: "Confirmar Exclusão",
        text: `Deseja realmente remover "${produtoNome}" da pré-venda? O estoque será restaurado automaticamente.`,
        icon: "warning",
        allowOutsideClick: false,
        showCancelButton: true,
        confirmButtonColor: "#d33",
        cancelButtonColor: "#3085d6",
        confirmButtonText: "Sim, remover!",
        cancelButtonText: "Cancelar"
    }).then((result) => {
        if (result.isConfirmed) {
            // Restaurar o estoque antes de remover o item
            $.post(path_url + 'api/frenteCaixa/restaurar-estoque', {
                produto_id: produto_id,
                quantidade: quantidade,
                variacao_id: variacao_id,
                local_id: local_id
            }).done(function(data) {
                // Remove a linha da tabela
                linha.fadeOut(300, function() {
                    $(this).remove();
                    
                    // Aguardar um pouco para garantir que o DOM foi atualizado
                    setTimeout(() => {
                        // Recalcula os subtotais e o total
                        calcSubTotal();
                        calcTotal();
                        debugTabelaPreVenda(); // Debug para verificar se tudo está correto
                        
                        // Validar botão de formas de pagamento
                        validaButtonFormasPagamento();
                    }, 100);
                    
                    // Mostra mensagem de sucesso
                    Swal.fire({
                        title: "Removido!",
                        text: "Produto removido e estoque restaurado!",
                        icon: "success",
                        timer: 1500,
                        showConfirmButton: false
                    });
                });
            }).fail(function(xhr) {
                Swal.fire("Erro", "Erro ao restaurar estoque: " + xhr.responseText, "error");
            });
        }
    });
});


function calcSubTotal(e) {
    console.log('=== INÍCIO CALCSUBTOTAL ===');
    console.log('Número de linhas encontradas:', $(".line-product").length);
    
    // Teste simples primeiro
    if ($(".line-product").length === 0) {
        console.log('Nenhuma linha encontrada!');
        return;
    }
    
    $(".line-product").each(function (index) {
        console.log('--- Processando linha', index + 1, '---');
        
        // Buscar elementos - usar múltiplos seletores para garantir compatibilidade
        let $qtd = $(this).find('.qtd, .qtd_row, input[name="quantidade[]"]');
        let $value = $(this).find('.value-unit, input[name="valor_unitario[]"]');
        let $sub = $(this).find('.subtotal-item, input[name="subtotal_item[]"]');
        
        console.log('Elementos encontrados:', {
            qtd: $qtd.length > 0 ? 'SIM' : 'NÃO',
            value: $value.length > 0 ? 'SIM' : 'NÃO',
            sub: $sub.length > 0 ? 'SIM' : 'NÃO'
        });
        
        if ($qtd.length > 0 && $value.length > 0 && $sub.length > 0) {
            let qtdValor = $qtd.val();
            let valueValor = $value.val();
            
            console.log('Valores originais:', {
                qtd: qtdValor,
                value: valueValor
            });
            
            let qtd = convertMoedaToFloat(qtdValor);
            let value = convertMoedaToFloat(valueValor);
            
            console.log('Valores convertidos:', {
                qtd: qtd,
                value: value
            });
            
            if (qtd <= 0) {
                console.log('Quantidade <= 0, removendo linha');
                $(this).remove();
            } else {
                let subtotal = parseFloat((qtd * value).toFixed(2));
                let subtotalFormatado = convertFloatToMoeda(subtotal);
                
                console.log('Cálculo:', {
                    qtd: qtd,
                    value: value,
                    subtotal: subtotal,
                    subtotalFormatado: subtotalFormatado
                });
                
                $sub.val(subtotalFormatado);
                console.log('Subtotal definido na linha', index + 1, ':', subtotalFormatado);
            }
        } else {
            console.error('Campos não encontrados na linha', index + 1);
            console.log('HTML da linha:', $(this).html());
        }
    });
    
    console.log('=== FIM CALCSUBTOTAL ===');
    
    setTimeout(() => {
        calcTotal();
    }, 10);
}

function setaDesconto() {
    if (total_venda == 0) {
        Swal.fire("Erro", "Total da venda é igual a zero", "warning");
    } else {
        Swal.fire({
            title: "Valor desconto?",
            text: "Ultilize ponto(.) ao invés de virgula!",
            content: "input",
            button: {
                text: "Ok",
                closeModal: false,
                type: "error",
            },
        }).then((v) => {
            if (v) {
                let desconto = v;
                if (desconto.substring(0, 1) == "%") {
                    let perc = desconto.substring(1, desconto.length);
                    DESCONTO = TOTAL * (perc / 100);
                    if (PERCENTUALMAXDESCONTO > 0) {
                        if (perc > PERCENTUALMAXDESCONTO) {
                            Swal.close();
                            setTimeout(() => {
                                Swal.fire(
                                    "Erro",
                                    "Máximo de desconto permitido é de " +
                                    PERCENTUALMAXDESCONTO +
                                    "%",
                                    "error"
                                    );
                                $("#valor_desconto").html("0,00");
                            }, 500);
                        }
                    }
                    if (DESCONTO > 0) {
                        $("#valor_item").attr("disabled", "disabled");
                        $(".btn-mini-desconto").attr(
                            "disabled",
                            "disabled"
                            );
                    } else {
                        $("#valor_item").removeAttr("disabled");
                        $(".btn-mini-desconto").removeAttr("disabled");
                    }
                } else {
                    desconto = desconto.replace(",", ".");
                    DESCONTO = parseFloat(desconto);
                    if (PERCENTUALMAXDESCONTO > 0) {
                        let tempDesc =
                        (TOTAL * PERCENTUALMAXDESCONTO) / 100;
                        if (tempDesc < DESCONTO) {
                            Swal.close();

                            setTimeout(() => {
                                Swal.fire(
                                    "Erro",
                                    "Máximo de desconto permitido é de R$ " +
                                    parseFloat(tempDesc),
                                    "error"
                                    );
                                $("#valor_desconto").html("0,00");
                            }, 500);
                        }
                    }
                    if (DESCONTO > 0) {
                        $("#valor_item").attr("disabled", "disabled");
                        $(".btn-mini-desconto").attr(
                            "disabled",
                            "disabled"
                            );
                    } else {
                        $("#valor_item").removeAttr("disabled");
                        $(".btn-mini-desconto").removeAttr("disabled");
                    }
                }
                if (desconto.length == 0) DESCONTO = 0;
                $("#valor_desconto").html(convertFloatToMoeda(DESCONTO));
                $("#inp-valor_desconto").val(convertFloatToMoeda(DESCONTO));
                calcTotal();
            }
            Swal.close();
            $("#codBarras").focus();
        });
    }
}

function setaAcrescimo() {
    if (total_venda == 0) {
        Swal.fire("Erro", "Total da venda é igual a zero", "warning");
    } else {
        Swal.fire({
            title: "Valor acrescimo?",
            text: "Ultilize ponto(.) ao invés de virgula!",
            content: "input",
            button: {
                text: "Ok",
                closeModal: false,
                type: "error",
            },
        }).then((v) => {
            if (v) {
                let acrescimo = v;
                if (acrescimo > 0) {
                    DESCONTO = 0;
                    $("#valor_desconto").html(convertFloatToMoeda(DESCONTO));
                }
                let total = total_venda;
                if (acrescimo.substring(0, 1) == "%") {
                    let perc = acrescimo.substring(1, acrescimo.length);
                    VALORACRESCIMO = total * (perc / 100);
                } else {
                    acrescimo = acrescimo.replace(",", ".");
                    VALORACRESCIMO = parseFloat(acrescimo);
                }
                if (acrescimo.length == 0) VALORACRESCIMO = 0;
                VALORACRESCIMO = parseFloat(VALORACRESCIMO);
                $("#valor_acrescimo").html(convertFloatToMoeda(VALORACRESCIMO));
                $("#inp-valor_acrescimo").val(convertFloatToMoeda(VALORACRESCIMO));
                calcTotal();
                $("#codBarras").focus();
            }
            Swal.close();
        });
    }
}

$("#cliente select").each(function () {
    let id = $(this).prop("id");
    if (id == "inp-cliente_id") {
        $(this).select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar o cliente",
            width: "100%",
            theme: "bootstrap4",
            dropdownParent: $(this).parent(),
            ajax: {
                cache: true,
                url: path_url + "api/clientes/pesquisa",
                dataType: "json",
                data: function (params) {
                    console.clear();
                    var query = {
                        pesquisa: params.term,
                        empresa_id: $("#empresa_id").val(),
                    };
                    return query;
                },
                processResults: function (response) {

                    var results = [];
                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;

                        o.text = v.razao_social + " - " + v.cpf_cnpj;
                        o.value = v.id;
                        results.push(o);
                        $('.cliente_selecionado').html(o.text);

                    });
                    return {
                        results: results,
                    };
                },
            },
        });
    }
});

var total_venda = 0;
var VALORACRESCIMO = 0;
var DESCONTO = 0;

function calcTotal() {
    console.log('=== INÍCIO CALCTOTAL ===');
    console.log('Número de subtotais encontrados:', $(".subtotal-item").length);
    var total = 0;
    
    $(".subtotal-item").each(function (index) {
        let valorOriginal = $(this).val();
        let valor = convertMoedaToFloat(valorOriginal);
        total += valor;
        console.log('Subtotal item', index + 1, ':', {
            valorOriginal: valorOriginal,
            valorConvertido: valor,
            totalAcumulado: total
        });
    });
    
    setTimeout(() => {
        total_venda = total;
        
        // Garantir que as variáveis existam
        if (typeof VALORACRESCIMO === 'undefined') VALORACRESCIMO = 0;
        if (typeof DESCONTO === 'undefined') DESCONTO = 0;
        
        let valorFinal = total + parseFloat(VALORACRESCIMO) - parseFloat(DESCONTO);
        
        console.log('Cálculo final:', {
            total: total,
            acrescimo: VALORACRESCIMO,
            desconto: DESCONTO,
            valorFinal: valorFinal
        });
        
        // Atualizar o TOTAL (soma dos subtotais dos itens)
        $(".total-venda").html(convertFloatToMoeda(total));
        $('#inp-valor_total').val(convertFloatToMoeda(total));
        
        // Atualizar o SUBTOTAL na pré-venda - procurar pela estrutura correta
        $('.total-item').each(function() {
            let label = $(this).find('.total-label').text().trim();
            if (label === 'SUBTOTAL') {
                $(this).find('.total-value').html('R$ ' + convertFloatToMoeda(valorFinal));
                console.log('Subtotal atualizado:', 'R$ ' + convertFloatToMoeda(valorFinal));
            }
        });
        
        // Atualizar também o campo de input do subtotal se existir
        $('#inp-subtotal').val(convertFloatToMoeda(valorFinal));
        
        // Atualizar outros elementos se necessário
        $(".total-venda-modal").html(convertFloatToMoeda(valorFinal));
        $('#inp-valor_integral').val(convertFloatToMoeda(valorFinal));

        $('#inp-quantidade').val('')
        $('#inp-valor_unitario').val('')
        $('#inp-produto_id').val('').change()
        
        console.log('=== FIM CALCTOTAL ===');
    }, 100);
}

$(function () {
    let data = new Date
    let dataFormatada = (data.getFullYear() + "-" + adicionaZero((data.getMonth() + 1)) + "-" + adicionaZero(data.getDate()));
    $('.data_atual').val(dataFormatada)
})
function adicionaZero(numero) {
    if (numero <= 9)
        return "0" + numero;
    else
        return numero;
}


$(".btn-add-payment").click(() => {
    let tipo_pagamento_row = $("#inp-tipo_pagamento_row").val();
    let vencimento = $("#inp-data_vencimento_row").val();
    let valor_integral_row = $("#inp-valor_row").val();
    let obs_row = $("#inp-observacao_row").val();

    validaButtonSave();

    let v = convertMoedaToFloat(valor_integral_row);

    if (v + total_payment <= total_venda) {
        if (vencimento && valor_integral_row && tipo_pagamento_row) {
            let dataRequest = {
                data_vencimento_row: vencimento,
                valor_integral_row: valor_integral_row,
                obs_row: obs_row,
                tipo_pagamento_row: tipo_pagamento_row,
            };

            $.get(path_url + "api/frenteCaixa/linhaParcelaVenda", dataRequest)
            .done((e) => {
                $(".table-payment tbody").append(e);
                calcTotalPayment();

            })
            .fail((e) => {
                console.log(e);
            });
        } else {
            Swal.fire(
                "Atenção",
                "Informe corretamente os campos para continuar!",
                "warning"
                );
        }
    } else {
        Swal.fire(
            "Atenção",
            "A soma das parcelas não bate com o valor total da venda",
            "warning"
            );
    }
});

var total_payment = 0;
function calcTotalPayment() {
    $('#btn-pag_row').attr("disabled", true)

    var total = 0;
    $(".valor_integral").each(function () {
        total += convertMoedaToFloat($(this).val());
    });
    setTimeout(() => {
        total_payment = total;
        $(".sum-payment").html("R$ " + convertFloatToMoeda(total));

        $(".sum-restante").html("R$ " + convertFloatToMoeda(total_venda - total));
    }, 100);

    let dif = total_venda - total;

    let diferenca = dif.toFixed(2);

    if (diferenca <= 10) {
        $("#btn-pag_row").removeAttr("disabled")
    }
}


// $(".table-payment").on("click", ".btn-delete-row", function () {
//     $(this).closest("tr").remove();
//     swal("Sucesso", "Parcela removida!", "success");
//     calcTotalPayment();
// });

// Função conflitante removida - agora usa a função melhorada acima

$('.funcionario-venda').click(() => {
    let funcionario_id = $('#inp-funcionario_id').val()
    $.get(path_url + "api/funcionarios/find/", {id: funcionario_id})
    .done((e) => {
        $('.funcionario_selecionado').text(e.nome)
    })
    .fail((e) => {
        console.log(e);
    });
})

$(".modal-funcioario select").each(function () {

    let id = $(this).prop("id");

    if (id == "inp-funcionario_id") {

        $(this).select2({
            minimumInputLength: 2,
            language: "pt-BR",
            placeholder: "Digite para buscar o funcionário",
            theme: "bootstrap4",
            dropdownParent: $(this).parent(),
            ajax: {
                cache: true,
                url: path_url + "api/funcionarios/pesquisa",
                dataType: "json",
                data: function (params) {
                    console.clear();
                    var query = {
                        pesquisa: params.term,
                        empresa_id: $("#empresa_id").val(),
                    };
                    return query;
                },
                processResults: function (response) {
                    var results = [];

                    $.each(response, function (i, v) {
                        var o = {};
                        o.id = v.id;

                        o.text = v.nome;
                        o.value = v.id;
                        results.push(o);
                    });
                    return {
                        results: results,
                    };
                },
            },
        });
    }
});
}

// Inicialização do select2 para busca dinâmica de produtos
$(function() {
    $('#codBarras').select2({
        minimumInputLength: 2,
        language: "pt-BR",
        placeholder: "Digite para buscar o produto",
        width: "100%",
        theme: "bootstrap4",
        ajax: {
            cache: true,
            url: path_url + "api/produtos",
            dataType: "json",
            data: function (params) {
                return {
                    pesquisa: params.term,
                    lista_id: $('#lista_id').val(),
                    empresa_id: $('#empresa_id').val(),
                    usuario_id: $('#usuario_id').val(),
                };
            },
            processResults: function (response) {
                var results = [];
                $.each(response, function (i, v) {
                    results.push({
                        id: v.id,
                        text: v.nome + (v.codigo_barras ? ' [' + v.codigo_barras + ']' : ''),
                        codigo_variacao: v.codigo_variacao
                    });
                });
                return { results: results };
            }
        }
    });
});

$(document).on('submit', '#form-pre-venda', function(e) {
    let ok = true;
    let msg = '';
    // Verifica se há pelo menos um produto
    if ($('input[name="produto_id[]"]').length === 0) {
        ok = false;
        msg = 'Adicione pelo menos um produto à pré-venda!';
    }
    // Verifica se todos os campos obrigatórios dos itens estão preenchidos corretamente
    $('input[name="produto_id[]"], input[name="quantidade[]"], input[name="valor_unitario[]"]').each(function() {
        if (!$(this).val() || $(this).val() === '0' || $(this).val() === '0,00') {
            ok = false;
            msg = 'Todos os itens devem ter produto, quantidade e valor preenchidos!';
        }
    });
    // Não validar desconto/acréscimo por item, pois são campos da pré-venda
    if (!ok) {
        e.preventDefault();
        Swal.fire('Atenção', msg, 'warning');
        return false;
    }
});

$('#codBarras').on('select2:select', function (e) {
    var data = e.params.data;
    if (data && data.id) {
        // Busca o valor unitário via AJAX
        $.get(path_url + "api/produtos/find", {
            produto_id: data.id,
            usuario_id: $('#usuario_id').val(),
            empresa_id: $('#empresa_id').val(),
            lista_id: $('#lista_id').val()
        })
        .done(function(produto) {
            if (produto && produto.valor_unitario) {
                $('#inp-valor_unitario').val(convertFloatToMoeda(produto.valor_unitario));
            } else {
                $('#inp-valor_unitario').val('');
            }
            $('#inp-quantidade').val('1,00');
            // Atualiza subtotal e total
            let valor = convertMoedaToFloat($('#inp-valor_unitario').val());
            let qtd = convertMoedaToFloat($('#inp-quantidade').val());
            $('#inp-subtotal').val(convertFloatToMoeda(qtd * valor));
            $('#inp-total').val(convertFloatToMoeda(qtd * valor));
        });
    } else {
        $('#inp-valor_unitario').val('');
        $('#inp-quantidade').val('1,00');
        $('#inp-subtotal').val('');
        $('#inp-total').val('');
    }
});

$('#inp-quantidade').on('input', function() {
    let valor = convertMoedaToFloat($('#inp-valor_unitario').val());
    let qtd = convertMoedaToFloat($(this).val());
    $('#inp-subtotal').val(convertFloatToMoeda(qtd * valor));
    $('#inp-total').val(convertFloatToMoeda(qtd * valor));
});

// Função para validar campos em tempo real
function validarCamposTempoReal() {
    // Remove classes de erro quando o usuário começa a digitar
    $("#inp-quantidade, #inp-valor_unitario, #codBarras").on('input change', function() {
        $(this).removeClass('is-invalid');
        // Oculta mensagens de erro específicas
        if ($(this).attr('id') === 'inp-quantidade') {
            $("#quantidade-error").hide();
        } else if ($(this).attr('id') === 'inp-valor_unitario') {
            $("#valor-error").hide();
        } else if ($(this).attr('id') === 'codBarras') {
            $("#produto-error").hide();
        }
    });
    
    // Valida quantidade
    $("#inp-quantidade").on('blur', function() {
        let valor = $(this).val();
        if (!valor || convertMoedaToFloat(valor) <= 0) {
            $(this).addClass('is-invalid');
            $(this).attr('title', 'Quantidade deve ser maior que zero');
            $("#quantidade-error").show();
        } else {
            $(this).removeClass('is-invalid');
            $(this).removeAttr('title');
            $("#quantidade-error").hide();
        }
    });
    
    // Valida valor unitário
    $("#inp-valor_unitario").on('blur', function() {
        let valor = $(this).val();
        if (!valor || convertMoedaToFloat(valor) <= 0) {
            $(this).addClass('is-invalid');
            $(this).attr('title', 'Valor unitário deve ser maior que zero');
            $("#valor-error").show();
        } else {
            $(this).removeClass('is-invalid');
            $(this).removeAttr('title');
            $("#valor-error").hide();
        }
    });
    
    // Valida produto selecionado
    $("#codBarras").on('change', function() {
        let valor = $(this).val();
        if (!valor) {
            $(this).addClass('is-invalid');
            $(this).attr('title', 'Selecione um produto');
            $("#produto-error").show();
        } else {
            $(this).removeClass('is-invalid');
            $(this).removeAttr('title');
            $("#produto-error").hide();
        }
    });
}

// Função para mostrar dicas de preenchimento
function mostrarDicasPreenchimento() {
    // Adiciona tooltips informativos
    $("#inp-quantidade").attr('data-toggle', 'tooltip').attr('data-placement', 'top').attr('title', 'Digite a quantidade do produto');
    $("#inp-valor_unitario").attr('data-toggle', 'tooltip').attr('data-placement', 'top').attr('title', 'Digite o valor unitário do produto');
    $("#codBarras").attr('data-toggle', 'tooltip').attr('data-placement', 'top').attr('title', 'Selecione ou digite o código do produto');
    
    // Inicializa tooltips
    $('[data-toggle="tooltip"]').tooltip();
}

// Inicializa as validações quando o documento estiver pronto
$(document).ready(function() {
    validarCamposTempoReal();
    mostrarDicasPreenchimento();
    
    // Calcular subtotais e total inicial se houver itens na tabela
    if ($(".line-product").length > 0) {
        console.log('Página carregada com itens. Calculando subtotais iniciais...');
        setTimeout(() => {
            calcSubTotal();
        }, 500); // Aguardar um pouco para garantir que tudo carregou
    }
});

// Atalho de teclado para excluir item selecionado (Ctrl + Del)
$(document).on('keydown', function(e) {
    if (e.ctrlKey && e.key === 'Delete') {
        e.preventDefault();
        
        // Verifica se há uma linha selecionada
        let linhaSelecionada = $('.table-itens tbody tr.selected');
        if (linhaSelecionada.length > 0) {
            linhaSelecionada.find('.btn-delete-row').trigger('click');
        } else {
            // Se não há linha selecionada, pergunta qual excluir
            let linhas = $('.table-itens tbody tr');
            if (linhas.length > 0) {
                Swal.fire({
                    title: "Selecionar Item",
                    text: "Nenhum item selecionado. Clique em um item da tabela para selecioná-lo antes de usar Ctrl + Del.",
                    icon: "info",
                    confirmButtonText: "Entendi"
                });
            } else {
                Swal.fire({
                    title: "Nenhum Item",
                    text: "Não há itens na tabela para excluir.",
                    icon: "info",
                    confirmButtonText: "OK"
                });
            }
        }
    }
    
    // Remover o atalho de teclado F4 para cancelar pré-venda
});

// Seleção de linha na tabela
$(".table-itens").on('click', 'tbody tr', function() {
    $('.table-itens tbody tr').removeClass('selected');
    $(this).addClass('selected');
});

// Remove seleção ao clicar fora da tabela
$(document).on('click', function(e) {
    if (!$(e.target).closest('.table-itens').length) {
        $('.table-itens tbody tr').removeClass('selected');
    }
});

// Eventos de exclusão configurados

// Evento para recalcular subtotais quando quantidade ou valor unitário é alterado
$(document).on('input change', '.qtd, .value-unit', function() {
    calcSubTotal();
});

// Função para restaurar estoque de todos os itens da pré-venda
function restaurarEstoqueTodosItensPreVenda() {
    console.log('=== INÍCIO RESTAURAR ESTOQUE TODOS ITENS ===');
    
    var itens = $('.line-product');
    var promises = [];
    var itensRestaurados = 0;
    
    console.log('Número de itens encontrados:', itens.length);
    
    if (itens.length === 0) {
        console.log('Nenhum item encontrado para restaurar estoque');
        return Promise.resolve();
    }
    
    itens.each(function(index) {
        var row = $(this);
        var produto_id = row.find('.produto_row').val();
        var quantidade = row.find('.qtd, .qtd_row, input[name="quantidade[]"]').val();
        quantidade = parseFloat(quantidade);
        if (isNaN(quantidade) || quantidade <= 0) quantidade = 1;
        var variacao_id = row.find('input[name="variacao_id[]"]').val();
        var local_id = $('#local_id').val();
        var produtoNome = row.find('td:eq(1)').text().trim();
        
        console.log(`Item ${index + 1}:`, {
            produto_id: produto_id,
            quantidade: quantidade,
            variacao_id: variacao_id,
            local_id: local_id,
            produtoNome: produtoNome
        });
        
        if (produto_id && quantidade) {
            var promise = $.post(path_url + 'api/frenteCaixa/restaurar-estoque', {
                produto_id: produto_id,
                quantidade: quantidade,
                variacao_id: variacao_id,
                local_id: local_id
            }).then(function(response) {
                itensRestaurados++;
                console.log(`Estoque restaurado para ${produtoNome}:`, response);
                return response;
            }).catch(function(error) {
                console.error(`Erro ao restaurar estoque para ${produtoNome}:`, error);
                throw error;
            });
            
            promises.push(promise);
        } else {
            console.warn(`Item ${index + 1} sem produto_id ou quantidade válida`);
        }
    });
    
    console.log('Total de promises criadas:', promises.length);
    
    return Promise.all(promises).then(function(results) {
        console.log('=== FIM RESTAURAR ESTOQUE TODOS ITENS ===');
        console.log('Itens restaurados com sucesso:', itensRestaurados);
        return results;
    }).catch(function(error) {
        console.error('Erro ao restaurar estoque:', error);
        throw error;
    });
}

// Capturar clique no botão "Nova Pré-Venda" para restaurar estoque
$(document).on('click', 'a[href*="pre-venda.create"]', function(e) {
    e.preventDefault();
    var href = $(this).attr('href');
    
    // Verificar se há itens na pré-venda
    if ($('.line-product').length > 0) {
        Swal.fire({
            title: "Nova Pré-Venda",
            text: "Deseja cancelar a pré-venda atual e iniciar uma nova? O estoque será restaurado.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Sim, Nova Pré-Venda",
            cancelButtonText: "Cancelar"
        }).then((result) => {
            if (result.isConfirmed) {
                // Mostrar loading
                Swal.fire({
                    title: "Restaurando estoque...",
                    text: "Aguarde enquanto restauramos o estoque dos produtos.",
                    icon: "info",
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    showConfirmButton: false
                });
                
                // Restaurar estoque de todos os itens
                restaurarEstoqueTodosItensPreVenda().then(function() {
                    Swal.close();
                    // Redirecionar para nova pré-venda
                    window.location.href = href;
                }).catch(function(error) {
                    Swal.close();
                    Swal.fire("Erro", "Erro ao restaurar estoque: " + error, "error");
                });
            }
        });
    } else {
        // Se não há itens, redirecionar diretamente
        window.location.href = href;
    }
});

// Evento universal para qualquer botão/link "Cancelar" na pré-venda
$(document).on('click', 'a,button', function(e) {
    // Só executa se o texto do botão contiver "cancelar" (ignorando maiúsculas/minúsculas)
    if ($(this).text().toLowerCase().includes('cancelar')) {
        // Evita conflito com outros cancelamentos fora da pré-venda
        if (!$('.pre-venda-container').length) return;

        console.log('Clique detectado no botão Cancelar da pré-venda!', this);
        e.preventDefault();
        let href = $(this).attr('href') || $(this).data('href') || window.location.origin + '/pre-venda';
        let numeroItens = $('.line-product').length;

        if (numeroItens > 0) {
            Swal.fire({
                title: "Cancelar Pré-Venda?",
                text: `Existem ${numeroItens} item(s) na pré-venda. Deseja realmente cancelar? O estoque será restaurado automaticamente.`,
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Sim, cancelar!",
                cancelButtonText: "Não, continuar editando"
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Restaurando estoque...",
                        text: "Aguarde enquanto restauramos o estoque dos produtos.",
                        icon: "info",
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        showConfirmButton: false
                    });
                    restaurarEstoqueTodosItensPreVenda().then(() => {
                        Swal.fire({
                            title: "Pré-Venda Cancelada!",
                            text: "O estoque foi restaurado com sucesso.",
                            icon: "success",
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = href;
                        });
                    }).catch((error) => {
                        console.error('Erro ao restaurar estoque:', error);
                        Swal.fire({
                            title: "Atenção",
                            text: "A pré-venda foi cancelada, mas houve um erro ao restaurar o estoque. Verifique o estoque manualmente.",
                            icon: "warning",
                            confirmButtonText: "OK"
                        }).then(() => {
                            window.location.href = href;
                        });
                    });
                }
            });
        } else {
            window.location.href = href;
        }
    }
});
