<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDevolucaoFieldsToNfcesNfes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('nfces', function (Blueprint $table) {
            $table->decimal('valor_devolvido', 10, 2)->default(0)->comment('Valor total de devoluções');
            $table->tinyInteger('tem_devolucao')->default(0)->comment('1=Tem devolução, 0=Não tem');
        });
        
        Schema::table('nves', function (Blueprint $table) {
            $table->decimal('valor_devolvido', 10, 2)->default(0)->comment('Valor total de devoluções');
            $table->tinyInteger('tem_devolucao')->default(0)->comment('1=Tem devolução, 0=Não tem');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('nfces', function (Blueprint $table) {
            $table->dropColumn('valor_devolvido');
            $table->dropColumn('tem_devolucao');
        });
        
        Schema::table('nves', function (Blueprint $table) {
            $table->dropColumn('valor_devolvido');
            $table->dropColumn('tem_devolucao');
        });
    }
} 