<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Adicionar novas permissões
        $permissions = [
            'devolucao_venda_view' => 'Visualizar devolução/troca de vendas',
            'devolucao_venda_create' => 'Criar devolução/troca de vendas',
            'devolucao_venda_edit' => 'Editar devolução/troca de vendas',
            'devolucao_venda_delete' => 'Excluir devolução/troca de vendas',
        ];

        foreach ($permissions as $name => $display_name) {
            Permission::create([
                'name' => $name,
                'guard_name' => 'web',
                'display_name' => $display_name
            ]);
        }

        // Adicionar permissões ao papel/role de administrador
        $adminRoleId = DB::table('roles')->where('name', 'admin')->value('id');
        
        if ($adminRoleId) {
            $permissionIds = DB::table('permissions')
                ->whereIn('name', array_keys($permissions))
                ->pluck('id');
            
            foreach ($permissionIds as $permissionId) {
                DB::table('role_has_permissions')->insert([
                    'permission_id' => $permissionId,
                    'role_id' => $adminRoleId,
                ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remover permissões
        $permissions = [
            'devolucao_venda_view',
            'devolucao_venda_create',
            'devolucao_venda_edit',
            'devolucao_venda_delete',
        ];

        foreach ($permissions as $name) {
            $permission = Permission::where('name', $name)->first();
            if ($permission) {
                $permission->delete();
            }
        }
    }
}; 