<?php

namespace App\Observers;

use App\Models\TaxaPagamento;
use App\Models\TaxaHistorico;
use Illuminate\Support\Facades\Auth;

class TaxaPagamentoHistoricoObserver
{
    /**
     * Handle the TaxaPagamento "updating" event.
     *
     * @param  \App\Models\TaxaPagamento  $taxaPagamento
     * @return void
     */
    public function updating(TaxaPagamento $taxaPagamento)
    {
        // Apenas registrar no histórico se a taxa foi alterada
        if ($taxaPagamento->isDirty('taxa')) {
            TaxaHistorico::create([
                'empresa_id' => $taxaPagamento->empresa_id,
                'taxa_pagamento_id' => $taxaPagamento->id,
                'taxa_anterior' => $taxaPagamento->getOriginal('taxa'),
                'taxa_nova' => $taxaPagamento->taxa,
                'tipo_pagamento' => $taxaPagamento->tipo_pagamento,
                'bandeira_cartao' => $taxaPagamento->bandeira_cartao,
                'usuario_id' => Auth::id()
            ]);
        }
    }

    /**
     * Handle the TaxaPagamento "created" event.
     *
     * @param  \App\Models\TaxaPagamento  $taxaPagamento
     * @return void
     */
    public function created(TaxaPagamento $taxaPagamento)
    {
        // Registra a criação de uma nova taxa
        TaxaHistorico::create([
            'empresa_id' => $taxaPagamento->empresa_id,
            'taxa_pagamento_id' => $taxaPagamento->id,
            'taxa_anterior' => null, // Não há taxa anterior por ser uma nova configuração
            'taxa_nova' => $taxaPagamento->taxa,
            'tipo_pagamento' => $taxaPagamento->tipo_pagamento,
            'bandeira_cartao' => $taxaPagamento->bandeira_cartao,
            'usuario_id' => Auth::id()
        ]);
    }
} 