<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CentroCusto extends Model
{
    use HasFactory;

    protected $table = 'centro_custos';

    protected $fillable = [
        'nome',
        'codigo',
        'descricao',
        'empresa_id',
        'pai_id',
        'ativo'
    ];

    public function contasPagar()
    {
        return $this->hasMany(ContaPagar::class, 'centro_custo_id');
    }

    public function contasReceber()
    {
        return $this->hasMany(ContaReceber::class, 'centro_custo_id');
    }

    public function alocacoes()
    {
        return $this->hasMany(AlocacaoCentroCusto::class, 'centro_custo_id');
    }

    public function pai()
    {
        return $this->belongsTo(CentroCusto::class, 'pai_id');
    }

    public function filhos()
    {
        return $this->hasMany(CentroCusto::class, 'pai_id');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }
} 