@extends('layouts.app', ['title' => 'Histórico de Taxas de Pagamento'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12 d-flex justify-content-between align-items-center">
                    <h4 class="card-title">Histórico de Alterações em Taxas de Pagamento</h4>
                    <a href="{{ route('taxa-cartao.index') }}" class="btn btn-secondary">
                        <i class="ri-arrow-left-line"></i>
                        Voltar
                    </a>
                </div>
                <hr class="mt-3">
                <div class="col-md-12 mt-3">
                    <div class="alert alert-info">
                        <i class="ri-information-line me-2"></i>
                        Este relatório mostra todas as alterações feitas nas taxas de pagamento, incluindo quem fez a alteração e quando.
                    </div>
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Data</th>
                                    <th>Tipo Pagamento</th>
                                    <th>Bandeira</th>
                                    <th>Taxa Anterior</th>
                                    <th>Nova Taxa</th>
                                    <th>Alterado por</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($historico as $item)
                                <tr>
                                    <td>{{ $item->created_at->format('d/m/Y H:i:s') }}</td>
                                    <td>{{ $item->getTipoPagamentoNome() }}</td>
                                    <td>{{ $item->getBandeiraNome() }}</td>
                                    <td>
                                        @if($item->taxa_anterior === null)
                                            <span class="badge bg-primary">Nova Taxa</span>
                                        @else
                                            {{ __moeda($item->taxa_anterior) }}%
                                        @endif
                                    </td>
                                    <td>{{ __moeda($item->taxa_nova) }}%</td>
                                    <td>{{ $item->usuario ? $item->usuario->name : 'Sistema' }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">Nenhum histórico encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="mt-4">
                    {!! $historico->appends(request()->all())->links() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 