@extends('relatorios.default', ['title' => 'Relatório de Vendas por Forma de Pagamento'])

@section('css')
<style type="text/css">
    .period-filter {
        background: #eef2f7;
        border-left: 4px solid #3366cc;
        padding: 6px 10px;
        margin-bottom: 8px;
        font-size: 9px;
        font-weight: bold;
        color: #2c3e50;
    }

    .alert-warning {
        background: #fff3cd;
        color: #856404;
        padding: 6px 10px;
        margin-bottom: 10px;
        border-left: 3px solid #ffc107;
        font-size: 8px;
        border-radius: 3px;
    }

    .summary-card {
        border: 1px solid #ccc;
        border-radius: 4px;
        margin-bottom: 10px;
    }

    .summary-header {
        background: #3366cc;
        color: #fff;
        padding: 5px 10px;
        font-size: 9px;
        font-weight: bold;
    }

    .summary-body {
        padding: 6px 10px;
    }

    .summary-table {
        width: 100%;
        font-size: 8px;
        border-collapse: collapse;
    }

    .summary-table td {
        padding: 4px 5px;
        border-bottom: 1px solid #ddd;
    }

    .summary-table .total-row {
        font-weight: bold;
        background-color: #f9f9f9;
        border-top: 1px solid #ccc;
    }

    .payment-card {
        border: 1px solid #ccc;
        border-radius: 4px;
        margin-bottom: 10px;
        page-break-inside: avoid;
    }

    .payment-header {
        background: #f0f0f0;
        padding: 5px 10px;
        font-size: 9px;
        font-weight: bold;
        color: #2c3e50;
        display: flex;
        justify-content: space-between;
    }

    .payment-body {
        padding: 0;
    }

    .payment-table {
        width: 100%;
        font-size: 8px;
        border-collapse: collapse;
    }

    .payment-table th {
        background: #f1f1f1;
        color: #2c3e50;
        padding: 3px 5px;
        font-weight: bold;
        border-bottom: 1px solid #ccc;
        text-transform: uppercase;
    }

    .payment-table td {
        padding: 3px 5px;
        border-bottom: 1px solid #eee;
    }

    .payment-table tr:nth-child(even) {
        background: #fafafa;
    }

    .no-data {
        padding: 10px;
        font-size: 8.5px;
        color: #555;
        text-align: center;
        background: #f8f9fa;
        font-style: italic;
    }

    .document-number {
        font-size: 7.5px;
        color: #777;
    }

    .document-type {
        font-size: 7.5px;
        background: #e9f2ff;
        color: #3366cc;
        padding: 1px 3px;
        border-radius: 2px;
        font-weight: bold;
    }

    .text-right { text-align: right; }
    .text-center { text-align: center; }
    .text-bold { font-weight: bold; }
</style>
@endsection

@section('content')

<div>
    <div class="period-filter">
        Período: {{ isset($start_date) ? __data_pt($start_date) : '---' }} a {{ isset($end_date) ? __data_pt($end_date) : '---' }}
    </div>

    @if(isset($limite_atingido) && $limite_atingido)
    <div class="alert-warning">
        <strong>Atenção:</strong> relatório limitado a 500 vendas por tipo. Foram processados {{ $total_registros ?? 0 }} registros.
    </div>
    @endif

    @if(count($formasPagamento) > 0)

    {{-- Resumo geral --}}
    <div class="summary-card">
        <div class="summary-header">Resumo por Forma de Pagamento</div>
        <div class="summary-body">
            <table class="summary-table">
                @php $totalGeral = 0; @endphp
                @foreach($formasPagamento as $forma)
                @php 
                    $percentual = isset($total_geral) && $total_geral > 0 ? (($forma['total'] ?? 0) / $total_geral * 100) : 0;
                @endphp
                <tr>
                    <td class="text-bold">{{ $forma['nome'] ?? 'Não identificado' }}</td>
                    <td class="text-right">{{ __moeda($forma['total'] ?? 0) }}</td>
                    <td class="text-right" style="width: 70px;">{{ number_format($percentual, 1) }}%</td>
                </tr>
                @endforeach
                <tr class="total-row">
                    <td>Total Geral</td>
                    <td class="text-right">{{ __moeda($total_geral ?? 0) }}</td>
                    <td class="text-right">100%</td>
                </tr>
            </table>
        </div>
    </div>

    {{-- Detalhes por forma --}}
    @foreach($formasPagamento as $forma)
    <div class="payment-card">
        <div class="payment-header">
            <span>{{ $forma['nome'] ?? 'Não identificado' }}</span>
            <span>Total: {{ __moeda($forma['total'] ?? 0) }}</span>
        </div>
        <div class="payment-body">
            @if(count($forma['vendas'] ?? []) > 0)
            <table class="payment-table">
                <thead>
                    <tr>
                        <th style="width: 5%;">ID</th>
                        <th style="width: 10%;">Data</th>
                        <th style="width: 35%;">Cliente</th>
                        <th style="width: 15%;">Documento</th>
                        <th style="width: 8%;">Tipo</th>
                        <th style="width: 12%;" class="text-right">Valor</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($forma['vendas'] as $venda)
                    <tr>
                        <td>{{ $venda['id'] ?? 'N/A' }}</td>
                        <td>{{ isset($venda['data']) ? __data_pt($venda['data']) : 'N/A' }}</td>
                        <td>{{ $venda['cliente_nome'] ?? 'Consumidor Final' }}</td>
                        <td><span class="document-number">{{ $venda['documento'] ?? '--' }}</span></td>
                        <td><span class="document-type">{{ $venda['tipo_doc'] ?? '--' }}</span></td>
                        <td class="text-right text-bold">{{ __moeda($venda['valor'] ?? 0) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="no-data">Nenhuma venda encontrada para esta forma de pagamento.</div>
            @endif
        </div>
    </div>
    @endforeach

    @else
    <div class="no-data">
        <strong>Nenhuma venda encontrada para o período selecionado.</strong><br>
        Verifique o período ou se há vendas cadastradas.
    </div>
    @endif
</div>

@endsection
