@extends('relatorios.default')

@section('css')
<style>
    .report-period {
        font-size: 9px;
        margin-bottom: 8px;
        color: #444;
    }

    .section-title {
        font-size: 10px;
        font-weight: bold;
        margin-top: 10px;
        color: #2c3e50;
    }

    .date-label {
        color: #0BB7AF;
        font-weight: bold;
        font-size: 9px;
    }

    .product-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 8px;
        margin-bottom: 15px;
    }

    .product-table th,
    .product-table td {
        border: 1px solid #ccc;
        padding: 4px 6px;
        vertical-align: middle;
    }

    .product-table th {
        background-color: #f0f0f0;
        text-transform: uppercase;
        font-weight: bold;
        color: #2c3e50;
    }

    .product-table tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .text-right { text-align: right; }
</style>
@endsection

@section('content')

@if($start_date && $end_date)
    <div class="report-period">
        Período: {{ __data_pt($start_date, 0) }} - {{ __data_pt($end_date, 0) }}
    </div>
@endif

@php
    $somaLucro = 0;
    $somaVenda = 0;
    $somaCompra = 0;
    $somaQuantidade = 0;
@endphp

@foreach($data as $i)
    @if(count($i['itens']) > 0)
        <div class="section-title">
            Data: <span class="date-label">{{ __data_pt($i['data'], 0) }}</span>
        </div>

        <table class="product-table">
            <thead>
                <tr>
                    <th style="width: 40%">Produto</th>
                    <th style="width: 10%" class="text-right">Quantidade</th>
                    <th style="width: 12%" class="text-right">Valor Venda</th>
                    <th style="width: 12%" class="text-right">Venda Média</th>
                    <th style="width: 13%" class="text-right">Subtotal</th>
                    <th style="width: 13%" class="text-right">Lucro</th>
                </tr>
            </thead>
            <tbody>
                @foreach($i['itens'] as $d)
                    @php
                        $subtotal = $d['subtotal'];
                        $custoTotal = $d['quantidade'] * $d['produto']->valor_compra;
                        $lucro = $subtotal - $custoTotal;

                        $somaQuantidade += $d['quantidade'];
                        $somaVenda += $d['media'] * $d['quantidade'];
                        $somaCompra += $custoTotal;
                        $somaLucro += $lucro;
                    @endphp
                    <tr>
                        <td>{{ $d['produto']->nome }} {{ $d['produto']->referencia }}</td>
                        <td class="text-right">{{ __moeda($d['quantidade']) }}</td>
                        <td class="text-right">{{ __moeda($d['valor']) }}</td>
                        <td class="text-right">{{ __moeda($d['media']) }}</td>
                        <td class="text-right">{{ __moeda($subtotal) }}</td>
                        <td class="text-right">{{ __moeda($lucro) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
@endforeach

{{-- Totais (opcional) --}}
{{-- 
<div class="section-title">Totais Gerais:</div>
<table class="product-table">
    <tbody>
        <tr>
            <td><strong>Total Quantidade</strong></td>
            <td>{{ __moeda($somaQuantidade) }}</td>
            <td colspan="2"><strong>Total Vendas</strong></td>
            <td>{{ __moeda($somaVenda) }}</td>
            <td><strong>Lucro Total</strong></td>
            <td>{{ __moeda($somaLucro) }}</td>
        </tr>
    </tbody>
</table> 
--}}
@endsection
