@extends('relatorios.default', ['title' => 'Relatório de Produtos'])
@section('content')

@section('css')
<style type="text/css">
    .report-header {
        margin-bottom: 10px;
    }
    
    .filter-info {
        background-color: #f8f9fa;
        border-radius: 4px;
        padding: 6px 10px;
        margin-bottom: 10px;
        border-left: 3px solid #3366cc;
    }
    
    .filter-label {
        font-weight: bold;
        color: #2c3e50;
        margin-right: 5px;
    }
    
    .filter-value {
        color: #3366cc;
        font-weight: bold;
    }
    
    .summary-box {
        background-color: #f8f9fa;
        border-radius: 4px;
        padding: 6px 10px;
        margin-bottom: 10px;
        border: 1px solid #e9ecef;
        text-align: center;
    }
    
    .summary-label {
        font-size: 8px;
        color: #6c757d;
        text-transform: uppercase;
    }
    
    .summary-value {
        font-size: 12px;
        font-weight: bold;
        color: #2c3e50;
    }
    
    .table-header {
        background: #f1f1f1;
        font-weight: bold;
        padding: 4px 6px;
        text-align: left;
        color: #2c3e50;
        text-transform: uppercase;
        font-size: 8px;
        border-bottom: 1px solid #dee2e6;
    }
    
    .table-cell {
        padding: 3px 5px;
        vertical-align: middle;
        border-bottom: 1px solid #e9ecef;
        font-size: 8px;
    }
    
    .table-row-odd {
        background-color: #f8f9fa;
    }
    
    .product-code {
        padding: 2px 4px;
        background-color: #f1f1f1;
        border-radius: 3px;
        font-family: monospace;
        font-size: 7px;
        display: inline-block;
        color: #555;
        text-align: center;
        min-width: 40px;
    }
    
    .stock-value {
        font-weight: bold;
    }
    
    .stock-value.positive {
        color: #28a745;
    }
    
    .stock-value.negative {
        color: #dc3545;
    }
    
    .stock-value.warning {
        color: #fd7e14;
    }
    
    .quantity-sold {
        background-color: #e9f2ff;
        border-radius: 3px;
        padding: 1px 4px;
        font-weight: bold;
        color: #3366cc;
        font-size: 7px;
    }
    
    .location-tag {
        display: inline-block;
        background-color: #f1f1f1;
        border-radius: 2px;
        padding: 1px 3px;
        font-size: 7px;
        margin-right: 2px;
        margin-bottom: 2px;
    }
    
    .text-right {
        text-align: right;
    }
</style>
@endsection

<div class="report-header">
    @if(isset($marca) || isset($categoria))
    <div class="filter-info">
        @isset($marca)
        <span class="filter-label">Marca:</span>
        <span class="filter-value">{{ $marca->nome }}</span>
        @endisset
        
        @isset($categoria)
        <span class="filter-label">Categoria:</span>
        <span class="filter-value">{{ $categoria->nome }}</span>
        @endisset
    </div>
    @endif
    
    <div class="summary-box">
        <div class="summary-label">Total de Produtos</div>
        <div class="summary-value">{{ sizeof($data) }}</div>
    </div>
</div>

<table style="width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th class="table-header" style="width: 45px">Código</th>
            <th class="table-header">Produto</th>
            <th class="table-header text-right">Valor de Venda</th>
            <th class="table-header text-right">Valor de Compra</th>
            @if(__countLocalAtivo() > 1)
            <th class="table-header">Disponibilidade</th>
            @endif
            <th class="table-header text-right">Estoque</th>
            <th class="table-header text-right">Data de Cadastro</th>
            @if($tipo != '')
            <th class="table-header text-right">Quantidade Vendida</th>
            @endif
        </tr>
    </thead>
    <tbody>
        @foreach($data as $key => $item)
        <tr class="{{ $key%2 == 0 ? 'table-row-odd' : '' }}">
            <td class="table-cell" style="text-align: center">
                <span class="product-code">{{ $item->id }}</span>
            </td>
            <td class="table-cell"><strong>{{ $item->nome }}</strong></td>
            <td class="table-cell text-right">{{ __moeda($item->valor_unitario) }}</td>
            <td class="table-cell text-right">{{ __moeda($item->valor_compra) }}</td>
            
            @if(__countLocalAtivo() > 1)
            <td class="table-cell">
                @foreach($item->locais as $l)
                @if($l->localizacao)
                <span class="location-tag">{{ $l->localizacao->descricao }}</span>
                @endif
                @endforeach
            </td>
            <td class="table-cell text-right">
                @foreach($item->estoqueLocais as $e)
                @if($e->local)
                <div>
                    <small>{{ $e->local->descricao }}:</small>
                    @php
                        $stockClass = $e->quantidade <= 0 ? 'negative' : ($e->quantidade <= 5 ? 'warning' : 'positive');
                    @endphp
                    <span class="stock-value {{ $stockClass }}">
                        @if($item->unidade == 'UN' || $item->unidade == 'UNID')
                        {{ number_format($e->quantidade, 0) }}
                        @else
                        {{ number_format($e->quantidade, 3) }}
                        @endif
                    </span>
                </div>
                @endif
                @endforeach
            </td>
            @else
            <td class="table-cell text-right">
                @php
                    $quantidade = $item->estoque ? $item->estoque->quantidade : 0;
                    $stockClass = $quantidade <= 0 ? 'negative' : ($quantidade <= 5 ? 'warning' : 'positive');
                @endphp
                <span class="stock-value {{ $stockClass }}">
                    {{ $item->estoque ? number_format($item->estoque->quantidade, 2) : '0' }}
                </span>
                <small>{{ $item->unidade }}</small>
            </td>
            @endif
            
            <td class="table-cell text-right">{{ __data_pt($item->created_at) }}</td>

            @if($tipo != '')
            <td class="table-cell text-right">
                <span class="quantity-sold">{{ number_format($item->quantidade_vendida, 2) }}</span>
            </td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>

@if($tipo != '')
<div style="margin-top: 8px; border: 1px solid #ddd; padding: 6px; border-radius: 4px; font-size: 8px;">
    <div style="padding: 3px; background-color: #f5f5f5; font-weight: bold; margin-bottom: 4px;">
        Informações sobre o Relatório
    </div>
    <div>
        <p>Este relatório apresenta os produtos ordenados por 
        @if($tipo == 1)
        <strong>mais vendidos</strong>
        @else
        <strong>menos vendidos</strong>
        @endif
        , conforme o histórico de vendas.
        </p>
    </div>
</div>
@endif

@endsection
