@extends('relatorios.default', ['title' => 'Relatório de Estoque'])
@section('content')

@section('css')
<style type="text/css">
    body {
        font-family: 'Helvetica', 'Arial', sans-serif;
        font-size: 12px;
        line-height: 1.4;
        color: #333;
    }
    
    .report-filters {
        margin-bottom: 20px;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 5px;
        border-left: 4px solid #3366cc;
    }
    
    .filter-item {
        display: inline-block;
        margin-right: 15px;
    }
    
    .filter-label {
        font-weight: bold;
        color: #555;
        margin-right: 5px;
    }
    
    .filter-value {
        color: #3366cc;
        font-weight: bold;
    }
    
    .alert-estoque-minimo {
        background-color: #f8d7da;
        color: #721c24;
        padding: 10px;
        border-radius: 5px;
        margin-bottom: 15px;
        font-weight: bold;
        border-left: 4px solid #dc3545;
    }
    
    .table-header {
        background: linear-gradient(to bottom, #f8f9fa, #e9ecef);
        font-weight: bold;
        color: #2c3e50;
        text-align: left;
        padding: 8px;
        border-bottom: 2px solid #dee2e6;
        text-transform: uppercase;
        font-size: 11px;
    }
    
    .table-row {
        border-bottom: 1px solid #e9ecef;
        padding: 8px;
    }
    
    .table-row-odd {
        background-color: #f8f9fa;
    }
    
    .table-cell {
        padding: 8px;
        vertical-align: middle;
    }
    
    .text-right {
        text-align: right;
    }
    
    .text-center {
        text-align: center;
    }
    
    .estoque-baixo {
        color: #dc3545;
        font-weight: bold;
    }
    
    .estoque-medio {
        color: #fd7e14;
        font-weight: bold;
    }
    
    .estoque-ok {
        color: #28a745;
        font-weight: bold;
    }
    
    .resumo-container {
        margin: 20px 0;
        background-color: #f8f9fa;
        padding: 15px;
        border-radius: 5px;
        border: 1px solid #e9ecef;
    }
    
    .resumo-titulo {
        font-size: 16px;
        font-weight: bold;
        color: #2c3e50;
        margin-bottom: 10px;
        border-bottom: 1px solid #e9ecef;
        padding-bottom: 5px;
    }
    
    .resumo-info {
        display: flex;
        justify-content: space-between;
        flex-wrap: wrap;
    }
    
    .resumo-item {
        margin-right: 20px;
        margin-bottom: 10px;
    }
    
    .resumo-label {
        font-weight: bold;
        color: #6c757d;
        font-size: 11px;
        text-transform: uppercase;
    }
    
    .resumo-valor {
        font-size: 16px;
        font-weight: bold;
        color: #2c3e50;
    }
    
    .rodape {
        margin-top: 30px;
        text-align: center;
        font-size: 10px;
        color: #6c757d;
        border-top: 1px solid #e9ecef;
        padding-top: 10px;
    }
</style>
@endsection

@if($start_date || $end_date)
<div class="report-filters">
    @if($start_date && $end_date)
    <div class="filter-item">
        <span class="filter-label">Período:</span>
        <span class="filter-value">{{ date('d/m/Y', strtotime($start_date)) }} a {{ date('d/m/Y', strtotime($end_date)) }}</span>
    </div>
    @elseif($start_date)
    <div class="filter-item">
        <span class="filter-label">A partir de:</span>
        <span class="filter-value">{{ date('d/m/Y', strtotime($start_date)) }}</span>
    </div>
    @elseif($end_date)
    <div class="filter-item">
        <span class="filter-label">Até:</span>
        <span class="filter-value">{{ date('d/m/Y', strtotime($end_date)) }}</span>
    </div>
    @endif
</div>
@endif

@if($estoque_minimo == 1)
<div class="alert-estoque-minimo">
    <i class="ri-error-warning-line"></i> Este relatório exibe apenas produtos com estoque abaixo do mínimo configurado
</div>
@endif

<div class="resumo-container">
    <div class="resumo-titulo">Resumo do Relatório</div>
    <div class="resumo-info">
        <div class="resumo-item">
            <div class="resumo-label">Total de Itens</div>
            <div class="resumo-valor">{{ count($data) }}</div>
        </div>
        
        @php
            $totalQuantidade = 0;
            $totalValorCompra = 0;
            $totalValorVenda = 0;
            $qtdEstoqueMinimo = 0;
            
            foreach($data as $item) {
                $totalQuantidade += $item['quantidade'];
                $totalValorCompra += $item['valor_compra'] * $item['quantidade'];
                $totalValorVenda += $item['valor_venda'] * $item['quantidade'];
                
                if($item['quantidade'] <= $item['estoque_minimo']) {
                    $qtdEstoqueMinimo++;
                }
            }
        @endphp
        
        <div class="resumo-item">
            <div class="resumo-label">Quantidade Total</div>
            <div class="resumo-valor">{{ number_format($totalQuantidade, 2, ',', '.') }}</div>
        </div>
        
        <div class="resumo-item">
            <div class="resumo-label">Valor Total de Custo</div>
            <div class="resumo-valor">{{ __moeda($totalValorCompra) }}</div>
        </div>
        
        <div class="resumo-item">
            <div class="resumo-label">Valor Total de Venda</div>
            <div class="resumo-valor">{{ __moeda($totalValorVenda) }}</div>
        </div>
        
        @if($estoque_minimo != 1)
        <div class="resumo-item">
            <div class="resumo-label">Itens Abaixo do Mínimo</div>
            <div class="resumo-valor estoque-baixo">{{ $qtdEstoqueMinimo }}</div>
        </div>
        @endif
    </div>
</div>

<table style="width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th class="table-header" style="width: 25%">Produto</th>
            <th class="table-header" style="width: 15%">Categoria</th>
            <th class="table-header" style="width: 12%">Valor de Compra</th>
            <th class="table-header" style="width: 12%">Valor de Venda</th>
            <th class="table-header" style="width: 10%">Quantidade</th>
            <th class="table-header" style="width: 10%">Estoque Mínimo</th>
            <th class="table-header" style="width: 15%">Data de Cadastro</th>
        </tr>
    </thead>
    <tbody>
        @foreach($data as $key => $item)
        @php
            $estoqueClass = '';
            if($item['quantidade'] <= 0) {
                $estoqueClass = 'estoque-baixo';
            } elseif($item['quantidade'] <= $item['estoque_minimo']) {
                $estoqueClass = 'estoque-medio';
            } else {
                $estoqueClass = 'estoque-ok';
            }
        @endphp
        <tr class="table-row {{ $key%2 == 0 ? 'table-row-odd' : '' }}">
            <td class="table-cell">{{ $item['produto'] }}</td>
            <td class="table-cell">{{ $item['categoria'] }}</td>
            <td class="table-cell text-right">{{ __moeda($item['valor_compra']) }}</td>
            <td class="table-cell text-right">{{ __moeda($item['valor_venda']) }}</td>
            <td class="table-cell text-right {{ $estoqueClass }}">{{ number_format($item['quantidade'], 2, ',', '.') }}</td>
            <td class="table-cell text-right">{{ number_format($item['estoque_minimo'], 2, ',', '.') }}</td>
            <td class="table-cell">{{ $item['data_cadastro'] }}</td>
        </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr>
            <td colspan="4" class="table-cell" style="text-align: right; font-weight: bold;">Totais:</td>
            <td class="table-cell text-right" style="font-weight: bold;">{{ number_format($totalQuantidade, 2, ',', '.') }}</td>
            <td colspan="2" class="table-cell"></td>
        </tr>
    </tfoot>
</table>

<div class="rodape">
    <p>Relatório gerado em {{ date('d/m/Y H:i:s') }}</p>
    <p>Sistema {{ env('APP_NAME') }}</p>
</div>

@endsection
