<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"/>
    <title>{{ $title ?? 'Relatório' }}</title>
    <style>
        @page {
            margin: 0.8cm;
        }
        
        @page :first {
            margin-top: 0.8cm;
        }

        body {
            font-family: 'Arial', sans-serif;
            font-size: 8px;
            color: #222;
            margin: 0;
        }

        /* Cabeçalho apenas para a primeira página */
        .company-header {
            padding: 2px 8px;
            margin-bottom: 10px;
            page-break-after: avoid;
        }
        
        /* Rodapé permanece fixo em todas as páginas */
        footer {
            position: fixed;
            left: 0;
            right: 0;
            bottom: 0;
            height: 0.7cm;
            border-top: 1px solid #ccc;
            text-align: center;
            padding-top: 2px;
            color: #444;
            font-size: 7px;
            background: #fff;
        }

        .content {
            margin-bottom: 1.1cm;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            page-break-inside: auto;
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }

        thead {
            display: table-header-group;
        }

        tfoot {
            display: table-footer-group;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 2px 4px;
            text-align: left;
            font-size: 7px;
        }

        th {
            background: #f1f1f1;
            text-transform: uppercase;
        }

        .report-title {
            background: linear-gradient(to right, #f8f9fa, #e9ecef);
            text-align: center;
            font-size: 9px;
            font-weight: bold;
            padding: 3px;
            margin-bottom: 6px;
            border-radius: 3px;
            border-left: 3px solid #3366cc;
            color: #2c3e50;
        }

        .header-line {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1px;
            line-height: 1.1;
        }

        .company-logo {
            max-height: 28px;
            margin-right: 8px;
            float: left;
        }

        .company-name {
            font-weight: bold;
            font-size: 9px;
            color: #2c3e50;
        }

        .company-fantasia {
            font-style: italic;
            font-size: 8px;
            color: #3366cc;
        }

        .company-doc {
            font-size: 7px;
            text-align: right;
        }

        .report-datetime {
            text-align: right;
            font-size: 7px;
            color: #6c757d;
            font-weight: bold;
            margin-bottom: 4px;
        }

        .text-center { text-align: center; }
        .text-right { text-align: right; }

        .page-number:after {
            content: counter(page);
        }

        .page-break {
            page-break-before: always;
        }

        @media print {
            .card, .shadow, .rounded, .bg-light, .bg-white {
                box-shadow: none !important;
                border: none !important;
                background: none !important;
            }
        }
    </style>
    @yield('css')
</head>
<body>

@php
    $config = \App\Models\Empresa::where('id', session('empresa_id', 1))->first();
    $empresa = $config;
@endphp

<!-- Cabeçalho apenas na primeira página -->
<div class="company-header">
    @php
        $logoPath = '';
        $logoExists = false;
        if ($config && !empty($config->logo)) {
            $logoPath = public_path('logos/' . $config->logo);
            $logoExists = file_exists($logoPath);
        }
    @endphp

    @if($logoExists)
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents($logoPath)) }}" class="company-logo">
    @endif

    <div class="header-line">
        <div class="company-name">{{ $config->nome ?? '' }}</div>
        <div class="company-doc"><strong>CNPJ:</strong> {{ $config->cpf_cnpj ?? '00.000.000/0000-00' }}</div>
    </div>

    <div class="header-line">
        <div class="company-fantasia">{{ $config->nome_fantasia ?? 'Sistema Gerencial' }}</div>
        <div class="company-doc"><strong>IE:</strong> {{ $config->ie ?? 'ISENTO' }}</div>
    </div>
</div>

<footer>
    <div style="font-size: 7px;">
        Relatório gerado em {{ date('d/m/Y H:i:s') }} | {{ $config->nome ?? '' }} - {{ $config->cpf_cnpj ?? '' }}
    </div>
    <div style="font-size: 7px;">
        <strong>Sistema {{ env('APP_NAME') }}</strong> - https://{{ env('APP_URL') }}/ | Página <span class="page-number"></span>
    </div>
</footer>

<div class="content">
    <div class="report-title">{{ $title ?? 'Relatório' }}</div>
    <div class="report-datetime">Data de Emissão: {{ date('d/m/Y H:i:s') }}</div>

    @yield('content')
</div>

</body>
</html>
