@extends('relatorios.default')
@section('content')

@section('css')
<style type="text/css">
    .status-indicator {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        display: inline-block;
        margin-right: 4px;
    }

    .status-ativo {
        background-color: #28a745;
    }

    .status-inativo {
        background-color: #ccc;
    }

    .comissoes-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 9px;
        margin-bottom: 10px;
    }

    .comissoes-table th,
    .comissoes-table td {
        border: 1px solid #ddd;
        padding: 4px 5px;
        vertical-align: middle;
    }

    .comissoes-table th {
        background-color: #f1f1f1;
        font-weight: bold;
        text-transform: uppercase;
        color: #2c3e50;
    }

    .comissoes-table tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .text-right {
        text-align: right;
    }

    .text-center {
        text-align: center;
    }

    .text-left {
        text-align: left;
    }

    .total-footer td {
        font-weight: bold;
        background-color: #f1f1f1;
    }
</style>
@endsection

<table class="comissoes-table">
    <thead>
        <tr>
            <th>Funcionário</th>
            <th>Tipo</th>
            <th class="text-center">Status</th>
            <th class="text-right">Venda</th>
            <th class="text-right">Comissão</th>
            <th class="text-center">Data</th>
        </tr>
    </thead>
    <tbody>
        @foreach($data as $item)
        <tr>
            <td>{{ $item->funcionario->nome }}</td>
            <td>{{ $item->tabela === 'nfce' ? 'PDV' : 'Pedido' }}</td>
            <td class="text-center">
                <span class="status-indicator {{ $item->status ? 'status-ativo' : 'status-inativo' }}"></span>
                {{ $item->status ? 'Pago' : 'Pendente' }}
            </td>
            <td class="text-right">{{ __moeda($item->valor_venda) }}</td>
            <td class="text-right">{{ __moeda($item->valor) }}</td>
            <td class="text-center">{{ __data_pt($item->created_at) }}</td>
        </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr class="total-footer">
            <td colspan="3">Totais</td>
            <td class="text-right">{{ __moeda($data->sum('valor_venda')) }}</td>
            <td class="text-right">{{ __moeda($data->sum('valor')) }}</td>
            <td></td>
        </tr>
    </tfoot>
</table>

@endsection
