@extends('layouts.app', ['title' => 'Detalhes do Produto'])
@section('css')
<style type="text/css">
    @page { size: auto; margin: 0mm; }

    @media print {
        .print{
            margin: 10px;
        }
    }

    .product-header {
        background-color: #f8f9fa;
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        margin-bottom: 24px;
    }

    .product-info-card {
        height: 100%;
        transition: all 0.3s ease;
    }

    .product-info-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }

    .product-img {
        max-height: 150px;
        width: auto;
        object-fit: contain;
        border-radius: 8px;
    }

    .movement-table th, .movement-table td {
        vertical-align: middle;
    }

    .movement-table thead {
        background-color: #343a40;
        color: white;
    }

    .movement-table th {
        font-weight: 500;
        border-color: #495057;
    }

    .movement-type-increment {
        color: #198754;
        font-weight: 500;
    }

    .movement-type-reduction {
        color: #dc3545;
        font-weight: 500;
    }

    .detail-card {
        position: relative;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        transition: all 0.3s ease;
    }

    .detail-card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }

    .detail-card .detail-icon {
        position: absolute;
        right: 20px;
        top: 20px;
        font-size: 30px;
        opacity: 0.2;
    }

    .detail-card .detail-value {
        font-size: 24px;
        font-weight: 600;
        margin-top: 10px;
    }

    .detail-card .detail-label {
        text-transform: uppercase;
        font-size: 12px;
        letter-spacing: 1px;
        opacity: 0.7;
    }

    .card-sales {
        background-color: rgba(25, 135, 84, 0.1);
        border-left: 4px solid #198754;
    }

    .card-purchase {
        background-color: rgba(13, 110, 253, 0.1);
        border-left: 4px solid #0d6efd;
    }

    .card-stock {
        background-color: rgba(255, 193, 7, 0.1);
        border-left: 4px solid #ffc107;
    }

    .card-movements {
        background-color: rgba(108, 117, 125, 0.1);
        border-left: 4px solid #6c757d;
    }

    .badge-stock {
        font-size: 14px;
        padding: 6px 12px;
        font-weight: 500;
    }

    .product-barcode {
        background-color: #f8f9fa;
        padding: 8px 15px;
        border-radius: 50px;
        font-family: monospace;
        font-size: 14px;
        display: inline-flex;
        align-items: center;
    }

    .product-barcode i {
        margin-right: 8px;
    }

    .supplier-section {
        margin-top: 30px;
        border-top: 1px dashed rgba(0,0,0,0.1);
        padding-top: 20px;
    }
</style>
@endsection
@section('content')
<div class="mt-3 print">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <!-- Product Header -->
                    <div class="product-header">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h2 class="mb-1">{{ $item->nome }}</h2>
                                @if($item->codigo_barras)
                                <div class="product-barcode">
                                    <i class="ri-barcode-line"></i> {{ $item->codigo_barras }}
                                </div>
                                @endif
                                <div class="mt-3">
                                    <span class="badge bg-{{ $item->estoqueReal() > 0 ? 'success' : 'danger' }} badge-stock">
                                        {{ $item->estoqueFormatado() }} unidades em estoque
                                    </span>
                                    @if($item->categoria)
                                    <span class="badge bg-primary badge-stock ms-2">
                                        <i class="ri-price-tag-3-line me-1"></i> {{ $item->categoria->nome }}
                                    </span>
                                    @endif
                                    @if($item->marca)
                                    <span class="badge bg-info badge-stock ms-2">
                                        <i class="ri-shield-star-line me-1"></i> {{ $item->marca->nome }}
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <img class="product-img" src="{{ $item->img }}" alt="{{ $item->nome }}">
                            </div>
                        </div>
                    </div>

                    <!-- Key Metrics -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="detail-card card-sales">
                                <div class="detail-icon">
                                    <i class="ri-money-dollar-circle-line"></i>
                                </div>
                                <div class="detail-label">Valor de Venda</div>
                                <div class="detail-value">R$ {{ __moeda($item->valor_unitario) }}</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="detail-card card-purchase">
                                <div class="detail-icon">
                                    <i class="ri-shopping-cart-line"></i>
                                </div>
                                <div class="detail-label">Valor de Compra</div>
                                <div class="detail-value">R$ {{ __moeda($item->valor_compra) }}</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="detail-card card-stock">
                                <div class="detail-icon">
                                    <i class="ri-stack-line"></i>
                                </div>
                                <div class="detail-label">Total Movimentado</div>
                                <div class="detail-value">{{ number_format($data->sum('quantidade'), 2, ',', '.') }}</div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="detail-card card-movements">
                                <div class="detail-icon">
                                    <i class="ri-bar-chart-2-line"></i>
                                </div>
                                <div class="detail-label">Total Movimentações</div>
                                <div class="detail-value">{{ sizeof($data) }}</div>
                            </div>
                        </div>
                    </div>

                    <!-- History Section -->
                    <div class="card shadow-sm">
                        <div class="card-header bg-light">
                            <h5 class="mb-0">
                                <i class="ri-history-line me-2"></i>
                                Histórico de Movimentações
                            </h5>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover movement-table mb-0">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Quantidade</th>
                                            <th>Estoque Resultante</th>
                                            <th>Tipo de Operação</th>
                                            <th>Tipo</th>
                                            <th>Variação</th>
                                            <th>Usuário</th>
                                            <th>Data</th>
                                            <th class="d-print-none">Ação</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($data as $i)
                                        <tr>
                                            <td>{{ $i->id }}</td>
                                            <td class="{{ $i->tipo == 'incremento' ? 'movement-type-increment' : 'movement-type-reduction' }}">
                                                {{ $i->tipo == 'incremento' ? '+' : '-' }}{{ number_format($i->quantidade, 2, ',', '.') }}
                                            </td>
                                            <td>{{ $i->estoque_atual ? number_format($i->estoque_atual, 2, ',', '.') : '--' }}</td>
                                            <td>
                                                <span class="badge bg-light text-dark">
                                                    {{ $i->tipoTransacao() }}
                                                </span>
                                            </td>
                                            <td>
                                                @if($i->tipo == 'incremento')
                                                    <span class="badge bg-success">Incremento</span>
                                                @else
                                                    <span class="badge bg-danger">Redução</span>
                                                @endif
                                            </td>
                                            <td>{{ $i->produtoVariacao ? $i->produtoVariacao->descricao : '--' }}</td>
                                            <td>{{ $i->user ? $i->user->name : '--' }}</td>
                                            <td>{{ __data_pt($i->created_at) }}</td>
                                            <td class="d-print-none">
                                                <a class="btn btn-sm btn-primary" href="{{ route('produtos.movimentacao', [$i->id]) }}">
                                                    <i class="ri-eye-line me-1"></i> Visualizar
                                                </a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Suppliers Section -->
                    @if(count($item->fornecedores) > 0)
                    <div class="supplier-section">
                        <div class="card shadow-sm">
                            <div class="card-header bg-light">
                                <h5 class="mb-0">
                                    <i class="ri-user-2-line me-2"></i>
                                    Fornecedores do Produto
                                </h5>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover mb-0">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>Razão Social</th>
                                                <th>CPF/CNPJ</th>
                                                <th>Endereço</th>
                                                <th>Cidade</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($item->fornecedores as $i)
                                            <tr>
                                                <td>
                                                    <strong>{{ $i->fornecedor->razao_social }}</strong>
                                                </td>
                                                <td>{{ $i->fornecedor->cpf_cnpj }}</td>
                                                <td>{{ $i->fornecedor->rua }}, {{ $i->fornecedor->numero }} - {{ $i->fornecedor->bairro }}</td>
                                                <td>{{ $i->fornecedor->cidade->info }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Action Buttons -->
                    <div class="d-print-none mt-4">
                        <div class="text-end">
                            <a href="{{ route('produtos.index') }}" class="btn btn-secondary me-2">
                                <i class="ri-arrow-left-line me-1"></i> Voltar
                            </a>
                            <a href="{{ route('produtos.edit', [$item->id]) }}" class="btn btn-info me-2">
                                <i class="ri-edit-box-line me-1"></i> Editar
                            </a>
                            <a href="javascript:window.print()" class="btn btn-primary">
                                <i class="ri-printer-line me-1"></i> Imprimir
                            </a>
                        </div>
                    </div>   
                </div>
            </div>
        </div>
    </div>
</div>
@endsection