<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Relatório de Estoque</title>
    <style>
        @page {
            size: landscape;
            margin: 15mm 10mm; /* Margens mais compactas */
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }
        .title {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #333;
        }
        .subtitle {
            font-size: 13px;
            margin-bottom: 3px;
            color: #555;
        }
        .info {
            margin-bottom: 20px;
        }
        .info-box {
            margin-bottom: 10px;
            width: 23%;
            float: left;
            border: 1px solid #ddd;
            padding: 8px;
            margin-right: 1%;
            text-align: center;
            background-color: #f9f9f9;
            border-radius: 4px;
        }
        .info-box-title {
            font-weight: bold;
            margin-bottom: 6px;
            color: #555;
            font-size: 10px;
        }
        .info-box-value {
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            table-layout: fixed;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            word-wrap: break-word;
            overflow: hidden;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
            color: #333;
            font-size: 10px;
        }
        td {
            font-size: 10px;
        }
        /* Definindo larguras específicas para as colunas */
        th:nth-child(1), td:nth-child(1) { width: 22%; max-width: 22%; } /* Nome */
        th:nth-child(2), td:nth-child(2) { width: 8%; max-width: 8%; } /* Código de Barras */
        th:nth-child(3), td:nth-child(3) { width: 8%; max-width: 8%; } /* NCM */
        th:nth-child(4), td:nth-child(4) { width: 10%; max-width: 10%; } /* Categoria */
        th:nth-child(5), td:nth-child(5) { width: 7%; max-width: 7%; } /* Gerencia Estoque */
        th:nth-child(6), td:nth-child(6) { width: 7%; max-width: 7%; } /* Estoque */
        th:nth-child(7), td:nth-child(7) { width: 8%; max-width: 8%; } /* Valor de Compra */
        th:nth-child(8), td:nth-child(8) { width: 8%; max-width: 8%; } /* Valor de Venda */
        th:nth-child(9), td:nth-child(9) { width: 11%; max-width: 11%; } /* Total Compra */
        th:nth-child(10), td:nth-child(10) { width: 11%; max-width: 11%; } /* Total Venda */
        
        .text-right {
            text-align: right;
        }
        .clear {
            clear: both;
        }
        .text-center {
            text-align: center;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 10px;
            color: #777;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        h3 {
            color: #444;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
            font-size: 14px;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2; /* Cor um pouco mais escura para melhor legibilidade */
        }
        tr:hover {
            background-color: #ececec; /* Efeito hover, mesmo que não clicável, facilita leitura */
        }
        .page-number {
            position: absolute;
            bottom: 10px;
            width: 100%;
            text-align: center;
            font-size: 10px;
            color: #888;
        }
        .page-number:after {
            content: counter(page);
        }
    </style>
</head>
<body>
    <div class="header">
        <div style="text-align: right; margin-bottom: 10px;">
            <span style="font-size: 12px; color: #3366cc; font-weight: bold;">Powered by {{ env('APP_NAME') }}</span>
        </div>
        <div class="title">Relatório de Estoque</div>
        <div class="subtitle">{{ $empresa->nome }}</div>
        <div class="subtitle">Nome Fantasia: {{ $empresa->nome_fantasia }}</div>
        <div class="subtitle">CNPJ: {{ $empresa->cpf_cnpj }}</div>
        <div class="subtitle">Data: {{ date('d/m/Y H:i:s') }}</div>
    </div>

    <div class="info">
        <div class="info-box" style="width: 23%;">
            <div class="info-box-title">Total de Itens Cadastrados</div>
            <div class="info-box-value">{{ $totalItens }}</div>
        </div>
        <div class="info-box" style="width: 23%;">
            <div class="info-box-title">Quantidade Total em Estoque</div>
            <div class="info-box-value">{{ number_format($totalQuantidade, 2, ',', '.') }}</div>
        </div>
        <div class="info-box" style="width: 23%;">
            <div class="info-box-title">Valor Total de Custo</div>
            <div class="info-box-value">R$ {{ number_format($totalValorCompra, 2, ',', '.') }}</div>
        </div>
        <div class="info-box" style="width: 23%;">
            <div class="info-box-title">Valor Total de Venda</div>
            <div class="info-box-value">R$ {{ number_format($totalValorVenda, 2, ',', '.') }}</div>
        </div>
        <div class="clear"></div>
    </div>

    <h3>Lista de Produtos</h3>
    <table>
        <thead>
            <tr>
                <th>Nome</th>
                <th>Código de Barras</th>
                <th>NCM</th>
                <th>Categoria</th>
                <th>Gerencia Estoque</th>
                <th>Estoque</th>
                <th>Valor de Compra</th>
                <th>Valor de Venda</th>
                <th>Total Compra</th>
                <th>Total Venda</th>
            </tr>
        </thead>
        <tbody>
            @forelse($produtos as $produto)
            <tr>
                <td>{{ $produto->nome }}</td>
                <td>{{ $produto->codigo_barras }}</td>
                <td>{{ $produto->ncm }}</td>
                <td>{{ $produto->categoria ? $produto->categoria->nome : '-' }}</td>
                <td class="text-center">{{ $produto->gerenciar_estoque ? 'Sim' : 'Não' }}</td>
                <td class="text-right">{{ number_format($produto->estoque ? $produto->estoque->quantidade : 0, 2, ',', '.') }}</td>
                <td class="text-right">R$ {{ number_format($produto->valor_compra, 2, ',', '.') }}</td>
                <td class="text-right">R$ {{ number_format($produto->valor_unitario, 2, ',', '.') }}</td>
                <td class="text-right">R$ {{ number_format(($produto->estoque ? $produto->estoque->quantidade : 0) * $produto->valor_compra, 2, ',', '.') }}</td>
                <td class="text-right">R$ {{ number_format(($produto->estoque ? $produto->estoque->quantidade : 0) * $produto->valor_unitario, 2, ',', '.') }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="10" class="text-center">Nenhum produto encontrado</td>
            </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr>
                <th colspan="5">Totais</th>
                <th class="text-right">{{ number_format($totalQuantidade, 2, ',', '.') }}</th>
                <th colspan="2"></th>
                <th class="text-right">R$ {{ number_format($totalValorCompra, 2, ',', '.') }}</th>
                <th class="text-right">R$ {{ number_format($totalValorVenda, 2, ',', '.') }}</th>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>Relatório gerado em {{ date('d/m/Y H:i:s') }}</p>
        <p>{{ $empresa->nome }} - {{ $empresa->cpf_cnpj }}</p>
        @if($empresa->cidade)
        <p>{{ $empresa->rua }}, {{ $empresa->numero }} - {{ $empresa->bairro }} - {{ $empresa->cidade->nome }}/{{ $empresa->cidade->uf }}</p>
        @endif
        <p style="color: #3366cc; font-weight: bold;">Gerado por: Sistema {{ env('APP_NAME') }} - https://{{ env('APP_URL') }}/</p>
        <span class="page-number">Página </span>
    </div>
</body>
</html> 