@extends('layouts.app', ['title' => 'Produtos'])

@section('css')
<style>
    .img-thumbnail {
        max-width: 50px;
        height: auto;
    }

    .dropdown-menu {
        position: absolute !important;
        z-index: 1050;
        max-height: 300px;
        overflow-y: auto;
    }

    .table-responsive {
        min-height: 600px;
    }

    .card-body {
        padding-bottom: 80px;
    }

    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
    }

    .table th, .table td {
        vertical-align: middle;
    }

    .btn-sm {
        padding: 0.3rem 0.5rem;
        font-size: 0.75rem;
    }
</style>
@endsection

@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
            <div class="col-md-12 mb-3">
                <div class="d-flex flex-wrap gap-2">
                    @can('produtos_create')
                    <a href="{{ route('produtos.create') }}" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Novo Produto
                    </a>
                    @endcan

                    <a href="{{ route('produtos.import') }}" class="btn btn-info">
                        <i class="ri-file-upload-line"></i>
                        Upload
                    </a>

                    @can('produtos_edit')
                    <a href="{{ route('produtos.reajuste') }}" class="btn btn-dark">
                        <i class="ri-file-edit-fill"></i>
                        Reajuste em Grupo
                    </a>
                    @endcan

                    <a href="{{ route('produtos.relatorio-estoque') }}" class="btn btn-primary">
                        <i class="ri-file-list-3-line"></i>
                        Relatório de Estoque
                    </a>

                    <a href="{{ route('produtos.upload-imagens') }}" class="btn btn-light">
                        <i class="ri-image-fill"></i>
                        Upload de Imagens
                    </a>
                    
                    <a href="{{ route('produtos.emissao-etiquetas') }}" class="btn btn-secondary">
                        <i class="ri-barcode-box-line"></i>
                        Emissão de Etiquetas
                    </a>
                </div>
            </div>
                <hr>
                {!! Form::open()->fill(request()->all())->get() !!}
                <div class="row g-2">
                    <div class="col-md-3">
                        {!! Form::text('nome', 'Pesquisar por Nome') !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::tel('codigo_barras', 'Código de Barras') !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::select('categoria_id', 'Categoria', ['' => 'Todos'] + $categorias->pluck('nome', 'id')->all())->attrs(['class' => 'form-select']) !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::select('marca_id', 'Marca', ['' => 'Todas'] + $marcas->pluck('nome', 'id')->all())->attrs(['class' => 'form-select']) !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::date('start_date', 'Dt. inicial cadastro') !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::date('end_date', 'Dt. final cadastro') !!}
                    </div>
                    @if(__countLocalAtivo() > 1)
                    <div class="col-md-3">
                        {!! Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())->attrs(['class' => 'select2']) !!}
                    </div>
                    @endif
                    <div class="col-md-3">
                        {!! Form::select('com_variacao', 'Com Variação', ['' => 'Todos', 1 => 'Sim', 0 => 'Não'])->attrs(['class' => 'form-select']) !!}
                    </div>
                    <div class="col-md-3">
                        {!! Form::select('com_estoque', 'Situação do Estoque', ['' => 'Todos', '1' => 'Apenas com estoque', '0' => 'Apenas sem estoque'])->attrs(['class' => 'form-select']) !!}
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button class="btn btn-primary w-100" type="submit">
                            <i class="ri-search-line"></i> Pesquisar
                        </button>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <a id="clear-filter" class="btn btn-danger w-100" href="{{ route('produtos.index') }}">
                            <i class="ri-eraser-fill"></i> Limpar
                        </a>
                    </div>
                </div>
                {!! Form::close() !!}

                <div class="table-responsive mt-4">
                    <table class="table table-striped table-centered mb-0 w-100">
                        <thead class="table-dark">
                            <tr>
                                <th>Imagem</th>
                                <th>Nome</th>
                                <th>Valor Venda</th>
                                <th>Valor Compra</th>
                                <th>Estoque</th>
                                <th>Categoria</th>
                                <th>Cod. Barras</th>
                                <th>Unidade</th>
                                <th>Data Cadastro</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($data as $item)
                            <tr>
                                <td><img src="{{ $item->img }}" class="img-thumbnail"></td>
                                <td class="text-truncate" style="max-width: 180px">{{ $item->nome }}</td>
                                <td>{{ __moeda($item->valor_unitario) }}</td>
                                <td>{{ __moeda($item->valor_compra) }}</td>
                                <td>{{ $item->estoqueFormatado(request()->get('local_id')) }}</td>
                                <td>{{ $item->categoria->nome ?? '--' }}</td>
                                <td>{{ $item->codigo_barras ?? '--' }}</td>
                                <td>{{ $item->unidade }}</td>
                                <td>{{ __data_pt($item->created_at) }}</td>
                                <td>{!! $item->status ? '<span class="badge bg-success">Ativo</span>' : '<span class="badge bg-danger">Inativo</span>' !!}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-outline-secondary btn-sm dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            Ações
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end shadow-sm small">

                                            @can('produtos_edit')
                                            <li>
                                                <a class="dropdown-item text-warning" href="{{ route('produtos.edit', $item->id) }}">
                                                    <i class="ri-edit-line me-1"></i> Editar
                                                </a>
                                            </li>
                                            @endcan

                                            @can('produtos_delete')
                                            <li>
                                                <button type="button" class="dropdown-item text-danger btn-delete">
                                                    <i class="ri-delete-bin-line me-1"></i> Excluir
                                                </button>
                                            </li>
                                            @endcan

                                            <li>
                                                <a class="dropdown-item text-info" href="{{ route('produtos.show', $item->id) }}">
                                                    <i class="ri-draft-line me-1"></i> Detalhes
                                                </a>
                                            </li>

                                            @if($item->composto)
                                            <li>
                                                <a class="dropdown-item text-primary" href="{{ route('produto-composto.show', $item->id) }}">
                                                    <i class="ri-search-eye-fill me-1"></i> Ver Composição
                                                </a>
                                            </li>
                                            @endif

                                            <li>
                                                <a class="dropdown-item text-secondary" href="{{ route('produtos.etiqueta', $item->id) }}">
                                                    <i class="ri-barcode-box-line me-1"></i> Etiqueta
                                                </a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item text-dark" href="{{ route('produtos.duplicar', $item->id) }}">
                                                    <i class="ri-file-copy-line me-1"></i> Duplicar
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="10" class="text-center">Nada encontrado</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <br>
                {!! $data->appends(request()->all())->links() !!}
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script>
    document.querySelectorAll('.dropdown').forEach(function (dropdown) {
        const button = dropdown.querySelector('.dropdown-toggle');
        button.addEventListener('click', function () {
            const rect = dropdown.getBoundingClientRect();
            const isNearBottom = window.innerHeight - rect.bottom < 150;
            if (isNearBottom) {
                dropdown.classList.add('dropup');
            } else {
                dropdown.classList.remove('dropup');
            }
        });
    });
</script>
@endpush
