<button class="btn btn-success" onclick="window.print()">Imprimir</button>
<div id="preview_body">
	@php
	$contLinha = 0;
	$contTotal = 0;
	@endphp
	@for($i=0; $i<$quantidade; $i++)
	<div style="height: {{$altura}}mm !important; width: {{$largura}}mm !important; display: inline-block; margin-top: {{$contTotal > 0 && $contLinha == 0 ? $distancia_horizontal : $distancia_topo}}mm !important; margin-left: {{$quantidade_por_linhas > 1 && $contLinha > 0 ? $distancia_lateral : 0 }}mm !important;" class="sticker-border text-center">

		@if($data['tipo'] == 'simples')
		<div style="display:inline-block;vertical-align:middle;line-height:10px !important; margin-top: {{$distancia_topo}}mm;">

			@if($data['nome_empresa'])
			<b style="display: block !important; font-size: {{$tamanho_fonte}}px" class="text-uppercase">{{$data['empresa']}}</b>
			@endif

			@if($data['nome_produto'])
			<span style="display: block !important; font-size: {{$tamanho_fonte}}px">
				{{$data['nome']}}
			</span>
			@endif
			@if($data['cod_produto'])
			<span style="display: block !important; margin-top: 3px; font-size: {{$tamanho_fonte}}px">
				ID: <b>{{$data['codigo']}}</b>
			</span>
			@endif
			
			@if($data['codigo_barras_numerico'])
				<img class="center-block" style="max-width:90% !important; height: {{$tamanho_codigo}}mm !important;" src="/barcode/{{$rand}}.png">
				@if(!isset($data['tem_codigo_barras']) || $data['tem_codigo_barras'])
					<span style="display: block !important; font-size: {{$tamanho_fonte}}px;">{{$codigo}}</span>
				@else
					<span style="display: block !important; font-size: {{$tamanho_fonte}}px; color: #ff0000;">SEM CÓDIGO DE BARRAS</span>
				@endif
			@endif
			
			@if($data['valor_produto'])
			<span style="display: block !important; font-size: {{$tamanho_fonte}}px; margin-top: 4px;">
				<b>R$ {{number_format($data['valor'], 2, ',', '.')}}</b>
			</span>
			@endif
		</div>
		@elseif($data['tipo'] == 'gondola')
		<div style="line-height:10px !important; margin-top: {{$distancia_topo}}mm;">


			@if($data['nome_produto'])
			<span style="display: block !important; margin-bottom: 4px; font-size: {{$tamanho_fonte}}px">
				{{$data['nome']}}
			</span>
			@endif
			@if($data['cod_produto'])
			<span style="display: block !important; margin-top: 3px; font-size: {{$tamanho_fonte}}px">
				ID: <b>{{$data['codigo']}}</b>
			</span>
			@endif
			<div style="max-width:60%; float:left;">
				@if($data['codigo_barras_numerico'])
					<img class="center-block" style="margin-left:5px; margin-bottom: 4px; max-width:90% !important; height: {{$tamanho_codigo}}mm !important;" src="/barcode/{{$rand}}.png">
					@if(!isset($data['tem_codigo_barras']) || $data['tem_codigo_barras'])
						<span style="text-align: center; font-size: {{$tamanho_fonte}}px;">{{$codigo}}</span>
					@else
						<span style="text-align: center; font-size: {{$tamanho_fonte}}px; color: #ff0000;">SEM CÓDIGO DE BARRAS</span>
					@endif
				@endif
			</div>
			
			<div style="max-width:40%; float:left; text-align: center;">
				@if($data['valor_produto'])
				<span style="display: flex; text-align: center; font-size: {{$tamanho_fonte+7}}px; margin-top: 24px; margin-left: 20px;">
					<b>R$ {{number_format($data['valor'], 2, ',', '.')}}</b>
				</span>
				@endif
			</div>
		</div>
		@endif
	</div>

	@php
	$contLinha++;
	$contTotal++;
	if($contLinha == $quantidade_por_linhas){
		echo "<br>"; $contLinha = 0;
	}
	@endphp
	@endfor
</div>

<script type="text/javascript">

</script>

<style type="text/css">

	.text-center{
		text-align: center;
	}

	.text-uppercase{
		text-transform: uppercase;
	}

	/*Css related to printing of barcode*/
	.label-border-outer{
		border: 0.1px solid grey !important;
	}
	.label-border-internal{
		/*border: 0.1px dotted grey !important;*/
	}
	.sticker-border{
		border: 0.1px dotted grey !important;
		overflow: hidden;
		box-sizing: border-box;
		padding: 0 !important;
		margin: 0 !important;
	}
	#preview_body{
		padding-left: 30px !important;
		font-size: 0; /* Elimina espaços entre elementos inline-block */
	}
	@media print{
		.content-wrapper{
			border-left: none !important; /*fix border issue on invoice*/
		}
		.label-border-outer{
			border: none !important;
		}
		.label-border-internal{
			border: none !important;
		}
		.sticker-border{
			border: none !important;
		}
		#preview_box{
			padding-left: 0px !important;
		}
		#toast-container{
			display: none !important;
		}
		.tooltip{
			display: none !important;
		}
		.btn{
			display: none !important;
		}
	}

	@media print{
		#preview_body{
			display: block !important;
			font-size: 0; /* Mantém a eliminação de espaços na impressão */
		}
	}
	@page {
		margin-top: 0in;
		margin-bottom: 0in;
		margin-left: 0in;
		margin-right: 0in;
	}
</style>