@section('css')
<link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
<link rel="stylesheet" href="/css/pre-venda-validation.css">
<style>
    /* Layout limpo e moderno para pré-venda */
    body { background-color: #f8f9fc; }
    .pre-venda-container { max-width: 100%; background-color: transparent; }
    .card { background-color: #fff; border: none; border-radius: 0.5rem; box-shadow: 0 0.15rem 1.75rem 0 rgba(58,59,69,.15); }
    .card-header { background-color: #f8f9fc; border-bottom: 1px solid #e3e6f0; padding: 1rem; }
    .card-body { padding: 1rem; }
    
    /* Cabeçalho */
    .header-info { background: linear-gradient(135deg, #4e73df 0%, #224abe 100%); color: white; padding: 1rem; border-radius: 0.5rem; margin-bottom: 1rem; }
    .header-title { font-size: 1.5rem; font-weight: 600; margin: 0; }
    .header-subtitle { font-size: 0.9rem; opacity: 0.9; margin: 0; }
    
    /* Área de busca */
    .search-area { background: #fff; padding: 1rem; border-radius: 0.5rem; margin-bottom: 1rem; box-shadow: 0 0.15rem 1.75rem 0 rgba(58,59,69,.15); }
    .search-input { border: 2px solid #e3e6f0; border-radius: 0.5rem; padding: 0.75rem; font-size: 1rem; }
    .search-input:focus { border-color: #4e73df; box-shadow: 0 0 0 0.2rem rgba(78,115,223,.25); }
    
    /* Campos de produto */
    .product-fields { background: #fff; padding: 1rem; border-radius: 0.5rem; margin-bottom: 1rem; box-shadow: 0 0.15rem 1.75rem 0 rgba(58,59,69,.15); }
    .field-label { font-size: 0.8rem; font-weight: 600; color: #5a5c69; margin-bottom: 0.25rem; }
    .field-input { border: 1px solid #d1d3e2; border-radius: 0.35rem; padding: 0.5rem; font-size: 0.9rem; }
    .field-input:focus { border-color: #4e73df; box-shadow: 0 0 0 0.2rem rgba(78,115,223,.25); }
    
    /* Tabela de produtos */
    .products-table { background: #fff; border-radius: 0.5rem; overflow: hidden; box-shadow: 0 0.15rem 1.75rem 0 rgba(58,59,69,.15); }
    .table { margin: 0; }
    .table thead th { background-color: #f8f9fc; border: none; color: #5a5c69; font-weight: 600; padding: 0.75rem; font-size: 0.85rem; }
    .table tbody td { border: none; border-bottom: 1px solid #e3e6f0; padding: 0.75rem; vertical-align: middle; }
    .table tbody tr:hover { background-color: #f8f9fc; }
    .table tbody tr.selected { background-color: #e3f2fd; }
    
    /* Totais */
    .totals-area { background: #fff; padding: 1rem; border-radius: 0.5rem; box-shadow: 0 0.15rem 1.75rem 0 rgba(58,59,69,.15); }
    .total-item { display: flex; justify-content: space-between; align-items: center; padding: 0.5rem 0; border-bottom: 1px solid #e3e6f0; }
    .total-item:last-child { border-bottom: none; font-weight: 600; font-size: 1.1rem; }
    .total-label { color: #5a5c69; }
    .total-value { font-weight: 600; color: #1cc88a; }
    
    /* Botões */
    .btn { border-radius: 0.35rem; font-weight: 500; padding: 0.5rem 1rem; }
    .btn-success { background-color: #1cc88a; border-color: #1cc88a; }
    .btn-warning { background-color: #f6c23e; border-color: #f6c23e; }
    .btn-danger { background-color: #e74a3b; border-color: #e74a3b; }
    .btn-dark { background-color: #5a5c69; border-color: #5a5c69; }
    
         /* Botões do cabeçalho */
     .btn-outline-light { border-color: rgba(255,255,255,0.5); color: white; }
     .btn-outline-light:hover { background-color: rgba(255,255,255,0.1); border-color: white; color: white; }
     .vendedor-selecionado, .cliente-selecionado { 
         background: rgba(255,255,255,0.1); 
         padding: 0.25rem 0.5rem; 
         border-radius: 0.25rem; 
         border: 1px solid rgba(255,255,255,0.2);
     }
     
     /* Esconder texto solto do Select2 */
     .select2-container + * {
         display: none !important;
     }
     
     /* Responsivo */
     @media (max-width: 768px) {
         .header-title { font-size: 1.2rem; }
         .search-input { font-size: 0.9rem; }
         .btn-outline-light { font-size: 0.8rem; padding: 0.25rem 0.5rem; }
     }
     
     /* Esconder qualquer texto que apareça fora do Select2 modal cliente */
     #modal-cliente .cliente_id + *:not(.select2-container) [object Object]
         display: none !important;
     }
     
     /* Esconder texto solto específico do modal cliente */
     #modal-cliente .input-group > *:not(.select2ontainer):not(.btn) [object Object]
         display: none !important;
     }
     
     /* Garantir que apenas o Select2a no modal cliente */
     #modal-cliente .input-group > select + *:not(.select2-container) [object Object]
         display: none !important;
     }
     
     /* Esconder qualquer elemento que apareça após o select */
     #modal-cliente .cliente_id ~ *:not(.select2ontainer):not(.btn) [object Object]
         display: none !important;
     }
</style>
@endsection

<input type="hidden" id="lista_id" value="" name="lista_id">
<input type="hidden" id="abertura" value="{{ $abertura }}" name="">
<input type="hidden" id="local_id" value="{{ $caixa->localizacao->id }}">
<input type="hidden" id="empresa_id" value="{{ Auth::user()->empresa->empresa->id }}">
<input type="hidden" id="inp-funcionario_id" name="funcionario_id" value="">
<input type="hidden" id="inp-cliente_id" name="cliente_id" value="">
@isset($pedido)
<input name="pedido_id" id="pedido_id" value="{{ $pedido->id }}" class="d-none">
@endif

<div class="pre-venda-container">
    <!-- Cabeçalho -->
    <div class="header-info">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="header-title">Lançamento Pré-Venda</h1>
                <p class="header-subtitle">
                    <i class="ri-store-2-line me-2"></i>Empresa: <strong>{{ Auth::user()->empresa->empresa->nome ?? 'N/A' }}</strong>
                </p>
            </div>
            <div class="col-md-6 text-end">
                <div class="row">
                    <div class="col-6">
                        <p class="header-subtitle mb-2">
                            <i class="ri-user-line me-1"></i>Vendedor
                        </p>
                        <button type="button" class="btn btn-outline-light btn-sm w-100 mb-2" data-bs-toggle="modal" data-bs-target="#modal-funcionario">
                            <i class="ri-user-line me-1"></i>Selecionar Vendedor
                        </button>
                        <div class="vendedor-selecionado">
                            <small class="text-white-50">Vendedor: <strong>LOJA</strong></small>
                        </div>
                    </div>
                    <div class="col-6">
                        <p class="header-subtitle mb-2">
                            <i class="ri-user-3-line me-1"></i>Cliente
                        </p>
                        <button type="button" class="btn btn-outline-light btn-sm w-100 mb-2" data-bs-toggle="modal" data-bs-target="#modal-cliente">
                            <i class="ri-user-3-line me-1"></i>Selecionar Cliente
                        </button>
                        <div class="cliente-selecionado">
                            <small class="text-white-50">Cliente: <strong>CONSUMIDOR FINAL</strong></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Área de Busca -->
    <div class="search-area">
        <div class="row align-items-end mb-3">
            <div class="col-md-4">
                <label class="field-label required-field">Produto</label>
                <select class="form-control" id="codBarras" style="width:100%; min-width: 180px;"></select>
                <div class="error-feedback" id="produto-error" style="display: none;">Selecione um produto</div>
            </div>
            <div class="col-md-1">
                <label class="field-label required-field">Preço</label>
                <input type="text" class="form-control field-input" id="inp-valor_unitario" value="0,00" readonly>
                <div class="error-feedback" id="valor-error" style="display: none;">Valor deve ser maior que zero</div>
            </div>
            <div class="col-md-1">
                <label class="field-label required-field">Qtd</label>
                <input type="text" class="form-control field-input" id="inp-quantidade" value="0,00">
                <div class="error-feedback" id="quantidade-error" style="display: none;">Quantidade deve ser maior que zero</div>
            </div>
            <div class="col-md-2">
                <label class="field-label">Sub Total</label>
                <input type="text" class="form-control field-input" id="inp-subtotal" value="0,00" readonly>
            </div>
            <div class="col-md-2">
                <label class="field-label"><strong>TOTAL</strong></label>
                <input type="text" class="form-control field-input" id="inp-total" value="0,00" readonly style="font-weight: bold;">
            </div>
            <div class="col-md-2 d-grid">
                <label class="invisible">Adicionar</label>
                <button class="btn btn-primary btn-add-item" type="button" id="btn-add-item">
                    <i class="ri-add-circle-line"></i> Adicionar
                </button>
            </div>
        </div>
    </div>

    <!-- Layout principal -->
    <div class="row">
        <!-- Lista de Produtos -->
        <div class="col-md-8">
            <div class="products-table">
                <div class="card-header">
                    <h5 class="mb-0 text-center">Itens da Pré-Venda</h5>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover mb-0 table-itens">
                        <thead>
                            <tr>
                                <th style="width: 100px; text-align:center;">Cód.</th>
                                <th>Produto</th>
                                <th style="width: 60px; text-align:center;">Und</th>
                                <th style="width: 100px; text-align:center;">Qtde</th>
                                <th style="width: 100px; text-align:center;">Valor Unit.</th>
                                <th style="width: 100px; text-align:center;">Sub Total</th>
                                <th style="width: 80px; text-align:center;">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (isset($itens))
                            @foreach ($itens as $key => $product)
                            <tr class="line-product">
                                <input type="hidden" name="key" value="{{ $product->key }}">
                                <td class="text-center">{{ $product->produto->codigo_barras ?? $product->produto->codigo ?? '-' }}</td>
                                <td style="white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width:220px;">
                                    <input type="text" name="produto_nome[]" class="form-control field-input produto_nome" value="{{ $product->produto->nome }}" readonly>
                                </td>
                                <td class="text-center">{{ $product->produto->unidade ?? 'UN' }}</td>
                                <td class="text-center">
                                    <input type="text" name="quantidade[]" class="form-control field-input qtd-item text-center" value="{{ number_format($product->quantidade, 2, ',', '.') }}" readonly>
                                </td>
                                <td class="text-center">
                                    <input type="text" name="valor_unitario[]" class="form-control field-input text-center" value="{{ __moeda($product->valor_unitario) }}" readonly>
                                </td>
                                <td class="text-center">
                                    <input type="text" name="subtotal_item[]" class="form-control field-input subtotal-item text-center" value="{{ __moeda($product->valor_unitario * $product->quantidade) }}" readonly>
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-danger btn-sm btn-delete-row" title="Excluir item">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Totais e Ações -->
        <div class="col-md-4">
            <!-- Totais -->
            <div class="totals-area mb-3">
                <div class="total-item">
                    <span class="total-label">TOTAL</span>
                    <span class="total-value total-venda">R$ {{ isset($item) ? __moeda($item->valor_total) : '0,00' }}</span>
                </div>
                <div class="total-item">
                    <span class="total-label">TOTAL DESC.</span>
                    <span class="total-value">R$ {{ isset($item) ? __moeda($item->desconto ?? 0) : '0,00' }}</span>
                </div>
                <div class="total-item">
                    <span class="total-label">SUBTOTAL</span>
                    <span class="total-value">R$ {{ isset($item) ? __moeda($item->valor_total - ($item->desconto ?? 0)) : '0,00' }}</span>
                </div>
            </div>

            <!-- Botões de Ação -->
            <div class="card mb-3">
                <div class="card-body p-2">
                    <div class="row g-2">
                        <div class="col-12">
                            <button type="button" class="btn btn-success w-100" id="btn_formas_pagamento" disabled>
                                <i class="ri-bank-card-line me-2"></i> Formas de Pagamento
                            </button>
                        </div>
                        <div class="col-12">
                            <a href="{{ route('pre-venda.index') }}" class="btn btn-danger w-100">
                                <i class="ri-close-line me-2"></i> Cancelar
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Observações e Instruções -->
            <div class="card">
                <div class="card-body p-2">
                    <div class="mb-3">
                        <label class="field-label">Observações</label>
                        <textarea class="form-control field-input" rows="3" placeholder="Digite observações..."></textarea>
                    </div>
                    <div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@section('js')
<script src="/js/pre_venda.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
    @if(Session::has('codigo'))
    window.open(path_url + 'pre-venda/imprimir/' + '{{ Session::get('codigo') }}')
    @endif
    
    // Função para atualizar vendedor selecionado
    function atualizarVendedor(id, nome) {
        console.log('Atualizando vendedor:', nome, 'ID:', id);
        
        // Atualizar o campo hidden
        $('#inp-funcionario_id').val(id);
        
        // Atualizar a interface
        $('.vendedor-selecionado strong').text(nome);
        
        // Forçar atualização da interface
        $('.vendedor-selecionado').show();
        
        console.log('Vendedor atualizado na interface:', nome);
        
        // Fechar modal após um pequeno delay
        setTimeout(function() {
            var modal = bootstrap.Modal.getInstance(document.getElementById('modal-funcionario'));
            if (modal) {
                modal.hide();
            } else {
                $('#modal-funcionario').modal('hide');
            }
            console.log('Modal fechado');
        }, 200);
    }
    
    // Função para atualizar cliente selecionado
    function atualizarCliente(id, nome) {
        console.log('Atualizando cliente:', nome, 'ID:', id);
        
        // Atualizar o campo hidden
        $('#inp-cliente_id').val(id);
        
        // Atualizar a interface
        $('.cliente-selecionado strong').text(nome);
        
        // Forçar atualização da interface
        $('.cliente-selecionado').show();
        
        console.log('Cliente atualizado na interface:', nome);
        
        // Fechar modal após um pequeno delay
        setTimeout(function() {
            var modal = bootstrap.Modal.getInstance(document.getElementById('modal-cliente'));
            if (modal) {
                modal.hide();
            } else {
                $('#modal-cliente').modal('hide');
            }
            console.log('Modal cliente fechado');
        }, 200);
    }
    
    // Variáveis globais para controle do fluxo
    let formaPagamentoSelecionada = null;
    let preVendaData = null;
    
    // Função para validar botão de formas de pagamento
    function validarBotaoFormasPagamento() {
        console.log('Validando botão de formas de pagamento...');
        
        // Verificar se o botão existe
        let botao = $('#btn_formas_pagamento');
        if (botao.length === 0) {
            console.error('Botão btn_formas_pagamento não encontrado no DOM!');
            return;
        }
        
        let itensCount = $('.table-itens tbody tr.line-product').length;
        console.log('Número de itens na tabela (line-product):', itensCount);
        
        // Se não encontrar com line-product, tenta com tr simples
        if (itensCount === 0) {
            itensCount = $('.table-itens tbody tr').length;
            console.log('Número de itens na tabela (tr simples):', itensCount);
        }
        
        if (itensCount > 0) {
            botao.removeAttr('disabled');
            console.log('Botão habilitado');
        } else {
            botao.attr('disabled', 'disabled');
            console.log('Botão desabilitado');
        }
    }
    
    // Event listeners para os modais
    $(document).ready(function() {
        // Validar botão de formas de pagamento na inicialização
        setTimeout(function() {
            validarBotaoFormasPagamento();
        }, 500);
        
        // Validar também após um tempo maior para garantir que tudo carregou
        setTimeout(function() {
            validarBotaoFormasPagamento();
        }, 1000);
        
        // Observer para monitorar mudanças na tabela de itens
        const observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.type === 'childList') {
                    validarBotaoFormasPagamento();
                }
            });
        });
        
        // Observar mudanças na tabela de itens
        const tabelaItens = document.querySelector('.table-itens tbody');
        if (tabelaItens) {
            observer.observe(tabelaItens, {
                childList: true,
                subtree: true
            });
        }
        // Configurar Select2 para funcionários no modal
        $('#modal-funcionario').on('shown.bs.modal', function() {
            if (!$('#modal-funcionario .funcionario_id').hasClass('select2-hidden-accessible')) {
                $('#modal-funcionario .funcionario_id').select2({
                    minimumInputLength: 2,
                    language: "pt-BR",
                    placeholder: "Digite para buscar o vendedor",
                    width: "100%",
                    theme: "bootstrap4",
                    dropdownParent: $('#modal-funcionario'),
                    ajax: {
                        cache: true,
                        url: path_url + "api/funcionarios/pesquisa",
                        dataType: "json",
                        data: function (params) {
                            var query = {
                                pesquisa: params.term,
                                empresa_id: $("#empresa_id").val(),
                            };
                            return query;
                        },
                        processResults: function (response) {
                            var results = [];
                            $.each(response, function (i, v) {
                                var o = {};
                                o.id = v.id;
                                o.text = v.nome;
                                o.value = v.id;
                                results.push(o);
                            });
                            return { results: results };
                        },
                    },
                });
            }
        });
        
        // Configurar Select2 para clientes no modal
        $('#modal-cliente').on('shown.bs.modal', function() {
            // Destruir Select2 existente se houver
            if ($('#modal-cliente .cliente_id').hasClass('select2-hidden-accessible')) {
                $('#modal-cliente .cliente_id').select2('destroy');
            }
            
            // Configurar Select2
            $('#modal-cliente .cliente_id').select2({
                minimumInputLength: 2,
                language: "pt-BR",
                placeholder: "Digite para buscar o cliente",
                width: "100%",
                theme: "bootstrap4",
                dropdownParent: $('#modal-cliente'),

                ajax: {
                    cache: true,
                    url: path_url + "api/clientes/pesquisa",
                    dataType: "json",

                    data: function (params) {
                        var query = {
                            pesquisa: params.term,
                            empresa_id: $("#empresa_id").val(),
                        };
                        return query;
                    },
                    processResults: function (response) {
                        var results = [];
                        if (response && response.length > 0) {
                            $.each(response, function (i, v) {
                                var o = {};
                                o.id = v.id;
                                o.text = v.razao_social || v.nome || v.fantasia || 'Cliente ' + v.id;
                                o.value = v.id;
                                results.push(o);
                            });
                        }
                        return { results: results };
                    },
                    error: function(xhr, status, error) {
                        console.error('Erro na API clientes:', error);
                        return { results: [] };
                    }
                },
            });
        });
        
        // Quando um vendedor for selecionado no modal (só atualiza, não fecha)
        $(document).on('change', '#modal-funcionario .funcionario_id', function() {
            var id = $(this).val();
            var nome = $(this).find('option:selected').text();
            console.log('Change event vendedor - ID:', id, 'Nome:', nome);
            if (id && id !== '') {
                // Só atualizar o campo hidden, não fechar o modal
                $('#inp-funcionario_id').val(id);
                console.log('Vendedor selecionado no modal:', nome);
            }
        });
        
        // Quando um cliente for selecionado no modal (só atualiza, não fecha)
        $(document).on('change', '#modal-cliente .cliente_id', function() {
            var id = $(this).val();
            var nome = $(this).find('option:selected').text();
            console.log('Change event cliente - ID:', id, 'Nome:', nome);
            if (id && id !== '') {
                // Só atualizar o campo hidden, não fechar o modal
                $('#inp-cliente_id').val(id);
                console.log('Cliente selecionado no modal:', nome);
            }
        });
        
        // Botão selecionar vendedor (fecha modal e atualiza interface)
        $(document).on('click', '.funcionario-venda', function() {
            var id = $('#modal-funcionario .funcionario_id').val();
            var nome = $('#modal-funcionario .funcionario_id option:selected').text();
            console.log('Botão vendedor clicado - ID:', id, 'Nome:', nome);
            if (id && id !== '') {
                // Atualizar interface
                $('.vendedor-selecionado strong').text(nome);
                console.log('Vendedor confirmado:', nome);
                
                // Fechar modal
                var modal = bootstrap.Modal.getInstance(document.getElementById('modal-funcionario'));
                if (modal) {
                    modal.hide();
                } else {
                    $('#modal-funcionario').modal('hide');
                }
            } else {
                alert('Por favor, selecione um vendedor primeiro.');
            }
        });
        
        // Botão selecionar cliente (fecha modal e atualiza interface)
        $(document).on('click', '.cliente-venda', function() {
            var id = $('#modal-cliente .cliente_id').val();
            var nome = $('#modal-cliente .cliente_id option:selected').text();
            console.log('Botão cliente clicado - ID:', id, 'Nome:', nome);
            if (id && id !== '') {
                // Atualizar interface
                $('.cliente-selecionado strong').text(nome);
                console.log('Cliente confirmado:', nome);
                
                // Fechar modal
                var modal = bootstrap.Modal.getInstance(document.getElementById('modal-cliente'));
                if (modal) {
                    modal.hide();
                } else {
                    $('#modal-cliente').modal('hide');
                }
            } else {
                alert('Por favor, selecione um cliente primeiro.');
            }
        });
        
        // Botão de adicionar item - validar botão após adicionar
        $(document).on('click', '#btn-add-item', function() {
            setTimeout(function() {
                validarBotaoFormasPagamento();
            }, 100);
        });
        
        // Botão de remover item - validar botão após remover
        $(document).on('click', '.btn-delete-row', function() {
            setTimeout(function() {
                validarBotaoFormasPagamento();
            }, 100);
        });
        
        // Debug: Validar botão manualmente (pode ser removido depois)
        $(document).on('keydown', function(e) {
            if (e.ctrlKey && e.key === 'v') {
                console.log('=== DEBUG VALIDAÇÃO ===');
                validarBotaoFormasPagamento();
                console.log('Tabela HTML:', $('.table-itens tbody').html());
                console.log('=== FIM DEBUG ===');
            }
        });
        
        // Botão de formas de pagamento
        $(document).on('click', '#btn_formas_pagamento', function() {
            // Verificar se há itens na pré-venda
            if ($('.table-itens tbody tr').length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Adicione pelo menos um produto antes de prosseguir!'
                });
                return;
            }
            
            // Atualizar valor no modal
            let valorTotal = $('.total-venda').text().replace('R$ ', '').replace('.', '').replace(',', '.');
            $('#valor_venda_modal').text(parseFloat(valorTotal).toFixed(2).replace('.', ','));
            
            // Inicializar campo de desconto
            $('#desconto_modal').val('0,00');
            $('#valor_com_desconto').text('R$ ' + parseFloat(valorTotal).toFixed(2).replace('.', ','));
            
            // Abrir modal de formas de pagamento
            $('#modal_formas_pagamento').modal('show');
        });
        
        // Controle do campo de desconto
        $(document).on('input', '#desconto_modal', function() {
            let valorVenda = parseFloat($('#valor_venda_modal').text().replace(',', '.'));
            let desconto = parseFloat($(this).val().replace('.', '').replace(',', '.'));
            
            if (isNaN(desconto)) desconto = 0;
            if (isNaN(valorVenda)) valorVenda = 0;
            
            let valorComDesconto = valorVenda - desconto;
            if (valorComDesconto < 0) valorComDesconto = 0;
            
            $('#valor_com_desconto').text('R$ ' + valorComDesconto.toFixed(2).replace('.', ','));
        });
        
        // Seleção de forma de pagamento
        $(document).on('click', '.forma-pagamento-btn', function() {
            // Remover seleção anterior
            $('.forma-pagamento-btn').removeClass('selected');
            
            // Selecionar o botão clicado
            $(this).addClass('selected');
            
            // Armazenar dados da forma de pagamento
            formaPagamentoSelecionada = {
                codigo: $(this).data('forma'),
                nome: $(this).data('nome')
            };
            
            // Obter valor do desconto
            let desconto = parseFloat($('#desconto_modal').val().replace('.', '').replace(',', '.'));
            if (isNaN(desconto)) desconto = 0;
            
            // Confirmar forma de pagamento
            Swal.fire({
                icon: 'question',
                title: 'Confirmar Forma de Pagamento',
                allowOutsideClick: false,
                html: `
                    <div class="text-start">
                        <p><strong>Forma de Pagamento:</strong> ${formaPagamentoSelecionada.nome}</p>
                        <p><strong>Valor Original:</strong> R$ ${$('#valor_venda_modal').text()}</p>
                        <p><strong>Desconto:</strong> R$ ${desconto.toFixed(2).replace('.', ',')}</p>
                        <p><strong>Valor Final:</strong> R$ ${$('#valor_com_desconto').text().replace('R$ ', '')}</p>
                    </div>
                `,
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar',
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#6c757d'
            }).then((result) => {
                if (result.isConfirmed) {
                    confirmarImpressao();
                }
            });
        });
        
        // Confirmação de impressão
        function confirmarImpressao() {
            Swal.fire({
                icon: 'question',
                title: 'Imprimir Pré-Venda?',
                allowOutsideClick: false,
                html: `
                    <p>Deseja imprimir a pré-venda após finalizar?</p>
                    <small class="text-muted">
                        <i class="ri-information-line me-1"></i>
                        A impressão será aberta em uma nova aba do navegador.
                    </small>
                `,
                showCancelButton: true,
                showDenyButton: true,
                confirmButtonText: 'Sim, Imprimir',
                denyButtonText: 'Não Imprimir',
                cancelButtonText: 'Cancelar',
                confirmButtonColor: '#28a745',
                denyButtonColor: '#6c757d',
                cancelButtonColor: '#dc3545'
            }).then((result) => {
                if (result.isConfirmed) {
                    finalizarPreVenda(true); // true = imprimir
                } else if (result.isDenied) {
                    finalizarPreVenda(false); // false = não imprimir
                }
            });
        }
        
        // Atalhos de teclado para formas de pagamento
        $(document).on('keydown', function(e) {
            if ($('#modal_formas_pagamento').hasClass('show')) {
                switch(e.key) {
                    case 'F1':
                        e.preventDefault();
                        $('.forma-pagamento-btn[data-forma="01"]').click();
                        break;
                    case 'F2':
                        e.preventDefault();
                        $('.forma-pagamento-btn[data-forma="09"]').click(); // PIX
                        break;
                    case 'F3':
                        e.preventDefault();
                        $('.forma-pagamento-btn[data-forma="03"]').click(); // Cartão Crédito
                        break;
                    case 'F4':
                        e.preventDefault();
                        $('.forma-pagamento-btn[data-forma="04"]').click(); // Cartão Débito
                        break;
                    case 'F5':
                        e.preventDefault();
                        $('.forma-pagamento-btn[data-forma="05"]').click(); // Crédito Loja
                        break;
                    case 'F6':
                        e.preventDefault();
                        $('.forma-pagamento-btn[data-forma="10"]').click(); // Vale Crédito
                        break;
                    case 'F12':
                        e.preventDefault();
                        $('#modal_formas_pagamento').modal('hide');
                        break;
                }
            }
        });
        
        // Função para finalizar pré-venda
        function finalizarPreVenda(imprimir = false) {
            if (!formaPagamentoSelecionada) {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Selecione uma forma de pagamento!'
                });
                return;
            }
            
            // Obter valor do desconto
            let desconto = parseFloat($('#desconto_modal').val().replace('.', '').replace(',', '.'));
            if (isNaN(desconto)) desconto = 0;
            
            // Calcular valor total com desconto
            let valorTotalTexto = $('.total-venda').text().replace('R$ ', '').replace('.', '').replace(',', '.');
            let valorTotal = parseFloat(valorTotalTexto) - desconto;
            
            console.log('Debug valores:', {
                valorTotalTexto: valorTotalTexto,
                desconto: desconto,
                valorTotalFinal: valorTotal
            });
            
            // Coletar dados da pré-venda
            let dados = {
                cliente_id: $('#inp-cliente_id').val() || null,
                funcionario_id: $('#inp-funcionario_id').val() || null,
                tipo_pagamento: formaPagamentoSelecionada.codigo,
                valor_total: valorTotal,
                desconto: desconto,
                observacao: $('textarea[placeholder="Digite observações..."]').val() || '',
                data_vencimento: new Date().toISOString().split('T')[0], // Data atual no formato YYYY-MM-DD
                produto_id: [],
                quantidade: [],
                valor_unitario: [],
                subtotal_item: []
            };
            
            // Coletar itens da tabela
            $('.table-itens tbody tr').each(function() {
                dados.produto_id.push($(this).find('input[name="produto_nome[]"]').attr('data-produto-id') || '');
                dados.quantidade.push($(this).find('input[name="quantidade[]"]').val().replace('.', '').replace(',', '.'));
                dados.valor_unitario.push($(this).find('input[name="valor_unitario[]"]').val().replace('R$ ', '').replace('.', '').replace(',', '.'));
                dados.subtotal_item.push($(this).find('input[name="subtotal_item[]"]').val().replace('R$ ', '').replace('.', '').replace(',', '.'));
            });
            
            // Mostrar loading
            Swal.fire({
                title: 'Finalizando Pré-Venda...',
                text: 'Aguarde enquanto salvamos os dados',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // Enviar dados para o servidor
            $.ajax({
                url: path_url + 'pre-venda',
                method: 'POST',
                data: dados,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    console.log('Resposta do servidor:', response);
                    
                    // Fechar modal de formas de pagamento
                    $('#modal_formas_pagamento').modal('hide');
                    
                    if (imprimir) {
                        console.log('Tentando abrir impressão...');
                        
                        // Verificar se temos o ID da pré-venda (igual ao PDV)
                        let preVendaId = response.id;
                        console.log('ID da pré-venda:', preVendaId);
                        
                        if (preVendaId) {
                            // Tentar abrir impressão em nova aba
                            let printUrl = path_url + 'pre-venda/imprimir/' + response.codigo;
                            console.log('URL da impressão:', printUrl);
                            
                            let printWindow = window.open(printUrl, '_blank');
                            
                            // Verificar se a janela foi aberta com sucesso
                            if (printWindow && !printWindow.closed) {
                                console.log('Janela de impressão aberta com sucesso');
                                
                                // Aguardar um pouco para a página carregar
                                setTimeout(() => {
                                    printWindow.focus();
                                }, 500);
                                
                                // Mostrar sucesso com impressão
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Pré-Venda Finalizada!',
                                    text: 'A pré-venda foi salva com sucesso e a impressão foi aberta em nova aba.',
                                    showConfirmButton: false,
                                    timer: 3000
                                }).then(() => {
                                    // Redirecionar para a listagem
                                    window.location.href = path_url + 'pre-venda';
                                });
                            } else {
                                console.log('Falha ao abrir janela de impressão');
                                
                                // Se a janela não abriu (bloqueador de pop-ups)
                                Swal.fire({
                                    icon: 'warning',
                                    title: 'Pré-Venda Finalizada!',
                                    html: `
                                        <p>A pré-venda foi salva com sucesso!</p>
                                        <p>A impressão não pôde ser aberta automaticamente.</p>
                                        <p><strong>URL da impressão:</strong></p>
                                        <code>${printUrl}</code>
                                        <p class="mt-2">Copie e cole esta URL em uma nova aba para imprimir.</p>
                                        <button class="btn btn-primary mt-2" onclick="window.open('${printUrl}', '_blank')">
                                            <i class="ri-external-link-line me-1"></i>Tentar Abrir Novamente
                                        </button>
                                    `,
                                    confirmButtonText: 'OK',
                                    confirmButtonColor: '#28a745',
                                    showCloseButton: true
                                }).then(() => {
                                    // Redirecionar para a listagem
                                    window.location.href = path_url + 'pre-venda';
                                });
                            }
                        } else {
                            console.log('Código da pré-venda não encontrado na resposta');
                            
                            // Mostrar erro se não tiver código
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro na Impressão',
                                text: 'A pré-venda foi salva, mas não foi possível gerar a impressão. Código não encontrado.',
                                confirmButtonText: 'OK',
                                confirmButtonColor: '#dc3545'
                            }).then(() => {
                                // Redirecionar para a listagem
                                window.location.href = path_url + 'pre-venda';
                            });
                        }
                    } else {
                        // Mostrar sucesso sem impressão
                        Swal.fire({
                            icon: 'success',
                            title: 'Pré-Venda Finalizada!',
                            text: 'A pré-venda foi salva com sucesso.',
                            showConfirmButton: false,
                            timer: 2000
                        }).then(() => {
                            // Redirecionar para a listagem
                            window.location.href = path_url + 'pre-venda';
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.log('Erro na requisição:', xhr.responseText);
                    
                    // Tratar erros igual ao PDV
                    if (xhr.status === 401) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro ao Finalizar',
                            text: xhr.responseText.replace(/"/g, ''),
                            confirmButtonText: 'OK',
                            confirmButtonColor: '#dc3545'
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro ao Finalizar',
                            text: 'Ocorreu um erro ao finalizar a pré-venda. Tente novamente.',
                            confirmButtonText: 'OK',
                            confirmButtonColor: '#dc3545'
                        });
                    }
                }
            });
        }
        

    });
</script>
@endsection

@include('modals._lista_precos')
@include('modals._pagamento_multiplo', ['not_submit' => true])
@include('modals._funcionario', ['not_submit' => true])
@include('modals._variacao', ['not_submit' => true])
@include('modals._cartao_credito', ['not_submit' => true])
@include('modals._cliente', ['cashback' => 0])
@include('modals._formas_pagamento_pre_venda')

