<!DOCTYPE html>
<html>
<head>
    <title>Orçamento #{{ $ordem->codigo_sequencial }}</title>
    <style>
        @page {
            margin: 0.5cm;
        }
        body {
            font-family: 'Helvetica', sans-serif;
            margin: 0;
            padding: 15px;
            color: #333;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #eee;
        }
        .header img {
            max-width: 140px;
            height: auto;
        }
        .header-right {
            text-align: right;
        }
        .header-right h2 {
            color: #2d3748;
            margin: 0;
            font-size: 20px;
        }
        .header-right p {
            color: #666;
            margin: 5px 0;
        }
        .info-container {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            gap: 20px;
        }
        .info-box {
            flex: 1;
            background: #f8f9fa;
            padding: 12px;
            border-radius: 4px;
        }
        .info-box h3 {
            margin: 0 0 8px 0;
            color: #2d3748;
            font-size: 14px;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 5px;
        }
        .info-box p {
            margin: 4px 0;
            font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            font-size: 11px;
        }
        th {
            background: #f1f5f9;
            color: #334155;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 10px;
            padding: 8px;
            text-align: left;
            border-bottom: 2px solid #e2e8f0;
        }
        td {
            padding: 8px;
            border-bottom: 1px solid #e2e8f0;
        }
        .total-box {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 4px;
            text-align: right;
            margin-top: 20px;
        }
        .total-value {
            font-size: 18px;
            color: #2d3748;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
            color: #666;
            font-size: 10px;
            text-align: center;
        }
        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 60px;
            color: rgba(200, 200, 200, 0.1);
            z-index: -1;
            font-weight: bold;
        }
        .description {
            background: #fff;
            padding: 10px;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            margin: 10px 0;
            font-size: 11px;
        }
        .highlight {
            color: #2d3748;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="watermark">ORÇAMENTO</div>
    
    <div class="header">
        <div class="header-left">
            @if($config->logo != "")
            <img src="{{ public_path('logos/'.$config->logo) }}" alt="Logo">
            @endif
        </div>
        <div class="header-right">
            <h2>ORÇAMENTO Nº {{ $ordem->codigo_sequencial }}</h2>
            <p>Data: {{ date('d/m/Y H:i') }}</p>
        </div>
    </div>

    <div class="info-container">
        <div class="info-box">
            <h3>EMPRESA</h3>
            <p><span class="highlight">{{ $config->nome }}</span></p>
            <p>{{ $config->rua }}, {{ $config->numero }} - {{ $config->bairro }}</p>
            <p>{{ $config->cidade->nome }} - {{ $config->cidade->uf }}</p>
            <p>CNPJ/CPF: {{ $config->cpf_cnpj }}</p>
            <p>Tel: {{ $config->celular }}</p>
        </div>
        <div class="info-box">
            <h3>CLIENTE</h3>
            <p><span class="highlight">{{ $ordem->cliente->nome }}</span></p>
            <p>CPF/CNPJ: {{ $ordem->cliente->cpf_cnpj }}</p>
            <p>Tel: {{ $ordem->cliente->celular }}</p>
            <p>Email: {{ $ordem->cliente->email }}</p>
        </div>
    </div>

    @if($ordem->descricao)
    <div class="description">
        <h3>DESCRIÇÃO</h3>
        {!! $ordem->descricao !!}
    </div>
    @endif

    @if(count($ordem->itens) > 0)
    <table>
        <thead>
            <tr>
                <th width="45%">Produto</th>
                <th width="15%">Qtd</th>
                <th width="20%">Valor Unit.</th>
                <th width="20%">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($ordem->itens as $i)
            <tr>
                <td>{{ $i->produto->nome }}</td>
                <td>{{ $i->quantidade }}</td>
                <td>R$ {{ number_format($i->valor, 2, ',', '.') }}</td>
                <td>R$ {{ number_format($i->quantidade * $i->valor, 2, ',', '.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    @if(count($ordem->servicos) > 0)
    <table>
        <thead>
            <tr>
                <th width="45%">Serviço</th>
                <th width="15%">Qtd</th>
                <th width="20%">Valor Unit.</th>
                <th width="20%">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($ordem->servicos as $s)
            <tr>
                <td>{{ $s->servico->nome }}</td>
                <td>{{ $s->quantidade }}</td>
                <td>R$ {{ number_format($s->valor, 2, ',', '.') }}</td>
                <td>R$ {{ number_format($s->quantidade * $s->valor, 2, ',', '.') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    <div class="total-box">
        <span class="total-value">Total: R$ {{ number_format($ordem->valor, 2, ',', '.') }}</span>
    </div>

    <div class="footer">
        <p>Este orçamento tem validade de 7 dias a partir da data de emissão.</p>
        <p>{{ $config->nome }} - CNPJ/CPF: {{ $config->cpf_cnpj }}</p>
    </div>
</body>
</html> 