@extends('layouts.app', ['title' => 'NFCe'])
@section('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
<style>
    .btn-sm {
        width: 32px;
        height: 32px;
        padding: 6px;
        margin-right: 4px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .dropdown-menu {
        position: absolute !important;
        z-index: 1050;
        max-height: 300px;
        overflow-y: auto;
    }

    .table-responsive {
        min-height: 400px;
    }

    .card-body {
        padding-bottom: 80px;
    }

    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
    }

    .table th, .table td {
        vertical-align: middle;
    }
</style>
@endsection
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        @can('nfce_view')
                        <a href="{{ route('nfce.create') }}" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Nova NFCe
                        </a>
                        @endcan
                    </div>
                    <div class="col-md-6 text-end">
                        <button id="btn-consulta-sefaz" class="btn btn-dark">
                            <i class="ri-refresh-line"></i>
                            Consultar Status Sefaz
                        </button>
                    </div>
                </div>
                
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->get()
                    !!}
                    <div class="row g-2">
                        <div class="col-12 col-sm-6 col-md-4 col-lg-4">
                            {!!Form::select('cliente_id', 'Cliente')
                            ->attrs(['class' => 'select2'])
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::date('start_date', 'Data inicial')
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::date('end_date', 'Data final')
                            !!}
                        </div>

                        @if(__countLocalAtivo() > 1)
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2'])
                            !!}
                        </div>
                        @endif

                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::select('estado', 'Estado', [
                                '' => 'Todos',
                                'novo' => 'Novo',
                                'aprovado' => 'Aprovado',
                                'cancelado' => 'Cancelado',
                                'rejeitado' => 'Rejeitado'
                            ])!!}
                        </div>

                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit"> 
                                <i class="ri-search-line"></i> Pesquisar
                            </button>
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <a id="clear-filter" class="btn btn-danger w-100" href="{{ route('nfce.index') }}">
                                <i class="ri-eraser-fill"></i> Limpar
                            </a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                </div>

                <div class="row" style="margin-top: 18px; margin-bottom: 10px;">
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #6c2eb7; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaValores, 2, ',', '.') }}</h5>
                                <small>Soma Valores</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #d32f2f; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaCancelamentos, 2, ',', '.') }}</h5>
                                <small>Soma Cancelamentos</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #ff9800; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaRejeitados, 2, ',', '.') }}</h5>
                                <small>Soma Rejeitados</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #1976d2; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaDescontos, 2, ',', '.') }}</h5>
                                <small>Soma Descontos</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-sm-4 col-md-2 mb-2">
                        <div class="card" style="background-color: #222; color: #fff; min-width: 140px; min-height: 70px;">
                            <div class="card-body py-2 px-3">
                                <h5 class="mb-0">R$ {{ number_format($somaValores - $somaCancelamentos - $somaRejeitados, 2, ',', '.') }}</h5>
                                <small>Soma Recebimentos</small>
                            </div>
                        </div>
                    </div>
                </div>

                @if($contigencia != null)
                <div class="row mt-3">
                    <div class="col-md-3">
                        <div class="card h-100">
                            <div class="card-body">
                                <h4 class="text-danger">Contigência ativada</h4>
                                <p class="text-danger">Tipo: <strong>{{$contigencia->tipo}}</strong></p>
                                <p class="text-danger">Data de ínicio: <strong>{{ __data_pt($contigencia->created_at) }}</strong></p>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                <div class="col-lg-12 mt-4">
                    <div class="table-responsive">
                        <table class="table table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>CPF/CNPJ</th>
                                    @if(__countLocalAtivo() > 1)
                                    <th>Local</th>
                                    @endif
                                    <th>Número</th>
                                    <th>Número Série</th>
                                    <th>Valor</th>
                                    <th>Data de cadastro</th>
                                    <th>Data de emissão</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data as $item)
                                <tr class="{{ 
                                    $item->estado == 'aprovado' ? 'table-success' : 
                                    ($item->estado == 'cancelado' ? 'table-danger' : 
                                    ($item->estado == 'rejeitado' ? 'table-warning' : '')) 
                                }}">
                                    <td>{{ $item->numero_sequencial }}</td>
                                    <td class="text-truncate" style="max-width: 150px">{{ $item->cliente ? $item->cliente->razao_social : ($item->cliente_nome != "" ? $item->cliente_nome : "--") }}</td>
                                    <td>{{ $item->cliente ? $item->cliente->cpf_cnpj : ($item->cliente_cpf_cnpj != "" ? $item->cliente_cpf_cnpj : "--") }}</td>
                                    @if(__countLocalAtivo() > 1)
                                    <td class="text-danger">{{ $item->localizacao->descricao }}</td>
                                    @endif
                                    <td>{{ $item->numero }}</td>
                                    <td>{{ $item->numero_serie }}</td>
                                    <td>{{ number_format($item->total, 2, ',', '.') }}</td>
                                    <td>{{ __data_pt($item->created_at) }}</td>
                                    <td>{{ __data_pt($item->data_emissao) }}</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-outline-secondary btn-sm dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                Ações
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm small">
                                                @if($item->estado == 'aprovado')
                                                <li>
                                                    <a class="dropdown-item text-primary" target="_blank" href="{{ route('nfce.imprimir', [$item->id]) }}">
                                                        <i class="ri-printer-line me-1"></i> Imprimir NFCe
                                                    </a>
                                                </li>
                                                
                                                @can('nfce_transmitir')
                                                <li>
                                                    <button title="Cancelar NFCe" type="button" class="dropdown-item text-danger" onclick="cancelar('{{$item->id}}', '{{$item->numero}}')">
                                                        <i class="ri-close-circle-line me-1"></i> Cancelar NFCe
                                                    </button>
                                                </li>
                                                @endcan
                                                @endif

                                                @if($item->estado == 'aprovado' || $item->estado == 'rejeitado')
                                                <li>
                                                    <button type="button" class="dropdown-item text-dark" onclick="info('{{$item->motivo_rejeicao}}', '{{$item->chave}}', '{{$item->estado}}', '{{$item->recibo}}')">
                                                        <i class="ri-file-line me-1"></i> Informações
                                                    </button>
                                                </li>
                                                @endif

                                                @if($item->estado == 'novo' || $item->estado == 'rejeitado')
                                                @can('nfce_edit')
                                                <li>
                                                    <a class="dropdown-item text-warning" href="{{ route('nfce.edit', $item->id) }}">
                                                        <i class="ri-edit-line me-1"></i> Editar
                                                    </a>
                                                </li>
                                                @endcan

                                                <li>
                                                    <a target="_blank" title="XML temporário" class="dropdown-item text-secondary" href="{{ route('nfce.xml-temp', $item->id) }}">
                                                        <i class="ri-file-line me-1"></i> XML Temporário
                                                    </a>
                                                </li>

                                                @can('nfce_delete')
                                                <li>
                                                    <form action="{{ route('nfce.destroy', $item->id) }}" method="post" id="form-{{$item->id}}">
                                                        @method('delete')
                                                        @csrf
                                                        <button type="button" class="dropdown-item text-danger btn-delete">
                                                            <i class="ri-delete-bin-line me-1"></i> Excluir
                                                        </button>
                                                    </form>
                                                </li>
                                                @endcan

                                                @can('nfce_transmitir')
                                                <li>
                                                    <button title="Transmitir NFCe" type="button" class="dropdown-item text-success" onclick="transmitir('{{$item->id}}')">
                                                        <i class="ri-send-plane-fill me-1"></i> Transmitir
                                                    </button>
                                                </li>
                                                @endcan
                                                @endif

                                                @if($item->estado == 'aprovado' || $item->estado == 'cancelado')
                                                <li>
                                                    <button title="Consultar NFCe" type="button" class="dropdown-item text-info" onclick="consultar('{{$item->id}}', '{{$item->numero}}')">
                                                        <i class="ri-search-eye-line me-1"></i> Consultar
                                                    </button>
                                                </li>
                                                @endif

                                                @can('nfce_edit')
                                                <li>
                                                    <a title="Alterar estado fiscal" class="dropdown-item text-danger" href="{{ route('nfce.alterar-estado', $item->id) }}">
                                                        <i class="ri-arrow-up-down-line me-1"></i> Alterar Estado Fiscal
                                                    </a>
                                                </li>
                                                @endcan

                                                <li>
                                                    <a class="dropdown-item text-primary" title="Detalhes" href="{{ route('nfce.show', $item->id) }}">
                                                        <i class="ri-eye-line me-1"></i> Detalhes
                                                    </a>
                                                </li>

                                                <li>
                                                    <a class="dropdown-item text-danger" title="DANFCE Temporária" target="_blank" href="{{ route('nfce.danfce-temporaria', [$item->id]) }}">
                                                        <i class="ri-printer-fill me-1"></i> DANFCE Temporária
                                                    </a>
                                                </li>

                                                @if($item->estado == 'aprovado')
                                                <li>
                                                    <button title="Enviar Email" type="button" class="dropdown-item text-primary" onclick="enviarEmail('{{$item->id}}', '{{$item->numero}}')">
                                                        <i class="ri-mail-send-line me-1"></i> Enviar Email
                                                    </button>
                                                </li>

                                                <li>
                                                    <a title="Download XML" href="{{ route('nfce.download-xml', [$item->id]) }}" class="dropdown-item text-dark">
                                                        <i class="ri-download-line me-1"></i> Download XML
                                                    </a>
                                                </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">Nada encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {!! $data->appends(request()->all())->links() !!}
                    </div>
                </div>
                <h5 class="mt-3">Soma: <strong class="text-success">R$ {{ __moeda($data->sum('total')) }}</strong></h5>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar NFCe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        {!!Form::text('motivo-cancela', 'Motivo')
                        ->required()

                        !!}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-email" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Enviar email NFCe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        {!!Form::text('email', 'Email')
                        ->required()
                        ->type('email')
                        !!}
                    </div>

                    <div class="col-md-4 mt-2">
                        {!!Form::checkbox('danfe', 'DANFCE Cupom')
                        !!}
                    </div>
                    <div class="col-md-4 mt-2">
                        {!!Form::checkbox('xml', 'XML')
                        !!}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-enviar-email" class="btn btn-success">Enviar Email</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {

        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            text += "Recibo: " + recibo + "\n"
            swal("", text, "success")
        }
    }

    $('#btn-consulta-sefaz').click(() => {
        $.post(path_url + 'api/nfce_painel/consulta-status-sefaz', { 
            empresa_id: $('#empresa_id').val(),
            usuario_id: $('#usuario_id').val(),
        })
        .done((res) => {
            let msg = "cStat: " + res.cStat
            msg += "\nMotivo: " + res.xMotivo
            msg += "\nAmbiente: " + (res.tpAmb == 2 ? "Homologação" : "Produção")
            msg += "\nverAplic: " + res.verAplic

            swal("Sucesso", msg, "success")
        })
        .fail((err) => {
            try{
                swal("Erro", err.responseText, "error")
            }catch{
                swal("Erro", "Algo deu errado", "error")
            }
        })
    })

</script>
<script type="text/javascript" src="/js/nfce_transmitir.js"></script>

<script>
    // Aplica 'dropup' se o dropdown estiver perto do rodapé
    document.querySelectorAll('.dropdown').forEach(function (dropdown) {
        const button = dropdown.querySelector('.dropdown-toggle');
        button.addEventListener('click', function () {
            const rect = dropdown.getBoundingClientRect();
            const isNearBottom = window.innerHeight - rect.bottom < 150;
            if (isNearBottom) {
                dropdown.classList.add('dropup');
            } else {
                dropdown.classList.remove('dropup');
            }
        });
    });
</script>


@endsection
