<div class="modal fade" id="finalizar_venda" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header py-2">
                <h5 class="modal-title" id="staticBackdropLabel">Finalizar Venda <span class="total-venda-modal text-success"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div> 
            <div class="modal-body py-2">
                <div class="alert alert-info mb-2">
                    <div id="resumo-pagamentos-modal">
                        <h5 class="mb-2">Pagamentos Registrados:</h5>
                        <div id="lista-resumo-pagamentos-modal">
                            <div class="text-center">Carregando pagamentos...</div>
                        </div>
                    </div>
                </div>
                <div class="row g-2">
                    <div class="@can('nfce_create') col-md-6 @endcan col-12">
                        <button type="button" class="btn btn-info" id="btn_nao_fiscal" style="height: 40px; width: 100%">
                            <i class="bx bx-file-blank"></i> CUPOM NÃO FISCAL
                        </button>
                    </div>
                    @can('nfce_create')
                    <div class="col-md-6 col-12">
                        <button type="button" class="btn btn-success btn-fiscal" style="height: 40px; width: 100%" data-bs-toggle="modal" data-bs-target="#cpf_nota">
                            <i class="bx bx-file-blank"></i> CUPOM FISCAL
                        </button>
                    </div>
                    @endcan
                </div>
            </div>
        </div> 
    </div> 
</div> 
@include('modals._cpf_nota', ['not_submit' => true])

<script type="text/javascript">
// Verificar se console está disponível para evitar erros
var consoleLog = function(msg) {
    if (window.console && console.log) {
        console.log("[FINALIZAR VENDA]", msg);
    }
};

// Log imediato para verificar se o script está sendo executado
consoleLog("Script de finalização de venda carregado - Timestamp: " + new Date().getTime());

// Função segura para acessar jQuery
var usejQuery = function(callback) {
    if (window.jQuery) {
        callback(window.jQuery);
    } else {
        consoleLog("jQuery não disponível. Tentando novamente em 100ms");
        setTimeout(function() {
            if (window.jQuery) {
                callback(window.jQuery);
            } else {
                consoleLog("jQuery ainda não disponível após espera");
            }
        }, 100);
    }
};

// Função para atualizar resumo - independente de jQuery
function atualizarResumoIndependente() {
    consoleLog("Tentando atualizar resumo sem jQuery");
    
    var resumoElement = document.getElementById('lista-resumo-pagamentos-modal');
    if (!resumoElement) {
        consoleLog("Elemento de resumo não encontrado no DOM");
        return;
    }
    
    if (typeof window.pagamentosRegistradosPDV === 'undefined' || !window.pagamentosRegistradosPDV || window.pagamentosRegistradosPDV.length === 0) {
        consoleLog("Nenhum pagamento encontrado na variável pagamentosRegistradosPDV");
        resumoElement.innerHTML = '<div class="alert alert-warning mb-0 text-center"><i class="bx bx-error me-1"></i>Nenhum pagamento encontrado! Por favor, registre ao menos uma forma de pagamento antes de finalizar a venda.</div>';
        return;
    }
    
    consoleLog("Pagamentos encontrados (sem jQuery): " + window.pagamentosRegistradosPDV.length);
    
    // Obter o valor total da venda (não o valor dos pagamentos)
    var valorTotalVenda = 0;
    if (typeof getValorTotal === 'function') {
        valorTotalVenda = getValorTotal();
        consoleLog("Valor total da venda obtido via getValorTotal(): " + valorTotalVenda);
    } else if (typeof window.valorTotalVenda !== 'undefined') {
        valorTotalVenda = window.valorTotalVenda;
        consoleLog("Valor total da venda obtido via variável global: " + valorTotalVenda);
    } else {
        consoleLog("Método para obter valor total da venda não encontrado");
    }
    
    // Resto da lógica para atualizar o resumo...
    var htmlPagamentos = '';
    var valorTotalPago = 0;
    
    for (var i = 0; i < window.pagamentosRegistradosPDV.length; i++) {
        var pagamento = window.pagamentosRegistradosPDV[i];
        valorTotalPago += parseFloat(pagamento.valor);
        
        // Formatação do valor para exibição
        var valorFormatado = pagamento.valorFormatado || pagamento.valor.toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
        
        htmlPagamentos += '<div class="mb-1"><strong>' + pagamento.tipoNome + ':</strong> R$ ' + valorFormatado;
        
        if (pagamento.detalhes) {
            htmlPagamentos += ' <small class="text-muted">(' + pagamento.detalhes + ')</small>';
        }
        
        htmlPagamentos += '</div>';
    }
    
    // Adicionar o total pago no final
    htmlPagamentos += '<div class="mt-2 pt-2 border-top"><strong>Total Pago:</strong> R$ ' + valorTotalPago.toLocaleString('pt-BR', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    }) + '</div>';
    
    // Calcular e mostrar o troco, se houver
    if (valorTotalVenda > 0 && valorTotalPago > valorTotalVenda) {
        var troco = valorTotalPago - valorTotalVenda;
        htmlPagamentos += '<div class="text-success"><strong>Troco:</strong> R$ ' + troco.toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }) + '</div>';
    }
    
    resumoElement.innerHTML = htmlPagamentos;
    
    // Atualizar o total no título também
    var totalElements = document.getElementsByClassName('total-venda-modal');
    for (var j = 0; j < totalElements.length; j++) {
        if (valorTotalVenda > 0) {
            totalElements[j].textContent = 'R$ ' + valorTotalVenda.toLocaleString('pt-BR', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
        } else {
            totalElements[j].textContent = 'R$ ' + valorTotalPago.toLocaleString('pt-BR', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
        }
    }
    
    consoleLog("Resumo de pagamentos atualizado com sucesso (sem jQuery)");
}

// Atualizar resumo com jQuery
function atualizarResumoPagamentos() {
    usejQuery(function($) {
        try {
            consoleLog("Função atualizarResumoPagamentos chamada (com jQuery)");
            
            // Verificar se há pagamentos registrados
            if (typeof window.pagamentosRegistradosPDV === 'undefined' || !window.pagamentosRegistradosPDV || window.pagamentosRegistradosPDV.length === 0) {
                consoleLog("Nenhum pagamento encontrado na variável global");
                $('#lista-resumo-pagamentos-modal').html('<div class="alert alert-warning mb-0 text-center"><i class="bx bx-error me-1"></i>Nenhum pagamento encontrado! Por favor, registre ao menos uma forma de pagamento antes de finalizar a venda.</div>');
                return;
            }
            
            consoleLog("Pagamentos encontrados: " + window.pagamentosRegistradosPDV.length);
            
            // Obter o valor total da venda (não o valor dos pagamentos)
            let valorTotalVenda = 0;
            if (typeof getValorTotal === 'function') {
                valorTotalVenda = getValorTotal();
                consoleLog("Valor total da venda obtido via getValorTotal(): " + valorTotalVenda);
            } else if (typeof window.valorTotalVenda !== 'undefined') {
                valorTotalVenda = window.valorTotalVenda;
                consoleLog("Valor total da venda obtido via variável global: " + valorTotalVenda);
            } else {
                consoleLog("Método para obter valor total da venda não encontrado");
            }
            
            // Atualizar o resumo de pagamentos
            let htmlPagamentos = '';
            let valorTotalPago = 0;
            
            window.pagamentosRegistradosPDV.forEach(pagamento => {
                valorTotalPago += parseFloat(pagamento.valor);
                
                // Formatação do valor para exibição
                const valorFormatado = pagamento.valorFormatado || pagamento.valor.toLocaleString('pt-BR', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
                
                htmlPagamentos += `<div class="mb-1"><strong>${pagamento.tipoNome}:</strong> R$ ${valorFormatado}`;
                
                if (pagamento.detalhes) {
                    htmlPagamentos += ` <small class="text-muted">(${pagamento.detalhes})</small>`;
                }
                
                htmlPagamentos += '</div>';
            });
            
            // Adicionar o total pago
            htmlPagamentos += `<div class="mt-2 pt-2 border-top"><strong>Total Pago:</strong> R$ ${valorTotalPago.toLocaleString('pt-BR', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            })}</div>`;
            
            // Calcular e mostrar o troco, se houver
            if (valorTotalVenda > 0 && valorTotalPago > valorTotalVenda) {
                const troco = valorTotalPago - valorTotalVenda;
                htmlPagamentos += `<div class="text-success"><strong>Troco:</strong> R$ ${troco.toLocaleString('pt-BR', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })}</div>`;
            }
            
            // Atualizar a lista e o total
            $('#lista-resumo-pagamentos-modal').html(htmlPagamentos);
            
            // Atualizar o título com o valor real da venda, não com o valor dos pagamentos
            if (valorTotalVenda > 0) {
                $('.total-venda-modal').text('R$ ' + valorTotalVenda.toLocaleString('pt-BR', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                }));
            } else {
                // Fallback para o comportamento antigo se não conseguirmos obter o valor da venda
                $('.total-venda-modal').text('R$ ' + valorTotalPago.toLocaleString('pt-BR', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                }));
            }
            
            consoleLog("Resumo de pagamentos atualizado com sucesso");
        } catch (error) {
            consoleLog("Erro ao atualizar resumo: " + error.message);
            // Em caso de erro, tentar método alternativo
            atualizarResumoIndependente();
        }
    });
}

// Configurar de forma segura
function setupEventHandlers() {
    usejQuery(function($) {
        try {
            consoleLog("Configurando manipuladores de eventos");
            
            // Método 1: Usando o evento show.bs.modal do Bootstrap
            $('#finalizar_venda').on('show.bs.modal', function() {
                consoleLog("Evento show.bs.modal capturado!");
                setTimeout(atualizarResumoPagamentos, 50);
            });
            
            // Método 2: Usando click no botão que abre o modal
            $('#finalizar_venda_tab').on('click', function() {
                consoleLog("Botão finalizar_venda_tab clicado");
                setTimeout(atualizarResumoPagamentos, 100);
            });
            
            // Método 3: Diretamente através do botão na navbar ou outro elemento
            $('.btn-abrir-finalizar-venda, [data-bs-target="#finalizar_venda"]').on('click', function() {
                consoleLog("Botão para abrir modal de finalização clicado");
                setTimeout(atualizarResumoPagamentos, 100);
            });
            
            // Método 4: Monitorar mudanças na classe do modal
            const observerConfig = { attributes: true, attributeFilter: ['class'] };
            const observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.type === 'attributes' && $('#finalizar_venda').hasClass('show')) {
                        consoleLog("Modal detectado como visível por MutationObserver");
                        atualizarResumoPagamentos();
                    }
                });
            });
            
            const modalElement = document.getElementById('finalizar_venda');
            if (modalElement) {
                observer.observe(modalElement, observerConfig);
                consoleLog("MutationObserver configurado para o modal");
            }
            
            // Adicionar evento nos botões de finalização dentro do modal
            $('#btn_nao_fiscal').on('click', function() {
                consoleLog("Botão DOCUMENTO AUXILIAR clicado");
            });
            
            $('.btn-fiscal').on('click', function() {
                consoleLog("Botão CUPOM FISCAL clicado");
            });
            
            // Inicializar imediatamente se o modal já estiver aberto
            if ($('#finalizar_venda').hasClass('show') && $('#finalizar_venda').is(':visible')) {
                consoleLog("Modal já está visível na inicialização");
                atualizarResumoPagamentos();
            }
        } catch (error) {
            consoleLog("Erro ao configurar eventos: " + error.message);
        }
    });
}

// Executar quando o documento estiver pronto
if (document.readyState === 'complete' || document.readyState === 'interactive') {
    consoleLog("Documento já está pronto ou interativo");
    setupEventHandlers();
} else {
    document.addEventListener('DOMContentLoaded', function() {
        consoleLog("Evento DOMContentLoaded disparado");
        setupEventHandlers();
    });
}

// Backup: também executar quando a janela estiver carregada
window.addEventListener('load', function() {
    consoleLog("Evento window.load disparado");
    setupEventHandlers();
    
    // Tentar atualizar resumo após um pequeno atraso
    setTimeout(atualizarResumoPagamentos, 500);
});

// Para debug: expor a função de atualização globalmente
window.atualizarResumoVenda = atualizarResumoPagamentos;

// Atualizar diretamente se pagamentosRegistradosPDV já existir
if (typeof window.pagamentosRegistradosPDV !== 'undefined' && window.pagamentosRegistradosPDV && window.pagamentosRegistradosPDV.length > 0) {
    consoleLog("pagamentosRegistradosPDV já existe na carga do script");
    setTimeout(atualizarResumoPagamentos, 200);
}
</script>


