@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Categorias -->
        <div class="col-9">
            <div class="mb-2 d-flex flex-wrap">
                @foreach($categorias as $categoria)
                    <button class="btn btn-outline-primary m-1" onclick="filtrarCategoria('{{ $categoria->id }}')">
                        {{ strtoupper($categoria->nome) }}
                    </button>
                @endforeach
                <button class="btn btn-outline-secondary m-1" onclick="filtrarCategoria('')">TODOS</button>
            </div>
            <!-- Produtos -->
            <div class="row" id="produtosGrid">
                @foreach($produtos as $produto)
                    <div class="col-md-2 mb-3 produto-item" data-categoria="{{ $produto->categoria_id }}">
                        <div class="card h-100" onclick="adicionarProduto({{ $produto->id }}, '{{ $produto->nome }}', {{ $produto->preco }})">
                            <img src="{{ $produto->imagem_url ?? asset('images/sem-foto.png') }}" class="card-img-top" style="height:60px;object-fit:contain;">
                            <div class="card-body p-2 text-center">
                                <div class="fw-bold">{{ $produto->nome }}</div>
                                <div>R$ {{ number_format($produto->preco, 2, ',', '.') }}</div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <!-- Resumo da Comanda -->
        <div class="col-3">
            <div class="card">
                <div class="card-header">Resumo da Comanda</div>
                <div class="card-body p-2">
                    <table class="table table-sm" id="itensComandaTable">
                        <thead>
                            <tr>
                                <th>Produto</th>
                                <th>Qtde</th>
                                <th>Unit.</th>
                                <th>Total</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="itensComandaBody">
                            <!-- Itens adicionados via JS -->
                        </tbody>
                    </table>
                    <div class="d-flex justify-content-between fw-bold">
                        <span>Valor Total</span>
                        <span id="valorTotal">R$ 0,00</span>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-between">
                    <button class="btn btn-danger" onclick="cancelarComanda()">Cancelar</button>
                    <button class="btn btn-success" onclick="finalizarComanda()">Receber e Finalizar</button>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- SweetAlert2 CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let itensComanda = [];

function filtrarCategoria(categoriaId) {
    document.querySelectorAll('.produto-item').forEach(function(item) {
        if (!categoriaId || item.getAttribute('data-categoria') === categoriaId) {
            item.style.display = '';
        } else {
            item.style.display = 'none';
        }
    });
}

function adicionarProduto(id, nome, preco) {
    let item = itensComanda.find(i => i.id === id);
    if (item) {
        item.qtde++;
        item.total = item.qtde * item.preco;
    } else {
        itensComanda.push({id, nome, preco, qtde: 1, total: preco});
    }
    renderItensComanda();
}

function removerProduto(id) {
    itensComanda = itensComanda.filter(i => i.id !== id);
    renderItensComanda();
}

function renderItensComanda() {
    let tbody = document.getElementById('itensComandaBody');
    tbody.innerHTML = '';
    let total = 0;
    itensComanda.forEach(function(item) {
        total += item.total;
        tbody.innerHTML += `<tr>
            <td>${item.nome}</td>
            <td>${item.qtde}</td>
            <td>R$ ${item.preco.toFixed(2).replace('.', ',')}</td>
            <td>R$ ${item.total.toFixed(2).replace('.', ',')}</td>
            <td><button class='btn btn-sm btn-danger' onclick='removerProduto(${item.id})'>X</button></td>
        </tr>`;
    });
    document.getElementById('valorTotal').innerText = 'R$ ' + total.toFixed(2).replace('.', ',');
}

function cancelarComanda() {
    if (confirm('Deseja cancelar a comanda?')) {
        itensComanda = [];
        renderItensComanda();
    }
}

function mostrarAlertaComanda(msg) {
    Swal.fire({
        icon: 'warning',
        title: 'Atenção',
        text: msg,
        confirmButtonText: 'OK'
    });
}

function finalizarComanda() {
    if (itensComanda.length === 0) {
        mostrarAlertaComanda('Adicione ao menos um item!');
        return;
    }
    const mesaComandaId = {{ $mesaComanda->id ?? 'null' }};
    if (!mesaComandaId) {
        mostrarAlertaComanda('ID da comanda não encontrado!');
        return;
    }
    // Montar payload
    const payload = {
        itens: itensComanda.map(item => ({
            produto_id: item.id,
            quantidade: item.qtde,
            valor_unitario: item.preco,
            valor_total: item.total
        }))
    };
    fetch(`/mesa-comandas/${mesaComandaId}/finalizar`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(payload)
    })
    .then(response => response.json())
    .then(data => {
        if (data.redirect) {
            window.location.href = data.redirect;
        } else {
            mostrarAlertaComanda('Comanda finalizada, mas sem redirecionamento.');
        }
    })
    .catch(() => mostrarAlertaComanda('Erro ao finalizar comanda!'));
}
</script>
@endsection 