<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ env("APP_NAME") }} - Sistema ERP para Pequenas Empresas | Gestão Empresarial Completa</title>
    
    <!-- Meta tags SEO -->
    <meta name="description" content="Sistema ERP completo para pequenas empresas e MEIs. Emissão de notas fiscais, controle financeiro, estoque, PDV e muito mais. Experimente grátis o melhor sistema de gestão empresarial.">
    <meta name="keywords" content="sistema erp para pequenas empresas, erp para microempresas, sistema de gestão empresarial, emissão de notas fiscais, controle financeiro, controle de estoque, pdv, nfe, nfce, erp para prestação de serviços, sistema integrado para pequenas empresas, erp online, sistema de gestão para MEI, software empresarial, gestão financeira, controle de vendas">
    <meta name="author" content="{{ env('APP_NAME') }}">
    <meta name="robots" content="index, follow">
    
    <!-- Meta tags Open Graph -->
    <meta property="og:title" content="{{ env('APP_NAME') }} - O Melhor Sistema ERP para Pequenas Empresas">
    <meta property="og:description" content="Sistema ERP completo para pequenas empresas e MEIs. Controle financeiro, estoque, emissão de notas fiscais e muito mais. Teste grátis por 7 dias!">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://{{ env('APP_URL') }}">
    <meta property="og:image" content="https://{{ env('APP_URL') }}/imgs/logo escuro.png">
    
    <!-- Meta tags Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ env('APP_NAME') }} - Sistema ERP Ideal para Pequenas Empresas">
    <meta name="twitter:description" content="Sistema completo de gestão empresarial para pequenas empresas. Controle financeiro, estoque, PDV e emissão de notas fiscais. Comece agora!">
    <meta name="twitter:image" content="https://{{ env('APP_URL') }}/imgs/logo escuro.png">
    
    <!-- Link canônico -->
    <link rel="canonical" href="https://{{ env('APP_URL') }}">
    
    <!-- Metadados estruturados Schema.org -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "SoftwareApplication",
        "name": "{{ env("APP_NAME") }}",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web-based",
        "description": "Sistema ERP completo para pequenas empresas e MEIs. Gestão empresarial simplificada com emissão de notas fiscais, controle financeiro, estoque e PDV.",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "BRL",
            "availability": "https://schema.org/InStock",
            "description": "Teste grátis por 7 dias"
        },
        "aggregateRating": {
            "@type": "AggregateRating",
            "ratingValue": "4.8",
            "reviewCount": "127"
        },
        "featureList": [
            "Emissão de notas fiscais (NFe e NFCe)",
            "Controle de estoque",
            "Gestão financeira",
            "PDV (Ponto de Venda)",
            "Controle de vendas",
            "Gestão de serviços",
            "Relatórios gerenciais"
        ]
    }
    </script>
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="/favicon.ico">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">

    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary: #4254ba;
            --primary-dark: #2a3875;
            --primary-light: #6379c3;
            --primary-rgb: 66, 84, 186;
            --success: #28a745;
            --success-dark: #1e7e34;
            --info: #17a2b8;
            --info-dark: #117a8b;
            --warning: #ffc107;
            --warning-dark: #d39e00;
            --purple: #6f42c1;
            --purple-dark: #553098;
            --pink: #e83e8c;
            --pink-dark: #c21f6a;
            --gradient-1: linear-gradient(135deg, var(--primary-light) 0%, var(--primary) 100%);
            --gradient-2: linear-gradient(45deg, var(--primary) 0%, var(--primary-dark) 100%);
            --gradient-success: linear-gradient(135deg, var(--success) 0%, var(--success-dark) 100%);
            --gradient-info: linear-gradient(135deg, var(--info) 0%, var(--info-dark) 100%);
            --gradient-warning: linear-gradient(135deg, var(--warning) 0%, var(--warning-dark) 100%);
            --gradient-purple: linear-gradient(135deg, var(--purple) 0%, var(--purple-dark) 100%);
            --gradient-pink: linear-gradient(135deg, var(--pink) 0%, var(--pink-dark) 100%);
            --font-sans: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }

        body {
            font-family: var(--font-sans);
            overflow-x: hidden;
            background: #f8fafc;
            color: #1a1a1a;
        }

        /* Scrollbar moderna */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--primary);
            border-radius: 4px;
            transition: all 0.3s ease;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--primary-dark);
        }

        /* Estilos modernos React-like */
        .section-title {
            text-align: center;
            margin-bottom: 3rem;
            position: relative;
        }

        .section-title .badge {
            padding: 0.5rem 1rem;
            font-size: 0.9rem;
            font-weight: 500;
            letter-spacing: 0.5px;
            margin-bottom: 1rem;
            background: rgba(var(--primary-rgb), 0.1);
            border: 1px solid rgba(var(--primary-rgb), 0.2);
            color: var(--primary);
            border-radius: 12px;
        }

        .section-title h2 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            background: linear-gradient(120deg, #2d3748, #1a202c);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            line-height: 1.2;
        }

        .section-title p {
            font-size: 1.1rem;
            color: #64748b;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Cards modernos */
        .modern-card {
            background: white;
            border-radius: 20px;
            padding: 2rem;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
        }

        .modern-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border-color: rgba(var(--primary-rgb), 0.2);
        }

        .modern-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient-1);
            transform: scaleX(0);
            transition: transform 0.3s ease;
            transform-origin: left;
        }

        .modern-card:hover::before {
            transform: scaleX(1);
        }

        /* Botões modernos */
        .btn {
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            border-radius: 12px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            font-size: 1rem;
            letter-spacing: 0.3px;
            text-transform: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .btn i {
            font-size: 1.2em;
            margin-right: 0.25rem;
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(120deg, rgba(255,255,255,0.2), rgba(255,255,255,0));
            transform: translateX(-100%);
            transition: transform 0.5s ease;
        }

        .btn:hover::before {
            transform: translateX(100%);
        }

        .btn-primary {
            background: var(--gradient-1);
            border: none;
            color: white;
        }

        .btn-primary:hover {
            box-shadow: 0 10px 20px rgba(var(--primary-rgb), 0.3);
            transform: translateY(-2px);
        }

        .btn-outline-primary {
            border: 2px solid var(--primary);
            color: var(--primary);
            background: transparent;
        }

        .btn-outline-primary:hover {
            background: var(--gradient-1);
            border-color: transparent;
            color: white;
            transform: translateY(-2px);
        }

        /* Navbar moderna */
        .navbar {
            padding: 1rem 0;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            background: linear-gradient(90deg, #1a2234 70%, #27345a 100%) !important;
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
        }
        .navbar .nav-link, .navbar .navbar-brand {
            color: #fff !important;
        }
        .navbar .nav-link:hover {
            color: #a3bffa !important;
            background: rgba(66, 84, 186, 0.1);
        }
        .navbar.scrolled {
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        .container {
            padding-left: 0 !important;
            margin-left: 0 !important;
            max-width: 100%;
        }

        /* Hero Section */
        .hero-section {
            position: relative;
            overflow: hidden;
            padding: 6rem 0 4rem;
            background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        }

        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at top right, rgba(var(--primary-rgb), 0.1), transparent 70%);
            pointer-events: none;
        }

        .hero-title {
            font-size: 3.5rem;
            font-weight: 800;
            line-height: 1.2;
            margin-bottom: 1.5rem;
            background: linear-gradient(120deg, #1a202c, var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .hero-subtitle {
            font-size: 1.25rem;
            color: #64748b;
            margin-bottom: 2rem;
            line-height: 1.6;
        }

        /* Stats Cards */
        .stats-card {
            background: white;
            border-radius: 20px;
            padding: 2rem;
            text-align: center;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(0, 0, 0, 0.1);
            height: 100%;
        }

        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border-color: rgba(var(--primary-rgb), 0.2);
        }

        .stats-icon {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 16px;
            margin: 0 auto 1.5rem;
            font-size: 2rem;
            background: var(--gradient-1);
            color: white;
        }

        .stats-number {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            background: linear-gradient(120deg, #1a202c, var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .stats-label {
            color: #64748b;
            font-size: 1.1rem;
            margin: 0;
        }

        /* Seções */
        section {
            padding: 4rem 0;
            position: relative;
            overflow: hidden;
        }

        section:nth-child(even) {
            background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        }

        /* Footer moderno */
        .footer {
            background: #1a202c;
            color: white;
            padding: 4rem 0 2rem;
            position: relative;
            overflow: hidden;
        }

        .footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at top right, rgba(255,255,255,0.1), transparent 70%);
            pointer-events: none;
        }

        .footer-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: white;
        }

        .footer-links {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .footer-links li {
            margin-bottom: 1rem;
        }

        .footer-links a {
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .footer-links a:hover {
            color: white;
            transform: translateX(5px);
        }

        .footer-bottom {
            padding-top: 2rem;
            margin-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
            color: rgba(255, 255, 255, 0.7);
        }

        /* Animações */
        [data-aos] {
            pointer-events: none;
        }
        
        [data-aos].aos-animate {
            pointer-events: auto;
        }

        /* Responsividade */
        @media (max-width: 991.98px) {
            .navbar-collapse {
                background: linear-gradient(90deg, #1a2234 70%, #27345a 100%) !important;
                padding: 1rem;
                border-radius: 10px;
                margin-top: 1rem;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            }

            .nav-link::after {
                display: none;
            }

            section {
                padding: 60px 0;
            }

            .section-title h2 {
                font-size: 2rem;
            }
        }

        /* Mobile First - Responsividade Avançada */
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem !important;
                line-height: 1.1 !important;
            }

            .hero-subtitle {
                font-size: 1.1rem !important;
            }

            .section-title h2 {
                font-size: 1.8rem !important;
            }

            .section-title p {
                font-size: 1rem !important;
            }

            .modern-card {
                padding: 1.5rem !important;
                margin-bottom: 1rem;
            }

            .stats-card {
                padding: 1.5rem !important;
                margin-bottom: 1rem;
            }

            .stats-number {
                font-size: 2rem !important;
            }

            .btn {
                padding: 0.75rem 1.25rem !important;
                font-size: 0.95rem !important;
            }

            .showcase-item {
                margin-bottom: 1rem !important;
            }

            .showcase-item img {
                max-height: 200px !important;
            }

            .integration-card {
                padding: 1.5rem !important;
                min-height: 150px !important;
            }

            .integration-logo {
                height: 60px !important;
            }

            .container {
                padding-left: 15px !important;
                padding-right: 15px !important;
            }

            .navbar {
                padding: 0.75rem 0 !important;
            }

            .navbar-brand svg {
                width: 140px !important;
                height: 40px !important;
            }

            main {
                padding-top: 80px !important;
            }
        }

        @media (max-width: 576px) {
            .hero-title {
                font-size: 2rem !important;
            }

            .hero-subtitle {
                font-size: 1rem !important;
            }

            .section-title h2 {
                font-size: 1.5rem !important;
            }

            .modern-card {
                padding: 1.25rem !important;
            }

            .stats-card {
                padding: 1.25rem !important;
            }

            .btn {
                width: 100% !important;
                margin-bottom: 0.5rem;
            }

            .d-flex.gap-3 {
                flex-direction: column !important;
            }

            .showcase-item img {
                max-height: 180px !important;
            }

            .integration-card {
                padding: 1.25rem !important;
                min-height: 120px !important;
            }

            .integration-logo {
                height: 50px !important;
            }

            .footer {
                padding: 2rem 0 1rem !important;
            }

            .footer-links h5 {
                font-size: 1.1rem !important;
            }

            .navbar-nav {
                margin-right: 0 !important;
            }

            .navbar-nav .nav-item {
                margin-bottom: 0.5rem;
            }

            .navbar-nav .nav-item:last-child {
                margin-bottom: 0;
            }
        }

        /* Tablet Responsividade */
        @media (min-width: 769px) and (max-width: 1024px) {
            .hero-title {
                font-size: 3rem !important;
            }

            .section-title h2 {
                font-size: 2.2rem !important;
            }

            .modern-card {
                padding: 1.75rem !important;
            }

            .showcase-item img {
                max-height: 250px !important;
            }
        }

        /* Landscape Mobile */
        @media (max-width: 768px) and (orientation: landscape) {
            .hero-section {
                padding: 3rem 0 2rem !important;
            }

            .hero-title {
                font-size: 2.2rem !important;
            }

            main {
                padding-top: 70px !important;
            }
        }

        /* Touch Device Optimizations */
        @media (hover: none) and (pointer: coarse) {
            .modern-card:hover {
                transform: none !important;
            }

            .showcase-item:hover {
                transform: none !important;
            }

            .btn:hover {
                transform: none !important;
            }

            .stats-card:hover {
                transform: none !important;
            }
        }

        /* Cards de Recursos */
        .resource-card {
            background: white;
            border-radius: 20px;
            padding: 2rem;
            text-align: left;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(0, 0, 0, 0.05);
        }

        .resource-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border-color: var(--primary);
        }

        .resource-card::before {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            background: linear-gradient(45deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 100%);
            z-index: 0;
        }

        .card-icon {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 16px;
            margin: 0 auto 1.5rem;
            font-size: 2rem;
            background: var(--gradient-1);
            color: white;
        }

        .card-icon img {
            width: 32px;
            height: 32px;
            object-fit: contain;
        }

        .card-icon i {
            font-size: 32px;
        }

        .card-icon::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: -100%;
            background: linear-gradient(90deg, rgba(255,255,255,0) 0%, rgba(255,255,255,0.2) 50%, rgba(255,255,255,0) 100%);
            transition: all 0.5s ease;
        }

        .resource-card:hover .card-icon::after {
            left: 100%;
        }

        .resource-card h4 {
            color: #2d3748;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            position: relative;
        }

        .feature-list {
            list-style: none;
            padding: 0;
            margin: 0;
            position: relative;
            z-index: 1;
        }

        .feature-list li {
            padding: 0.75rem 0;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            color: #4a5568;
            font-size: 1rem;
            transition: all 0.3s ease;
            position: relative;
            padding-left: 1.75rem;
        }

        .feature-list li i {
            color: var(--primary);
            font-size: 1.25rem;
            margin-right: 0.5rem;
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
        }

        .feature-list li:hover {
            color: var(--primary);
            transform: translateX(5px);
        }

        .bg-gradient-purple {
            background: var(--gradient-purple);
        }

        .bg-gradient-pink {
            background: var(--gradient-pink);
        }

        /* Showcase de Recursos */
        .resource-showcase {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        }

        .showcase-item {
            padding: 1.5rem;
            border-radius: 15px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.8);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .showcase-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .showcase-item i {
            font-size: 2rem;
            margin-bottom: 1rem;
        }

        .showcase-item h5 {
            margin-bottom: 0.5rem;
            font-weight: 600;
        }

        .showcase-item p {
            margin-bottom: 0;
            font-size: 0.9rem;
            color: #6c757d;
        }

        /* Cards de Integração */
        .integration-showcase {
            background: white;
            border-radius: 20px;
            padding: 3rem 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        }

        .integration-card {
            padding: 2rem;
            border-radius: 15px;
            background: white;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100%;
            min-height: 180px;
        }

        .integration-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            background: #f8f9fa;
        }

        .integration-logo {
            width: 100% !important;
            height: 80px !important;
            object-fit: contain !important;
            margin-bottom: 1.5rem;
            transition: all 0.3s ease;
        }

        .integration-card:hover .integration-logo {
            transform: scale(1.1);
        }

        .integration-card h5 {
            margin-bottom: 0;
            font-size: 1.1rem;
            color: #495057;
            font-weight: 600;
            text-align: center;
        }

        /* Showcase do Sistema */
        .system-showcase {
            position: relative;
            padding: 2rem 0;
        }

        .showcase-item {
            position: relative;
            overflow: hidden;
            border-radius: 24px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            height: 100%;
            cursor: pointer;
        }

        .showcase-item.large {
            height: 100%;
        }

        .showcase-item img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            filter: brightness(0.95);
        }

        .showcase-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(0deg, 
                rgba(0,0,0,0.9) 0%, 
                rgba(0,0,0,0.8) 20%,
                rgba(0,0,0,0) 100%);
            padding: 2.5rem;
            color: white;
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .showcase-item:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
            border-color: rgba(var(--primary-rgb), 0.3);
        }

        .showcase-item:hover .showcase-overlay {
            opacity: 1;
            transform: translateY(0);
        }

        .showcase-item:hover img {
            transform: scale(1.05);
            filter: brightness(1);
        }

        .showcase-overlay h4 {
            font-size: 1.75rem;
            font-weight: 700;
            margin-bottom: 0.75rem;
            background: linear-gradient(120deg, #fff, #e0e0e0);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            opacity: 0;
            transform: translateY(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) 0.1s;
        }

        .showcase-overlay p {
            font-size: 1.1rem;
            margin-bottom: 0;
            opacity: 0;
            transform: translateY(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) 0.2s;
            color: rgba(255, 255, 255, 0.9);
        }

        .showcase-item:hover .showcase-overlay h4,
        .showcase-item:hover .showcase-overlay p {
            opacity: 1;
            transform: translateY(0);
        }

        .showcase-item::before {
            content: '';
            position: absolute;
            inset: 0;
            background: radial-gradient(
                circle at top right,
                rgba(var(--primary-rgb), 0.15),
                transparent 50%
            );
            opacity: 0;
            transition: opacity 0.4s ease;
            z-index: 1;
            pointer-events: none;
        }

        .showcase-item::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(
                45deg,
                rgba(var(--primary-rgb), 0.1),
                transparent 40%
            );
            opacity: 0;
            transition: opacity 0.4s ease;
            z-index: 1;
            pointer-events: none;
        }

        .showcase-item:hover::before,
        .showcase-item:hover::after {
            opacity: 1;
        }

        .showcase-badge {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            padding: 0.5rem 1rem;
            border-radius: 12px;
            color: white;
            font-size: 0.9rem;
            font-weight: 500;
            opacity: 0;
            transform: translateY(-10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 2;
        }

        .showcase-item:hover .showcase-badge {
            opacity: 1;
            transform: translateY(0);
        }

        @media (max-width: 991.98px) {
            .showcase-item {
                margin-bottom: 1.5rem;
            }

            .showcase-overlay {
                opacity: 1;
                transform: translateY(0);
                padding: 1.5rem;
            }

            .showcase-overlay h4,
            .showcase-overlay p {
                opacity: 1;
                transform: translateY(0);
            }

            .showcase-badge {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Animação de Pulse para chamar atenção */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }

        .showcase-pulse {
            animation: pulse 2s infinite;
        }

        /* Container com background moderno */
        .modern-container {
            background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.05) 100%);
            backdrop-filter: blur(10px);
            border-radius: 30px;
            padding: 3rem;
            border: 1px solid rgba(255,255,255,0.1);
        }
        .navbar-nav {
            margin-right: 32px !important;
        }
        .navbar-nav .nav-item:last-child {
            margin-right: 16px !important;
        }
        .navbar .btn-outline-primary {
            border: 2px solid #fff !important;
            color: #fff !important;
            background: transparent !important;
        }
        .navbar .btn-outline-primary i {
            color: #fff !important;
        }
        .navbar .btn-outline-primary:hover, .navbar .btn-outline-primary:focus {
            background: rgba(255,255,255,0.1) !important;
            color: #fff !important;
            border-color: #fff !important;
            box-shadow: 0 0 0 0.15rem rgba(255,255,255,0.2);
        }
        .navbar .btn-outline-primary:hover i, .navbar .btn-outline-primary:focus i {
            color: #fff !important;
        }
        .navbar-light .navbar-toggler {
            border-color: rgba(255,255,255,0.7);
            background: transparent !important;
        }
        .navbar-light .navbar-toggler:focus, .navbar-light .navbar-toggler:active {
            background: rgba(255,255,255,0.05) !important;
            outline: none;
            box-shadow: 0 0 0 0.15rem rgba(255,255,255,0.2);
        }
        .navbar-light .navbar-toggler-icon {
            background-image: url("data:image/svg+xml;charset=utf8,%3Csvg viewBox='0 0 30 30' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath stroke='rgba%28255,255,255,1%29' stroke-width='2' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3E%3C/svg%3E");
            filter: none;
        }
        .navbar-collapse {
            background: linear-gradient(90deg, #1a2234 70%, #27345a 100%) !important;
        }
        .navbar-collapse .nav-link {
            color: #fff !important;
        }
        .navbar-collapse .nav-link:hover {
            color: #a3bffa !important;
            background: rgba(66, 84, 186, 0.1);
        }
    </style>

  
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=GTM-MKLH896S"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'GTM-MKLH896S');
    </script>


</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white py-3 fixed-top">
        <div class="container">
            <a class="navbar-brand" href="/" style="margin-left:32px;padding-left:0;">
                <svg width="180" height="50" viewBox="0 0 200 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <text x="0" y="38" font-family="'Inter', Arial, sans-serif" font-size="34" font-weight="bold" fill="#fff" letter-spacing="2">
                        NEXT
                    </text>
                    <text x="120" y="38" font-family="'Inter', Arial, sans-serif" font-size="34" font-weight="bold" fill="#7ec4fa" letter-spacing="2">
                        ERP
                    </text>
                </svg>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="#recursos">Recursos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#integracoes">Integrações</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contato">Contato</a>
                    </li>
                    <li class="nav-item ms-lg-3">
                        <a class="btn btn-outline-primary" href="{{ route('login') }}">
                            <i class="ri-login-circle-line me-2"></i>Acessar Sistema
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main style="padding-top: 90px">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-4">
                    <div class="footer-logo">
                        <picture>
                            <source srcset="{{ asset('imgs/optimized/logo-branco.avif') }}" type="image/avif">
                            <source srcset="{{ asset('imgs/optimized/logo-branco.webp') }}" type="image/webp">
                            <!-- <img src="{{ asset('imgs/optimized/logo-branco.png') }}" alt="{{ env('APP_NAME') }} Logo" width="150" height="50" loading="lazy"> -->
                        </picture>
                        <p class="mt-3 text-white-50">Sistema ERP completo para gestão empresarial. Simplifique sua gestão e aumente seus resultados.</p>
                    </div>
                </div>
                <div class="col-lg-2">
                    <div class="footer-links">
                        <h5>Links Rápidos</h5>
                        <ul>
                            <li><a href="#recursos">Recursos</a></li>
                            <li><a href="#integracoes">Integrações</a></li>
                            <li><a href="#contato">Contato</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="footer-links">
                        <h5>Contato</h5>
                        <ul>
                            <li>
                                <a href="tel:+5584996662713">
                                    <i class="ri-phone-line me-2"></i>(84) 99666-2713
                                </a>
                            </li>
                            <li>
                                <a href="tel:+5584996662713">
                                    <i class="ri-phone-line me-2"></i>(84) 99666-2713
                                </a>
                            </li>
                            <li>
                                <a href="https://instagram.com/" target="_blank">
                                    <i class="ri-instagram-line me-2"></i>@
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="footer-bottom text-center">
                <p class="mb-0">&copy; {{ date('Y') }} {{ env("APP_NAME") }}. Todos os direitos reservados.</p>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- Custom Scripts -->
    <script>
        // Inicializa AOS
        AOS.init({
            duration: 1000,
            once: true
        });

        // Animação dos números
        $(document).ready(function() {
            $('.counter').each(function() {
                var $this = $(this);
                var countTo = $this.attr('data-count');
                
                $({ countNum: 0 }).animate({
                    countNum: countTo
                }, {
                    duration: 2000,
                    easing: 'swing',
                    step: function() {
                        $this.text(Math.floor(this.countNum));
                    },
                    complete: function() {
                        $this.text(this.countNum);
                    }
                });
            });
        });

        // Smooth scroll para links do menu
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    window.scrollTo({
                        top: target.offsetTop - 90,
                        behavior: 'smooth'
                    });
                }
            });
        });

        // Navbar scroll
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled', 'shadow-sm');
            } else {
                navbar.classList.remove('scrolled', 'shadow-sm');
            }
        });

        // Carousel autoplay
        $('.carousel').carousel({
            interval: 3000
        });
    </script>
</body>
</html> 