@extends('layouts.app', ['title' => 'Selecionar Produtos'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12 d-flex justify-content-between align-items-center mb-3">
                    <h4>Selecionar Produtos - Inventário #{{ $inventario->numero_sequencial }}</h4>
                    <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-success">
                        <i class="ri-list-check-line"></i> Opções de Contagem
                    </a>
                </div>
                <p class="text-muted">
                    Selecione os produtos que farão parte deste inventário. Você pode filtrar por nome, código ou categoria.
                </p>
                <hr>
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif
                
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Informações do Inventário</h5>
                                <div class="mt-3">
                                    <p><strong>Referência:</strong> {{ $inventario->referencia }}</p>
                                    <p><strong>Tipo:</strong> {{ \App\Models\Inventario::tipos()[$inventario->tipo] ?? 'Não definido' }}</p>
                                    <p><strong>Data de Início:</strong> {{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</p>
                                </div>
                                <div class="mt-3">
                                    <strong>Produtos selecionados:</strong> 
                                    <span class="badge bg-primary">{{ count($produtosAdicionados) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card border">
                            <div class="card-body">
                                <h5>Filtrar Produtos</h5>
                                <form action="{{ route('processo-inventario.selecionar', $inventario->id) }}" method="GET" class="mt-3">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <input type="text" class="form-control" name="busca" placeholder="Buscar por nome ou código" 
                                                    value="{{ request()->busca }}">
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <select class="form-select" name="categoria_id">
                                                    <option value="">Todas as categorias</option>
                                                    @foreach($categorias as $categoria)
                                                        <option value="{{ $categoria->id }}" {{ request()->categoria_id == $categoria->id ? 'selected' : '' }}>
                                                            {{ $categoria->nome }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <div class="mb-3 d-flex">
                                                <select class="form-select me-1" name="order_by">
                                                    <option value="produtos.nome" {{ request()->order_by == 'produtos.nome' || !request()->order_by ? 'selected' : '' }}>Ordenar por Nome</option>
                                                    <option value="produtos.id" {{ request()->order_by == 'produtos.id' ? 'selected' : '' }}>Ordenar por ID</option>
                                                    <option value="produtos.codigo_barras" {{ request()->order_by == 'produtos.codigo_barras' ? 'selected' : '' }}>Ordenar por Código de Barras</option>
                                                </select>
                                                <select class="form-select" name="order_dir">
                                                    <option value="asc" {{ request()->order_dir == 'asc' || !request()->order_dir ? 'selected' : '' }}>Crescente</option>
                                                    <option value="desc" {{ request()->order_dir == 'desc' ? 'selected' : '' }}>Decrescente</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-2">
                                            <button type="submit" class="btn btn-primary w-100">
                                                <i class="ri-search-line"></i> Aplicar
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                
                <form action="{{ route('processo-inventario.adicionar-produtos', $inventario->id) }}" method="POST">
                    @csrf
                    <div class="row mb-3">
                        <div class="col-md-12 d-flex justify-content-between align-items-center">
                            <h5>Produtos Disponíveis</h5>
                            <button type="submit" class="btn btn-success" id="btn-adicionar">
                                <i class="ri-add-line"></i> Adicionar Selecionados
                            </button>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th width="50">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkTodos">
                                        </div>
                                    </th>
                                    <th>ID</th>
                                    <th>Código de Barras</th>
                                    <th>Nome</th>
                                    <th>Categoria</th>
                                    <th>Marca</th>
                                    <th width="120">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($produtos as $produto)
                                <tr class="{{ in_array($produto->id, $produtosAdicionados) ? 'table-success' : '' }}">
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input produto-check" type="checkbox" name="produtos[]" 
                                                value="{{ $produto->id }}" {{ in_array($produto->id, $produtosAdicionados) ? 'checked disabled' : '' }}>
                                        </div>
                                    </td>
                                    <td>{{ $produto->id }}</td>
                                    <td>{{ $produto->codigo_barras }}</td>
                                    <td>{{ $produto->nome }}</td>
                                    <td>{{ $produto->categoria_nome }}</td>
                                    <td>{{ $produto->marca_nome }}</td>
                                    <td>
                                        @if(in_array($produto->id, $produtosAdicionados))
                                            <span class="badge bg-success">Adicionado</span>
                                        @else
                                            <span class="badge bg-secondary">Disponível</span>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">Nenhum produto encontrado.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center mt-3">
                        {{ $produtos->links() }}
                    </div>
                </form>
                
                <hr class="my-4">
                
                <div class="row">
                    <div class="col-md-12">
                        <h5>Produtos Adicionados ao Inventário</h5>
                        <div class="mt-3">
                            @if(count($produtosAdicionados) > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th>ID</th>
                                                <th>Código de Barras</th>
                                                <th>Nome</th>
                                                <th>Quantidade</th>
                                                <th width="100">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($inventario->itens as $item)
                                            <tr class="{{ $item->quantidade > 0 ? 'table-info' : 'table-success' }}">
                                                <td>{{ $item->produto->id }}</td>
                                                <td>{{ $item->produto->codigo_barras }}</td>
                                                <td>{{ $item->produto->nome }}</td>
                                                <td>{{ $item->quantidade > 0 ? number_format($item->quantidade, 2, ',', '.') : 'Não contado' }}</td>
                                                <td>
                                                    <a href="{{ route('processo-inventario.remover-produto', [$inventario->id, $item->id]) }}" 
                                                       class="btn btn-sm btn-outline-danger" 
                                                       title="Remover"
                                                       onclick="return confirm('Tem certeza que deseja remover este produto do inventário?');">
                                                        <i class="ri-delete-bin-line"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-warning">
                                    <i class="ri-information-line"></i> Nenhum produto foi adicionado a este inventário ainda.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <a href="{{ route('processo-inventario.index') }}" class="btn btn-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar para Lista de Inventários
                        </a>
                        
                        @if(count($produtosAdicionados) > 0)
                            <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-primary">
                                <i class="ri-arrow-right-line"></i> Próximo: Opções de Contagem
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        // Marcar/desmarcar todos os checkboxes
        $('#checkTodos').change(function() {
            $('.produto-check:not(:disabled)').prop('checked', $(this).prop('checked'));
            updateButtonStatus();
        });
        
        // Atualizar status do botão quando um checkbox é alterado
        $('.produto-check').change(function() {
            updateButtonStatus();
        });
        
        // Função para atualizar o status do botão
        function updateButtonStatus() {
            if ($('.produto-check:checked:not(:disabled)').length > 0) {
                $('#btn-adicionar').prop('disabled', false);
            } else {
                $('#btn-adicionar').prop('disabled', true);
            }
        }
        
        // Inicializar o status do botão
        updateButtonStatus();
    });
</script>
@endsection

@section('css')
<style>
    .table-success {
        background-color: #d1e7dd !important;
    }
    .table-info {
        background-color: #cff4fc !important;
    }
</style>
@endsection 