<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Listagem para Contagem de Inventário</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            border-bottom: 1px solid #ccc;
        }
        .header h1 {
            font-size: 18px;
            margin: 0;
            padding: 0;
        }
        .header h2 {
            font-size: 14px;
            margin: 5px 0;
            padding: 0;
            font-weight: normal;
        }
        .info {
            margin-bottom: 20px;
        }
        .info-item {
            margin-bottom: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table thead th {
            padding: 8px;
            background-color: #f2f2f2;
            border: 1px solid #ddd;
            font-size: 11px;
            text-align: left;
        }
        table tbody td {
            padding: 8px;
            border: 1px solid #999;
            font-size: 10px;
        }
        /* Estilo zebrado alternado com cor mais destacada */
        table tbody tr:nth-child(even) {
            background-color: #f2f2f2; /* Cinza claro */
        }
        table tbody tr:nth-child(odd) {
            background-color: #ffffff; /* Branco */
        }
        /* Classe para os campos de preenchimento */
        .quantidade, .observacao {
            height: 25px;
            border: 1px solid #999;
            background-color: #fff !important; /* Fundo branco para campos de preenchimento */
            position: relative;
        }
        .footer {
            margin-top: 20px;
            font-size: 10px;
            text-align: center;
            font-style: italic;
        }
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>LISTAGEM PARA CONTAGEM DE INVENTÁRIO</h1>
        <h2>{{ $inventario->referencia }}</h2>
    </div>
    
    <div class="info">
        <div class="info-item"><strong>Número:</strong> {{ $inventario->numero_sequencial }}</div>
        <div class="info-item"><strong>Data:</strong> {{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</div>
        <div class="info-item"><strong>Responsável:</strong> {{ $inventario->usuario ? $inventario->usuario->name : 'Não definido' }}</div>
        <div class="info-item"><strong>Total de Produtos:</strong> {{ count($itens) }}</div>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Código de Barras</th>
                <th>Produto</th>
                <th>Quantidade</th>
                <th>Observação</th>
            </tr>
        </thead>
        <tbody>
            @foreach($itens as $item)
            <tr>
                <td>{{ $item->produto->id }}</td>
                <td>{{ $item->produto->codigo_barras }}</td>
                <td>{{ $item->produto->nome }}</td>
                <td class="quantidade"></td>
                <td class="observacao"></td>
            </tr>
            @endforeach
        </tbody>
    </table>
    
    <div class="footer">
        <p>Este documento é parte do processo de inventário. Use-o para anotar as quantidades contadas fisicamente.</p>
        <p>Data de impressão: {{ date('d/m/Y H:i') }}</p>
    </div>
</body>
</html> 