@extends('layouts.app', ['title' => 'Confirmar Finalização do Inventário'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <h4 class="mb-3 text-danger"><i class="ri-alert-line"></i> Confirmar Finalização do Inventário #{{ $inventario->numero_sequencial }}</h4>
                    <p class="text-muted">
                        Você está prestes a finalizar o inventário e atualizar o estoque dos produtos de acordo com a contagem realizada.
                        Este processo irá:
                    </p>
                    
                    <ul class="list-group mb-4">
                        <li class="list-group-item list-group-item-danger">
                            <strong>1. ZERAR o estoque atual de todos os produtos contados</strong>
                        </li>
                        <li class="list-group-item list-group-item-danger">
                            <strong>2. Aplicar as quantidades contadas como novo estoque</strong>
                        </li>
                        <li class="list-group-item list-group-item-danger">
                            <strong>3. Marcar o inventário como FINALIZADO</strong>
                        </li>
                    </ul>
                    
                    <div class="alert alert-danger">
                        <h5><i class="ri-error-warning-line"></i> ATENÇÃO!</h5>
                        <p>
                            <strong>Este processo não pode ser desfeito!</strong> Uma vez finalizado, o estoque será permanentemente alterado.
                            Certifique-se de que todas as contagens estão corretas antes de prosseguir.
                        </p>
                    </div>
                </div>
                
                <hr class="mt-3">
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif
                
                @if(session('flash_warning'))
                <div class="alert alert-warning">
                    {{ session('flash_warning') }}
                </div>
                @endif
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Resumo do Inventário</h5>
                                <div class="row mt-3">
                                    <div class="col-md-4">
                                        <p><strong>Referência:</strong> {{ $inventario->referencia }}</p>
                                        <p><strong>Data de Início:</strong> {{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</p>
                                    </div>
                                    <div class="col-md-4">
                                        <p><strong>Tipo:</strong> {{ \App\Models\Inventario::tipos()[$inventario->tipo] ?? 'Não definido' }}</p>
                                        <p><strong>Produtos Contados:</strong> {{ $itensContados }}</p>
                                    </div>
                                    <div class="col-md-4">
                                        <p><strong>Status Atual:</strong> 
                                            @if($inventario->status == 1)
                                                <span class="badge bg-success">Ativo</span>
                                            @else
                                                <span class="badge bg-secondary">{{ $inventario->status }}</span>
                                            @endif
                                        </p>
                                        <p><strong>Responsável:</strong> {{ $inventario->usuario ? $inventario->usuario->name : 'Não definido' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <h5>Produtos que terão o estoque atualizado ({{ count($itens) }})</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Código de Barras</th>
                                        <th>Produto</th>
                                        <th>Estoque Atual</th>
                                        <th>Quantidade Contada</th>
                                        <th>Diferença</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($itens as $item)
                                    <tr>
                                        <td>{{ $item->produto->id }}</td>
                                        <td>{{ $item->produto->codigo_barras }}</td>
                                        <td>{{ $item->produto->nome }}</td>
                                        <td class="text-end">{{ number_format($item->produto->estoque ? $item->produto->estoque->quantidade : 0, 2, ',', '.') }}</td>
                                        <td class="text-end">{{ number_format($item->quantidade, 2, ',', '.') }}</td>
                                        <td class="text-end {{ ($item->produto->estoque ? $item->quantidade - $item->produto->estoque->quantidade : $item->quantidade) > 0 ? 'text-success' : 'text-danger' }}">
                                            {{ number_format($item->produto->estoque ? $item->quantidade - $item->produto->estoque->quantidade : $item->quantidade, 2, ',', '.') }}
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <form action="{{ route('processo-inventario.finalizar', $inventario->id) }}" method="POST" id="formFinalizar">
                    @csrf
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="confirmacao" required>
                                <label class="form-check-label" for="confirmacao">
                                    <strong class="text-danger">Confirmo que desejo finalizar este inventário e estou ciente que o estoque será zerado e depois atualizado com as quantidades contadas.</strong>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12 d-flex justify-content-between">
                            <a href="{{ route('processo-inventario.comparar', $inventario->id) }}" class="btn btn-secondary">
                                <i class="ri-arrow-left-line"></i> Voltar
                            </a>
                            <button type="submit" class="btn btn-danger" id="btnFinalizar" disabled>
                                <i class="ri-check-double-line"></i> Finalizar Inventário
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        // Habilitar o botão de finalizar apenas quando a confirmação for marcada
        $('#confirmacao').change(function() {
            if($(this).is(':checked')) {
                $('#btnFinalizar').prop('disabled', false);
            } else {
                $('#btnFinalizar').prop('disabled', true);
            }
        });
        
        // Confirmação adicional ao submeter o formulário
        $('#formFinalizar').submit(function(e) {
            if (!confirm('ATENÇÃO: Esta operação irá ZERAR e ATUALIZAR o estoque de todos os produtos. Confirma que deseja prosseguir?')) {
                e.preventDefault();
                return false;
            }
            
            return true;
        });
    });
</script>
@endsection 