@php
$title = 'Configurações Financeiras - {{ env('APP_NAME') }}';
@endphp
@extends('layouts.app')

@section('content')
<div class="container-fluid px-4">
    <div class="mb-2 mt-2">
        <div class="row">
            <div class="col-md-6">
                <h3 class="h4"><i class="fas fa-cog"></i> Configurações Financeiras</h3>
            </div>
            <div class="col-md-6 text-right">
                <a href="{{ route('home') }}" class="btn btn-outline-primary btn-sm"><i class="fas fa-undo"></i> Voltar</a>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-sliders-h me-1"></i> Parâmetros Financeiros
        </div>
        <div class="card-body">
            <form action="{{ route('financeiro.configuracoes.update') }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5>Configurações de Juros e Multa</h5>
                        <hr>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="juros_diario">Taxa de Juros Diário (%)</label>
                            <div class="input-group">
                                <input type="number" step="0.001" min="0" max="10" 
                                       class="form-control" id="juros_diario" name="juros_diario" 
                                       value="{{ old('juros_diario', $configuracao->juros_diario) }}" required>
                                <span class="input-group-text">% ao dia</span>
                            </div>
                            <small class="form-text text-muted">
                                Exemplo: 0.033% ao dia equivale a aproximadamente 1% ao mês
                            </small>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="multa_atraso">Multa por Atraso (%)</label>
                            <div class="input-group">
                                <input type="number" step="0.01" min="0" max="100" 
                                       class="form-control" id="multa_atraso" name="multa_atraso" 
                                       value="{{ old('multa_atraso', $configuracao->multa_atraso) }}" required>
                                <span class="input-group-text">%</span>
                            </div>
                            <small class="form-text text-muted">
                                Percentual fixo de multa aplicado ao valor em atraso
                            </small>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="carencia_dias">Dias de Carência</label>
                            <div class="input-group">
                                <input type="number" step="1" min="0" max="30" 
                                       class="form-control" id="carencia_dias" name="carencia_dias" 
                                       value="{{ old('carencia_dias', $configuracao->carencia_dias) }}" required>
                                <span class="input-group-text">dias</span>
                            </div>
                            <small class="form-text text-muted">
                                Período de carência antes de aplicar juros e multa
                            </small>
                        </div>
                    </div>
                </div>
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5>Configurações de Prazos</h5>
                        <hr>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="prazo_padrao_dias">Prazo Padrão para Novas Contas</label>
                            <div class="input-group">
                                <input type="number" step="1" min="1" max="365" 
                                       class="form-control" id="prazo_padrao_dias" name="prazo_padrao_dias" 
                                       value="{{ old('prazo_padrao_dias', $configuracao->prazo_padrao_dias) }}" required>
                                <span class="input-group-text">dias</span>
                            </div>
                            <small class="form-text text-muted">
                                Prazo padrão utilizado ao criar novas contas a receber
                            </small>
                        </div>
                    </div>
                </div>
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5>Configurações de Notificações</h5>
                        <hr>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" id="notificar_vencimento" 
                                   name="notificar_vencimento" value="1" 
                                   {{ old('notificar_vencimento', $configuracao->notificar_vencimento) ? 'checked' : '' }}>
                            <label class="form-check-label" for="notificar_vencimento">
                                Notificar sobre contas a vencer
                            </label>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group mb-3">
                            <label for="dias_notificacao_previa">Dias de Antecedência para Notificação</label>
                            <div class="input-group">
                                <input type="number" step="1" min="0" max="30" 
                                       class="form-control" id="dias_notificacao_previa" name="dias_notificacao_previa" 
                                       value="{{ old('dias_notificacao_previa', $configuracao->dias_notificacao_previa) }}" required>
                                <span class="input-group-text">dias</span>
                            </div>
                            <small class="form-text text-muted">
                                Período de antecedência para notificação de contas a vencer
                            </small>
                        </div>
                    </div>
                </div>
                
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5>Configurações de Recibos</h5>
                        <hr>
                    </div>
                    
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label for="texto_padrao_recibo">Texto Padrão do Recibo</label>
                            <textarea class="form-control" id="texto_padrao_recibo" name="texto_padrao_recibo" rows="3" required>{{ old('texto_padrao_recibo', $configuracao->texto_padrao_recibo) }}</textarea>
                            <small class="form-text text-muted">
                                Texto padrão que será incluído no recibo
                            </small>
                        </div>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-md-12">
                        <h5>Configurações de Boleto</h5>
                        <hr>
                    </div>
                    
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label for="instrucoes_padrao_boleto">Instruções Padrão do Boleto</label>
                            <textarea class="form-control" id="instrucoes_padrao_boleto" name="instrucoes_padrao_boleto" rows="3">{{ old('instrucoes_padrao_boleto', $configuracao->instrucoes_padrao_boleto) }}</textarea>
                            <small class="form-text text-muted">
                                Instruções que serão incluídas automaticamente em todos os boletos
                            </small>
                        </div>
                    </div>
                </div>
                
                <div class="row mb-4">
                    <div class="col-md-12 text-right">
                        <button type="submit" class="btn btn-primary">Atualizar Configurações</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection 