@component('mail::message')
# ALERTA DE SEGURANÇA: Tentativas de Login Suspeitas

Foram detectadas múltiplas tentativas de login malsucedidas no sistema **{{ env("APP_NAME") }}**, o que pode indicar uma tentativa de invasão.

## Detalhes do Alerta:

**Tipo**: {{ $dados['tipo'] }} Suspeito  
**{{ $dados['tipo'] }}**: {{ $dados['valor'] }}  
**Número de Tentativas**: {{ $dados['count'] }}  
**Período de Tempo**: {{ $dados['janela_tempo'] }} minutos  
**Data/Hora da Detecção**: {{ $dados['data'] }}  

## Últimas Tentativas:

@component('mail::table')
| Data/Hora | Email | IP | User Agent |
| --------- | ----- | -- | ---------- |
@foreach($dados['tentativas'] as $t)
| {{ \Carbon\Carbon::parse($t->created_at)->format('d/m/Y H:i:s') }} | {{ $t->email }} | {{ $t->ip }} | {{ Str::limit($t->user_agent, 50) }} |
@endforeach
@endcomponent

## Ações Recomendadas:

1. Verifique se este é um comportamento legítimo (ex: usuário esqueceu a senha)
2. Considere bloquear temporariamente o IP ou a conta se houver suspeita de ataque
3. Revise os logs do sistema para verificar outras atividades suspeitas

@component('mail::button', ['url' => url('/users')])
Gerenciar Usuários
@endcomponent

**Este é um email automático gerado pelo sistema de segurança. Por favor, não responda.**

Atenciosamente,  
Sistema de Segurança {{ config('app.name') }}
@endcomponent 