@component('mail::message')
# Resumo Semanal {{ env("APP_NAME") }}

Aqui está o resumo das atividades do sistema **{{ env("APP_NAME") }}** para o período de **{{ $estatisticas['periodo']['inicio'] }}** a **{{ $estatisticas['periodo']['fim'] }}**.

## Estatísticas Gerais

**Novas Empresas:** {{ $estatisticas['novas_empresas'] }}  
**Novas NFes Emitidas:** {{ $estatisticas['novas_nfes'] }}  
**Novas NFCes Emitidas:** {{ $estatisticas['novas_nfces'] }}  
**Documentos Fiscais Totais:** {{ $estatisticas['novas_nfes'] + $estatisticas['novas_nfces'] }}  
**Novos Usuários:** {{ $estatisticas['novos_usuarios'] }}  
**Novos Clientes:** {{ $estatisticas['novos_clientes'] }}  

## Total de Empresas Ativas
Atualmente o sistema possui **{{ $estatisticas['total_empresas'] }}** empresas cadastradas.

## Empresas Mais Ativas
@if(count($estatisticas['empresas_mais_ativas']) > 0)
As 5 empresas mais ativas no período (com mais documentos fiscais emitidos):

@component('mail::table')
| Empresa | Razão Social | NFes | NFCes | Total |
| ------- | ------------ | ---- | ----- | ----- |
@foreach($estatisticas['empresas_mais_ativas'] as $empresa)
| {{ $empresa->id }} | {{ $empresa->razao_social }} | {{ $empresa->nfes_count }} | {{ $empresa->nfces_count }} | {{ $empresa->nfes_count + $empresa->nfces_count }} |
@endforeach
@endcomponent
@else
Não foram encontradas empresas ativas no período.
@endif

@component('mail::button', ['url' => url('/empresas')])
Ver Todas as Empresas
@endcomponent

Este relatório foi gerado automaticamente em {{ $estatisticas['data_geracao'] }}.

Atenciosamente,  
Equipe {{ config('app.name') }}
@endcomponent 