@component('mail::message')
# Alerta: Planos Próximos da Expiração

O sistema **{{ env("APP_NAME") }}** identificou **{{ $total }}** planos que irão expirar nos próximos 7 dias.

## Detalhes dos Planos por Data de Expiração:

@foreach($planosAgrupados as $data => $planos)
### Planos com vencimento em {{ \Carbon\Carbon::parse($data)->format('d/m/Y') }} ({{ $planos->count() }} planos)

@component('mail::table')
| Empresa | Razão Social | Plano | Valor | Data Expiração |
| ------- | ------------ | ----- | ----- | -------------- |
@foreach($planos as $planoEmpresa)
| {{ $planoEmpresa->empresa->id }} | {{ $planoEmpresa->empresa->razao_social }} | {{ $planoEmpresa->plano->nome }} | R$ {{ number_format($planoEmpresa->valor, 2, ',', '.') }} | {{ \Carbon\Carbon::parse($planoEmpresa->data_expiracao)->format('d/m/Y') }} |
@endforeach
@endcomponent

@endforeach

## Ações Recomendadas:

1. Entre em contato com as empresas para confirmar a renovação dos planos
2. Verifique se há algum problema de pagamento pendente
3. Ofereça suporte para renovação automática quando aplicável

@component('mail::button', ['url' => url('/planos')])
Gerenciar Planos
@endcomponent

Este alerta foi gerado automaticamente em {{ $dataAtual }}.

Atenciosamente,  
Equipe {{ config('app.name') }}
@endcomponent 