@extends('layouts.app', ['title' => 'Devolução/Troca de Vendas'])

@section('css')
<link href="{{ asset('css/devolucao-venda.css') }}" rel="stylesheet">
@endsection

@section('content')

<div class="row">
    <div class="col-12">
        
        <div class="card">
            <div class="card-header">
                <h4>Filtros</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('devolucao_venda.index') }}" method="GET">
                    <input type="hidden" name="empresa_id" value="{{ $empresa_id ?? auth()->user()->empresa_id }}">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="start_date">Data Inicial</label>
                                <input type="date" name="start_date" class="form-control" value="{{ request()->get('start_date') }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="end_date">Data Final</label>
                                <input type="date" name="end_date" class="form-control" value="{{ request()->get('end_date') }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="cliente_id">Cliente</label>
                                <select name="cliente_id" class="form-control select2">
                                    <option value="">Selecione</option>
                                    @foreach(\App\Models\Cliente::where('empresa_id', $empresa_id ?? auth()->user()->empresa_id)->get() as $c)
                                    <option value="{{ $c->id }}" {{ request()->get('cliente_id') == $c->id ? 'selected' : '' }}>{{ $c->razao_social }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="numero">Número da Nota</label>
                                <input type="text" name="numero" class="form-control" value="{{ request()->get('numero') }}">
                            </div>
                        </div>
                        <div class="col-md-12 text-right">
                            <button type="submit" class="btn btn-primary"><i class="ri-filter-2-fill"></i> Filtrar</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4>Vendas Disponíveis para Devolução/Troca</h4>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-bordered table-hover datatable">
                    <thead>
                        <tr>
                            <th>Tipo</th>
                            <th>Número</th>
                            <th>Data</th>
                            <th>Cliente</th>
                            <th>Total</th>
                            <th>Itens</th>
                            <th>Devolvido</th>
                            <th width="200">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($vendas as $venda)
                        @php
                            // Buscar devoluções para esta venda
                            $devolucoes = \App\Models\Devolucao::where('tipo_venda', $venda['tipo'])
                                ->where('venda_id', $venda['id'])
                                ->get();
                        @endphp
                        <tr>
                            <td>
                                @if(strtoupper($venda['tipo']) == 'NFCE')
                                <span class="badge bg-info">{{ strtoupper($venda['tipo']) }}</span>
                                @else
                                <span class="badge bg-warning">{{ strtoupper($venda['tipo']) }}</span>
                                @endif
                            </td>
                            <td>{{ $venda['numero_sequencial'] }}</td>
                            <td>{{ date('d/m/Y H:i', strtotime($venda['data'])) }}</td>
                            <td>{{ $venda['cliente'] }}</td>
                            <td>{{ __moeda($venda['total']) }}</td>
                            <td>{{ $venda['itens_count'] }}</td>
                            <td>
                                @if($venda['status_devolucao'] == 'Total')
                                <span class="badge bg-danger">Total</span>
                                @elseif($venda['status_devolucao'] == 'Parcial')
                                <span class="badge bg-warning">Parcial</span>
                                @elseif($venda['status_devolucao'] == 'Não')
                                <span class="badge bg-success">Não</span>
                                @else
                                <span class="badge bg-secondary">{{ $venda['status_devolucao'] }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                        Ações
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <li>
                                            <a class="dropdown-item" href="{{ route('devolucao_venda.devolucao', [$venda['tipo'], $venda['id']]) }}">
                                                <i class="ri-arrow-go-back-line"></i> Devolução
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="{{ route('devolucao_venda.troca', [$venda['tipo'], $venda['id']]) }}">
                                                <i class="ri-repeat-fill"></i> Troca
                                            </a>
                                        </li>
                                        
                                        @if(count($devolucoes) > 0)
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <div class="dropdown-header text-muted">Comprovantes:</div>
                                            </li>
                                            @foreach($devolucoes as $devolucao)
                                                <li>
                                                    <a class="dropdown-item" href="{{ route('devolucao_venda.imprimir_comprovante', ['id' => $devolucao->id, 'tipo' => $devolucao->is_troca ? 'troca' : 'devolucao']) }}" target="_blank">
                                                        <i class="ri-printer-line"></i> Imprimir {{ $devolucao->is_troca ? 'Troca' : 'Devolução' }} #{{ $devolucao->id }}
                                                    </a>
                                                </li>
                                            @endforeach
                                        @endif
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal para imprimir comprovante -->
<div class="modal fade" id="modalImprimirComprovante" tabindex="-1" aria-labelledby="modalImprimirComprovanteLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalImprimirComprovanteLabel">Impressão de Comprovante</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Deseja imprimir o comprovante de <span id="tipoComprovante">devolução</span>?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                <a href="#" id="btnImprimirComprovante" class="btn btn-primary" target="_blank">Sim, imprimir</a>
            </div>
        </div>
    </div>
</div>

@endsection


@section('js')
<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2();
        
        // Verificar se há um comprovante para imprimir
        @if(session()->has('imprimir_comprovante'))
            var devolucaoId = "{{ session('imprimir_comprovante') }}";
            var tipoComprovante = "{{ session('tipo_comprovante', 'devolucao') }}";
            var textoTipo = tipoComprovante === 'troca' ? 'troca' : 'devolução';
            
            // Configurar o modal
            $('#tipoComprovante').text(textoTipo);
            
            // Definir o link com target="_blank" para abrir em nova aba
            var urlComprovante = "{{ route('devolucao_venda.imprimir_comprovante', ['id' => ':id', 'tipo' => ':tipo']) }}".replace(':id', devolucaoId).replace(':tipo', tipoComprovante);
            $('#btnImprimirComprovante').attr('href', urlComprovante);
            
            // Exibir o modal
            var modal = new bootstrap.Modal(document.getElementById('modalImprimirComprovante'));
            modal.show();
            
            // Quando o usuário clicar em "Sim, imprimir"
            $('#btnImprimirComprovante').on('click', function() {
                // Fechar o modal depois de abrir a nova aba
                setTimeout(function() {
                    modal.hide();
                }, 500);
            });
        @endif
    });
</script>
@endsection 