@extends('layouts.app', ['title' => 'Devolução de mercadoria'])

@section('css')
<link href="{{ asset('css/devolucao-venda.css') }}" rel="stylesheet">
<style>
    .valor-destaque {
        font-size: 1.5rem;
        font-weight: bold;
        color: #2563eb;
    }
    .resumo-item {
        border-bottom: 1px solid #e9ecef;
        padding: 8px 0;
    }
    .resumo-total {
        font-size: 1.2rem;
        font-weight: bold;
        margin-top: 15px;
        padding-top: 15px;
        border-top: 2px solid #e9ecef;
    }
    .devolucao-header {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .devolucao-header-icon {
        width: 60px;
        height: 60px;
        background: #fffbe6;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2.5rem;
        color: #f7b500;
    }
    .switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 24px;
    }
    .switch input {display:none;}
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0; left: 0; right: 0; bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 24px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 18px;
        width: 18px;
        left: 3px;
        bottom: 3px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .slider {
        background-color: #2563eb;
    }
    input:checked + .slider:before {
        transform: translateX(26px);
    }
</style>
@endsection

@section('content')
@if(session('sweet_error'))
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                html: @json(session('sweet_error')),
                confirmButtonText: 'OK'
            });
        });
    </script>
@endif
<div class="container-fluid">
    <div class="d-flex justify-content-center align-items-start" style="min-height: 80vh;">
        <div class="col-md-8">
            <div class="card mb-3 mt-2">
                <div class="card-body text-center py-4">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="devolucao-header-icon me-3" style="width: 20px; height: 20px; font-size: 8rem;">
                            <i class="ri-inbox-unarchive-line"></i>
                        </div>
                        <h3 class="mb-0" style="color: #f7b500; font-weight: bold;">Devolução de mercadoria</h3>
                    </div>
                </div>
            </div> 
            <div class="row mb-2">
                <div class="col-md-2">
                    <label for="codigo_venda"><b>Código Venda</b></label>
                    <input type="text" class="form-control" name="codigo_venda" id="codigo_venda" value="{{ $venda->numero ?? old('codigo_venda') }}" readonly>
                </div>
                <div class="col-md-8">
                    <label for="cliente_nome"><b>Cliente</b></label>
                    <input type="text" class="form-control" id="cliente_nome" value="{{ $venda->cliente ? $venda->cliente->razao_social : 'Consumidor Final' }}" readonly>
                </div>
                <div class="col-md-2">
                    <label for="valor_total"><b>Valor (R$)</b></label>
                    <input type="text" class="form-control" id="valor_total" value="{{ number_format($venda->total ?? 0, 2, ',', '.') }}" readonly>
                </div>
            </div>
            
            <form action="{{ route('devolucao_venda.store_devolucao') }}" method="POST" id="form-devolucao">
                @csrf
                <input type="hidden" name="tipo_venda" value="{{ $tipo }}">
                <input type="hidden" name="venda_id" value="{{ $venda->id }}">
                <input type="hidden" name="empresa_id" value="{{ $venda->empresa_id }}">
                <input type="hidden" name="pagamentos_json" id="pagamentos_json">

                <div class="card">
                    <div class="card-header">
                        <h4>Selecione os Itens para Devolução</h4>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th width="50">Selecionar</th>
                                    <th>Produto</th>
                                    <th>Quantidade Vendida</th>
                                    <th>Valor Unitário</th>
                                    <th>Subtotal</th>
                                    <th>Quantidade a Devolver</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($venda->itens as $item)
                                <tr class="{{ $item->totalmente_devolvido ? 'table-danger' : '' }}">
                                    <td class="text-center">
                                        <div class="form-check">
                                            <input class="form-check-input check-item" type="checkbox" name="itens_ids[]" value="{{ $item->id }}" id="check_{{ $item->id }}" {{ $item->totalmente_devolvido ? 'disabled' : '' }}>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($item->produto && $item->produto->img)
                                            <img src="{{ $item->produto->img }}" width="40" height="40" class="rounded me-2">
                                            @endif
                                            <div>
                                                {{ $item->produto ? $item->produto->nome : 'Produto não encontrado' }}
                                                @if(isset($item->variacao_id) && $item->variacao_id)
                                                <br><small class="text-muted">{{ $item->produtoVariacao ? $item->produtoVariacao->descricao : '' }}</small>
                                                @endif
                                                @if($item->totalmente_devolvido)
                                                <br><span class="badge bg-danger">Já devolvido</span>
                                                @elseif($item->ja_devolvido)
                                                <br><small class="text-danger">Parcialmente devolvido anteriormente</small>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ number_format($item->quantidade_disponivel, 3, ',', '.') }}
                                        @if($item->ja_devolvido)
                                        <br><small class="text-muted">(Original: {{ number_format($item->quantidade_original, 3, ',', '.') }})</small>
                                        @endif
                                    </td>
                                    <td>R$ {{ __moeda($item->valor_unitario) }}</td>
                                    <td>R$ {{ __moeda($item->quantidade_disponivel * $item->valor_unitario) }}</td>
                                    <td>
                                        <input type="text" name="quantidades[]" class="form-control quantidade-item" data-id="{{ $item->id }}" value="{{ number_format($item->quantidade_disponivel, 3, ',', '.') }}" data-mask="##0,000" data-mask-reverse="true" {{ $item->totalmente_devolvido ? 'disabled' : '' }}>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Novo painel de resumo de valor -->
                <div class="card mb-3">
                    <div class="card-header bg-info text-white">
                        <h4 class="mb-0 text-white">Resumo da Devolução</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div id="resumo-itens">
                                    <p class="text-muted text-center">Selecione os itens para visualizar o resumo da devolução</p>
                                </div>
                                <div class="resumo-total text-right">
                                    Valor Total a Devolver: <span id="valor-total-devolucao" class="valor-destaque">R$ 0,00</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- PAINEL DE PAGAMENTO SIMPLIFICADO -->
                <div class="card mb-3">
                    <div class="card-header bg-light">
                        <span style="font-weight: bold;">Pagamento da Devolução</span>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-2">
                            <label for="forma_pagamento">Forma de Pagamento</label>
                            <select class="form-control" name="forma_pagamento" id="forma_pagamento" required>
                                <option value="01">Dinheiro</option>
                                <option value="17">PIX</option>
                                <option value="00">Vale Crédito</option>
                            </select>
                        </div>
                        <div class="form-group mb-2">
                            <label for="valor_devolucao">Valor da Devolução</label>
                            <input type="text" class="form-control" name="valor_devolucao" id="valor_devolucao" value="{{ number_format($venda->total, 2, ',', '.') }}" readonly>
                        </div>
                    </div>
                </div>
                <!-- FIM PAINEL DE PAGAMENTOS -->

                <div class="card">
                    <div class="card-header">
                        <h4>Método de Devolução</h4>
                    </div>
                    <div class="card-body">
                        @if($temCrediario)
                        <div class="alert alert-warning">
                            <h5><i class="ri-information-line"></i> Venda com Crediário</h5>
                            <p><strong>Esta venda foi paga com crediário no valor de R$ {{ __moeda($valorCrediario) }}.</strong></p>
                            <p>O reembolso será feito através do abatimento nas parcelas do crediário (contas a receber).</p>
                            
                            @if($contasReceber->count() > 0)
                            <div class="mt-3">
                                <h6>Parcelas do Crediário Pendentes:</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Parcela</th>
                                                <th>Vencimento</th>
                                                <th>Valor Pendente</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($contasReceber as $conta)
                                            <tr>
                                                <td>{{ $conta->descricao ?? 'Parcela ' . $loop->iteration }}</td>
                                                <td>{{ __data_pt($conta->data_vencimento) }}</td>
                                                <td>R$ {{ __moeda($conta->valor_integral - $conta->valor_recebido) }}</td>
                                                <td>
                                                    @if($conta->status == 0)
                                                        <span class="badge bg-warning">Pendente</span>
                                                    @elseif($conta->status == 1)
                                                        <span class="badge bg-success">Recebido</span>
                                                    @elseif($conta->status == 2)
                                                        <span class="badge bg-danger">Vencido</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @endif
                        </div>
                        @endif
                        
                        <div class="row">
                            <div class="col-md-6">
                                <!-- Campo de seleção de cliente para caso de crédito em loja -->
                                <div class="form-group mt-3" id="div-cliente" style="display: none;">
                                    <label for="cliente_id">Cliente <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <select name="cliente_id" id="cliente_id" class="form-control select2">
                                            <option value="">Selecione um cliente</option>
                                            @foreach(\App\Models\Cliente::where('empresa_id', $venda->empresa_id)->orderBy('razao_social')->get() as $cliente)
                                            <option value="{{ $cliente->id }}" {{ $venda->cliente_id == $cliente->id ? 'selected' : '' }}>{{ $cliente->razao_social }}</option>
                                            @endforeach
                                        </select>
                                        <div class="input-group-append">
                                            <a href="{{ route('clientes.create') }}" target="_blank" class="btn btn-outline-secondary">
                                                <i class="ri-add-line"></i> Novo
                                            </a>
                                        </div>
                                    </div>
                                    <small class="form-text text-danger">Obrigatório para crédito em loja</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="alert alert-info mt-4">
                                    <p><i class="ri-information-line"></i> <strong>Importante:</strong></p>
                                    <ul class="mb-0">
                                        <!-- @if($temCrediario)
                                            <li><strong>Crediário:</strong> O valor será abatido das parcelas pendentes do crediário.</li>
                                        @else -->
                                            <li><strong>Dinheiro/PIX:</strong> O valor será retirado do caixa atual.</li>
                                            <li><strong>Crédito em Loja:</strong> O valor será adicionado como crédito para o cliente.</li>
                                        <!-- @endif -->
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <a href="{{ route('devolucao_venda.index') }}" class="btn btn-secondary">Voltar</a>
                        <button type="submit" class="btn btn-primary" id="btn-devolver">Concluir Devolução</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        // Armazenar o ID do cliente da venda em uma variável
        var vendaClienteId = "{{ $venda->cliente_id }}";
        
        // Inicializar select2
        $('.select2').select2({
            placeholder: "Selecione um cliente",
            allowClear: true
        });
        
        // Função para calcular o valor total da devolução
        function calcularValorTotalDevolucao() {
            var valorTotal = 0;
            var itemsHtml = '';
            var temItens = false;
            
            $('.check-item:checked').each(function() {
                temItens = true;
                var id = $(this).val();
                var input = $('.quantidade-item[data-id="'+id+'"]');
                var quantidadeStr = input.val().replace(/\./g, '').replace(',', '.');
                var quantidade = parseFloat(quantidadeStr);
                
                // Buscar o valor unitário e nome do produto na tabela
                var tr = input.closest('tr');
                var produto = tr.find('td:eq(1)').text().trim();
                var valorUnitarioStr = tr.find('td:eq(3)').text().replace('R$ ', '').replace(/\./g, '').replace(',', '.');
                var valorUnitario = parseFloat(valorUnitarioStr);
                
                if (!isNaN(quantidade) && !isNaN(valorUnitario)) {
                    var subtotal = quantidade * valorUnitario;
                    valorTotal += subtotal;
                    
                    // Adicionar item ao resumo
                    itemsHtml += '<div class="resumo-item">';
                    itemsHtml += '<div class="d-flex justify-content-between">';
                    
                    // Limitar o nome do produto a 50 caracteres
                    var nomeProduto = produto;
                    if (nomeProduto.length > 50) {
                        nomeProduto = nomeProduto.substring(0, 47) + '...';
                    }
                    
                    itemsHtml += '<div><strong>' + nomeProduto + '</strong></div>';
                    itemsHtml += '<div>R$ ' + subtotal.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + '</div>';
                    itemsHtml += '</div>';
                    itemsHtml += '<div class="text-muted">' + quantidade.toLocaleString('pt-BR', { minimumFractionDigits: 3, maximumFractionDigits: 3 }) + ' x R$ ' + valorUnitario.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + '</div>';
                    itemsHtml += '</div>';
                }
            });
            
            // Atualizar o HTML do resumo
            if (temItens) {
                $('#resumo-itens').html(itemsHtml);
            } else {
                $('#resumo-itens').html('<p class="text-muted text-center">Selecione os itens para visualizar o resumo da devolução</p>');
            }
            
            // Formatar e exibir o valor total
            $('#valor-total-devolucao').text('R$ ' + valorTotal.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            
            // Destacar o resumo visualmente se houver itens selecionados
            if (temItens) {
                $('#valor-total-devolucao').parents('.card').addClass('border-primary');
            } else {
                $('#valor-total-devolucao').parents('.card').removeClass('border-primary');
            }
        }
        
        // Função para atualizar o campo de valor da devolução
        function atualizarValorDevolucao() {
            // Pega o valor total a devolver do resumo
            var txt = $('#valor-total-devolucao').text().replace('R$','').replace(/\./g,'').replace(',', '.');
            var valor = parseFloat(txt);
            if (!isNaN(valor)) {
                // Formata para 2 casas decimais e separador brasileiro
                $('#valor_devolucao').val(valor.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            }
        }

        // Chamar a função ao carregar a página
        calcularValorTotalDevolucao();
        
        // Chamar a função quando um item for marcado/desmarcado
        $('.check-item').change(function() {
            var id = $(this).val();
            if($(this).is(':checked')) {
                $('.quantidade-item[data-id="'+id+'"]').prop('disabled', false);
            } else {
                $('.quantidade-item[data-id="'+id+'"]').prop('disabled', true);
            }
            
            // Recalcular o valor total
            calcularValorTotalDevolucao();
        });
        
        // Chamar a função quando a quantidade for alterada
        $('.quantidade-item').on('input', function() {
            calcularValorTotalDevolucao();
        });
        
        // Atualiza o valor ao selecionar forma de pagamento
        $('#forma_pagamento').change(function() {
            atualizarValorDevolucao();
        });

        // Atualiza o valor sempre que o total mudar
        $('.check-item, .quantidade-item').on('change input', function() {
            atualizarValorDevolucao();
        });

        // Se já tiver um cliente na venda, selecionar o cliente no dropdown
        if (vendaClienteId) {
            $('#cliente_id').val(vendaClienteId).trigger('change');
        }
        
        // Controlar exibição do campo de cliente com base no tipo de pagamento
        $('#forma_pagamento').change(function() {
            if ($(this).val() === '00') { // Crédito em loja
                $('#div-cliente').show();
                $('#cliente_id').prop('required', true);
                
                // Se já tiver um cliente, garantir que ele esteja selecionado
                if (vendaClienteId && !$('#cliente_id').val()) {
                    $('#cliente_id').val(vendaClienteId).trigger('change');
                }
            } else {
                $('#div-cliente').hide();
                $('#cliente_id').prop('required', false);
            }
        });
        
        // Se já tiver crediário, não mostrar o campo de cliente
        @if($temCrediario)
            $('#div-cliente').hide();
            $('#cliente_id').prop('required', false);
        @endif
        
        // Validar formulário antes de enviar
        let confirmandoEnvio = false;
        $('form').submit(function(e) {
            if (confirmandoEnvio) {
                // Já confirmou, deixa enviar normalmente
                confirmandoEnvio = false;
                return true;
            }
            if($('.check-item:checked').length === 0) {
                e.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'Atenção',
                    text: 'Selecione pelo menos um item para devolução!'
                });
                return false;
            }
            
            if($('#forma_pagamento').val() === '') {
                e.preventDefault();
                alert('Selecione uma forma de pagamento!');
                return false;
            }
            
            // Verificar se foi selecionado um cliente quando o pagamento for crédito em loja
            if($('#forma_pagamento').val() === '00' && $('#cliente_id').val() === '') {
                e.preventDefault();
                alert('Para gerar crédito em loja é necessário selecionar um cliente!');
                $('#cliente_id').focus();
                return false;
            }
            
            // Para crediário, não precisamos validar cliente
            @if(!$temCrediario)
            if($('#forma_pagamento').val() === '06') {
                e.preventDefault();
                alert('Crediário não é um método válido para devolução!');
                return false;
            }
            @endif
            
            // Verificar se a quantidade a devolver é válida
            var error = false;
            $('.check-item:checked').each(function() {
                var id = $(this).val();
                var input = $('.quantidade-item[data-id="'+id+'"]');
                var valor = input.val().replace(/\./g, '').replace(',', '.');
                var quantidade = parseFloat(valor);
                
                if(quantidade <= 0) {
                    error = true;
                    input.addClass('is-invalid');
                }
                
                // Obter a quantidade disponível do elemento tr
                var tr = input.closest('tr');
                var tdQuantidade = tr.find('td:eq(2)');
                var quantidadeDisponivelStr = tdQuantidade.text().split('(')[0].trim();
                quantidadeDisponivelStr = quantidadeDisponivelStr.replace(/\./g, '').replace(',', '.');
                var quantidadeDisponivel = parseFloat(quantidadeDisponivelStr);
                
                if(quantidade > quantidadeDisponivel) {
                    error = true;
                    input.addClass('is-invalid');
                    alert('A quantidade a devolver não pode ser maior que a quantidade disponível (' + tdQuantidade.text().split('(')[0].trim() + ')');
                    return false;
                }
            });
            
            if(error) {
                e.preventDefault();
                alert('Erro na quantidade informada! Verifique os campos destacados.');
                return false;
            }
            
            // Remover lógica de array de pagamentos e validação baseada em pagamentos
            // Substituir por validação simples:
            $('#form-devolucao').on('submit', function(e) {
                // Validar se o valor da devolução bate com o valor total a devolver
                var valorCampo = $('#valor_devolucao').val().replace(/\./g, '').replace(',', '.');
                var valorTotal = $('#valor-total-devolucao').text().replace('R$','').replace(/\./g,'').replace(',', '.');
                var v1 = parseFloat(valorCampo);
                var v2 = parseFloat(valorTotal);
                if (Math.abs(v1 - v2) > 0.01) {
                    e.preventDefault();
                    Swal.fire({
                        icon: 'error',
                        title: 'Atenção',
                        text: 'O valor da devolução deve ser igual ao valor total a devolver!'
                    });
                    return false;
                }
                // Se existir campo pagamentos_json, preenche com a forma e valor
                if ($('#pagamentos_json').length) {
                    var pagamento = [{
                        forma: $('#forma_pagamento option:selected').text(),
                        valor: v1
                    }];
                    $('#pagamentos_json').val(JSON.stringify(pagamento));
                }
                // SweetAlert de confirmação
                if (!confirmandoEnvio) {
                    e.preventDefault();
                    Swal.fire({
                        title: 'Confirmar Devolução',
                        text: 'Tem certeza que deseja concluir esta devolução?',
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonText: 'Sim, concluir',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            confirmandoEnvio = true;
                            $('#form-devolucao').submit();
                        }
                    });
                    return false;
                }
            });
        });
    });
</script>
@endsection 