@extends('layouts.app', ['title' => 'Dashboard de Taxas de Pagamento'])

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="mb-0 fw-bold text-dark">Dashboard de Taxas de Pagamento</h5>
                    <a href="{{ route('dashboard-taxa-pagamento.relatorio', ['data_inicial' => $dataInicial, 'data_final' => $dataFinal]) }}" class="btn btn-outline-success btn-sm" target="_blank">
                        <i class="ri-file-pdf-line"></i> PDF
                    </a>
                </div>

                <!-- Alerta informativo sobre taxas históricas -->
                <div class="alert alert-info small mb-3">
                    <i class="ri-information-line me-1"></i> 
                    <strong>Informação importante:</strong> Este dashboard mostra os valores calculados usando as taxas registradas no momento da venda, não as taxas atuais.
                    @if(isset($dadosDashboard['vendasSemTaxa']) && $dadosDashboard['vendasSemTaxa'] > 0)
                        <span class="d-block mt-1"><i class="ri-alert-line me-1"></i> <strong>{{ $dadosDashboard['vendasSemTaxa'] }}</strong> vendas não possuem taxas registradas e são exibidas com taxa 0%.</span>
                    @endif
                </div>

                <!-- Filtros -->
                <form action="{{ route('dashboard-taxa-pagamento.index') }}" method="GET" class="row g-3 mb-4">
                    <div class="col-md-4">
                        <label class="form-label small">Data Inicial</label>
                        <input type="date" class="form-control form-control-sm" name="data_inicial" value="{{ $dataInicial }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label small">Data Final</label>
                        <input type="date" class="form-control form-control-sm" name="data_final" value="{{ $dataFinal }}">
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary btn-sm w-100">Filtrar</button>
                    </div>
                </form>

                <!-- Cards -->
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="p-3 rounded bg-primary text-white shadow-sm">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="small fw-bold text-uppercase">Total de Vendas</span>
                                <i class="ri-money-dollar-circle-line fs-3"></i>
                            </div>
                            <h2 class="mt-2 mb-1 fw-bold">{{ __moeda($dadosDashboard['totalVendas']) }}</h2>
                            <small>100% do valor bruto</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="p-3 rounded bg-danger text-white shadow-sm">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="small fw-bold text-uppercase">Total de Taxas</span>
                                <i class="ri-percent-line fs-3"></i>
                            </div>
                            <h2 class="mt-2 mb-1 fw-bold">{{ __moeda($dadosDashboard['totalTaxas']) }}</h2>
                            <small>{{ number_format(($dadosDashboard['totalVendas'] > 0 ? $dadosDashboard['totalTaxas'] / $dadosDashboard['totalVendas'] * 100 : 0), 2) }}% do total</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="p-3 rounded bg-success text-white shadow-sm">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="small fw-bold text-uppercase">Valor Líquido</span>
                                <i class="ri-cash-line fs-3"></i>
                            </div>
                            <h2 class="mt-2 mb-1 fw-bold">{{ __moeda($dadosDashboard['totalLiquido']) }}</h2>
                            <small>{{ number_format(($dadosDashboard['totalVendas'] > 0 ? $dadosDashboard['totalLiquido'] / $dadosDashboard['totalVendas'] * 100 : 0), 2) }}% do total</small>
                        </div>
                    </div>
                </div>

                <!-- Gráficos lado a lado -->
                <div class="row g-3 mt-3">
                    <div class="col-md-6">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <h6 class="text-muted small mb-2">Taxas por Forma de Pagamento</h6>
                                <canvas id="chartFormaPagamento" height="160"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <h6 class="text-muted small mb-2">Taxas por Bandeira</h6>
                                <canvas id="chartBandeira" height="160"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Gráfico Evolução -->
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <h6 class="text-muted small mb-2">Evolução Diária</h6>
                                <canvas id="chartEvolucaoDiaria" height="160"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabela de dados -->
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <h6 class="text-muted small mb-3">Detalhamento</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered align-middle mb-0">
                                        <thead class="table-light small text-center">
                                            <tr>
                                                <th>Cliente</th>
                                                <th>Forma</th>
                                                <th>Bandeira</th>
                                                <th>Data</th>
                                                <th>Total</th>
                                                <th>Taxa %</th>
                                                <th>Taxa</th>
                                                <th>Líquido</th>
                                                <th>Tipo</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($dadosDashboard['vendas'] as $venda)
                                            <tr class="small text-center">
                                                <td>{{ $venda['cliente'] }}</td>
                                                <td>{{ $venda['tipo_pagamento'] }}</td>
                                                <td>{{ $venda['bandeira'] }}</td>
                                                <td>{{ $venda['data'] }}</td>
                                                <td>{{ __moeda($venda['total']) }}</td>
                                                <td>{{ number_format($venda['taxa_perc'], 2) }}%</td>
                                                <td>{{ __moeda($venda['valor_taxa']) }}</td>
                                                <td>{{ __moeda($venda['valor_liquido']) }}</td>
                                                <td>{{ $venda['tipo'] }}</td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="9" class="text-center small text-muted">Nenhum dado encontrado.</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div> <!-- card-body -->
        </div>
    </div>
</div>
@endsection

@section('js')
<!-- Chart.js -->
<script src="{{ asset('assets/vendor/chart.js/chart.min.js') }}"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const cores = [
        'rgba(54, 162, 235, 0.6)',
        'rgba(255, 99, 132, 0.6)',
        'rgba(255, 206, 86, 0.6)',
        'rgba(75, 192, 192, 0.6)',
        'rgba(153, 102, 255, 0.6)'
    ];

    const formaPagamentoData = {!! json_encode($dadosGraficos['porFormaPagamento']) !!};
    const formaLabels = Object.keys(formaPagamentoData);
    const formaValues = formaLabels.map(label => formaPagamentoData[label].taxas);

    new Chart(document.getElementById('chartFormaPagamento'), {
        type: 'bar',
        data: {
            labels: formaLabels,
            datasets: [{
                label: 'Taxa',
                data: formaValues,
                backgroundColor: cores,
                borderColor: cores.map(c => c.replace('0.6', '1')),
                borderWidth: 1
            }]
        },
        options: {
            plugins: { legend: { display: false }},
            scales: {
                y: {
                    ticks: {
                        callback: val => val.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' })
                    }
                }
            }
        }
    });

    const bandeiraData = {!! json_encode($dadosGraficos['porBandeira']) !!};
    const bandeiraLabels = Object.keys(bandeiraData);
    const bandeiraValues = bandeiraLabels.map(label => bandeiraData[label].taxas);

    new Chart(document.getElementById('chartBandeira'), {
        type: 'pie',
        data: {
            labels: bandeiraLabels,
            datasets: [{
                data: bandeiraValues,
                backgroundColor: cores,
                borderColor: cores.map(c => c.replace('0.6', '1'))
            }]
        },
        options: {
            plugins: {
                tooltip: {
                    callbacks: {
                        label: ctx => `${ctx.label}: ${ctx.parsed.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' })}`
                    }
                }
            }
        }
    });

    const evolucaoData = {!! json_encode($dadosGraficos['evolucaoDiaria']) !!};
    const dias = Object.keys(evolucaoData);
    const taxas = dias.map(d => evolucaoData[d].taxas);
    const totais = dias.map(d => evolucaoData[d].total);

    new Chart(document.getElementById('chartEvolucaoDiaria'), {
        type: 'line',
        data: {
            labels: dias,
            datasets: [
                {
                    label: 'Total',
                    data: totais,
                    borderColor: 'rgba(54, 162, 235, 1)',
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    fill: true
                },
                {
                    label: 'Taxas',
                    data: taxas,
                    borderColor: 'rgba(255, 99, 132, 1)',
                    backgroundColor: 'rgba(255, 99, 132, 0.2)',
                    fill: true
                }
            ]
        },
        options: {
            plugins: {
                tooltip: {
                    callbacks: {
                        label: ctx => `${ctx.dataset.label}: ${ctx.parsed.y.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' })}`
                    }
                }
            },
            scales: {
                y: {
                    ticks: {
                        callback: val => val.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' })
                    }
                }
            }
        }
    });
});
</script>
@endsection
