@extends('layouts.app', ['title' => 'Consignações'])
@section('content')

<div class="container-fluid pt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <h4 class="card-title mb-0">
                                <i class="ri-store-2-line me-2"></i>
                                Consignações
                            </h4>
                        </div>
                        <div class="col-md-6 text-end">
                            @can('consignacao_create')
                            <a href="{{ route('consignacao.create') }}" class="btn btn-success">
                                <i class="ri-add-circle-fill me-1"></i>
                                Nova Consignação
                            </a>
                            @endcan
                        </div>
                    </div>

                    <!-- Filtros -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            {!! Form::open()->fill(request()->all())->get() !!}
                            <div class="row">
                                <div class="col-md-3">
                                    {!! Form::select('cliente_id', 'Cliente', $clientes->pluck('nome', 'id')->prepend('Todos', ''))->attrs(['class' => 'form-control select2']) !!}
                                </div>
                                <div class="col-md-3">
                                    {!! Form::select('funcionario_id', 'Vendedor', $funcionarios->pluck('nome', 'id')->prepend('Todos', ''))->attrs(['class' => 'form-control select2']) !!}
                                </div>
                                <div class="col-md-1">
                                    {!! Form::select('status', 'Status', [
                                        '' => 'Todos',
                                        'ativa' => 'Aberta',
                                        'finalizada' => 'Finalizada',
                                        'cancelada' => 'Cancelada'
                                    ])->attrs(['class' => 'form-control select2']) !!}
                                </div>
                                <div class="col-md-2">
                                    {!! Form::date('start_date', 'Data Inicial')->attrs(['class' => 'form-control']) !!}
                                </div>
                                <div class="col-md-2">
                                    {!! Form::date('end_date', 'Data Final')->attrs(['class' => 'form-control']) !!}
                                </div>
                                <div class="col-md-2 d-flex align-items-end gap-1">
                                    <button type="submit" class="btn btn-primary w-50">
                                        <i class="ri-search-line me-1"></i>
                                        Filtrar
                                    </button>
                                    <a href="{{ route('consignacao.index') }}" class="btn btn-secondary w-50">
                                        <i class="ri-refresh-line me-1"></i>
                                        Limpar
                                    </a>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>

                    <!-- Tabela de Consignações -->
                    <div class="table-responsive">
                        <table class="table table-striped table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th class="text-center">Nº</th>
                                    <th>Cliente</th>
                                    <th>Vendedor</th>
                                    <th class="text-center">Data</th>
                                    <th class="text-center">Vencimento</th>
                                    <th class="text-end">Valor Total</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($consignacoes as $consignacao)
                                <tr>
                                    <td class="text-center">
                                        <span class="fw-bold">{{ $consignacao->numero_consignacao }}</span>
                                    </td>
                                    <td>
                                        <div class="fw-semibold">
                                            {{ $consignacao->cliente->nome_fantasia ?? $consignacao->cliente->razao_social ?? 'Sem cliente' }}
                                        </div>
                                    </td>
                                    <td><span class="fw-semibold">{{ $consignacao->funcionario->nome ?? '--' }}</span></td>
                                    <td class="text-center">{{ $consignacao->data_consignacao->format('d/m/Y H:i') }}</td>
                                    <td class="text-center">
                                        @if($consignacao->data_vencimento)
                                            {{ $consignacao->data_vencimento->format('d/m/Y') }}
                                        @else
                                            <span class="text-muted">--</span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <span class="fw-bold text-success">{{ __moeda($consignacao->valor_total) }}</span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-{{ $consignacao->status_color }} px-3 py-2 fs-6">
                                            {{ $consignacao->status_text }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group btn-group-sm" role="group">
                                            @can('consignacao_view')
                                            <a href="{{ route('consignacao.show', $consignacao->id) }}" class="btn btn-info" title="Visualizar">
                                                <i class="ri-eye-line"></i>
                                            </a>
                                            @endcan
                                            
                                            @if($consignacao->isAtiva())
                                            @can('consignacao_edit')
                                            <a href="{{ route('consignacao.devolucao', $consignacao->id) }}" class="btn btn-warning" title="Devolver">
                                                <i class="ri-arrow-go-back-line"></i>
                                            </a>
                                            @endcan
                                            @endif

                                            @if($consignacao->podeSerCancelada())
                                            @can('consignacao_delete')
                                            <form action="{{ route('consignacao.destroy', $consignacao->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Tem certeza que deseja cancelar esta consignação?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger" title="Cancelar">
                                                    <i class="ri-close-line"></i>
                                                </button>
                                            </form>
                                            @endcan
                                            @endif

                                            <a href="{{ route('consignacao.imprimir', $consignacao->id) }}" class="btn btn-secondary" title="Imprimir" target="_blank">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="ri-inbox-line fs-1"></i>
                                            <p class="mt-2">Nenhuma consignação encontrada</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginação -->
                    <div class="d-flex justify-content-center">
                        {{ $consignacoes->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('css')
<style>
/* ESPAÇAMENTO GERAL */
.container-fluid {
    padding-top: 24px !important;
}
.card {
    background: #f7f9fa !important;
    border: 1px solid #e3e6ea !important;
    border-radius: 10px !important;
    margin-bottom: 24px !important;
    box-shadow: 0 2px 8px rgba(0,0,0,0.04) !important;
}
.card-header {
    background: #eef1f4 !important;
    border-bottom: 1px solid #e3e6ea !important;
    border-radius: 10px 10px 0 0 !important;
    padding: 12px 16px !important;
}
.card-body {
    padding: 16px !important;
    border-radius: 0 0 10px 10px !important;
}

/* CABEÇALHO MAIS VISÍVEL */
.table.table-striped.table-hover.align-middle thead.table-light th {
    background: #e9ecef !important;
    color: #222 !important;
    font-weight: bold !important;
    font-size: 15px !important;
    border-bottom: 2px solid #bfc4ca !important;
    padding: 12px 8px !important;
}

/* ALINHAMENTO E PADRONIZAÇÃO DOS BOTÕES DE AÇÃO */
.table td .btn-group {
    display: flex !important;
    gap: 8px !important;
    align-items: center !important;
    justify-content: center !important;
}
.table td .btn-group .btn,
.table td .btn-group form .btn {
    width: 40px !important;
    height: 40px !important;
    min-width: 40px !important;
    min-height: 40px !important;
    max-width: 40px !important;
    max-height: 40px !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    padding: 0 !important;
    font-size: 20px !important;
    border-radius: 6px !important;
    margin: 0 !important;
    box-sizing: border-box !important;
}
.table td .btn-group form {
    margin: 0 !important;
    display: inline !important;
}

/* LINHAS ALTERNADAS MAIS VISÍVEIS */
.table-striped > tbody > tr:nth-of-type(odd) {
    background-color: #f8fafc !important;
}

/* DADOS DO CLIENTE */
.table td .fw-semibold {
    font-size: 14px !important;
    color: #333 !important;
}
.table thead th, .table-light th, .table-bordered thead th {
    background: #495057 !important;
    color: #fff !important;
    font-weight: bold !important;
    font-size: 15px !important;
    border-bottom: 2px solid #343a40 !important;
    padding: 12px 8px !important;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
</style>
@endsection

@section('js')
<script>
$(document).ready(function() {
    // Inicializar select2
    $('.select2').select2({
        placeholder: 'Selecione...',
        allowClear: true
    });
});
</script>
@endsection 