@extends('layouts.app', ['title' => 'Devolução de Consignação'])
@section('content')
<div class="container-fluid pt-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">
                    <i class="ri-arrow-go-back-line me-2"></i>
                    Devolução - Consignação #{{ $consignacao->numero_consignacao }}
                </h4>
                <div>
                    <a href="{{ route('consignacao.show', $consignacao->id) }}" class="btn btn-secondary">
                        <i class="ri-arrow-left-line me-1"></i>
                        Voltar
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <strong>Registrar Devolução</strong>
        </div>
        <div class="card-body">
            <form action="{{ route('consignacao.registrar_devolucao', $consignacao->id) }}" method="POST">
                @csrf
                <div class="table-responsive">
                    <table class="table table-bordered table-striped align-middle">
                        <thead>
                            <tr>
                                <th>Produto</th>
                                <th class="text-center" style="width: 150px;">Qtd. Consignada</th>
                                <th class="text-center" style="width: 200px;">Qtd. A Devolver</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($consignacao->itens as $item)
                            <tr>
                                <td class="fw-bold text-dark">
                                    <div class="fw-semibold">{{ $item->produto->nome ?? $item->descricao }}</div>
                                    <small class="text-muted">{{ $item->produto->codigo ?? '' }}</small>
                                </td>
                                <td class="text-center">{{ $item->quantidade }}</td>
                                <td>
                                    <input type="number" 
                                           name="itens[{{ $item->id }}][quantidade]" 
                                           class="form-control text-center"
                                           min="0" 
                                           max="{{ $item->quantidade - $item->quantidade_devolvida }}"
                                           step="0.001"
                                           value="0">
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <label for="observacao" class="form-label">Observação</label>
                        <textarea name="observacao" id="observacao" rows="2" class="form-control"></textarea>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12 text-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-save-line me-1"></i>
                            Registrar Devolução e Vender o Restante
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('css')
<style>
.container-fluid {
    padding-top: 24px !important;
}
.card {
    background: #f7f9fa !important;
    border: 1px solid #e3e6ea !important;
    border-radius: 10px !important;
    margin-bottom: 24px !important;
    box-shadow: 0 2px 8px rgba(0,0,0,0.04) !important;
}
.card-header {
    background: #eef1f4 !important;
    border-bottom: 1px solid #e3e6ea !important;
    border-radius: 10px 10px 0 0 !important;
    padding: 12px 16px !important;
}
.table thead th {
    background: #495057 !important;
    color: #fff !important;
    font-weight: bold !important;
    font-size: 15px !important;
    border-bottom: 2px solid #343a40 !important;
    padding: 12px 8px !important;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.table-striped > tbody > tr:nth-of-type(odd) {
    background-color: #f1f3f7 !important;
}
.table-striped > tbody > tr:nth-of-type(even) {
    background-color: #fff !important;
}
.table-bordered td, .table-bordered th {
    border: 1px solid #dee2e6 !important;
}
.table tbody td {
    padding: 14px 8px !important;
    vertical-align: middle !important;
    font-size: 15px;
}
.table tbody td.fw-bold {
    background: #e9ecef !important;
    font-weight: bold !important;
    color: #222 !important;
    border-left: 4px solid #495057 !important;
}
.form-control {
    border: 1px solid #ced4da !important;
    padding: 8px 12px !important;
}
.form-control:focus {
    border-color: #80bdff !important;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25) !important;
}
</style>
@endsection 