@extends('layouts.app', ['title' => 'Detalhes'])
@section('content')
<style>
    .pagamentos-compactos {
        display: flex;
        flex-direction: column;
        gap: 0.3rem;
    }
    
    .pagamentos-compactos .badge {
        min-width: 80px;
        display: inline-block;
        width: auto;
        white-space: normal;
        text-align: left;
        padding: 0.4em 0.65em;
        line-height: 1.2;
    }
    
    .pagamentos-compactos .mb-1 {
        display: flex;
        align-items: center;
        margin-bottom: 0 !important;
    }
    
    .pagamentos-compactos .parcelamento {
        color: #6c757d;
        font-size: 0.9em;
        white-space: nowrap;
    }
    
    /* Estilo personalizado para zebra striping com cinza claro */
    .table-striped-light tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, 0.02);
    }
    
    /* Alinhar valores à esquerda */
    .table-centered td {
        vertical-align: middle;
    }
    
    .text-end.text-success,
    .text-end.text-warning,
    .text-end {
        text-align: left !important;
    }
    
    /* Melhorar exibição de pagamentos */
    .pagamento-info {
        display: block;
        margin-bottom: 4px;
    }
</style>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                @php
                // Inicialização antecipada das variáveis para evitar erro
                $somaSuprimento = $somaSuprimento ?? 0;
                $somaSangria = $somaSangria ?? 0;
                @endphp
                
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card border-primary shadow-sm">
                            <div class="card-header bg-primary text-white">
                                <h3 class="mb-0"><i class="ri-money-dollar-box-line me-2"></i>Total por Tipo de Pagamento</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    @foreach($somaTiposPagamento as $key => $tp)
                                    @if($tp > 0)
                                    <div class="col-sm-4 col-lg-3 col-md-6 mb-3">
                                        <div class="card h-100 {{ ($key == '05' || $key == '06' || $key == '15') ? 'border-warning' : 'border-success' }}">
                                            <div class="card-header {{ ($key == '05' || $key == '06' || $key == '15') ? 'bg-warning text-dark' : 'bg-success text-white' }}" style="min-height: 70px;">
                                                <h4 class="mb-1">
                                                    {{App\Models\Nfce::getTipoPagamento($key)}}
                                                </h4>
                                                @if($key == '05' || $key == '06' || $key == '15')
                                                <small class="text-muted d-block">(não soma no valor do caixa)</small>
                                                @endif
                                            </div>
                                            @php
                                            if($key == '01') $somaDinheiro = $tp;
                                            @endphp
                                            <div class="card-body text-center">
                                                <h3 class="{{ ($key == '05' || $key == '06' || $key == '15') ? 'text-warning' : 'text-success' }}">R$ {{ __moeda($tp) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Movimentações de Vendas -->
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="card border-primary shadow-sm">
                            <div class="card-header bg-primary text-white">
                                <h3 class="mb-0"><i class="ri-shopping-cart-line me-2"></i>Movimentações de Vendas</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-centered table-striped-light">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>ID</th>
                                                <th>Tipo</th>
                                                <th>Cliente</th>
                                                <th>Data</th>
                                                <th>Forma(s) de Pagamento</th>
                                                <th>À Vista</th>
                                                <th>A Prazo</th>
                                                <th>Valor Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php 
                                            $somaReceita = 0; 
                                            $somaDespesa = 0; 
                                            @endphp
                                            
                                            @forelse ($vendasAgrupadas as $venda)
                                                @if(!isset($venda->estado) || $venda->estado != 'cancelado')
                                                <tr>
                                                    @php
                                                    // Calcular quanto da venda é à vista vs a prazo
                                                    $valorAVista = 0;
                                                    $valorAPrazo = 0;
                                                    
                                                    foreach($venda->pagamentos as $pagamento) {
                                                        if($pagamento->a_prazo) {
                                                            $valorAPrazo += $pagamento->valor_pagamento;
                                                        } else {
                                                            $valorAVista += $pagamento->valor_pagamento;
                                                        }
                                                    }
                                                    @endphp
                                                    <td>{{ $venda->doc_id }}</td>
                                                    <td>{{ $venda->tipo }}</td>
                                                    <td>{{ $venda->cliente->razao_social ?? 'NÃO IDENTIFICADO' }}</td>
                                                    <td>{{ __data_pt($venda->created_at, 1) }}</td>
                                                    <td>
                                                        <div class="pagamentos-compactos">
                                                            @php
                                                            // Agrupar pagamentos por tipo para economizar espaço
                                                            $pagamentosAgrupados = [];
                                                            foreach($venda->pagamentos as $pag) {
                                                                $tipo = $pag->pagamento_nome;
                                                                if (!isset($pagamentosAgrupados[$tipo])) {
                                                                    $pagamentosAgrupados[$tipo] = [
                                                                        'a_prazo' => $pag->a_prazo,
                                                                        'valor' => 0,
                                                                        'info_parcela' => '',
                                                                        'num_parcelas' => $pag->num_parcelas ?? 1,
                                                                        'valor_parcela' => $pag->valor_parcela ?? 0,
                                                                        'parcelado' => $pag->parcelado ?? false
                                                                    ];
                                                                }

                                                                $pagamentosAgrupados[$tipo]['valor'] += $pag->valor_pagamento;
                                                                
                                                                if (isset($pag->parcelado) && $pag->parcelado && $pag->num_parcelas > 1) {
                                                                    $pagamentosAgrupados[$tipo]['info_parcela'] = "{$pag->num_parcelas}x R$ " . __moeda($pag->valor_parcela);
                                                                }
                                                            }
                                                            @endphp
                                                            
                                                            @foreach($pagamentosAgrupados as $tipo => $info)
                                                                <div class="mb-1">
                                                                    <span class="badge {{ $info['a_prazo'] ? 'bg-warning text-dark' : 'bg-success' }}">
                                                                        @if($info['parcelado'] && $info['num_parcelas'] > 1)
                                                                            {{ $tipo }} {{ $info['num_parcelas'] }}x R$ {{ __moeda($info['valor_parcela']) }}
                                                        @else
                                                                            {{ $tipo }}
                                                                        @endif
                                                                    </span>
                                                                    <div class="ms-1">
                                                                        <strong>R$ {{ __moeda($info['valor']) }}</strong>
                                                                        @if($info['a_prazo'])
                                                                            <span class="text-warning small ms-1">(Futuro)</span>
                                                        @endif
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </td>
                                                    <td class="text-end text-success">
                                                        <strong>R$ {{ __moeda($valorAVista) }}</strong>
                                                    </td>
                                                    <td class="text-end text-warning">
                                                        <strong>R$ {{ __moeda($valorAPrazo) }}</strong>
                                                    </td>
                                                    <td class="text-end">
                                                        <strong>R$ {{ __moeda($venda->valor_total) }}</strong>
                                                        <br>
                                                        @if($venda->receita == 1)
                                                            @if($venda->tem_a_prazo)
                                                                <span class="badge bg-warning text-dark">Misto</span>
                                                            @else
                                                                <span class="badge bg-success">Receita</span>
                                                            @endif
                                                        @else
                                                            <span class="badge bg-danger">Despesa</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                @php
                                                if($venda->receita == 1){                                                    
                                                    // Adiciona apenas valor à vista na soma de receita
                                                    $somaReceita += $valorAVista;
                                                } else {
                                                    $somaDespesa += $venda->valor_total;
                                                }
                                                @endphp
                                                @endif
                                            @empty
                                            <tr>
                                                <td colspan="6" class="text-center">Nenhum registro</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                        <tfoot class="table-dark">
                                            <tr>
                                                <td colspan="7" class="text-end"><strong>TOTAL DE VENDAS BRUTAS</strong></td>
                                                <td><strong>R$ {{ __moeda($totalVendas) }}</strong></td>
                                            </tr>
                                            <tr>
                                                <td colspan="7" class="text-end"><strong>TOTAL EFETIVO NO CAIXA</strong></td>
                                                <td><strong>R$ {{ __moeda($somaReceita - $somaDespesa) }}</strong></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Movimentações de Recebimentos -->
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="card border-success shadow-sm">
                            <div class="card-header bg-success text-white">
                                <h3 class="mb-0"><i class="ri-money-dollar-circle-line me-2"></i>Movimentações de Recebimentos</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-centered table-striped-light">
                                        <thead class="table-success">
                                            <tr>
                                                <th>ID</th>
                                                <th>Tipo</th>
                                                <th>Cliente</th>
                                                <th>Descrição</th>
                                                <th>Data</th>
                                                <th>Forma(s) de Pagamento</th>
                                                <th>Valor Total</th>
                                                <th>Valor Pago</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $totalRecebimentos = 0; $totalRecebidoEfetivo = 0; @endphp
                                            @forelse($recebimentosAgrupados as $conta)
                                            <tr>
                                                <td>{{ $conta->doc_id }}</td>
                                                <td>{{ $conta->tipo }}</td>
                                                <td>
                                                    @if(isset($conta->cliente) && $conta->cliente)
                                                        {{ $conta->cliente->razao_social ?? 'NÃO IDENTIFICADO' }}
                                                    @else
                                                        Não identificado
                                                    @endif
                                                </td>
                                                <td>{{ $conta->descricao }}</td>
                                                <td>{{ __data_pt($conta->created_at, 0) }}</td>
                                                <td>
                                                    <div class="pagamentos-compactos">
                                                        @foreach($conta->pagamentos as $pagamento)
                                                            <div class="mb-1">
                                                                <span class="badge bg-success">{{ $pagamento->pagamento_nome }}</span>
                                                                <strong>R$ {{ __moeda($pagamento->valor_pagamento) }}</strong>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </td>
                                                <td>
                                                    <strong>R$ {{ __moeda($conta->valor_integral) }}</strong>
                                                    @if($conta->status == 2)
                                                        <span class="badge bg-warning text-dark">Parcial</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <strong>R$ {{ __moeda($conta->valor_total_pago) }}</strong>
                                                    @if($conta->status == 1)
                                                        <span class="badge bg-success">Completo</span>
                                                    @endif
                                                </td>
                                            </tr>
                                            @php 
                                                $totalRecebimentos += $conta->valor_total_pago;
                                                $totalRecebidoEfetivo = $totalRecebimentos;
                                            @endphp
                                            @empty
                                            <tr>
                                                <td colspan="8" class="text-center">Nenhum registro</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                        @if(count($recebimentosAgrupados) > 0)
                                        <tfoot class="table-success">
                                            <tr>
                                                <td colspan="7" class="text-end"><strong>TOTAL</strong></td>
                                                <td><strong>R$ {{ __moeda($totalRecebimentos) }}</strong></td>
                                            </tr>
                                        </tfoot>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Movimentações de Trocas -->
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="card border-warning shadow-sm">
                            <div class="card-header bg-warning text-dark">
                                <h3 class="mb-0"><i class="ri-exchange-fill me-2"></i>Movimentações de Trocas</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-centered table-striped-light">
                                        <thead class="table-warning">
                                            <tr>
                                                <th>ID</th>
                                                <th>Cliente</th>
                                                <th>Data</th>
                                                <th>Forma de Pagamento</th>
                                                <th>Valor Devolvido</th>
                                                <th>Valor Trocado</th>
                                                <th>Diferença</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php 
                                            $somaDevolucoesDinheiro = 0; 
                                            $somaTrocasDiferenca = 0; 
                                            @endphp
                                            
                                            @forelse ($devolucoes->where('is_troca', true) as $troca)
                                                @php
                                                // Calcular o valor da troca (valor devolvido - diferença)
                                                $valorTrocado = $troca->valor_total - $troca->valor_diferenca;
                                                
                                                // Se for troca com diferença em dinheiro ou PIX, adicionar ao total
                                                if (($troca->tipo_pagamento == '01' || $troca->tipo_pagamento == '17') && $troca->valor_diferenca != 0) {
                                                    if ($troca->valor_diferenca > 0) {
                                                        // Se diferença é positiva, cliente recebeu: sai do caixa
                                                        $somaDevolucoesDinheiro += $troca->valor_diferenca;
                                                    } else {
                                                        // Se diferença é negativa, cliente pagou: entra no caixa
                                                        $somaTrocasDiferenca += abs($troca->valor_diferenca);
                                                    }
                                                }
                                                @endphp
                                                <tr>
                                                    <td>{{ $troca->id }}</td>
                                                    <td>{{ $troca->cliente ? $troca->cliente->razao_social : 'NÃO IDENTIFICADO' }}</td>
                                                    <td>{{ __data_pt($troca->data_devolucao) }}</td>
                                                    <td>
                                                        {{ App\Models\Nfce::getTipoPagamento($troca->tipo_pagamento) }}
                                                    </td>
                                                    <td>
                                                        <strong>R$ {{ __moeda($troca->valor_total) }}</strong>
                                                    </td>
                                                    <td>
                                                        <strong>R$ {{ __moeda($valorTrocado) }}</strong>
                                                    </td>
                                                    <td>
                                                        @if($troca->valor_diferenca != 0)
                                                            <strong class="{{ $troca->valor_diferenca > 0 ? 'text-danger' : 'text-success' }}">
                                                                R$ {{ __moeda(abs($troca->valor_diferenca)) }}
                                                                @if($troca->valor_diferenca > 0)
                                                                    <small>(Cliente recebeu)</small>
                                                                @else
                                                                    <small>(Cliente pagou)</small>
                                                                @endif
                                                            </strong>
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="7" class="text-center">Nenhuma troca registrada neste caixa.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                        @if($devolucoes->where('is_troca', true)->count() > 0)
                                        <tfoot class="table-warning">
                                            <tr>
                                                <td colspan="6" class="text-end"><strong>Total de Saídas (Diferenças pagas ao cliente):</strong></td>
                                                <td><strong class="text-danger">R$ {{ __moeda($somaDevolucoesDinheiro) }}</strong></td>
                                            </tr>
                                            <tr>
                                                <td colspan="6" class="text-end"><strong>Total de Entradas (Diferenças pagas pelo cliente):</strong></td>
                                                <td><strong class="text-success">R$ {{ __moeda($somaTrocasDiferenca) }}</strong></td>
                                            </tr>
                                        </tfoot>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Movimentações de Devoluções -->
                <div class="row mt-5">
                    <div class="col-12">
                        <div class="card border-danger shadow-sm">
                            <div class="card-header bg-danger text-white">
                                <h3 class="mb-0"><i class="ri-refund-2-line me-2"></i>Movimentações de Devoluções</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-centered table-striped-light">
                                        <thead class="table-danger">
                                            <tr>
                                                <th>ID</th>
                                                <th>Tipo Venda</th>
                                                <th>Cliente</th>
                                                <th>Data</th>
                                                <th>Forma de Pagamento</th>
                                                <th>Valor Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $totalDevolucoesSimples = 0; @endphp
                                            @forelse ($devolucoes->where('is_troca', false) as $devolucao)
                                                @php $totalDevolucoesSimples += $devolucao->valor_total; @endphp
                                                <tr>
                                                    <td>{{ $devolucao->id }}</td>
                                                    <td>{{ strtoupper($devolucao->tipo_venda) }}</td>
                                                    <td>{{ $devolucao->cliente ? $devolucao->cliente->razao_social : 'NÃO IDENTIFICADO' }}</td>
                                                    <td>{{ __data_pt($devolucao->data_devolucao) }}</td>
                                                    <td>
                                                        {{ App\Models\Nfce::getTipoPagamento($devolucao->tipo_pagamento) }}
                                                    </td>
                                                    <td>
                                                        <strong>R$ {{ __moeda($devolucao->valor_total) }}</strong>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="6" class="text-center">Nenhuma devolução registrada neste caixa.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                        @if($devolucoes->where('is_troca', false)->count() > 0)
                                        <tfoot class="table-danger">
                                            <tr>
                                                <td colspan="5" class="text-end"><strong>Total de Devoluções:</strong></td>
                                                <td><strong>R$ {{ __moeda($totalDevolucoesSimples) }}</strong></td>
                                            </tr>
                                        </tfoot>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-primary text-white">
                                <h3 class="mb-0"><i class="ri-file-chart-line me-2"></i>Demonstrativo Financeiro do Caixa</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <!-- Coluna de Entradas -->
                                    <div class="col-md-4">
                                        <div class="card border-success h-100">
                                            <div class="card-header bg-success text-white">
                                                <h4 class="mb-0"><i class="ri-arrow-down-circle-line me-2"></i>Entradas</h4>
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Valor de Abertura
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($item->valor_abertura) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Vendas Recebidas
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($totalVendas - ($somaTiposPagamento['05'] ?? 0) - ($somaTiposPagamento['06'] ?? 0) - ($somaTiposPagamento['15'] ?? 0) - ($somaTiposPagamento['16'] ?? 0)) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Contas Recebidas
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($totalRecebidoEfetivo) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Suprimentos
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($somaSuprimento) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Diferenças Pagas pelo Cliente (Trocas)
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($somaTrocasDiferenca) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Total de Entradas</strong>
                                                        <span class="badge bg-success rounded-pill">R$ {{ __moeda($item->valor_abertura + $totalVendas - ($somaTiposPagamento['05'] ?? 0) - ($somaTiposPagamento['06'] ?? 0) - ($somaTiposPagamento['15'] ?? 0) - ($somaTiposPagamento['16'] ?? 0) + $totalRecebidoEfetivo + $somaSuprimento + $somaTrocasDiferenca) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Coluna de Saídas -->
                                    <div class="col-md-4">
                                        <div class="card border-danger h-100">
                                            <div class="card-header bg-danger text-white">
                                                <h4 class="mb-0"><i class="ri-arrow-up-circle-line me-2"></i>Saídas</h4>
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Sangrias
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($somaSangria) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Contas Pagas
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($pagar->sum('valor_integral')) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Devoluções em Dinheiro
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Devoluções em Cartão
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Devoluções em Crédito Loja
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['credito']) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        Diferenças Pagas ao Cliente (Trocas)
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($somaDevolucoesDinheiro) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Total de Saídas</strong>
                                                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($somaSangria + $pagar->sum('valor_integral') + $devolucoesPorTipo['dinheiro'] + $devolucoesPorTipo['cartao'] + $devolucoesPorTipo['credito'] + $somaDevolucoesDinheiro) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Coluna de Saldo e Pendente -->
                                    <div class="col-md-4">
                                        <div class="card border-info h-100">
                                            <div class="card-header bg-info text-white">
                                                <h4 class="mb-0"><i class="ri-funds-box-line me-2"></i>Saldos e Pendências</h4>
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Saldo em Caixa</strong>
                                                        <span class="badge bg-primary rounded-pill">R$ {{ __moeda($item->valor_abertura + $totalVendas - ($somaTiposPagamento['05'] ?? 0) - ($somaTiposPagamento['06'] ?? 0) - ($somaTiposPagamento['15'] ?? 0) - ($somaTiposPagamento['16'] ?? 0) + $totalRecebidoEfetivo + $somaSuprimento + $somaTrocasDiferenca - $somaSangria - $pagar->sum('valor_integral') - $devolucoesPorTipo['dinheiro'] - $somaDevolucoesDinheiro) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>Vendas Pendentes (Crediário)</span>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda($somaTiposPagamento['06'] ?? 0) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>Vendas Pendentes (Boleto)</span>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda($somaTiposPagamento['15'] ?? 0) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                                        <span>Vendas Pendentes (Crédito Loja)</span>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda($somaTiposPagamento['05'] ?? 0) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                        <strong>Total Vendas Pendentes</strong>
                                                        <span class="badge bg-warning rounded-pill">R$ {{ __moeda(($somaTiposPagamento['05'] ?? 0) + ($somaTiposPagamento['06'] ?? 0) + ($somaTiposPagamento['15'] ?? 0) + ($somaTiposPagamento['16'] ?? 0)) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Resumo Visual Final -->
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div class="card border-primary">
                                            <div class="card-header bg-primary text-white">
                                                <h4 class="mb-0"><i class="ri-bank-card-line me-2"></i>Resumo Geral</h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row align-items-center">
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Vendas Brutas</h5>
                                                            <h3 class="text-primary">R$ {{ __moeda($totalVendas) }}</h3>
                                                            <small class="text-muted">(Total de todas as vendas)</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Vendas Recebidas</h5>
                                                            <h3 class="text-success">R$ {{ __moeda($totalVendas - ($somaTiposPagamento['05'] ?? 0) - ($somaTiposPagamento['06'] ?? 0) - ($somaTiposPagamento['15'] ?? 0) - ($somaTiposPagamento['16'] ?? 0)) }}</h3>
                                                            <small class="text-muted">(Dinheiro, Cartão, PIX, etc.)</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Vendas Pendentes</h5>
                                                            <h3 class="text-warning">R$ {{ __moeda(($somaTiposPagamento['05'] ?? 0) + ($somaTiposPagamento['06'] ?? 0) + ($somaTiposPagamento['15'] ?? 0) + ($somaTiposPagamento['16'] ?? 0)) }}</h3>
                                                            <small class="text-muted">(Crediário, Boleto, Crédito Loja)</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="text-center border border-success rounded p-3 bg-light">
                                                            <h5>Saldo Final em Caixa</h5>
                                                            <small class="text-muted d-block mb-1">(Abertura + Vendas + Recebimentos + Suprimentos + Diferenças Pagas - Sangrias - Contas Pagas - Devoluções - Diferenças a Pagar)</small>
                                                            <h2 class="text-success">R$ {{ __moeda($item->valor_abertura + $totalVendas - ($somaTiposPagamento['05'] ?? 0) - ($somaTiposPagamento['06'] ?? 0) - ($somaTiposPagamento['15'] ?? 0) - ($somaTiposPagamento['16'] ?? 0) + $totalRecebidoEfetivo + $somaSuprimento + $somaTrocasDiferenca - $somaSangria - $pagar->sum('valor_integral') - $devolucoesPorTipo['dinheiro'] - $somaDevolucoesDinheiro) }}</h2>
                                                            <div class="mt-2 text-start small">
                                                                <button class="btn btn-sm btn-outline-info w-100" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFormula" aria-expanded="false" aria-controls="collapseFormula">
                                                                    <i class="ri-information-line me-1"></i>Ver detalhes do cálculo
                                                                </button>
                                                                <div class="collapse" id="collapseFormula">
                                                                    <div class="alert alert-info p-2 mt-2">
                                                                        <strong>Fórmula:</strong>
                                                                        <p class="mb-0">
                                                                            <i class="ri-corner-right-down-line me-1"></i>Valor Abertura (R$ {{ __moeda($item->valor_abertura) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-add-line me-1"></i>Vendas Recebidas (R$ {{ __moeda($totalVendas - ($somaTiposPagamento['05'] ?? 0) - ($somaTiposPagamento['06'] ?? 0) - ($somaTiposPagamento['15'] ?? 0) - ($somaTiposPagamento['16'] ?? 0)) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-add-line me-1"></i>Contas Recebidas (R$ {{ __moeda($totalRecebidoEfetivo) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-add-line me-1"></i>Suprimentos (R$ {{ __moeda($somaSuprimento) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-add-line me-1"></i>Diferenças pagas pelo cliente (R$ {{ __moeda($somaTrocasDiferenca) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-subtract-line me-1"></i>Sangrias (R$ {{ __moeda($somaSangria) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-subtract-line me-1"></i>Contas Pagas (R$ {{ __moeda($pagar->sum('valor_integral')) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-subtract-line me-1"></i>Devoluções em Dinheiro (R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }})
                                                                        </p>
                                                                        <p class="mb-0">
                                                                            <i class="ri-subtract-line me-1"></i>Diferenças pagas ao cliente (R$ {{ __moeda($somaDevolucoesDinheiro) }})
                                                                        </p>
                                                                        <hr class="my-1">
                                                                        <p class="mb-0 fw-bold">
                                                                            <i class="ri-equals-line me-1"></i>Total (R$ {{ __moeda($item->valor_abertura + $totalVendas - ($somaTiposPagamento['05'] ?? 0) - ($somaTiposPagamento['06'] ?? 0) - ($somaTiposPagamento['15'] ?? 0) - ($somaTiposPagamento['16'] ?? 0) + $totalRecebidoEfetivo + $somaSuprimento + $somaTrocasDiferenca - $somaSangria - $pagar->sum('valor_integral') - $devolucoesPorTipo['dinheiro'] - $somaDevolucoesDinheiro) }})
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="row align-items-center mt-4">
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Valor de Abertura</h5>
                                                            <h3 class="text-primary">R$ {{ __moeda($item->valor_abertura) }}</h3>
                                                            <small class="text-muted">(Saldo inicial do caixa)</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Contas Recebidas</h5>
                                                            <h3 class="text-info">R$ {{ __moeda($totalRecebidoEfetivo) }}</h3>
                                                            <small class="text-muted">(Valor efetivo recebido)</small>
                                                            <small class="text-muted d-block">(Valor total das contas: R$ {{ __moeda($receber->sum('valor_integral')) }})</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Suprimentos</h5>
                                                            <h3 class="text-success">R$ {{ __moeda($somaSuprimento) }}</h3>
                                                            <small class="text-muted">(Entradas de dinheiro no caixa)</small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Sangrias</h5>
                                                            <h3 class="text-danger">R$ {{ __moeda($somaSangria) }}</h3>
                                                            <small class="text-muted">(Saídas de dinheiro do caixa)</small>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row align-items-center mt-2">
                                                    <div class="col-md-3">
                                                        <div class="text-center mb-3">
                                                            <h5>Devoluções</h5>
                                                            <h3 class="text-danger">R$ {{ __moeda($totalDevolucoes) }}</h3>
                                                            <small class="text-muted">
                                                                <span class="d-block">Dinheiro: R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</span>
                                                                <span class="d-block">Cartão: R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</span>
                                                                <span class="d-block">Crédito: R$ {{ __moeda($devolucoesPorTipo['credito']) }}</span>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 m-3">
                <a href="{{ route('caixa.index') }}" class="btn btn-info">
                    <i class="ri-arrow-left-line"></i>
                    Voltar para o Caixa
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Card de resumo de devoluções -->
<div class="row mt-3">
    <div class="col-md-6">
        <div class="card border-danger">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0"><i class="ri-refund-line"></i> Devoluções no Período</h5>
            </div>
            <div class="card-body">
                <div class="d-flex flex-wrap justify-content-between">
                    <div class="mb-3 mr-4">
                        <label class="text-muted">Dinheiro:</label>
                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</span>
                    </div>
                    <div class="mb-3 mr-4">
                        <label class="text-muted">Cartão:</label>
                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</span>
                    </div>
                    <div class="mb-3 mr-4">
                        <label class="text-muted">Crédito Loja:</label>
                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['credito']) }}</span>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted">PIX:</label>
                        <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['pix']) }}</span>
                    </div>
                </div>
                <div class="text-center pt-3 border-top">
                    <span class="text-muted">Total de Devoluções: </span>
                    <span class="badge bg-danger rounded-pill">R$ {{ __moeda($devolucoesPorTipo['dinheiro'] + $devolucoesPorTipo['cartao'] + $devolucoesPorTipo['credito'] + $devolucoesPorTipo['pix'] + $somaDevolucoesDinheiro) }}</span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card border-success">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="ri-money-dollar-circle-line"></i> Saldo Final em Caixa</h5>
            </div>
            <div class="card-body">
                <div class="alert alert-light border">
                    <strong>Fórmula:</strong>
                    <ul class="list-unstyled mb-0 small">
                        <li><i class="ri-add-line text-success"></i> Valor de Abertura (R$ {{ __moeda($item->valor_abertura) }})</li>
                        <li><i class="ri-add-line text-success"></i> Vendas à Vista</li>
                        <li><i class="ri-add-line text-success"></i> Contas Recebidas</li>
                        <li><i class="ri-add-line text-success"></i> Suprimentos (R$ {{ __moeda($somaSuprimento) }})</li>
                        <li><i class="ri-subtract-line text-danger"></i> Sangrias (R$ {{ __moeda($somaSangria) }})</li>
                        <li><i class="ri-subtract-line text-danger"></i> Contas pagas (R$ {{ __moeda($pagar->sum('valor_integral')) }})</li>
                        <li><i class="ri-subtract-line text-danger"></i> Devoluções em Dinheiro (R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }})</li>
                        <li><i class="ri-subtract-line text-danger"></i> Devoluções em PIX (R$ {{ __moeda($devolucoesPorTipo['pix']) }})</li>
                    </ul>
                </div>
                <div class="text-center">
                    <span class="fs-4 fw-bold text-success">R$ {{ __moeda($item->valor_abertura + $somaReceita - $somaDespesa + $valorRecebidoTotal + $somaSuprimento - $somaSangria - $pagar->sum('valor_integral') - $devolucoesPorTipo['dinheiro'] - $devolucoesPorTipo['pix'] - $somaDevolucoesDinheiro) }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para detalhes das devoluções -->
<div class="modal fade" id="modalDetalhesDevolucoesERecebimentos" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes de Devoluções e Recebimentos</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <h6 class="border-bottom pb-2">Devoluções por Tipo</h6>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <small class="text-muted d-block">Dinheiro</small>
                                    <span class="d-block">R$ {{ __moeda($devolucoesPorTipo['dinheiro']) }}</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <small class="text-muted d-block">Cartão</small>
                                    <span class="d-block">R$ {{ __moeda($devolucoesPorTipo['cartao']) }}</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <small class="text-muted d-block">Crédito Loja</small>
                                    <span class="d-block">R$ {{ __moeda($devolucoesPorTipo['credito']) }}</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <small class="text-muted d-block">PIX</small>
                                    <span class="d-block">R$ {{ __moeda($devolucoesPorTipo['pix']) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

@endsection
