@if($item != null)
<div class="row">
    <div class="col-12">
        <div class="alert alert-warning">
            <div class="d-flex align-items-center">
                <i class="ri-alert-line me-2" style="font-size: 24px;"></i>
                <div>
                    <h4 class="text-success mb-1">Você já possui um caixa aberto!</h4>
                    <p class="mb-0">Não é possível abrir um novo caixa enquanto este estiver ativo. Você deve fechar o caixa atual antes de abrir um novo.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Informações do Caixa Aberto</h5>
                <ul class="list-group">
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Valor de Abertura:</span>
                        <strong>R$ {{ __moeda($item->valor_abertura) }}</strong>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Data/Hora de Abertura:</span>
                        <strong>{{ __data_hora($item->created_at) }}</strong>
                    </li>
                    @if($item->contaEmpresa)
                    <li class="list-group-item d-flex justify-content-between">
                        <span>Conta:</span>
                        <strong>{{ $item->contaEmpresa->nome }}</strong>
                    </li>
                    @endif
                </ul>
                <div class="mt-3 text-center">
                    <a href="{{ route('caixa.index') }}" class="btn btn-primary px-4">
                        <i class="ri-arrow-right-line me-1"></i>Ir para o Caixa
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@else
<div class="row g-2">
    <div class="col-md-2">
        {!!Form::text('valor_abertura', 'Valor de abertura')->attrs(['class' => 'moeda'])->required()
        !!}
    </div>

    @if(__countLocalAtivo() > 1)
    <div class="col-md-2">
        <label for="">Local</label>

        <select id="inp-local_id" required class="select2 class-required" data-toggle="select2" name="local_id">
            <option value="">Selecione</option>
            @foreach(__getLocaisAtivoUsuario() as $local)
            <option @isset($item) @if($item->local_id == $local->id) selected @endif @endif value="{{ $local->id }}">{{ $local->descricao }}</option>
            @endforeach
        </select>
    </div>
    @else
    <input id="inp-local_id" type="hidden" value="{{ __getLocalAtivo() ? __getLocalAtivo()->id : '' }}" name="local_id">
    @endif

    <div class="col-md-3 div-conta-empresa">
        {!!Form::select('conta_empresa_id', 'Escolha o Caixa')
        ->required()
        !!}
    </div>

    <div class="col-md-6">
        {!!Form::text('observacao', 'Observação')->attrs(['class' => ''])
        !!}
    </div>
    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>
@endif
