$(function(){
	setTimeout(() => {
		validaBtn()
	}, 10)
})

$(document).on("click", ".select-all", function () {
	let isChecked = $(this).is(':checked')
	$('.select-check').each(function(){
		$(this).prop('checked', isChecked)
	})
	setTimeout(() => {
		validaBtn()
	}, 10)
});

$(document).on("click", ".select-check", function () {
	validaBtn()
});

function validaBtn(){
	$('.btn-pay').attr('disabled', 1)
	let total = 0
	$('.select-check').each(function(){
		if($(this).is(':checked')){
			let v = $(this).closest('td').next().next().next().next().next()[0].innerText
			if(v){
				total += convertMoedaToFloat(v)
			}
			$('.btn-pay').removeAttr('disabled')
		}
	})

	setTimeout(() => {
		$('.total-pay').text(convertFloatToMoeda(total))
	}, 50)
}

// Abrir modal de pagamento
$(document).on("click", ".btn-pay", function () {
	// Preencher valor no modal
	$('#valor_total').val($('.total-pay').text())
	
	// Mostrar modal
	$('#modal_conta_pagar').modal('show')
});

// Controlar exibição dos campos baseado no tipo de pagamento
$(document).on("change", "#tipo_pagamento", function () {
	let tipo = $(this).val()
	
	if(tipo == '1') {
		// Gerar conta a pagar
		$('#campos_conta_pagar').show()
		$('#campos_pagamento_direto').hide()
		
		// Configurar campos obrigatórios
		$('#data_vencimento').prop('required', true)
	} else {
		// Pagamento direto
		$('#campos_conta_pagar').hide()
		$('#campos_pagamento_direto').show()
		
		// Configurar campos obrigatórios
		$('#data_vencimento').prop('required', false)
	}
});

// Confirmar pagamento
$(document).on("click", "#btn-confirmar-pagamento", function () {
	let tipo = $('#tipo_pagamento').val()
	let metodo = $('#metodo_pagamento').val()
	
	// Validações básicas
	if(!metodo) {
		swal("Alerta", "Selecione o método de pagamento", "warning")
		return
	}
	
	if(tipo == '1') {
		// Validar campos para conta a pagar
		let dataVencimento = $('#data_vencimento').val()
		if(!dataVencimento) {
			swal("Alerta", "Informe a data de vencimento", "warning")
			return
		}
	}
	
	// Copiar dados do modal para o formulário principal
	copiarDadosParaFormulario()
	
	// Fechar modal
	$('#modal_conta_pagar').modal('hide')
	
	// Submeter formulário
	$('#form-comissao').submit()
});

// Função para copiar dados do modal para o formulário principal
function copiarDadosParaFormulario() {
	// Remover campos existentes do formulário principal
	$('#form-comissao input[name="gerar_conta"]').remove()
	$('#form-comissao input[name="valor_integral"]').remove()
	$('#form-comissao input[name="descricao"]').remove()
	$('#form-comissao input[name="tipo_pagamento"]').remove()
	$('#form-comissao input[name="data_vencimento"]').remove()
	$('#form-comissao input[name="status"]').remove()
	$('#form-comissao input[name="observacao"]').remove()
	
	// Adicionar campos do modal ao formulário principal
	let formData = $('#form-pagamento').serializeArray()
	
	formData.forEach(function(item) {
		$('#form-comissao').append('<input type="hidden" name="' + item.name + '" value="' + item.value + '">')
	})
	
	// Remover botões de delete para evitar conflitos
	$('.td-delete').remove()
}

// Inicializar modal quando abrir
$(document).on('shown.bs.modal', '#modal_conta_pagar', function () {
	$('#tipo_pagamento').val('0').trigger('change')
});

