<?php
// Script para corrigir problema de timezone em NFCe específica
// Use: php fix_nfce_timezone.php

// Definir timezone para Brasil/São Paulo
date_default_timezone_set('America/Sao_Paulo');

// Carregar o ambiente Laravel
require __DIR__ . '/vendor/autoload.php';

// Carregar variáveis de ambiente
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Executar como script CLI
if (php_sapi_name() == 'cli') {
    // ID da NFCe com problema
    $nfce_id = 501;
    
    // Buscar a NFCe
    $nfce = App\Models\Nfce::find($nfce_id);
    
    if (!$nfce) {
        echo "NFCe não encontrada com ID $nfce_id\n";
        exit(1);
    }
    
    echo "NFCe encontrada: {$nfce->chave}\n";
    echo "Data de emissão: " . ($nfce->data_emissao ?? 'Não definida') . "\n";
    
    // Verificar se a NFCe já foi cancelada
    if ($nfce->estado == 'cancelado') {
        echo "Esta NFCe já está cancelada.\n";
        exit(0);
    }
    
    // Obter empresa
    $empresa = App\Models\Empresa::find($nfce->empresa_id);
    if (!$empresa) {
        echo "Empresa não encontrada.\n";
        exit(1);
    }
    
    echo "Empresa: {$empresa->nome}\n";
    
    try {
        // Criar serviço NFCe
        $nfce_service = new App\Services\NFCeService([
            "atualizacao" => date('Y-m-d h:i:s'),
            "tpAmb" => (int)$nfce->ambiente,
            "razaosocial" => $nfce->emissor_nome,
            "siglaUF" => $empresa->cidade->uf,
            "cnpj" => preg_replace('/[^0-9]/', '', $nfce->emissor_cpf_cnpj),
            "schemes" => "PL_009_V4",
            "versao" => "4.00",
        ], $empresa);
        
        // Definir motivo padrão do cancelamento
        $motivo = "CANCELAMENTO SOLICITADO PELO CLIENTE";
        
        echo "Tentando cancelar a NFCe...\n";
        
        // Definir a data de emissão manualmente para garantir que ela seja usada
        if (!isset($nfce->data_emissao)) {
            $data_emissao_str = "2024-05-11 15:21:00";
            echo "AVISO: Data de emissão não definida no registro. Usando $data_emissao_str\n";
            $nfce->data_emissao = $data_emissao_str;
        }
        
        // Tentativa de cancelamento
        $resultado = $nfce_service->cancelar($nfce, $motivo);
        
        if (!isset($resultado['erro'])) {
            $motivo_resp = $resultado['retEvento']['infEvento']['xMotivo'] ?? 'Desconhecido';
            $cStat = $resultado['retEvento']['infEvento']['cStat'] ?? 'Desconhecido';
            
            echo "Resposta da SEFAZ: [$cStat] $motivo_resp\n";
            
            if ($cStat == '101' || $cStat == '135' || $cStat == '155') {
                // Atualizar estado da NFCe no banco de dados
                $nfce->estado = 'cancelado';
                $nfce->save();
                echo "NFCe cancelada com sucesso!\n";
            } else {
                echo "Erro no cancelamento. Verifique o código de status.\n";
            }
        } else {
            if (isset($resultado['data']) && isset($resultado['data']['retEvento'])) {
                $arr = $resultado['data'];
                $cStat = $arr['retEvento']['infEvento']['cStat'] ?? 'Desconhecido';
                $motivo_resp = $arr['retEvento']['infEvento']['xMotivo'] ?? 'Desconhecido';
                echo "Erro: [$cStat] $motivo_resp\n";
            } else {
                echo "Erro desconhecido no cancelamento.\n";
                var_dump($resultado);
            }
        }
        
    } catch (Exception $e) {
        echo "Exceção: " . $e->getMessage() . "\n";
    }
} else {
    echo "Este script deve ser executado via linha de comando.";
} 