<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('item_consignacoes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('consignacao_id');
            $table->unsignedBigInteger('produto_id');
            $table->unsignedBigInteger('produto_variacao_id')->nullable();
            $table->decimal('quantidade', 10, 3)->default(0);
            $table->decimal('quantidade_vendida', 10, 3)->default(0);
            $table->decimal('quantidade_devolvida', 10, 3)->default(0);
            $table->decimal('valor_unitario', 10, 2)->default(0);
            $table->decimal('sub_total', 10, 2)->default(0);
            $table->text('observacao')->nullable();
            $table->timestamps();

            $table->foreign('consignacao_id')->references('id')->on('consignacoes')->onDelete('cascade');
            $table->foreign('produto_id')->references('id')->on('produtos')->onDelete('cascade');
            $table->foreign('produto_variacao_id')->references('id')->on('produto_variacaos')->onDelete('set null');

            $table->index('consignacao_id');
            $table->index('produto_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('item_consignacoes');
    }
};
