<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('nps_configuracoes', function (Blueprint $table) {
            $table->id();
            $table->boolean('ativo')->default(false);                // Status da pesquisa (ativada/desativada)
            $table->date('data_inicio')->nullable();                 // Data de início da pesquisa
            $table->date('data_fim')->nullable();                    // Data opcional de término da pesquisa
            $table->tinyInteger('dia_mes')->default(1);              // Dia do mês para exibir a pesquisa
            $table->string('titulo')->default('Pesquisa de Satisfação');  // Título personalizado da pesquisa
            $table->text('descricao')->nullable();                   // Descrição ou mensagem personalizada
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('nps_configuracoes');
    }
};
